import { Component, OnInit, ViewChild, Inject, Output, EventEmitter } from '@angular/core';
import { Pharmacy } from '../models/Pharmacy';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { HttpClient } from '@angular/common/http';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar, MatSnackBarRef, SimpleSnackBar } from '@angular/material/snack-bar';
import { Router, RouterModule } from '@angular/router';
import { HomeComponent } from '../home/home.component';
import { Medicine } from '../models/Medicine';
import { PharmacyHead } from '../models/PharmacyHead';
import { MedicineList } from '../models/MedicineList';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.css']
})
export class DashboardComponent implements OnInit {
  public mymedicines: Medicine[];
  public hasmymedicines: boolean[];
  public pharmacies: Pharmacy[];
  public mypharmacies: Pharmacy[];
  public head: PharmacyHead;
  public status: string;
  displayedColumns = ['Име','Јачина','Форма', 'Начин на издавање', 'Производител', 'Цена', 'Пакување', 'Actions'];
  displayedColumnsPharmacies = ['Име','Локација','Адреса', 'Actions'];
  dataSource = new MatTableDataSource<Medicine>();
  dataSourcePharmacies = new MatTableDataSource<Pharmacy>();

  @ViewChild(MatPaginator, {static: true}) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string, private dialog: MatDialog, private _snackBar: MatSnackBar, private router: Router) {
    http.get<PharmacyHead>(baseUrl + 'PharmacyHead/GetLoggedHead?').subscribe(result => {
      this.head = result;
      console.log(this.head);
      this.mymedicines = this.head.PharmacyMedicines.Medicines;
      console.log(this.mymedicines);
      this.mypharmacies = this.head.Pharmacy;
      console.log(this.mypharmacies);
      this.dataSource = new MatTableDataSource<Medicine>(this.mymedicines);
    }, error => console.error(error));
    http.get<Pharmacy[]>(baseUrl + 'Pharmacy/Get?').subscribe(result => {
      this.pharmacies = result;
      console.log(this.pharmacies);
      this.dataSourcePharmacies = new MatTableDataSource<Pharmacy>(this.pharmacies);
    }, error => console.error(error));
  }

  ngOnInit(): void {
  }

  ngAfterViewInit(): void {
    this.dataSource.paginator = this.paginator;
    this.dataSource.sort = this.sort;
    this.dataSourcePharmacies.paginator = this.paginator;
    this.dataSourcePharmacies.sort = this.sort;
  }

  works24hrs(pharmacy: Pharmacy) {
    console.log(pharmacy);
    // post request vo prodolzenie

    this.status="Status bar works24hrs";
  }

  doesntWork24hrs(pharmacy: Pharmacy) {
    console.log(pharmacy);
    // post request vo prodolzenie

    this.status="Status bar doesntWork24hrs";
  }

  claimPharmacy(pharmacy: Pharmacy) {
    console.log(pharmacy);
    // post request vo prodolzenie

    this.status="Status bar claimPharmacy";
  }

  medicineExists(mymedicine: Medicine) {
    console.log(mymedicine);
    // post request vo prodolzenie

    this.status="Status bar medicineexists";
  }

  medicineDoesntSell(mymedicine: Medicine) {
    console.log(mymedicine);
    // post request vo prodolzenie

    this.status="Status bar medicineDoesntSell";
  }

  applyFilter(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSource.filter = filterValue;
  }
  
  applyFilterPharmacies(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSourcePharmacies.filter = filterValue;
  }

  test(): void {
    console.log('Snackbar works!');
    this.openSnackBar("Are you sure?", "Yes").onAction().subscribe(() => {
      this.router.navigate(['/']);
    });
  }

  openDialog():void {
    let dialogRef = this.dialog.open(HomeComponent, {
      width: '70%'
    });
    dialogRef.afterClosed().subscribe(result => {
      if(result) {
        this.openSnackBar("Success", "OK");
      }
    });
  }

  openSnackBar(message: string, action: string) : MatSnackBarRef<SimpleSnackBar> {
    return this._snackBar.open(message, action, {
      duration: 10000,
    });
  }
}
