﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoData.FarmatikoRepo
{
    public class PandemicRepository : IPandemicRepository
    {
        private FarmatikoDataContext _context;

        public PandemicRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(Pandemic pandemic)
        {
            _context.Pandemics.Add(pandemic);
            _context.SaveChangesAsync();
        }

        public IEnumerable<Pandemic> GetAll()
        {
            return _context.Pandemics;
        }

        public void Remove(Pandemic pandemic)
        {
            _context.Pandemics.Remove(pandemic);
            _context.SaveChangesAsync();
        }
    }
}
