import { Component, OnInit, ViewChild, Inject, Output, EventEmitter } from '@angular/core';
import { Pharmacy } from '../models/Pharmacy';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { HealthFacilities } from '../models/HealthFacilities';
import { HttpClient } from '@angular/common/http';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar, MatSnackBarRef, SimpleSnackBar } from '@angular/material/snack-bar';
import { Router, RouterModule } from '@angular/router';
import { HomeComponent } from '../home/home.component';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.css']
})
export class DashboardComponent implements OnInit {
  public facilities: HealthFacilities[];
  displayedColumns = ['Име','Општина','Адреса', 'Тип', 'Е-пошта', 'Телефон'];
  dataSource = new MatTableDataSource<HealthFacilities>();

  @ViewChild(MatPaginator, {static: true}) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string, private dialog: MatDialog, private _snackBar: MatSnackBar, private router: Router) {
    http.get<HealthFacilities[]>(baseUrl + 'HealthFacilities/Get?').subscribe(result => {
      this.facilities = result;
      console.log(this.facilities);
      this.dataSource = new MatTableDataSource<HealthFacilities>(this.facilities);
    }, error => console.error(error));
  }
  ngOnInit(): void {
  }

  ngAfterViewInit(): void {
    this.dataSource.paginator = this.paginator;
    this.dataSource.sort = this.sort;
  }

  applyFilter(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSource.filter = filterValue;
  }
  test(): void {
    console.log('Snackbar works!');
    this.openSnackBar("Are you sure?", "Yes").onAction().subscribe(() => {
      this.router.navigate(['/']);
    });
  }

  openDialog():void {
    let dialogRef = this.dialog.open(HomeComponent, {
      width: '70%'
    });
    dialogRef.afterClosed().subscribe(result => {
      if(result) {
        this.openSnackBar("Success", "OK");
      }
    });
  }

  openSnackBar(message: string, action: string) : MatSnackBarRef<SimpleSnackBar> {
    return this._snackBar.open(message, action, {
      duration: 10000,
    });
  }
}
