﻿using FarmatikoData.FarmatikoRepoInterfaces;
using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthFacilityRepository : IHealthFacilityRepository
    {
        private FarmatikoDataContext _context;

        public HealthFacilityRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthFacilities healthFacility)
        {
            _context.Add(healthFacility);
            _context.SaveChangesAsync();
        }

        public IEnumerable<HealthFacilities> GetAll()
        {
            return _context.HealthFacilities.OrderBy(x => x.Name).ToList();
        }

    }
}
