﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;
using System.Collections.Generic;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthcareWorkerRepository : IHealthcareWorkerRepository
    {

        private FarmatikoDataContext _context;

        public HealthcareWorkerRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _context.Add(HealthcareWorker);
            _context.SaveChangesAsync();
        }

        public IEnumerable<HealthcareWorkers> GetAll()
        {
            return _context.HealthcareWorkers.OrderBy(x => x.Name);
        }

        public void Remove(HealthcareWorkers healthcareWorker)
        {
            _context.Remove(healthcareWorker);
        }
    }
}
