﻿using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineListRepository : IMedicineListRepository
    {
        private FarmatikoDataContext _context;
        public MedicineListRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(MedicineList medicineList)
        {
            _context.MedicineLists.Add(medicineList);
            _context.SaveChangesAsync();
        }
        // Maybe later
        /*public MedicineList CheckMedicine(string Name)
        {
            return (MedicineList)_context.MedicineLists
                .Where(medicineList => medicineList.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name);
        }*/

        public ICollection<MedicineList> GetAll()
        {
            return (ICollection<MedicineList>)_context.MedicineLists.OrderBy(x => x.Medicine.Name);
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Manufacturer.Contains(Manufacturer))
                .OrderBy(x => x.Medicine.Name);
        }
        public ICollection<MedicineList> GetByName(string Name)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name);
        }

        public void Remove(MedicineList medicineList)
        {
            var list = (MedicineList)_context.MedicineLists.Where(x => x.Equals(medicineList));
            _context.Remove(list);
        }

        public void SetHasMedicine(MedicineList medicineList, bool HasMedicine)
        {
            var medicine = _context.MedicineLists.Where(x => x.Medicine.Equals(medicineList.Medicine));
        }
    }
}
