﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System.Collections.Generic;

namespace FarmatikoServices.Services
{
    public class MedicineService : IMedicineService
    {
        private IMedicineRepository _medicineRepository;
        public MedicineService(IMedicineRepository medicineRepository)
        {
            _medicineRepository = medicineRepository;
        }

        public void Add(Medicine medicine)
        {
            _medicineRepository.Add(medicine);
        }

        public IEnumerable<Medicine> GetAll()
        {
            return _medicineRepository.GetAll();
        }

        public IEnumerable<Medicine> GetByManufacturer(string Manufacturer)
        {
            return _medicineRepository.GetByManufacturer(Manufacturer);
        }

        public IEnumerable<Medicine> GetByName(string Name)
        {
            return _medicineRepository.GetByName(Name);
        }

        public void Remove(string Medicine)
        {
            _medicineRepository.Remove(Medicine);
        }
    }
}
