import { Component, OnInit } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { Router, ActivatedRoute } from '@angular/router';
import { DataService } from '../shared/data.service';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})
export class LoginComponent implements OnInit {
  loginForm: FormGroup;
  email: string;
  passwd: string;
  errorMessage: string;

  constructor(private dataService: DataService,private router: Router, private route: ActivatedRoute) {
    this.loginForm = new FormGroup({
      email: new FormControl('', [Validators.required, Validators.email]),
      password: new FormControl('', [Validators.required])
    });
  }

  ngOnInit(): void {
  }

  loginPharmacyHead() {
    this.dataService.loginPharmacyHead(this.email, this.passwd)
                .subscribe((id: Number) => {
                  if(id) {
                    this.router.navigate(['/dashboard/' + id]);
                  }
                  else {
                    this.errorMessage = 'There was a problem signing in!';
                    console.log(this.errorMessage);
                  }
                },
                (err: any) => console.log(err));
  }
}
