/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.controllers;

import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.service.impl.JWTService;
import internettehnologii.imaps.backendRender.web.service.impl.MapUserDetailsService;
import internettehnologii.imaps.backendRender.web.service.impl.UserServiceImpl;
import internettehnologii.imaps.backendRender.web.util.DTO.UserAuthSuccessDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.UserLoginDTO;
import java.util.HashMap;
import java.util.Map;
import javax.management.relation.RoleNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/auth"})
@RestController
public class AuthController {
    @Autowired
    private UserServiceImpl userService;
    @Autowired
    private JWTService jwtService;
    @Autowired
    private ApplicationContext context;

    @PostMapping(value={"/register"})
    public IMapsUser register(@RequestBody IMapsUser user) throws RoleNotFoundException {
        return this.userService.register(user);
    }

    @PostMapping(value={"/login"})
    public Map<String, Object> login(@RequestBody UserLoginDTO user) {
        System.out.println(user);
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            UserAuthSuccessDTO userAuthSuccessDTO = this.userService.login(user);
            response.put("token", userAuthSuccessDTO.getToken());
            response.put("username", userAuthSuccessDTO.getUsername());
            response.put("roles", userAuthSuccessDTO.getRoles());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            response.put("error", e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/verify"})
    public ResponseEntity<Map<String, Object>> authenticateUser(@RequestParam String token) {
        System.out.println("VERIFY");
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String username = this.jwtService.extractUsername(token);
            UserDetails userDetails = ((MapUserDetailsService)this.context.getBean(MapUserDetailsService.class)).loadUserByUsername(username);
            boolean auth = this.jwtService.validateToken(token, userDetails);
            if (!auth) {
                response.put("error", "Token could not be validated");
                return ResponseEntity.status((int)403).body(response);
            }
            response.put("username", username);
            System.out.println("Authenticated user: " + username);
        }
        catch (Exception e) {
            response.put("auth", false);
            System.out.println("ERROR: NOT AUTHENTICATED: " + e.getMessage());
        }
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/test_auth"})
    public ResponseEntity<Map<String, Object>> testAuth() {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("auth", true);
        return ResponseEntity.ok(response);
    }
}

