/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.entities;

import internettehnologii.imaps.backendRender.web.entities.Floor;
import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.entities.MAP_STATUS;
import internettehnologii.imaps.backendRender.web.entities.RoomType;
import internettehnologii.imaps.backendRender.web.util.DTO.MapDTO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="maps")
public class IndoorMap {
    @Id
    @SequenceGenerator(name="maps_id_seq", sequenceName="maps_id_seq", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="maps_id_seq")
    private Integer id;
    private String name = "";
    @Column(name="gmaps_url")
    private String gmapsUrl = "";
    @Enumerated(value=EnumType.STRING)
    private MAP_STATUS status;
    @Column(name="published_at")
    private LocalDateTime publishedAt;
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @Column(name="modified_at")
    private LocalDateTime modifiedAt;
    @Column(name="map_type")
    private String mapType;
    @Column(name="image_url")
    private String imageUrl;
    @Column(name="is_published")
    private Boolean isPublished;
    @ManyToOne
    @JoinColumn(name="usr_id", referencedColumnName="id", nullable=false)
    private IMapsUser user;
    @OneToMany(mappedBy="indoorMap")
    private List<RoomType> roomTypes = new ArrayList();
    @OneToMany(mappedBy="indoorMap")
    private List<Floor> floors = new ArrayList();
    @ManyToMany(mappedBy="favoriteMaps")
    private Set<IMapsUser> favoritedBy = new HashSet();

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
        this.status = MAP_STATUS.PRIVATE;
    }

    public int getFavouriteCount() {
        return this.favoritedBy.size();
    }

    @PreUpdate
    protected void onUpdate() {
        this.modifiedAt = LocalDateTime.now();
    }

    public MapDTO toMapDTO() {
        return new MapDTO(this.getName(), this.getMapType(), this.getCreatedAt(), this.getModifiedAt(), this.getStatus().name(), this.getFavouriteCount(), this.getGmapsUrl());
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getGmapsUrl() {
        return this.gmapsUrl;
    }

    @Generated
    public MAP_STATUS getStatus() {
        return this.status;
    }

    @Generated
    public LocalDateTime getPublishedAt() {
        return this.publishedAt;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    @Generated
    public String getMapType() {
        return this.mapType;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public Boolean getIsPublished() {
        return this.isPublished;
    }

    @Generated
    public IMapsUser getUser() {
        return this.user;
    }

    @Generated
    public List<RoomType> getRoomTypes() {
        return this.roomTypes;
    }

    @Generated
    public List<Floor> getFloors() {
        return this.floors;
    }

    @Generated
    public Set<IMapsUser> getFavoritedBy() {
        return this.favoritedBy;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setGmapsUrl(String gmapsUrl) {
        this.gmapsUrl = gmapsUrl;
    }

    @Generated
    public void setStatus(MAP_STATUS status) {
        this.status = status;
    }

    @Generated
    public void setPublishedAt(LocalDateTime publishedAt) {
        this.publishedAt = publishedAt;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setModifiedAt(LocalDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    @Generated
    public void setMapType(String mapType) {
        this.mapType = mapType;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setIsPublished(Boolean isPublished) {
        this.isPublished = isPublished;
    }

    @Generated
    public void setUser(IMapsUser user) {
        this.user = user;
    }

    @Generated
    public void setRoomTypes(List<RoomType> roomTypes) {
        this.roomTypes = roomTypes;
    }

    @Generated
    public void setFloors(List<Floor> floors) {
        this.floors = floors;
    }

    @Generated
    public void setFavoritedBy(Set<IMapsUser> favoritedBy) {
        this.favoritedBy = favoritedBy;
    }
}

