/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.service.impl;

import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.entities.MAP_STATUS;
import internettehnologii.imaps.backendRender.web.entities.PublishRequest;
import internettehnologii.imaps.backendRender.web.repo.MapRepository;
import internettehnologii.imaps.backendRender.web.repo.PublishRequestRepository;
import internettehnologii.imaps.backendRender.web.repo.UserRepository;
import internettehnologii.imaps.backendRender.web.service.interfaces.MapService;
import internettehnologii.imaps.backendRender.web.service.interfaces.PublishRequestService;
import internettehnologii.imaps.backendRender.web.service.interfaces.UserService;
import internettehnologii.imaps.backendRender.web.util.DTO.MapDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.PublishMapDTO;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class PublishRequestServiceImpl
implements PublishRequestService {
    private final PublishRequestRepository publishRequestRepository;
    private final MapRepository mapRepository;
    private final MapService mapService;
    private final UserService userService;
    private final UserRepository userRepository;

    public PublishRequestServiceImpl(PublishRequestRepository publishRequestRepository, MapRepository mapRepository, MapService mapService, UserService userService, UserRepository userRepository) {
        this.publishRequestRepository = publishRequestRepository;
        this.mapRepository = mapRepository;
        this.mapService = mapService;
        this.userService = userService;
        this.userRepository = userRepository;
    }

    @Transactional
    public MapDTO addPublishRequest(PublishMapDTO formData, IMapsUser user) {
        PublishRequest pr;
        Optional prOptional = this.publishRequestRepository.findById((Object)formData.getId());
        IndoorMap map = this.mapService.getMapByName(formData.getMapName());
        if (prOptional.isPresent()) {
            pr = (PublishRequest)prOptional.get();
            pr.setName(formData.getName());
            pr.setLastName(formData.getLastName());
            pr.setGMapsUrl(formData.getGoogleMapsUrl());
            pr.setMapType(formData.getMapType());
            map.setStatus(MAP_STATUS.PENDING);
        } else {
            pr = new PublishRequest(formData.getName(), formData.getLastName(), formData.getGoogleMapsUrl(), formData.getMapType());
            pr.setMap(map);
            pr.setUser(user);
            map.setStatus(MAP_STATUS.PENDING);
        }
        this.mapRepository.save((Object)map);
        this.publishRequestRepository.save((Object)pr);
        this.sendMailToAdmins(user, pr);
        return map.toMapDTO();
    }

    public void denyPublishRequest(int id, String reason) throws Exception {
        PublishRequest pr = (PublishRequest)this.publishRequestRepository.findById((Object)id).orElseThrow(Exception::new);
        pr.setResolved(true);
        IndoorMap map = pr.getMap();
        map.setStatus(MAP_STATUS.PRIVATE);
        map.setIsPublished(Boolean.valueOf(false));
        this.publishRequestRepository.save((Object)pr);
        this.mapRepository.save((Object)map);
    }

    public List<PublishRequest> getAllPublishRequests() {
        return this.publishRequestRepository.findAll();
    }

    public void save(PublishRequest publishRequest) {
    }

    public void sendMailToAdmins(IMapsUser user, PublishRequest pr) {
    }

    public void approvePublishRequest(int id) throws Exception {
        PublishRequest pr = (PublishRequest)this.publishRequestRepository.findById((Object)id).orElseThrow(Exception::new);
        pr.setResolved(true);
        IndoorMap map = pr.getMap();
        map.setStatus(MAP_STATUS.PUBLIC);
        map.setIsPublished(Boolean.valueOf(true));
        map.setGmapsUrl(pr.getGMapsUrl());
        map.setMapType(pr.getMapType());
        this.publishRequestRepository.save((Object)pr);
        this.mapRepository.save((Object)map);
    }

    public void rejectPublishRequest(PublishRequest publishRequest) {
        publishRequest.setResolved(false);
        IndoorMap map = publishRequest.getMap();
        map.setStatus(MAP_STATUS.PRIVATE);
    }

    public PublishRequest getPublishRequestByMapName(String mapName) {
        return this.publishRequestRepository.findByMapName(mapName).orElse(new PublishRequest());
    }

    public void editPublishRequest(PublishRequest publishRequest) {
        if (!this.publishRequestRepository.existsById((Object)publishRequest.getId())) {
            return;
        }
        this.publishRequestRepository.save((Object)publishRequest);
    }
}

