/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.service.impl;

import internettehnologii.imaps.backendRender.web.entities.Floor;
import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.entities.MAP_STATUS;
import internettehnologii.imaps.backendRender.web.exceptions.MapNameTakenException;
import internettehnologii.imaps.backendRender.web.exceptions.MapNotFoundException;
import internettehnologii.imaps.backendRender.web.repo.FloorRepository;
import internettehnologii.imaps.backendRender.web.repo.MapRepository;
import internettehnologii.imaps.backendRender.web.repo.UserRepository;
import internettehnologii.imaps.backendRender.web.service.interfaces.MapService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class MapServiceImpl
implements MapService {
    private final MapRepository mapRepository;
    private final UserRepository userRepository;
    private final FloorRepository floorRepository;

    @Autowired
    public MapServiceImpl(MapRepository mapRepository, UserRepository userRepository, FloorRepository floorRepository) {
        this.mapRepository = mapRepository;
        this.userRepository = userRepository;
        this.floorRepository = floorRepository;
    }

    public void createMap(String mapName, String username) {
        Optional user = this.userRepository.findUserByName(username);
        if (this.mapRepository.existsByName(mapName)) {
            throw new MapNameTakenException("Map with name " + mapName + " already exists");
        }
        if (user.isEmpty()) {
            throw new UsernameNotFoundException("User " + username + " not found");
        }
        IndoorMap indoorMap = new IndoorMap();
        indoorMap.setName(mapName);
        indoorMap.setUser((IMapsUser)user.get());
        Floor floor = new Floor();
        floor.setFloorNumber(0);
        floor.setIndoorMap(indoorMap);
        this.mapRepository.save((Object)indoorMap);
        this.floorRepository.save((Object)floor);
    }

    public void updateMap(IndoorMap indoorMap) {
        this.mapRepository.save((Object)indoorMap);
    }

    public void deleteMap(IndoorMap indoorMap) {
        this.mapRepository.delete((Object)indoorMap);
    }

    public List<IndoorMap> getAllMapsForUser(String username) {
        IMapsUser user = (IMapsUser)this.userRepository.findUserByName(username).orElseThrow(() -> new UsernameNotFoundException(username));
        Optional indoorMaps = this.mapRepository.findAllMapsForUser((long)user.getId());
        return indoorMaps.orElseGet(ArrayList::new);
    }

    public List<IndoorMap> getPublicMaps() {
        Optional maps = this.mapRepository.findAllByStatus(MAP_STATUS.PUBLIC);
        return maps.orElseGet(ArrayList::new);
    }

    public IndoorMap getMapForUser(String username, String mapName) {
        IMapsUser user = (IMapsUser)this.userRepository.findUserByName(username).orElseThrow(() -> new UsernameNotFoundException(username));
        IndoorMap map = (IndoorMap)this.mapRepository.findMapByName(mapName).orElseThrow(() -> new MapNotFoundException(mapName));
        boolean isAdmin = user.getRoles().stream().anyMatch(role -> Objects.equals(role.getName(), "ADMIN"));
        if (isAdmin) {
            return map;
        }
        return (IndoorMap)this.mapRepository.getMapForUser(user, map.getId().intValue()).orElseThrow(() -> new MapNotFoundException("No map found for user: " + username));
    }

    public IndoorMap getPublicMapByName(String mapName) {
        return (IndoorMap)this.mapRepository.getIndoorMapByNameAndStatus(mapName, MAP_STATUS.PUBLIC).orElseThrow(() -> new MapNotFoundException(mapName));
    }

    public IndoorMap getMapByName(String mapName) {
        return (IndoorMap)this.mapRepository.getIndoorMapByName(mapName).orElseThrow(() -> new MapNotFoundException(mapName));
    }

    public List<IndoorMap> findByStatus(MAP_STATUS status) {
        return this.mapRepository.findAllByStatus(status).orElseGet(ArrayList::new);
    }
}

