import {
  require_Global
} from "./chunk-M3JPOOL7.js";
import {
  __commonJS
} from "./chunk-V4OQ3NZ2.js";

// node_modules/konva/lib/Util.js
var require_Util = __commonJS({
  "node_modules/konva/lib/Util.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Util = exports.Transform = void 0;
    var Global_1 = require_Global();
    var Transform = class _Transform {
      constructor(m = [1, 0, 0, 1, 0, 0]) {
        this.dirty = false;
        this.m = m && m.slice() || [1, 0, 0, 1, 0, 0];
      }
      reset() {
        this.m[0] = 1;
        this.m[1] = 0;
        this.m[2] = 0;
        this.m[3] = 1;
        this.m[4] = 0;
        this.m[5] = 0;
      }
      copy() {
        return new _Transform(this.m);
      }
      copyInto(tr) {
        tr.m[0] = this.m[0];
        tr.m[1] = this.m[1];
        tr.m[2] = this.m[2];
        tr.m[3] = this.m[3];
        tr.m[4] = this.m[4];
        tr.m[5] = this.m[5];
      }
      point(point) {
        var m = this.m;
        return {
          x: m[0] * point.x + m[2] * point.y + m[4],
          y: m[1] * point.x + m[3] * point.y + m[5]
        };
      }
      translate(x, y) {
        this.m[4] += this.m[0] * x + this.m[2] * y;
        this.m[5] += this.m[1] * x + this.m[3] * y;
        return this;
      }
      scale(sx, sy) {
        this.m[0] *= sx;
        this.m[1] *= sx;
        this.m[2] *= sy;
        this.m[3] *= sy;
        return this;
      }
      rotate(rad) {
        var c = Math.cos(rad);
        var s = Math.sin(rad);
        var m11 = this.m[0] * c + this.m[2] * s;
        var m12 = this.m[1] * c + this.m[3] * s;
        var m21 = this.m[0] * -s + this.m[2] * c;
        var m22 = this.m[1] * -s + this.m[3] * c;
        this.m[0] = m11;
        this.m[1] = m12;
        this.m[2] = m21;
        this.m[3] = m22;
        return this;
      }
      getTranslation() {
        return {
          x: this.m[4],
          y: this.m[5]
        };
      }
      skew(sx, sy) {
        var m11 = this.m[0] + this.m[2] * sy;
        var m12 = this.m[1] + this.m[3] * sy;
        var m21 = this.m[2] + this.m[0] * sx;
        var m22 = this.m[3] + this.m[1] * sx;
        this.m[0] = m11;
        this.m[1] = m12;
        this.m[2] = m21;
        this.m[3] = m22;
        return this;
      }
      multiply(matrix) {
        var m11 = this.m[0] * matrix.m[0] + this.m[2] * matrix.m[1];
        var m12 = this.m[1] * matrix.m[0] + this.m[3] * matrix.m[1];
        var m21 = this.m[0] * matrix.m[2] + this.m[2] * matrix.m[3];
        var m22 = this.m[1] * matrix.m[2] + this.m[3] * matrix.m[3];
        var dx = this.m[0] * matrix.m[4] + this.m[2] * matrix.m[5] + this.m[4];
        var dy = this.m[1] * matrix.m[4] + this.m[3] * matrix.m[5] + this.m[5];
        this.m[0] = m11;
        this.m[1] = m12;
        this.m[2] = m21;
        this.m[3] = m22;
        this.m[4] = dx;
        this.m[5] = dy;
        return this;
      }
      invert() {
        var d = 1 / (this.m[0] * this.m[3] - this.m[1] * this.m[2]);
        var m0 = this.m[3] * d;
        var m1 = -this.m[1] * d;
        var m2 = -this.m[2] * d;
        var m3 = this.m[0] * d;
        var m4 = d * (this.m[2] * this.m[5] - this.m[3] * this.m[4]);
        var m5 = d * (this.m[1] * this.m[4] - this.m[0] * this.m[5]);
        this.m[0] = m0;
        this.m[1] = m1;
        this.m[2] = m2;
        this.m[3] = m3;
        this.m[4] = m4;
        this.m[5] = m5;
        return this;
      }
      getMatrix() {
        return this.m;
      }
      decompose() {
        var a = this.m[0];
        var b = this.m[1];
        var c = this.m[2];
        var d = this.m[3];
        var e = this.m[4];
        var f = this.m[5];
        var delta = a * d - b * c;
        let result = {
          x: e,
          y: f,
          rotation: 0,
          scaleX: 0,
          scaleY: 0,
          skewX: 0,
          skewY: 0
        };
        if (a != 0 || b != 0) {
          var r = Math.sqrt(a * a + b * b);
          result.rotation = b > 0 ? Math.acos(a / r) : -Math.acos(a / r);
          result.scaleX = r;
          result.scaleY = delta / r;
          result.skewX = (a * c + b * d) / delta;
          result.skewY = 0;
        } else if (c != 0 || d != 0) {
          var s = Math.sqrt(c * c + d * d);
          result.rotation = Math.PI / 2 - (d > 0 ? Math.acos(-c / s) : -Math.acos(c / s));
          result.scaleX = delta / s;
          result.scaleY = s;
          result.skewX = 0;
          result.skewY = (a * c + b * d) / delta;
        } else {
        }
        result.rotation = exports.Util._getRotation(result.rotation);
        return result;
      }
    };
    exports.Transform = Transform;
    var OBJECT_ARRAY = "[object Array]";
    var OBJECT_NUMBER = "[object Number]";
    var OBJECT_STRING = "[object String]";
    var OBJECT_BOOLEAN = "[object Boolean]";
    var PI_OVER_DEG180 = Math.PI / 180;
    var DEG180_OVER_PI = 180 / Math.PI;
    var HASH = "#";
    var EMPTY_STRING = "";
    var ZERO = "0";
    var KONVA_WARNING = "Konva warning: ";
    var KONVA_ERROR = "Konva error: ";
    var RGB_PAREN = "rgb(";
    var COLORS = {
      aliceblue: [240, 248, 255],
      antiquewhite: [250, 235, 215],
      aqua: [0, 255, 255],
      aquamarine: [127, 255, 212],
      azure: [240, 255, 255],
      beige: [245, 245, 220],
      bisque: [255, 228, 196],
      black: [0, 0, 0],
      blanchedalmond: [255, 235, 205],
      blue: [0, 0, 255],
      blueviolet: [138, 43, 226],
      brown: [165, 42, 42],
      burlywood: [222, 184, 135],
      cadetblue: [95, 158, 160],
      chartreuse: [127, 255, 0],
      chocolate: [210, 105, 30],
      coral: [255, 127, 80],
      cornflowerblue: [100, 149, 237],
      cornsilk: [255, 248, 220],
      crimson: [220, 20, 60],
      cyan: [0, 255, 255],
      darkblue: [0, 0, 139],
      darkcyan: [0, 139, 139],
      darkgoldenrod: [184, 132, 11],
      darkgray: [169, 169, 169],
      darkgreen: [0, 100, 0],
      darkgrey: [169, 169, 169],
      darkkhaki: [189, 183, 107],
      darkmagenta: [139, 0, 139],
      darkolivegreen: [85, 107, 47],
      darkorange: [255, 140, 0],
      darkorchid: [153, 50, 204],
      darkred: [139, 0, 0],
      darksalmon: [233, 150, 122],
      darkseagreen: [143, 188, 143],
      darkslateblue: [72, 61, 139],
      darkslategray: [47, 79, 79],
      darkslategrey: [47, 79, 79],
      darkturquoise: [0, 206, 209],
      darkviolet: [148, 0, 211],
      deeppink: [255, 20, 147],
      deepskyblue: [0, 191, 255],
      dimgray: [105, 105, 105],
      dimgrey: [105, 105, 105],
      dodgerblue: [30, 144, 255],
      firebrick: [178, 34, 34],
      floralwhite: [255, 255, 240],
      forestgreen: [34, 139, 34],
      fuchsia: [255, 0, 255],
      gainsboro: [220, 220, 220],
      ghostwhite: [248, 248, 255],
      gold: [255, 215, 0],
      goldenrod: [218, 165, 32],
      gray: [128, 128, 128],
      green: [0, 128, 0],
      greenyellow: [173, 255, 47],
      grey: [128, 128, 128],
      honeydew: [240, 255, 240],
      hotpink: [255, 105, 180],
      indianred: [205, 92, 92],
      indigo: [75, 0, 130],
      ivory: [255, 255, 240],
      khaki: [240, 230, 140],
      lavender: [230, 230, 250],
      lavenderblush: [255, 240, 245],
      lawngreen: [124, 252, 0],
      lemonchiffon: [255, 250, 205],
      lightblue: [173, 216, 230],
      lightcoral: [240, 128, 128],
      lightcyan: [224, 255, 255],
      lightgoldenrodyellow: [250, 250, 210],
      lightgray: [211, 211, 211],
      lightgreen: [144, 238, 144],
      lightgrey: [211, 211, 211],
      lightpink: [255, 182, 193],
      lightsalmon: [255, 160, 122],
      lightseagreen: [32, 178, 170],
      lightskyblue: [135, 206, 250],
      lightslategray: [119, 136, 153],
      lightslategrey: [119, 136, 153],
      lightsteelblue: [176, 196, 222],
      lightyellow: [255, 255, 224],
      lime: [0, 255, 0],
      limegreen: [50, 205, 50],
      linen: [250, 240, 230],
      magenta: [255, 0, 255],
      maroon: [128, 0, 0],
      mediumaquamarine: [102, 205, 170],
      mediumblue: [0, 0, 205],
      mediumorchid: [186, 85, 211],
      mediumpurple: [147, 112, 219],
      mediumseagreen: [60, 179, 113],
      mediumslateblue: [123, 104, 238],
      mediumspringgreen: [0, 250, 154],
      mediumturquoise: [72, 209, 204],
      mediumvioletred: [199, 21, 133],
      midnightblue: [25, 25, 112],
      mintcream: [245, 255, 250],
      mistyrose: [255, 228, 225],
      moccasin: [255, 228, 181],
      navajowhite: [255, 222, 173],
      navy: [0, 0, 128],
      oldlace: [253, 245, 230],
      olive: [128, 128, 0],
      olivedrab: [107, 142, 35],
      orange: [255, 165, 0],
      orangered: [255, 69, 0],
      orchid: [218, 112, 214],
      palegoldenrod: [238, 232, 170],
      palegreen: [152, 251, 152],
      paleturquoise: [175, 238, 238],
      palevioletred: [219, 112, 147],
      papayawhip: [255, 239, 213],
      peachpuff: [255, 218, 185],
      peru: [205, 133, 63],
      pink: [255, 192, 203],
      plum: [221, 160, 203],
      powderblue: [176, 224, 230],
      purple: [128, 0, 128],
      rebeccapurple: [102, 51, 153],
      red: [255, 0, 0],
      rosybrown: [188, 143, 143],
      royalblue: [65, 105, 225],
      saddlebrown: [139, 69, 19],
      salmon: [250, 128, 114],
      sandybrown: [244, 164, 96],
      seagreen: [46, 139, 87],
      seashell: [255, 245, 238],
      sienna: [160, 82, 45],
      silver: [192, 192, 192],
      skyblue: [135, 206, 235],
      slateblue: [106, 90, 205],
      slategray: [119, 128, 144],
      slategrey: [119, 128, 144],
      snow: [255, 255, 250],
      springgreen: [0, 255, 127],
      steelblue: [70, 130, 180],
      tan: [210, 180, 140],
      teal: [0, 128, 128],
      thistle: [216, 191, 216],
      transparent: [255, 255, 255, 0],
      tomato: [255, 99, 71],
      turquoise: [64, 224, 208],
      violet: [238, 130, 238],
      wheat: [245, 222, 179],
      white: [255, 255, 255],
      whitesmoke: [245, 245, 245],
      yellow: [255, 255, 0],
      yellowgreen: [154, 205, 5]
    };
    var RGB_REGEX = /rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;
    var animQueue = [];
    var req = typeof requestAnimationFrame !== "undefined" && requestAnimationFrame || function(f) {
      setTimeout(f, 60);
    };
    exports.Util = {
      _isElement(obj) {
        return !!(obj && obj.nodeType == 1);
      },
      _isFunction(obj) {
        return !!(obj && obj.constructor && obj.call && obj.apply);
      },
      _isPlainObject(obj) {
        return !!obj && obj.constructor === Object;
      },
      _isArray(obj) {
        return Object.prototype.toString.call(obj) === OBJECT_ARRAY;
      },
      _isNumber(obj) {
        return Object.prototype.toString.call(obj) === OBJECT_NUMBER && !isNaN(obj) && isFinite(obj);
      },
      _isString(obj) {
        return Object.prototype.toString.call(obj) === OBJECT_STRING;
      },
      _isBoolean(obj) {
        return Object.prototype.toString.call(obj) === OBJECT_BOOLEAN;
      },
      isObject(val) {
        return val instanceof Object;
      },
      isValidSelector(selector) {
        if (typeof selector !== "string") {
          return false;
        }
        var firstChar = selector[0];
        return firstChar === "#" || firstChar === "." || firstChar === firstChar.toUpperCase();
      },
      _sign(number) {
        if (number === 0) {
          return 1;
        }
        if (number > 0) {
          return 1;
        } else {
          return -1;
        }
      },
      requestAnimFrame(callback) {
        animQueue.push(callback);
        if (animQueue.length === 1) {
          req(function() {
            const queue = animQueue;
            animQueue = [];
            queue.forEach(function(cb) {
              cb();
            });
          });
        }
      },
      createCanvasElement() {
        var canvas = document.createElement("canvas");
        try {
          canvas.style = canvas.style || {};
        } catch (e) {
        }
        return canvas;
      },
      createImageElement() {
        return document.createElement("img");
      },
      _isInDocument(el) {
        while (el = el.parentNode) {
          if (el == document) {
            return true;
          }
        }
        return false;
      },
      _urlToImage(url, callback) {
        var imageObj = exports.Util.createImageElement();
        imageObj.onload = function() {
          callback(imageObj);
        };
        imageObj.src = url;
      },
      _rgbToHex(r, g, b) {
        return ((1 << 24) + (r << 16) + (g << 8) + b).toString(16).slice(1);
      },
      _hexToRgb(hex) {
        hex = hex.replace(HASH, EMPTY_STRING);
        var bigint = parseInt(hex, 16);
        return {
          r: bigint >> 16 & 255,
          g: bigint >> 8 & 255,
          b: bigint & 255
        };
      },
      getRandomColor() {
        var randColor = (Math.random() * 16777215 << 0).toString(16);
        while (randColor.length < 6) {
          randColor = ZERO + randColor;
        }
        return HASH + randColor;
      },
      getRGB(color) {
        var rgb;
        if (color in COLORS) {
          rgb = COLORS[color];
          return {
            r: rgb[0],
            g: rgb[1],
            b: rgb[2]
          };
        } else if (color[0] === HASH) {
          return this._hexToRgb(color.substring(1));
        } else if (color.substr(0, 4) === RGB_PAREN) {
          rgb = RGB_REGEX.exec(color.replace(/ /g, ""));
          return {
            r: parseInt(rgb[1], 10),
            g: parseInt(rgb[2], 10),
            b: parseInt(rgb[3], 10)
          };
        } else {
          return {
            r: 0,
            g: 0,
            b: 0
          };
        }
      },
      colorToRGBA(str) {
        str = str || "black";
        return exports.Util._namedColorToRBA(str) || exports.Util._hex3ColorToRGBA(str) || exports.Util._hex4ColorToRGBA(str) || exports.Util._hex6ColorToRGBA(str) || exports.Util._hex8ColorToRGBA(str) || exports.Util._rgbColorToRGBA(str) || exports.Util._rgbaColorToRGBA(str) || exports.Util._hslColorToRGBA(str);
      },
      _namedColorToRBA(str) {
        var c = COLORS[str.toLowerCase()];
        if (!c) {
          return null;
        }
        return {
          r: c[0],
          g: c[1],
          b: c[2],
          a: 1
        };
      },
      _rgbColorToRGBA(str) {
        if (str.indexOf("rgb(") === 0) {
          str = str.match(/rgb\(([^)]+)\)/)[1];
          var parts = str.split(/ *, */).map(Number);
          return {
            r: parts[0],
            g: parts[1],
            b: parts[2],
            a: 1
          };
        }
      },
      _rgbaColorToRGBA(str) {
        if (str.indexOf("rgba(") === 0) {
          str = str.match(/rgba\(([^)]+)\)/)[1];
          var parts = str.split(/ *, */).map((n, index) => {
            if (n.slice(-1) === "%") {
              return index === 3 ? parseInt(n) / 100 : parseInt(n) / 100 * 255;
            }
            return Number(n);
          });
          return {
            r: parts[0],
            g: parts[1],
            b: parts[2],
            a: parts[3]
          };
        }
      },
      _hex8ColorToRGBA(str) {
        if (str[0] === "#" && str.length === 9) {
          return {
            r: parseInt(str.slice(1, 3), 16),
            g: parseInt(str.slice(3, 5), 16),
            b: parseInt(str.slice(5, 7), 16),
            a: parseInt(str.slice(7, 9), 16) / 255
          };
        }
      },
      _hex6ColorToRGBA(str) {
        if (str[0] === "#" && str.length === 7) {
          return {
            r: parseInt(str.slice(1, 3), 16),
            g: parseInt(str.slice(3, 5), 16),
            b: parseInt(str.slice(5, 7), 16),
            a: 1
          };
        }
      },
      _hex4ColorToRGBA(str) {
        if (str[0] === "#" && str.length === 5) {
          return {
            r: parseInt(str[1] + str[1], 16),
            g: parseInt(str[2] + str[2], 16),
            b: parseInt(str[3] + str[3], 16),
            a: parseInt(str[4] + str[4], 16) / 255
          };
        }
      },
      _hex3ColorToRGBA(str) {
        if (str[0] === "#" && str.length === 4) {
          return {
            r: parseInt(str[1] + str[1], 16),
            g: parseInt(str[2] + str[2], 16),
            b: parseInt(str[3] + str[3], 16),
            a: 1
          };
        }
      },
      _hslColorToRGBA(str) {
        if (/hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.test(str)) {
          const [_, ...hsl] = /hsl\((\d+),\s*([\d.]+)%,\s*([\d.]+)%\)/g.exec(str);
          const h = Number(hsl[0]) / 360;
          const s = Number(hsl[1]) / 100;
          const l = Number(hsl[2]) / 100;
          let t2;
          let t3;
          let val;
          if (s === 0) {
            val = l * 255;
            return {
              r: Math.round(val),
              g: Math.round(val),
              b: Math.round(val),
              a: 1
            };
          }
          if (l < 0.5) {
            t2 = l * (1 + s);
          } else {
            t2 = l + s - l * s;
          }
          const t1 = 2 * l - t2;
          const rgb = [0, 0, 0];
          for (let i = 0; i < 3; i++) {
            t3 = h + 1 / 3 * -(i - 1);
            if (t3 < 0) {
              t3++;
            }
            if (t3 > 1) {
              t3--;
            }
            if (6 * t3 < 1) {
              val = t1 + (t2 - t1) * 6 * t3;
            } else if (2 * t3 < 1) {
              val = t2;
            } else if (3 * t3 < 2) {
              val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
            } else {
              val = t1;
            }
            rgb[i] = val * 255;
          }
          return {
            r: Math.round(rgb[0]),
            g: Math.round(rgb[1]),
            b: Math.round(rgb[2]),
            a: 1
          };
        }
      },
      haveIntersection(r1, r2) {
        return !(r2.x > r1.x + r1.width || r2.x + r2.width < r1.x || r2.y > r1.y + r1.height || r2.y + r2.height < r1.y);
      },
      cloneObject(obj) {
        var retObj = {};
        for (var key in obj) {
          if (this._isPlainObject(obj[key])) {
            retObj[key] = this.cloneObject(obj[key]);
          } else if (this._isArray(obj[key])) {
            retObj[key] = this.cloneArray(obj[key]);
          } else {
            retObj[key] = obj[key];
          }
        }
        return retObj;
      },
      cloneArray(arr) {
        return arr.slice(0);
      },
      degToRad(deg) {
        return deg * PI_OVER_DEG180;
      },
      radToDeg(rad) {
        return rad * DEG180_OVER_PI;
      },
      _degToRad(deg) {
        exports.Util.warn("Util._degToRad is removed. Please use public Util.degToRad instead.");
        return exports.Util.degToRad(deg);
      },
      _radToDeg(rad) {
        exports.Util.warn("Util._radToDeg is removed. Please use public Util.radToDeg instead.");
        return exports.Util.radToDeg(rad);
      },
      _getRotation(radians) {
        return Global_1.Konva.angleDeg ? exports.Util.radToDeg(radians) : radians;
      },
      _capitalize(str) {
        return str.charAt(0).toUpperCase() + str.slice(1);
      },
      throw(str) {
        throw new Error(KONVA_ERROR + str);
      },
      error(str) {
        console.error(KONVA_ERROR + str);
      },
      warn(str) {
        if (!Global_1.Konva.showWarnings) {
          return;
        }
        console.warn(KONVA_WARNING + str);
      },
      each(obj, func) {
        for (var key in obj) {
          func(key, obj[key]);
        }
      },
      _inRange(val, left, right) {
        return left <= val && val < right;
      },
      _getProjectionToSegment(x1, y1, x2, y2, x3, y3) {
        var x, y, dist;
        var pd2 = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
        if (pd2 == 0) {
          x = x1;
          y = y1;
          dist = (x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2);
        } else {
          var u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / pd2;
          if (u < 0) {
            x = x1;
            y = y1;
            dist = (x1 - x3) * (x1 - x3) + (y1 - y3) * (y1 - y3);
          } else if (u > 1) {
            x = x2;
            y = y2;
            dist = (x2 - x3) * (x2 - x3) + (y2 - y3) * (y2 - y3);
          } else {
            x = x1 + u * (x2 - x1);
            y = y1 + u * (y2 - y1);
            dist = (x - x3) * (x - x3) + (y - y3) * (y - y3);
          }
        }
        return [x, y, dist];
      },
      _getProjectionToLine(pt, line, isClosed) {
        var pc = exports.Util.cloneObject(pt);
        var dist = Number.MAX_VALUE;
        line.forEach(function(p1, i) {
          if (!isClosed && i === line.length - 1) {
            return;
          }
          var p2 = line[(i + 1) % line.length];
          var proj = exports.Util._getProjectionToSegment(p1.x, p1.y, p2.x, p2.y, pt.x, pt.y);
          var px = proj[0], py = proj[1], pdist = proj[2];
          if (pdist < dist) {
            pc.x = px;
            pc.y = py;
            dist = pdist;
          }
        });
        return pc;
      },
      _prepareArrayForTween(startArray, endArray, isClosed) {
        var n, start = [], end = [];
        if (startArray.length > endArray.length) {
          var temp = endArray;
          endArray = startArray;
          startArray = temp;
        }
        for (n = 0; n < startArray.length; n += 2) {
          start.push({
            x: startArray[n],
            y: startArray[n + 1]
          });
        }
        for (n = 0; n < endArray.length; n += 2) {
          end.push({
            x: endArray[n],
            y: endArray[n + 1]
          });
        }
        var newStart = [];
        end.forEach(function(point) {
          var pr = exports.Util._getProjectionToLine(point, start, isClosed);
          newStart.push(pr.x);
          newStart.push(pr.y);
        });
        return newStart;
      },
      _prepareToStringify(obj) {
        var desc;
        obj.visitedByCircularReferenceRemoval = true;
        for (var key in obj) {
          if (!(obj.hasOwnProperty(key) && obj[key] && typeof obj[key] == "object")) {
            continue;
          }
          desc = Object.getOwnPropertyDescriptor(obj, key);
          if (obj[key].visitedByCircularReferenceRemoval || exports.Util._isElement(obj[key])) {
            if (desc.configurable) {
              delete obj[key];
            } else {
              return null;
            }
          } else if (exports.Util._prepareToStringify(obj[key]) === null) {
            if (desc.configurable) {
              delete obj[key];
            } else {
              return null;
            }
          }
        }
        delete obj.visitedByCircularReferenceRemoval;
        return obj;
      },
      _assign(target, source) {
        for (var key in source) {
          target[key] = source[key];
        }
        return target;
      },
      _getFirstPointerId(evt) {
        if (!evt.touches) {
          return evt.pointerId || 999;
        } else {
          return evt.changedTouches[0].identifier;
        }
      },
      releaseCanvas(...canvases) {
        if (!Global_1.Konva.releaseCanvasOnDestroy)
          return;
        canvases.forEach((c) => {
          c.width = 0;
          c.height = 0;
        });
      },
      drawRoundedRectPath(context, width, height, cornerRadius) {
        let topLeft = 0;
        let topRight = 0;
        let bottomLeft = 0;
        let bottomRight = 0;
        if (typeof cornerRadius === "number") {
          topLeft = topRight = bottomLeft = bottomRight = Math.min(cornerRadius, width / 2, height / 2);
        } else {
          topLeft = Math.min(cornerRadius[0] || 0, width / 2, height / 2);
          topRight = Math.min(cornerRadius[1] || 0, width / 2, height / 2);
          bottomRight = Math.min(cornerRadius[2] || 0, width / 2, height / 2);
          bottomLeft = Math.min(cornerRadius[3] || 0, width / 2, height / 2);
        }
        context.moveTo(topLeft, 0);
        context.lineTo(width - topRight, 0);
        context.arc(width - topRight, topRight, topRight, Math.PI * 3 / 2, 0, false);
        context.lineTo(width, height - bottomRight);
        context.arc(width - bottomRight, height - bottomRight, bottomRight, 0, Math.PI / 2, false);
        context.lineTo(bottomLeft, height);
        context.arc(bottomLeft, height - bottomLeft, bottomLeft, Math.PI / 2, Math.PI, false);
        context.lineTo(0, topLeft);
        context.arc(topLeft, topLeft, topLeft, Math.PI, Math.PI * 3 / 2, false);
      }
    };
  }
});

// node_modules/konva/lib/Validators.js
var require_Validators = __commonJS({
  "node_modules/konva/lib/Validators.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getComponentValidator = exports.getBooleanValidator = exports.getNumberArrayValidator = exports.getFunctionValidator = exports.getStringOrGradientValidator = exports.getStringValidator = exports.getNumberOrAutoValidator = exports.getNumberOrArrayOfNumbersValidator = exports.getNumberValidator = exports.alphaComponent = exports.RGBComponent = void 0;
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    function _formatValue(val) {
      if (Util_1.Util._isString(val)) {
        return '"' + val + '"';
      }
      if (Object.prototype.toString.call(val) === "[object Number]") {
        return val;
      }
      if (Util_1.Util._isBoolean(val)) {
        return val;
      }
      return Object.prototype.toString.call(val);
    }
    function RGBComponent(val) {
      if (val > 255) {
        return 255;
      } else if (val < 0) {
        return 0;
      }
      return Math.round(val);
    }
    exports.RGBComponent = RGBComponent;
    function alphaComponent(val) {
      if (val > 1) {
        return 1;
      } else if (val < 1e-4) {
        return 1e-4;
      }
      return val;
    }
    exports.alphaComponent = alphaComponent;
    function getNumberValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          if (!Util_1.Util._isNumber(val)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a number.');
          }
          return val;
        };
      }
    }
    exports.getNumberValidator = getNumberValidator;
    function getNumberOrArrayOfNumbersValidator(noOfElements) {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          let isNumber = Util_1.Util._isNumber(val);
          let isValidArray = Util_1.Util._isArray(val) && val.length == noOfElements;
          if (!isNumber && !isValidArray) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a number or Array<number>(' + noOfElements + ")");
          }
          return val;
        };
      }
    }
    exports.getNumberOrArrayOfNumbersValidator = getNumberOrArrayOfNumbersValidator;
    function getNumberOrAutoValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          var isNumber = Util_1.Util._isNumber(val);
          var isAuto = val === "auto";
          if (!(isNumber || isAuto)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a number or "auto".');
          }
          return val;
        };
      }
    }
    exports.getNumberOrAutoValidator = getNumberOrAutoValidator;
    function getStringValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          if (!Util_1.Util._isString(val)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a string.');
          }
          return val;
        };
      }
    }
    exports.getStringValidator = getStringValidator;
    function getStringOrGradientValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          const isString = Util_1.Util._isString(val);
          const isGradient = Object.prototype.toString.call(val) === "[object CanvasGradient]" || val && val.addColorStop;
          if (!(isString || isGradient)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a string or a native gradient.');
          }
          return val;
        };
      }
    }
    exports.getStringOrGradientValidator = getStringOrGradientValidator;
    function getFunctionValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          if (!Util_1.Util._isFunction(val)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a function.');
          }
          return val;
        };
      }
    }
    exports.getFunctionValidator = getFunctionValidator;
    function getNumberArrayValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          const TypedArray = Int8Array ? Object.getPrototypeOf(Int8Array) : null;
          if (TypedArray && val instanceof TypedArray) {
            return val;
          }
          if (!Util_1.Util._isArray(val)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a array of numbers.');
          } else {
            val.forEach(function(item) {
              if (!Util_1.Util._isNumber(item)) {
                Util_1.Util.warn('"' + attr + '" attribute has non numeric element ' + item + ". Make sure that all elements are numbers.");
              }
            });
          }
          return val;
        };
      }
    }
    exports.getNumberArrayValidator = getNumberArrayValidator;
    function getBooleanValidator() {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          var isBool = val === true || val === false;
          if (!isBool) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be a boolean.');
          }
          return val;
        };
      }
    }
    exports.getBooleanValidator = getBooleanValidator;
    function getComponentValidator(components) {
      if (Global_1.Konva.isUnminified) {
        return function(val, attr) {
          if (val === void 0 || val === null) {
            return val;
          }
          if (!Util_1.Util.isObject(val)) {
            Util_1.Util.warn(_formatValue(val) + ' is a not valid value for "' + attr + '" attribute. The value should be an object with properties ' + components);
          }
          return val;
        };
      }
    }
    exports.getComponentValidator = getComponentValidator;
  }
});

// node_modules/konva/lib/Factory.js
var require_Factory = __commonJS({
  "node_modules/konva/lib/Factory.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Factory = void 0;
    var Util_1 = require_Util();
    var Validators_1 = require_Validators();
    var GET = "get";
    var SET = "set";
    exports.Factory = {
      addGetterSetter(constructor, attr, def, validator, after) {
        exports.Factory.addGetter(constructor, attr, def);
        exports.Factory.addSetter(constructor, attr, validator, after);
        exports.Factory.addOverloadedGetterSetter(constructor, attr);
      },
      addGetter(constructor, attr, def) {
        var method = GET + Util_1.Util._capitalize(attr);
        constructor.prototype[method] = constructor.prototype[method] || function() {
          var val = this.attrs[attr];
          return val === void 0 ? def : val;
        };
      },
      addSetter(constructor, attr, validator, after) {
        var method = SET + Util_1.Util._capitalize(attr);
        if (!constructor.prototype[method]) {
          exports.Factory.overWriteSetter(constructor, attr, validator, after);
        }
      },
      overWriteSetter(constructor, attr, validator, after) {
        var method = SET + Util_1.Util._capitalize(attr);
        constructor.prototype[method] = function(val) {
          if (validator && val !== void 0 && val !== null) {
            val = validator.call(this, val, attr);
          }
          this._setAttr(attr, val);
          if (after) {
            after.call(this);
          }
          return this;
        };
      },
      addComponentsGetterSetter(constructor, attr, components, validator, after) {
        var len = components.length, capitalize = Util_1.Util._capitalize, getter = GET + capitalize(attr), setter = SET + capitalize(attr), n, component;
        constructor.prototype[getter] = function() {
          var ret = {};
          for (n = 0; n < len; n++) {
            component = components[n];
            ret[component] = this.getAttr(attr + capitalize(component));
          }
          return ret;
        };
        var basicValidator = (0, Validators_1.getComponentValidator)(components);
        constructor.prototype[setter] = function(val) {
          var oldVal = this.attrs[attr], key;
          if (validator) {
            val = validator.call(this, val);
          }
          if (basicValidator) {
            basicValidator.call(this, val, attr);
          }
          for (key in val) {
            if (!val.hasOwnProperty(key)) {
              continue;
            }
            this._setAttr(attr + capitalize(key), val[key]);
          }
          if (!val) {
            components.forEach((component2) => {
              this._setAttr(attr + capitalize(component2), void 0);
            });
          }
          this._fireChangeEvent(attr, oldVal, val);
          if (after) {
            after.call(this);
          }
          return this;
        };
        exports.Factory.addOverloadedGetterSetter(constructor, attr);
      },
      addOverloadedGetterSetter(constructor, attr) {
        var capitalizedAttr = Util_1.Util._capitalize(attr), setter = SET + capitalizedAttr, getter = GET + capitalizedAttr;
        constructor.prototype[attr] = function() {
          if (arguments.length) {
            this[setter](arguments[0]);
            return this;
          }
          return this[getter]();
        };
      },
      addDeprecatedGetterSetter(constructor, attr, def, validator) {
        Util_1.Util.error("Adding deprecated " + attr);
        var method = GET + Util_1.Util._capitalize(attr);
        var message = attr + " property is deprecated and will be removed soon. Look at Konva change log for more information.";
        constructor.prototype[method] = function() {
          Util_1.Util.error(message);
          var val = this.attrs[attr];
          return val === void 0 ? def : val;
        };
        exports.Factory.addSetter(constructor, attr, validator, function() {
          Util_1.Util.error(message);
        });
        exports.Factory.addOverloadedGetterSetter(constructor, attr);
      },
      backCompat(constructor, methods) {
        Util_1.Util.each(methods, function(oldMethodName, newMethodName) {
          var method = constructor.prototype[newMethodName];
          var oldGetter = GET + Util_1.Util._capitalize(oldMethodName);
          var oldSetter = SET + Util_1.Util._capitalize(oldMethodName);
          function deprecated() {
            method.apply(this, arguments);
            Util_1.Util.error('"' + oldMethodName + '" method is deprecated and will be removed soon. Use ""' + newMethodName + '" instead.');
          }
          constructor.prototype[oldMethodName] = deprecated;
          constructor.prototype[oldGetter] = deprecated;
          constructor.prototype[oldSetter] = deprecated;
        });
      },
      afterSetFilter() {
        this._filterUpToDate = false;
      }
    };
  }
});

// node_modules/konva/lib/Context.js
var require_Context = __commonJS({
  "node_modules/konva/lib/Context.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.HitContext = exports.SceneContext = exports.Context = void 0;
    var Util_1 = require_Util();
    var Global_1 = require_Global();
    function simplifyArray(arr) {
      var retArr = [], len = arr.length, util = Util_1.Util, n, val;
      for (n = 0; n < len; n++) {
        val = arr[n];
        if (util._isNumber(val)) {
          val = Math.round(val * 1e3) / 1e3;
        } else if (!util._isString(val)) {
          val = val + "";
        }
        retArr.push(val);
      }
      return retArr;
    }
    var COMMA = ",";
    var OPEN_PAREN = "(";
    var CLOSE_PAREN = ")";
    var OPEN_PAREN_BRACKET = "([";
    var CLOSE_BRACKET_PAREN = "])";
    var SEMICOLON = ";";
    var DOUBLE_PAREN = "()";
    var EQUALS = "=";
    var CONTEXT_METHODS = [
      "arc",
      "arcTo",
      "beginPath",
      "bezierCurveTo",
      "clearRect",
      "clip",
      "closePath",
      "createLinearGradient",
      "createPattern",
      "createRadialGradient",
      "drawImage",
      "ellipse",
      "fill",
      "fillText",
      "getImageData",
      "createImageData",
      "lineTo",
      "moveTo",
      "putImageData",
      "quadraticCurveTo",
      "rect",
      "roundRect",
      "restore",
      "rotate",
      "save",
      "scale",
      "setLineDash",
      "setTransform",
      "stroke",
      "strokeText",
      "transform",
      "translate"
    ];
    var CONTEXT_PROPERTIES = [
      "fillStyle",
      "strokeStyle",
      "shadowColor",
      "shadowBlur",
      "shadowOffsetX",
      "shadowOffsetY",
      "letterSpacing",
      "lineCap",
      "lineDashOffset",
      "lineJoin",
      "lineWidth",
      "miterLimit",
      "direction",
      "font",
      "textAlign",
      "textBaseline",
      "globalAlpha",
      "globalCompositeOperation",
      "imageSmoothingEnabled"
    ];
    var traceArrMax = 100;
    var Context = class {
      constructor(canvas) {
        this.canvas = canvas;
        if (Global_1.Konva.enableTrace) {
          this.traceArr = [];
          this._enableTrace();
        }
      }
      fillShape(shape) {
        if (shape.fillEnabled()) {
          this._fill(shape);
        }
      }
      _fill(shape) {
      }
      strokeShape(shape) {
        if (shape.hasStroke()) {
          this._stroke(shape);
        }
      }
      _stroke(shape) {
      }
      fillStrokeShape(shape) {
        if (shape.attrs.fillAfterStrokeEnabled) {
          this.strokeShape(shape);
          this.fillShape(shape);
        } else {
          this.fillShape(shape);
          this.strokeShape(shape);
        }
      }
      getTrace(relaxed, rounded) {
        var traceArr = this.traceArr, len = traceArr.length, str = "", n, trace, method, args;
        for (n = 0; n < len; n++) {
          trace = traceArr[n];
          method = trace.method;
          if (method) {
            args = trace.args;
            str += method;
            if (relaxed) {
              str += DOUBLE_PAREN;
            } else {
              if (Util_1.Util._isArray(args[0])) {
                str += OPEN_PAREN_BRACKET + args.join(COMMA) + CLOSE_BRACKET_PAREN;
              } else {
                if (rounded) {
                  args = args.map((a) => typeof a === "number" ? Math.floor(a) : a);
                }
                str += OPEN_PAREN + args.join(COMMA) + CLOSE_PAREN;
              }
            }
          } else {
            str += trace.property;
            if (!relaxed) {
              str += EQUALS + trace.val;
            }
          }
          str += SEMICOLON;
        }
        return str;
      }
      clearTrace() {
        this.traceArr = [];
      }
      _trace(str) {
        var traceArr = this.traceArr, len;
        traceArr.push(str);
        len = traceArr.length;
        if (len >= traceArrMax) {
          traceArr.shift();
        }
      }
      reset() {
        var pixelRatio = this.getCanvas().getPixelRatio();
        this.setTransform(1 * pixelRatio, 0, 0, 1 * pixelRatio, 0, 0);
      }
      getCanvas() {
        return this.canvas;
      }
      clear(bounds) {
        var canvas = this.getCanvas();
        if (bounds) {
          this.clearRect(bounds.x || 0, bounds.y || 0, bounds.width || 0, bounds.height || 0);
        } else {
          this.clearRect(0, 0, canvas.getWidth() / canvas.pixelRatio, canvas.getHeight() / canvas.pixelRatio);
        }
      }
      _applyLineCap(shape) {
        const lineCap = shape.attrs.lineCap;
        if (lineCap) {
          this.setAttr("lineCap", lineCap);
        }
      }
      _applyOpacity(shape) {
        var absOpacity = shape.getAbsoluteOpacity();
        if (absOpacity !== 1) {
          this.setAttr("globalAlpha", absOpacity);
        }
      }
      _applyLineJoin(shape) {
        const lineJoin = shape.attrs.lineJoin;
        if (lineJoin) {
          this.setAttr("lineJoin", lineJoin);
        }
      }
      setAttr(attr, val) {
        this._context[attr] = val;
      }
      arc(x, y, radius, startAngle, endAngle, counterClockwise) {
        this._context.arc(x, y, radius, startAngle, endAngle, counterClockwise);
      }
      arcTo(x1, y1, x2, y2, radius) {
        this._context.arcTo(x1, y1, x2, y2, radius);
      }
      beginPath() {
        this._context.beginPath();
      }
      bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
        this._context.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
      }
      clearRect(x, y, width, height) {
        this._context.clearRect(x, y, width, height);
      }
      clip(...args) {
        this._context.clip.apply(this._context, args);
      }
      closePath() {
        this._context.closePath();
      }
      createImageData(width, height) {
        var a = arguments;
        if (a.length === 2) {
          return this._context.createImageData(width, height);
        } else if (a.length === 1) {
          return this._context.createImageData(width);
        }
      }
      createLinearGradient(x0, y0, x1, y1) {
        return this._context.createLinearGradient(x0, y0, x1, y1);
      }
      createPattern(image, repetition) {
        return this._context.createPattern(image, repetition);
      }
      createRadialGradient(x0, y0, r0, x1, y1, r1) {
        return this._context.createRadialGradient(x0, y0, r0, x1, y1, r1);
      }
      drawImage(image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight) {
        var a = arguments, _context = this._context;
        if (a.length === 3) {
          _context.drawImage(image, sx, sy);
        } else if (a.length === 5) {
          _context.drawImage(image, sx, sy, sWidth, sHeight);
        } else if (a.length === 9) {
          _context.drawImage(image, sx, sy, sWidth, sHeight, dx, dy, dWidth, dHeight);
        }
      }
      ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, counterclockwise) {
        this._context.ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, counterclockwise);
      }
      isPointInPath(x, y, path, fillRule) {
        if (path) {
          return this._context.isPointInPath(path, x, y, fillRule);
        }
        return this._context.isPointInPath(x, y, fillRule);
      }
      fill(...args) {
        this._context.fill.apply(this._context, args);
      }
      fillRect(x, y, width, height) {
        this._context.fillRect(x, y, width, height);
      }
      strokeRect(x, y, width, height) {
        this._context.strokeRect(x, y, width, height);
      }
      fillText(text, x, y, maxWidth) {
        if (maxWidth) {
          this._context.fillText(text, x, y, maxWidth);
        } else {
          this._context.fillText(text, x, y);
        }
      }
      measureText(text) {
        return this._context.measureText(text);
      }
      getImageData(sx, sy, sw, sh) {
        return this._context.getImageData(sx, sy, sw, sh);
      }
      lineTo(x, y) {
        this._context.lineTo(x, y);
      }
      moveTo(x, y) {
        this._context.moveTo(x, y);
      }
      rect(x, y, width, height) {
        this._context.rect(x, y, width, height);
      }
      roundRect(x, y, width, height, radii) {
        this._context.roundRect(x, y, width, height, radii);
      }
      putImageData(imageData, dx, dy) {
        this._context.putImageData(imageData, dx, dy);
      }
      quadraticCurveTo(cpx, cpy, x, y) {
        this._context.quadraticCurveTo(cpx, cpy, x, y);
      }
      restore() {
        this._context.restore();
      }
      rotate(angle) {
        this._context.rotate(angle);
      }
      save() {
        this._context.save();
      }
      scale(x, y) {
        this._context.scale(x, y);
      }
      setLineDash(segments) {
        if (this._context.setLineDash) {
          this._context.setLineDash(segments);
        } else if ("mozDash" in this._context) {
          this._context["mozDash"] = segments;
        } else if ("webkitLineDash" in this._context) {
          this._context["webkitLineDash"] = segments;
        }
      }
      getLineDash() {
        return this._context.getLineDash();
      }
      setTransform(a, b, c, d, e, f) {
        this._context.setTransform(a, b, c, d, e, f);
      }
      stroke(path2d) {
        if (path2d) {
          this._context.stroke(path2d);
        } else {
          this._context.stroke();
        }
      }
      strokeText(text, x, y, maxWidth) {
        this._context.strokeText(text, x, y, maxWidth);
      }
      transform(a, b, c, d, e, f) {
        this._context.transform(a, b, c, d, e, f);
      }
      translate(x, y) {
        this._context.translate(x, y);
      }
      _enableTrace() {
        var that = this, len = CONTEXT_METHODS.length, origSetter = this.setAttr, n, args;
        var func = function(methodName) {
          var origMethod = that[methodName], ret;
          that[methodName] = function() {
            args = simplifyArray(Array.prototype.slice.call(arguments, 0));
            ret = origMethod.apply(that, arguments);
            that._trace({
              method: methodName,
              args
            });
            return ret;
          };
        };
        for (n = 0; n < len; n++) {
          func(CONTEXT_METHODS[n]);
        }
        that.setAttr = function() {
          origSetter.apply(that, arguments);
          var prop = arguments[0];
          var val = arguments[1];
          if (prop === "shadowOffsetX" || prop === "shadowOffsetY" || prop === "shadowBlur") {
            val = val / this.canvas.getPixelRatio();
          }
          that._trace({
            property: prop,
            val
          });
        };
      }
      _applyGlobalCompositeOperation(node) {
        const op = node.attrs.globalCompositeOperation;
        var def = !op || op === "source-over";
        if (!def) {
          this.setAttr("globalCompositeOperation", op);
        }
      }
    };
    exports.Context = Context;
    CONTEXT_PROPERTIES.forEach(function(prop) {
      Object.defineProperty(Context.prototype, prop, {
        get() {
          return this._context[prop];
        },
        set(val) {
          this._context[prop] = val;
        }
      });
    });
    var SceneContext = class extends Context {
      constructor(canvas, { willReadFrequently = false } = {}) {
        super(canvas);
        this._context = canvas._canvas.getContext("2d", {
          willReadFrequently
        });
      }
      _fillColor(shape) {
        var fill = shape.fill();
        this.setAttr("fillStyle", fill);
        shape._fillFunc(this);
      }
      _fillPattern(shape) {
        this.setAttr("fillStyle", shape._getFillPattern());
        shape._fillFunc(this);
      }
      _fillLinearGradient(shape) {
        var grd = shape._getLinearGradient();
        if (grd) {
          this.setAttr("fillStyle", grd);
          shape._fillFunc(this);
        }
      }
      _fillRadialGradient(shape) {
        const grd = shape._getRadialGradient();
        if (grd) {
          this.setAttr("fillStyle", grd);
          shape._fillFunc(this);
        }
      }
      _fill(shape) {
        const hasColor = shape.fill(), fillPriority = shape.getFillPriority();
        if (hasColor && fillPriority === "color") {
          this._fillColor(shape);
          return;
        }
        const hasPattern = shape.getFillPatternImage();
        if (hasPattern && fillPriority === "pattern") {
          this._fillPattern(shape);
          return;
        }
        const hasLinearGradient = shape.getFillLinearGradientColorStops();
        if (hasLinearGradient && fillPriority === "linear-gradient") {
          this._fillLinearGradient(shape);
          return;
        }
        const hasRadialGradient = shape.getFillRadialGradientColorStops();
        if (hasRadialGradient && fillPriority === "radial-gradient") {
          this._fillRadialGradient(shape);
          return;
        }
        if (hasColor) {
          this._fillColor(shape);
        } else if (hasPattern) {
          this._fillPattern(shape);
        } else if (hasLinearGradient) {
          this._fillLinearGradient(shape);
        } else if (hasRadialGradient) {
          this._fillRadialGradient(shape);
        }
      }
      _strokeLinearGradient(shape) {
        const start = shape.getStrokeLinearGradientStartPoint(), end = shape.getStrokeLinearGradientEndPoint(), colorStops = shape.getStrokeLinearGradientColorStops(), grd = this.createLinearGradient(start.x, start.y, end.x, end.y);
        if (colorStops) {
          for (var n = 0; n < colorStops.length; n += 2) {
            grd.addColorStop(colorStops[n], colorStops[n + 1]);
          }
          this.setAttr("strokeStyle", grd);
        }
      }
      _stroke(shape) {
        var dash = shape.dash(), strokeScaleEnabled = shape.getStrokeScaleEnabled();
        if (shape.hasStroke()) {
          if (!strokeScaleEnabled) {
            this.save();
            var pixelRatio = this.getCanvas().getPixelRatio();
            this.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);
          }
          this._applyLineCap(shape);
          if (dash && shape.dashEnabled()) {
            this.setLineDash(dash);
            this.setAttr("lineDashOffset", shape.dashOffset());
          }
          this.setAttr("lineWidth", shape.strokeWidth());
          if (!shape.getShadowForStrokeEnabled()) {
            this.setAttr("shadowColor", "rgba(0,0,0,0)");
          }
          var hasLinearGradient = shape.getStrokeLinearGradientColorStops();
          if (hasLinearGradient) {
            this._strokeLinearGradient(shape);
          } else {
            this.setAttr("strokeStyle", shape.stroke());
          }
          shape._strokeFunc(this);
          if (!strokeScaleEnabled) {
            this.restore();
          }
        }
      }
      _applyShadow(shape) {
        var _a, _b, _c;
        var color = (_a = shape.getShadowRGBA()) !== null && _a !== void 0 ? _a : "black", blur = (_b = shape.getShadowBlur()) !== null && _b !== void 0 ? _b : 5, offset = (_c = shape.getShadowOffset()) !== null && _c !== void 0 ? _c : {
          x: 0,
          y: 0
        }, scale = shape.getAbsoluteScale(), ratio = this.canvas.getPixelRatio(), scaleX = scale.x * ratio, scaleY = scale.y * ratio;
        this.setAttr("shadowColor", color);
        this.setAttr("shadowBlur", blur * Math.min(Math.abs(scaleX), Math.abs(scaleY)));
        this.setAttr("shadowOffsetX", offset.x * scaleX);
        this.setAttr("shadowOffsetY", offset.y * scaleY);
      }
    };
    exports.SceneContext = SceneContext;
    var HitContext = class extends Context {
      constructor(canvas) {
        super(canvas);
        this._context = canvas._canvas.getContext("2d", {
          willReadFrequently: true
        });
      }
      _fill(shape) {
        this.save();
        this.setAttr("fillStyle", shape.colorKey);
        shape._fillFuncHit(this);
        this.restore();
      }
      strokeShape(shape) {
        if (shape.hasHitStroke()) {
          this._stroke(shape);
        }
      }
      _stroke(shape) {
        if (shape.hasHitStroke()) {
          const strokeScaleEnabled = shape.getStrokeScaleEnabled();
          if (!strokeScaleEnabled) {
            this.save();
            var pixelRatio = this.getCanvas().getPixelRatio();
            this.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);
          }
          this._applyLineCap(shape);
          var hitStrokeWidth = shape.hitStrokeWidth();
          var strokeWidth = hitStrokeWidth === "auto" ? shape.strokeWidth() : hitStrokeWidth;
          this.setAttr("lineWidth", strokeWidth);
          this.setAttr("strokeStyle", shape.colorKey);
          shape._strokeFuncHit(this);
          if (!strokeScaleEnabled) {
            this.restore();
          }
        }
      }
    };
    exports.HitContext = HitContext;
  }
});

// node_modules/konva/lib/Canvas.js
var require_Canvas = __commonJS({
  "node_modules/konva/lib/Canvas.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.HitCanvas = exports.SceneCanvas = exports.Canvas = void 0;
    var Util_1 = require_Util();
    var Context_1 = require_Context();
    var Global_1 = require_Global();
    var Factory_1 = require_Factory();
    var Validators_1 = require_Validators();
    var _pixelRatio;
    function getDevicePixelRatio() {
      if (_pixelRatio) {
        return _pixelRatio;
      }
      var canvas = Util_1.Util.createCanvasElement();
      var context = canvas.getContext("2d");
      _pixelRatio = function() {
        var devicePixelRatio = Global_1.Konva._global.devicePixelRatio || 1, backingStoreRatio = context.webkitBackingStorePixelRatio || context.mozBackingStorePixelRatio || context.msBackingStorePixelRatio || context.oBackingStorePixelRatio || context.backingStorePixelRatio || 1;
        return devicePixelRatio / backingStoreRatio;
      }();
      Util_1.Util.releaseCanvas(canvas);
      return _pixelRatio;
    }
    var Canvas = class {
      constructor(config) {
        this.pixelRatio = 1;
        this.width = 0;
        this.height = 0;
        this.isCache = false;
        var conf = config || {};
        var pixelRatio = conf.pixelRatio || Global_1.Konva.pixelRatio || getDevicePixelRatio();
        this.pixelRatio = pixelRatio;
        this._canvas = Util_1.Util.createCanvasElement();
        this._canvas.style.padding = "0";
        this._canvas.style.margin = "0";
        this._canvas.style.border = "0";
        this._canvas.style.background = "transparent";
        this._canvas.style.position = "absolute";
        this._canvas.style.top = "0";
        this._canvas.style.left = "0";
      }
      getContext() {
        return this.context;
      }
      getPixelRatio() {
        return this.pixelRatio;
      }
      setPixelRatio(pixelRatio) {
        var previousRatio = this.pixelRatio;
        this.pixelRatio = pixelRatio;
        this.setSize(this.getWidth() / previousRatio, this.getHeight() / previousRatio);
      }
      setWidth(width) {
        this.width = this._canvas.width = width * this.pixelRatio;
        this._canvas.style.width = width + "px";
        var pixelRatio = this.pixelRatio, _context = this.getContext()._context;
        _context.scale(pixelRatio, pixelRatio);
      }
      setHeight(height) {
        this.height = this._canvas.height = height * this.pixelRatio;
        this._canvas.style.height = height + "px";
        var pixelRatio = this.pixelRatio, _context = this.getContext()._context;
        _context.scale(pixelRatio, pixelRatio);
      }
      getWidth() {
        return this.width;
      }
      getHeight() {
        return this.height;
      }
      setSize(width, height) {
        this.setWidth(width || 0);
        this.setHeight(height || 0);
      }
      toDataURL(mimeType, quality) {
        try {
          return this._canvas.toDataURL(mimeType, quality);
        } catch (e) {
          try {
            return this._canvas.toDataURL();
          } catch (err) {
            Util_1.Util.error("Unable to get data URL. " + err.message + " For more info read https://konvajs.org/docs/posts/Tainted_Canvas.html.");
            return "";
          }
        }
      }
    };
    exports.Canvas = Canvas;
    Factory_1.Factory.addGetterSetter(Canvas, "pixelRatio", void 0, (0, Validators_1.getNumberValidator)());
    var SceneCanvas = class extends Canvas {
      constructor(config = { width: 0, height: 0, willReadFrequently: false }) {
        super(config);
        this.context = new Context_1.SceneContext(this, {
          willReadFrequently: config.willReadFrequently
        });
        this.setSize(config.width, config.height);
      }
    };
    exports.SceneCanvas = SceneCanvas;
    var HitCanvas = class extends Canvas {
      constructor(config = { width: 0, height: 0 }) {
        super(config);
        this.hitCanvas = true;
        this.context = new Context_1.HitContext(this);
        this.setSize(config.width, config.height);
      }
    };
    exports.HitCanvas = HitCanvas;
  }
});

// node_modules/konva/lib/DragAndDrop.js
var require_DragAndDrop = __commonJS({
  "node_modules/konva/lib/DragAndDrop.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DD = void 0;
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    exports.DD = {
      get isDragging() {
        var flag = false;
        exports.DD._dragElements.forEach((elem) => {
          if (elem.dragStatus === "dragging") {
            flag = true;
          }
        });
        return flag;
      },
      justDragged: false,
      get node() {
        var node;
        exports.DD._dragElements.forEach((elem) => {
          node = elem.node;
        });
        return node;
      },
      _dragElements: /* @__PURE__ */ new Map(),
      _drag(evt) {
        const nodesToFireEvents = [];
        exports.DD._dragElements.forEach((elem, key) => {
          const { node } = elem;
          const stage = node.getStage();
          stage.setPointersPositions(evt);
          if (elem.pointerId === void 0) {
            elem.pointerId = Util_1.Util._getFirstPointerId(evt);
          }
          const pos = stage._changedPointerPositions.find((pos2) => pos2.id === elem.pointerId);
          if (!pos) {
            return;
          }
          if (elem.dragStatus !== "dragging") {
            var dragDistance = node.dragDistance();
            var distance = Math.max(Math.abs(pos.x - elem.startPointerPos.x), Math.abs(pos.y - elem.startPointerPos.y));
            if (distance < dragDistance) {
              return;
            }
            node.startDrag({ evt });
            if (!node.isDragging()) {
              return;
            }
          }
          node._setDragPosition(evt, elem);
          nodesToFireEvents.push(node);
        });
        nodesToFireEvents.forEach((node) => {
          node.fire("dragmove", {
            type: "dragmove",
            target: node,
            evt
          }, true);
        });
      },
      _endDragBefore(evt) {
        const drawNodes = [];
        exports.DD._dragElements.forEach((elem) => {
          const { node } = elem;
          const stage = node.getStage();
          if (evt) {
            stage.setPointersPositions(evt);
          }
          const pos = stage._changedPointerPositions.find((pos2) => pos2.id === elem.pointerId);
          if (!pos) {
            return;
          }
          if (elem.dragStatus === "dragging" || elem.dragStatus === "stopped") {
            exports.DD.justDragged = true;
            Global_1.Konva._mouseListenClick = false;
            Global_1.Konva._touchListenClick = false;
            Global_1.Konva._pointerListenClick = false;
            elem.dragStatus = "stopped";
          }
          const drawNode = elem.node.getLayer() || elem.node instanceof Global_1.Konva["Stage"] && elem.node;
          if (drawNode && drawNodes.indexOf(drawNode) === -1) {
            drawNodes.push(drawNode);
          }
        });
        drawNodes.forEach((drawNode) => {
          drawNode.draw();
        });
      },
      _endDragAfter(evt) {
        exports.DD._dragElements.forEach((elem, key) => {
          if (elem.dragStatus === "stopped") {
            elem.node.fire("dragend", {
              type: "dragend",
              target: elem.node,
              evt
            }, true);
          }
          if (elem.dragStatus !== "dragging") {
            exports.DD._dragElements.delete(key);
          }
        });
      }
    };
    if (Global_1.Konva.isBrowser) {
      window.addEventListener("mouseup", exports.DD._endDragBefore, true);
      window.addEventListener("touchend", exports.DD._endDragBefore, true);
      window.addEventListener("mousemove", exports.DD._drag);
      window.addEventListener("touchmove", exports.DD._drag);
      window.addEventListener("mouseup", exports.DD._endDragAfter, false);
      window.addEventListener("touchend", exports.DD._endDragAfter, false);
    }
  }
});

// node_modules/konva/lib/Node.js
var require_Node = __commonJS({
  "node_modules/konva/lib/Node.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Node = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Canvas_1 = require_Canvas();
    var Global_1 = require_Global();
    var DragAndDrop_1 = require_DragAndDrop();
    var Validators_1 = require_Validators();
    var ABSOLUTE_OPACITY = "absoluteOpacity";
    var ALL_LISTENERS = "allEventListeners";
    var ABSOLUTE_TRANSFORM = "absoluteTransform";
    var ABSOLUTE_SCALE = "absoluteScale";
    var CANVAS = "canvas";
    var CHANGE = "Change";
    var CHILDREN = "children";
    var KONVA = "konva";
    var LISTENING = "listening";
    var MOUSEENTER = "mouseenter";
    var MOUSELEAVE = "mouseleave";
    var SET = "set";
    var SHAPE = "Shape";
    var SPACE = " ";
    var STAGE = "stage";
    var TRANSFORM = "transform";
    var UPPER_STAGE = "Stage";
    var VISIBLE = "visible";
    var TRANSFORM_CHANGE_STR = [
      "xChange.konva",
      "yChange.konva",
      "scaleXChange.konva",
      "scaleYChange.konva",
      "skewXChange.konva",
      "skewYChange.konva",
      "rotationChange.konva",
      "offsetXChange.konva",
      "offsetYChange.konva",
      "transformsEnabledChange.konva"
    ].join(SPACE);
    var idCounter = 1;
    var Node = class _Node {
      constructor(config) {
        this._id = idCounter++;
        this.eventListeners = {};
        this.attrs = {};
        this.index = 0;
        this._allEventListeners = null;
        this.parent = null;
        this._cache = /* @__PURE__ */ new Map();
        this._attachedDepsListeners = /* @__PURE__ */ new Map();
        this._lastPos = null;
        this._batchingTransformChange = false;
        this._needClearTransformCache = false;
        this._filterUpToDate = false;
        this._isUnderCache = false;
        this._dragEventId = null;
        this._shouldFireChangeEvents = false;
        this.setAttrs(config);
        this._shouldFireChangeEvents = true;
      }
      hasChildren() {
        return false;
      }
      _clearCache(attr) {
        if ((attr === TRANSFORM || attr === ABSOLUTE_TRANSFORM) && this._cache.get(attr)) {
          this._cache.get(attr).dirty = true;
        } else if (attr) {
          this._cache.delete(attr);
        } else {
          this._cache.clear();
        }
      }
      _getCache(attr, privateGetter) {
        var cache = this._cache.get(attr);
        var isTransform = attr === TRANSFORM || attr === ABSOLUTE_TRANSFORM;
        var invalid = cache === void 0 || isTransform && cache.dirty === true;
        if (invalid) {
          cache = privateGetter.call(this);
          this._cache.set(attr, cache);
        }
        return cache;
      }
      _calculate(name, deps, getter) {
        if (!this._attachedDepsListeners.get(name)) {
          const depsString = deps.map((dep) => dep + "Change.konva").join(SPACE);
          this.on(depsString, () => {
            this._clearCache(name);
          });
          this._attachedDepsListeners.set(name, true);
        }
        return this._getCache(name, getter);
      }
      _getCanvasCache() {
        return this._cache.get(CANVAS);
      }
      _clearSelfAndDescendantCache(attr) {
        this._clearCache(attr);
        if (attr === ABSOLUTE_TRANSFORM) {
          this.fire("absoluteTransformChange");
        }
      }
      clearCache() {
        if (this._cache.has(CANVAS)) {
          const { scene, filter, hit } = this._cache.get(CANVAS);
          Util_1.Util.releaseCanvas(scene, filter, hit);
          this._cache.delete(CANVAS);
        }
        this._clearSelfAndDescendantCache();
        this._requestDraw();
        return this;
      }
      cache(config) {
        var conf = config || {};
        var rect = {};
        if (conf.x === void 0 || conf.y === void 0 || conf.width === void 0 || conf.height === void 0) {
          rect = this.getClientRect({
            skipTransform: true,
            relativeTo: this.getParent() || void 0
          });
        }
        var width = Math.ceil(conf.width || rect.width), height = Math.ceil(conf.height || rect.height), pixelRatio = conf.pixelRatio, x = conf.x === void 0 ? Math.floor(rect.x) : conf.x, y = conf.y === void 0 ? Math.floor(rect.y) : conf.y, offset = conf.offset || 0, drawBorder = conf.drawBorder || false, hitCanvasPixelRatio = conf.hitCanvasPixelRatio || 1;
        if (!width || !height) {
          Util_1.Util.error("Can not cache the node. Width or height of the node equals 0. Caching is skipped.");
          return;
        }
        const extraPaddingX = Math.abs(Math.round(rect.x) - x) > 0.5 ? 1 : 0;
        const extraPaddingY = Math.abs(Math.round(rect.y) - y) > 0.5 ? 1 : 0;
        width += offset * 2 + extraPaddingX;
        height += offset * 2 + extraPaddingY;
        x -= offset;
        y -= offset;
        var cachedSceneCanvas = new Canvas_1.SceneCanvas({
          pixelRatio,
          width,
          height
        }), cachedFilterCanvas = new Canvas_1.SceneCanvas({
          pixelRatio,
          width: 0,
          height: 0,
          willReadFrequently: true
        }), cachedHitCanvas = new Canvas_1.HitCanvas({
          pixelRatio: hitCanvasPixelRatio,
          width,
          height
        }), sceneContext = cachedSceneCanvas.getContext(), hitContext = cachedHitCanvas.getContext();
        cachedHitCanvas.isCache = true;
        cachedSceneCanvas.isCache = true;
        this._cache.delete(CANVAS);
        this._filterUpToDate = false;
        if (conf.imageSmoothingEnabled === false) {
          cachedSceneCanvas.getContext()._context.imageSmoothingEnabled = false;
          cachedFilterCanvas.getContext()._context.imageSmoothingEnabled = false;
        }
        sceneContext.save();
        hitContext.save();
        sceneContext.translate(-x, -y);
        hitContext.translate(-x, -y);
        this._isUnderCache = true;
        this._clearSelfAndDescendantCache(ABSOLUTE_OPACITY);
        this._clearSelfAndDescendantCache(ABSOLUTE_SCALE);
        this.drawScene(cachedSceneCanvas, this);
        this.drawHit(cachedHitCanvas, this);
        this._isUnderCache = false;
        sceneContext.restore();
        hitContext.restore();
        if (drawBorder) {
          sceneContext.save();
          sceneContext.beginPath();
          sceneContext.rect(0, 0, width, height);
          sceneContext.closePath();
          sceneContext.setAttr("strokeStyle", "red");
          sceneContext.setAttr("lineWidth", 5);
          sceneContext.stroke();
          sceneContext.restore();
        }
        this._cache.set(CANVAS, {
          scene: cachedSceneCanvas,
          filter: cachedFilterCanvas,
          hit: cachedHitCanvas,
          x,
          y
        });
        this._requestDraw();
        return this;
      }
      isCached() {
        return this._cache.has(CANVAS);
      }
      getClientRect(config) {
        throw new Error('abstract "getClientRect" method call');
      }
      _transformedRect(rect, top) {
        var points = [
          { x: rect.x, y: rect.y },
          { x: rect.x + rect.width, y: rect.y },
          { x: rect.x + rect.width, y: rect.y + rect.height },
          { x: rect.x, y: rect.y + rect.height }
        ];
        var minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity;
        var trans = this.getAbsoluteTransform(top);
        points.forEach(function(point) {
          var transformed = trans.point(point);
          if (minX === void 0) {
            minX = maxX = transformed.x;
            minY = maxY = transformed.y;
          }
          minX = Math.min(minX, transformed.x);
          minY = Math.min(minY, transformed.y);
          maxX = Math.max(maxX, transformed.x);
          maxY = Math.max(maxY, transformed.y);
        });
        return {
          x: minX,
          y: minY,
          width: maxX - minX,
          height: maxY - minY
        };
      }
      _drawCachedSceneCanvas(context) {
        context.save();
        context._applyOpacity(this);
        context._applyGlobalCompositeOperation(this);
        const canvasCache = this._getCanvasCache();
        context.translate(canvasCache.x, canvasCache.y);
        var cacheCanvas = this._getCachedSceneCanvas();
        var ratio = cacheCanvas.pixelRatio;
        context.drawImage(cacheCanvas._canvas, 0, 0, cacheCanvas.width / ratio, cacheCanvas.height / ratio);
        context.restore();
      }
      _drawCachedHitCanvas(context) {
        var canvasCache = this._getCanvasCache(), hitCanvas = canvasCache.hit;
        context.save();
        context.translate(canvasCache.x, canvasCache.y);
        context.drawImage(hitCanvas._canvas, 0, 0, hitCanvas.width / hitCanvas.pixelRatio, hitCanvas.height / hitCanvas.pixelRatio);
        context.restore();
      }
      _getCachedSceneCanvas() {
        var filters = this.filters(), cachedCanvas = this._getCanvasCache(), sceneCanvas = cachedCanvas.scene, filterCanvas = cachedCanvas.filter, filterContext = filterCanvas.getContext(), len, imageData, n, filter;
        if (filters) {
          if (!this._filterUpToDate) {
            var ratio = sceneCanvas.pixelRatio;
            filterCanvas.setSize(sceneCanvas.width / sceneCanvas.pixelRatio, sceneCanvas.height / sceneCanvas.pixelRatio);
            try {
              len = filters.length;
              filterContext.clear();
              filterContext.drawImage(sceneCanvas._canvas, 0, 0, sceneCanvas.getWidth() / ratio, sceneCanvas.getHeight() / ratio);
              imageData = filterContext.getImageData(0, 0, filterCanvas.getWidth(), filterCanvas.getHeight());
              for (n = 0; n < len; n++) {
                filter = filters[n];
                if (typeof filter !== "function") {
                  Util_1.Util.error("Filter should be type of function, but got " + typeof filter + " instead. Please check correct filters");
                  continue;
                }
                filter.call(this, imageData);
                filterContext.putImageData(imageData, 0, 0);
              }
            } catch (e) {
              Util_1.Util.error("Unable to apply filter. " + e.message + " This post my help you https://konvajs.org/docs/posts/Tainted_Canvas.html.");
            }
            this._filterUpToDate = true;
          }
          return filterCanvas;
        }
        return sceneCanvas;
      }
      on(evtStr, handler) {
        this._cache && this._cache.delete(ALL_LISTENERS);
        if (arguments.length === 3) {
          return this._delegate.apply(this, arguments);
        }
        var events = evtStr.split(SPACE), len = events.length, n, event, parts, baseEvent, name;
        for (n = 0; n < len; n++) {
          event = events[n];
          parts = event.split(".");
          baseEvent = parts[0];
          name = parts[1] || "";
          if (!this.eventListeners[baseEvent]) {
            this.eventListeners[baseEvent] = [];
          }
          this.eventListeners[baseEvent].push({
            name,
            handler
          });
        }
        return this;
      }
      off(evtStr, callback) {
        var events = (evtStr || "").split(SPACE), len = events.length, n, t, event, parts, baseEvent, name;
        this._cache && this._cache.delete(ALL_LISTENERS);
        if (!evtStr) {
          for (t in this.eventListeners) {
            this._off(t);
          }
        }
        for (n = 0; n < len; n++) {
          event = events[n];
          parts = event.split(".");
          baseEvent = parts[0];
          name = parts[1];
          if (baseEvent) {
            if (this.eventListeners[baseEvent]) {
              this._off(baseEvent, name, callback);
            }
          } else {
            for (t in this.eventListeners) {
              this._off(t, name, callback);
            }
          }
        }
        return this;
      }
      dispatchEvent(evt) {
        var e = {
          target: this,
          type: evt.type,
          evt
        };
        this.fire(evt.type, e);
        return this;
      }
      addEventListener(type, handler) {
        this.on(type, function(evt) {
          handler.call(this, evt.evt);
        });
        return this;
      }
      removeEventListener(type) {
        this.off(type);
        return this;
      }
      _delegate(event, selector, handler) {
        var stopNode = this;
        this.on(event, function(evt) {
          var targets = evt.target.findAncestors(selector, true, stopNode);
          for (var i = 0; i < targets.length; i++) {
            evt = Util_1.Util.cloneObject(evt);
            evt.currentTarget = targets[i];
            handler.call(targets[i], evt);
          }
        });
      }
      remove() {
        if (this.isDragging()) {
          this.stopDrag();
        }
        DragAndDrop_1.DD._dragElements.delete(this._id);
        this._remove();
        return this;
      }
      _clearCaches() {
        this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);
        this._clearSelfAndDescendantCache(ABSOLUTE_OPACITY);
        this._clearSelfAndDescendantCache(ABSOLUTE_SCALE);
        this._clearSelfAndDescendantCache(STAGE);
        this._clearSelfAndDescendantCache(VISIBLE);
        this._clearSelfAndDescendantCache(LISTENING);
      }
      _remove() {
        this._clearCaches();
        var parent = this.getParent();
        if (parent && parent.children) {
          parent.children.splice(this.index, 1);
          parent._setChildrenIndices();
          this.parent = null;
        }
      }
      destroy() {
        this.remove();
        this.clearCache();
        return this;
      }
      getAttr(attr) {
        var method = "get" + Util_1.Util._capitalize(attr);
        if (Util_1.Util._isFunction(this[method])) {
          return this[method]();
        }
        return this.attrs[attr];
      }
      getAncestors() {
        var parent = this.getParent(), ancestors = [];
        while (parent) {
          ancestors.push(parent);
          parent = parent.getParent();
        }
        return ancestors;
      }
      getAttrs() {
        return this.attrs || {};
      }
      setAttrs(config) {
        this._batchTransformChanges(() => {
          var key, method;
          if (!config) {
            return this;
          }
          for (key in config) {
            if (key === CHILDREN) {
              continue;
            }
            method = SET + Util_1.Util._capitalize(key);
            if (Util_1.Util._isFunction(this[method])) {
              this[method](config[key]);
            } else {
              this._setAttr(key, config[key]);
            }
          }
        });
        return this;
      }
      isListening() {
        return this._getCache(LISTENING, this._isListening);
      }
      _isListening(relativeTo) {
        const listening = this.listening();
        if (!listening) {
          return false;
        }
        const parent = this.getParent();
        if (parent && parent !== relativeTo && this !== relativeTo) {
          return parent._isListening(relativeTo);
        } else {
          return true;
        }
      }
      isVisible() {
        return this._getCache(VISIBLE, this._isVisible);
      }
      _isVisible(relativeTo) {
        const visible = this.visible();
        if (!visible) {
          return false;
        }
        const parent = this.getParent();
        if (parent && parent !== relativeTo && this !== relativeTo) {
          return parent._isVisible(relativeTo);
        } else {
          return true;
        }
      }
      shouldDrawHit(top, skipDragCheck = false) {
        if (top) {
          return this._isVisible(top) && this._isListening(top);
        }
        var layer = this.getLayer();
        var layerUnderDrag = false;
        DragAndDrop_1.DD._dragElements.forEach((elem) => {
          if (elem.dragStatus !== "dragging") {
            return;
          } else if (elem.node.nodeType === "Stage") {
            layerUnderDrag = true;
          } else if (elem.node.getLayer() === layer) {
            layerUnderDrag = true;
          }
        });
        var dragSkip = !skipDragCheck && !Global_1.Konva.hitOnDragEnabled && (layerUnderDrag || Global_1.Konva.isTransforming());
        return this.isListening() && this.isVisible() && !dragSkip;
      }
      show() {
        this.visible(true);
        return this;
      }
      hide() {
        this.visible(false);
        return this;
      }
      getZIndex() {
        return this.index || 0;
      }
      getAbsoluteZIndex() {
        var depth = this.getDepth(), that = this, index = 0, nodes, len, n, child;
        function addChildren(children) {
          nodes = [];
          len = children.length;
          for (n = 0; n < len; n++) {
            child = children[n];
            index++;
            if (child.nodeType !== SHAPE) {
              nodes = nodes.concat(child.getChildren().slice());
            }
            if (child._id === that._id) {
              n = len;
            }
          }
          if (nodes.length > 0 && nodes[0].getDepth() <= depth) {
            addChildren(nodes);
          }
        }
        const stage = this.getStage();
        if (that.nodeType !== UPPER_STAGE && stage) {
          addChildren(stage.getChildren());
        }
        return index;
      }
      getDepth() {
        var depth = 0, parent = this.parent;
        while (parent) {
          depth++;
          parent = parent.parent;
        }
        return depth;
      }
      _batchTransformChanges(func) {
        this._batchingTransformChange = true;
        func();
        this._batchingTransformChange = false;
        if (this._needClearTransformCache) {
          this._clearCache(TRANSFORM);
          this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);
        }
        this._needClearTransformCache = false;
      }
      setPosition(pos) {
        this._batchTransformChanges(() => {
          this.x(pos.x);
          this.y(pos.y);
        });
        return this;
      }
      getPosition() {
        return {
          x: this.x(),
          y: this.y()
        };
      }
      getRelativePointerPosition() {
        const stage = this.getStage();
        if (!stage) {
          return null;
        }
        var pos = stage.getPointerPosition();
        if (!pos) {
          return null;
        }
        var transform = this.getAbsoluteTransform().copy();
        transform.invert();
        return transform.point(pos);
      }
      getAbsolutePosition(top) {
        let haveCachedParent = false;
        let parent = this.parent;
        while (parent) {
          if (parent.isCached()) {
            haveCachedParent = true;
            break;
          }
          parent = parent.parent;
        }
        if (haveCachedParent && !top) {
          top = true;
        }
        var absoluteMatrix = this.getAbsoluteTransform(top).getMatrix(), absoluteTransform = new Util_1.Transform(), offset = this.offset();
        absoluteTransform.m = absoluteMatrix.slice();
        absoluteTransform.translate(offset.x, offset.y);
        return absoluteTransform.getTranslation();
      }
      setAbsolutePosition(pos) {
        const { x, y, ...origTrans } = this._clearTransform();
        this.attrs.x = x;
        this.attrs.y = y;
        this._clearCache(TRANSFORM);
        var it = this._getAbsoluteTransform().copy();
        it.invert();
        it.translate(pos.x, pos.y);
        pos = {
          x: this.attrs.x + it.getTranslation().x,
          y: this.attrs.y + it.getTranslation().y
        };
        this._setTransform(origTrans);
        this.setPosition({ x: pos.x, y: pos.y });
        this._clearCache(TRANSFORM);
        this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);
        return this;
      }
      _setTransform(trans) {
        var key;
        for (key in trans) {
          this.attrs[key] = trans[key];
        }
      }
      _clearTransform() {
        var trans = {
          x: this.x(),
          y: this.y(),
          rotation: this.rotation(),
          scaleX: this.scaleX(),
          scaleY: this.scaleY(),
          offsetX: this.offsetX(),
          offsetY: this.offsetY(),
          skewX: this.skewX(),
          skewY: this.skewY()
        };
        this.attrs.x = 0;
        this.attrs.y = 0;
        this.attrs.rotation = 0;
        this.attrs.scaleX = 1;
        this.attrs.scaleY = 1;
        this.attrs.offsetX = 0;
        this.attrs.offsetY = 0;
        this.attrs.skewX = 0;
        this.attrs.skewY = 0;
        return trans;
      }
      move(change) {
        var changeX = change.x, changeY = change.y, x = this.x(), y = this.y();
        if (changeX !== void 0) {
          x += changeX;
        }
        if (changeY !== void 0) {
          y += changeY;
        }
        this.setPosition({ x, y });
        return this;
      }
      _eachAncestorReverse(func, top) {
        var family = [], parent = this.getParent(), len, n;
        if (top && top._id === this._id) {
          return;
        }
        family.unshift(this);
        while (parent && (!top || parent._id !== top._id)) {
          family.unshift(parent);
          parent = parent.parent;
        }
        len = family.length;
        for (n = 0; n < len; n++) {
          func(family[n]);
        }
      }
      rotate(theta) {
        this.rotation(this.rotation() + theta);
        return this;
      }
      moveToTop() {
        if (!this.parent) {
          Util_1.Util.warn("Node has no parent. moveToTop function is ignored.");
          return false;
        }
        var index = this.index, len = this.parent.getChildren().length;
        if (index < len - 1) {
          this.parent.children.splice(index, 1);
          this.parent.children.push(this);
          this.parent._setChildrenIndices();
          return true;
        }
        return false;
      }
      moveUp() {
        if (!this.parent) {
          Util_1.Util.warn("Node has no parent. moveUp function is ignored.");
          return false;
        }
        var index = this.index, len = this.parent.getChildren().length;
        if (index < len - 1) {
          this.parent.children.splice(index, 1);
          this.parent.children.splice(index + 1, 0, this);
          this.parent._setChildrenIndices();
          return true;
        }
        return false;
      }
      moveDown() {
        if (!this.parent) {
          Util_1.Util.warn("Node has no parent. moveDown function is ignored.");
          return false;
        }
        var index = this.index;
        if (index > 0) {
          this.parent.children.splice(index, 1);
          this.parent.children.splice(index - 1, 0, this);
          this.parent._setChildrenIndices();
          return true;
        }
        return false;
      }
      moveToBottom() {
        if (!this.parent) {
          Util_1.Util.warn("Node has no parent. moveToBottom function is ignored.");
          return false;
        }
        var index = this.index;
        if (index > 0) {
          this.parent.children.splice(index, 1);
          this.parent.children.unshift(this);
          this.parent._setChildrenIndices();
          return true;
        }
        return false;
      }
      setZIndex(zIndex) {
        if (!this.parent) {
          Util_1.Util.warn("Node has no parent. zIndex parameter is ignored.");
          return this;
        }
        if (zIndex < 0 || zIndex >= this.parent.children.length) {
          Util_1.Util.warn("Unexpected value " + zIndex + " for zIndex property. zIndex is just index of a node in children of its parent. Expected value is from 0 to " + (this.parent.children.length - 1) + ".");
        }
        var index = this.index;
        this.parent.children.splice(index, 1);
        this.parent.children.splice(zIndex, 0, this);
        this.parent._setChildrenIndices();
        return this;
      }
      getAbsoluteOpacity() {
        return this._getCache(ABSOLUTE_OPACITY, this._getAbsoluteOpacity);
      }
      _getAbsoluteOpacity() {
        var absOpacity = this.opacity();
        var parent = this.getParent();
        if (parent && !parent._isUnderCache) {
          absOpacity *= parent.getAbsoluteOpacity();
        }
        return absOpacity;
      }
      moveTo(newContainer) {
        if (this.getParent() !== newContainer) {
          this._remove();
          newContainer.add(this);
        }
        return this;
      }
      toObject() {
        var attrs = this.getAttrs(), key, val, getter, defaultValue, nonPlainObject;
        const obj = {
          attrs: {},
          className: this.getClassName()
        };
        for (key in attrs) {
          val = attrs[key];
          nonPlainObject = Util_1.Util.isObject(val) && !Util_1.Util._isPlainObject(val) && !Util_1.Util._isArray(val);
          if (nonPlainObject) {
            continue;
          }
          getter = typeof this[key] === "function" && this[key];
          delete attrs[key];
          defaultValue = getter ? getter.call(this) : null;
          attrs[key] = val;
          if (defaultValue !== val) {
            obj.attrs[key] = val;
          }
        }
        return Util_1.Util._prepareToStringify(obj);
      }
      toJSON() {
        return JSON.stringify(this.toObject());
      }
      getParent() {
        return this.parent;
      }
      findAncestors(selector, includeSelf, stopNode) {
        var res = [];
        if (includeSelf && this._isMatch(selector)) {
          res.push(this);
        }
        var ancestor = this.parent;
        while (ancestor) {
          if (ancestor === stopNode) {
            return res;
          }
          if (ancestor._isMatch(selector)) {
            res.push(ancestor);
          }
          ancestor = ancestor.parent;
        }
        return res;
      }
      isAncestorOf(node) {
        return false;
      }
      findAncestor(selector, includeSelf, stopNode) {
        return this.findAncestors(selector, includeSelf, stopNode)[0];
      }
      _isMatch(selector) {
        if (!selector) {
          return false;
        }
        if (typeof selector === "function") {
          return selector(this);
        }
        var selectorArr = selector.replace(/ /g, "").split(","), len = selectorArr.length, n, sel;
        for (n = 0; n < len; n++) {
          sel = selectorArr[n];
          if (!Util_1.Util.isValidSelector(sel)) {
            Util_1.Util.warn('Selector "' + sel + '" is invalid. Allowed selectors examples are "#foo", ".bar" or "Group".');
            Util_1.Util.warn('If you have a custom shape with such className, please change it to start with upper letter like "Triangle".');
            Util_1.Util.warn("Konva is awesome, right?");
          }
          if (sel.charAt(0) === "#") {
            if (this.id() === sel.slice(1)) {
              return true;
            }
          } else if (sel.charAt(0) === ".") {
            if (this.hasName(sel.slice(1))) {
              return true;
            }
          } else if (this.className === sel || this.nodeType === sel) {
            return true;
          }
        }
        return false;
      }
      getLayer() {
        var parent = this.getParent();
        return parent ? parent.getLayer() : null;
      }
      getStage() {
        return this._getCache(STAGE, this._getStage);
      }
      _getStage() {
        var parent = this.getParent();
        if (parent) {
          return parent.getStage();
        } else {
          return null;
        }
      }
      fire(eventType, evt = {}, bubble) {
        evt.target = evt.target || this;
        if (bubble) {
          this._fireAndBubble(eventType, evt);
        } else {
          this._fire(eventType, evt);
        }
        return this;
      }
      getAbsoluteTransform(top) {
        if (top) {
          return this._getAbsoluteTransform(top);
        } else {
          return this._getCache(ABSOLUTE_TRANSFORM, this._getAbsoluteTransform);
        }
      }
      _getAbsoluteTransform(top) {
        var at;
        if (top) {
          at = new Util_1.Transform();
          this._eachAncestorReverse(function(node) {
            var transformsEnabled2 = node.transformsEnabled();
            if (transformsEnabled2 === "all") {
              at.multiply(node.getTransform());
            } else if (transformsEnabled2 === "position") {
              at.translate(node.x() - node.offsetX(), node.y() - node.offsetY());
            }
          }, top);
          return at;
        } else {
          at = this._cache.get(ABSOLUTE_TRANSFORM) || new Util_1.Transform();
          if (this.parent) {
            this.parent.getAbsoluteTransform().copyInto(at);
          } else {
            at.reset();
          }
          var transformsEnabled = this.transformsEnabled();
          if (transformsEnabled === "all") {
            at.multiply(this.getTransform());
          } else if (transformsEnabled === "position") {
            const x = this.attrs.x || 0;
            const y = this.attrs.y || 0;
            const offsetX = this.attrs.offsetX || 0;
            const offsetY = this.attrs.offsetY || 0;
            at.translate(x - offsetX, y - offsetY);
          }
          at.dirty = false;
          return at;
        }
      }
      getAbsoluteScale(top) {
        var parent = this;
        while (parent) {
          if (parent._isUnderCache) {
            top = parent;
          }
          parent = parent.getParent();
        }
        const transform = this.getAbsoluteTransform(top);
        const attrs = transform.decompose();
        return {
          x: attrs.scaleX,
          y: attrs.scaleY
        };
      }
      getAbsoluteRotation() {
        return this.getAbsoluteTransform().decompose().rotation;
      }
      getTransform() {
        return this._getCache(TRANSFORM, this._getTransform);
      }
      _getTransform() {
        var _a, _b;
        var m = this._cache.get(TRANSFORM) || new Util_1.Transform();
        m.reset();
        var x = this.x(), y = this.y(), rotation = Global_1.Konva.getAngle(this.rotation()), scaleX = (_a = this.attrs.scaleX) !== null && _a !== void 0 ? _a : 1, scaleY = (_b = this.attrs.scaleY) !== null && _b !== void 0 ? _b : 1, skewX = this.attrs.skewX || 0, skewY = this.attrs.skewY || 0, offsetX = this.attrs.offsetX || 0, offsetY = this.attrs.offsetY || 0;
        if (x !== 0 || y !== 0) {
          m.translate(x, y);
        }
        if (rotation !== 0) {
          m.rotate(rotation);
        }
        if (skewX !== 0 || skewY !== 0) {
          m.skew(skewX, skewY);
        }
        if (scaleX !== 1 || scaleY !== 1) {
          m.scale(scaleX, scaleY);
        }
        if (offsetX !== 0 || offsetY !== 0) {
          m.translate(-1 * offsetX, -1 * offsetY);
        }
        m.dirty = false;
        return m;
      }
      clone(obj) {
        var attrs = Util_1.Util.cloneObject(this.attrs), key, allListeners, len, n, listener;
        for (key in obj) {
          attrs[key] = obj[key];
        }
        var node = new this.constructor(attrs);
        for (key in this.eventListeners) {
          allListeners = this.eventListeners[key];
          len = allListeners.length;
          for (n = 0; n < len; n++) {
            listener = allListeners[n];
            if (listener.name.indexOf(KONVA) < 0) {
              if (!node.eventListeners[key]) {
                node.eventListeners[key] = [];
              }
              node.eventListeners[key].push(listener);
            }
          }
        }
        return node;
      }
      _toKonvaCanvas(config) {
        config = config || {};
        var box = this.getClientRect();
        var stage = this.getStage(), x = config.x !== void 0 ? config.x : Math.floor(box.x), y = config.y !== void 0 ? config.y : Math.floor(box.y), pixelRatio = config.pixelRatio || 1, canvas = new Canvas_1.SceneCanvas({
          width: config.width || Math.ceil(box.width) || (stage ? stage.width() : 0),
          height: config.height || Math.ceil(box.height) || (stage ? stage.height() : 0),
          pixelRatio
        }), context = canvas.getContext();
        const bufferCanvas = new Canvas_1.SceneCanvas({
          width: canvas.width / canvas.pixelRatio + Math.abs(x),
          height: canvas.height / canvas.pixelRatio + Math.abs(y),
          pixelRatio: canvas.pixelRatio
        });
        if (config.imageSmoothingEnabled === false) {
          context._context.imageSmoothingEnabled = false;
        }
        context.save();
        if (x || y) {
          context.translate(-1 * x, -1 * y);
        }
        this.drawScene(canvas, void 0, bufferCanvas);
        context.restore();
        return canvas;
      }
      toCanvas(config) {
        return this._toKonvaCanvas(config)._canvas;
      }
      toDataURL(config) {
        config = config || {};
        var mimeType = config.mimeType || null, quality = config.quality || null;
        var url = this._toKonvaCanvas(config).toDataURL(mimeType, quality);
        if (config.callback) {
          config.callback(url);
        }
        return url;
      }
      toImage(config) {
        return new Promise((resolve, reject) => {
          try {
            const callback = config === null || config === void 0 ? void 0 : config.callback;
            if (callback)
              delete config.callback;
            Util_1.Util._urlToImage(this.toDataURL(config), function(img) {
              resolve(img);
              callback === null || callback === void 0 ? void 0 : callback(img);
            });
          } catch (err) {
            reject(err);
          }
        });
      }
      toBlob(config) {
        return new Promise((resolve, reject) => {
          try {
            const callback = config === null || config === void 0 ? void 0 : config.callback;
            if (callback)
              delete config.callback;
            this.toCanvas(config).toBlob((blob) => {
              resolve(blob);
              callback === null || callback === void 0 ? void 0 : callback(blob);
            }, config === null || config === void 0 ? void 0 : config.mimeType, config === null || config === void 0 ? void 0 : config.quality);
          } catch (err) {
            reject(err);
          }
        });
      }
      setSize(size) {
        this.width(size.width);
        this.height(size.height);
        return this;
      }
      getSize() {
        return {
          width: this.width(),
          height: this.height()
        };
      }
      getClassName() {
        return this.className || this.nodeType;
      }
      getType() {
        return this.nodeType;
      }
      getDragDistance() {
        if (this.attrs.dragDistance !== void 0) {
          return this.attrs.dragDistance;
        } else if (this.parent) {
          return this.parent.getDragDistance();
        } else {
          return Global_1.Konva.dragDistance;
        }
      }
      _off(type, name, callback) {
        var evtListeners = this.eventListeners[type], i, evtName, handler;
        for (i = 0; i < evtListeners.length; i++) {
          evtName = evtListeners[i].name;
          handler = evtListeners[i].handler;
          if ((evtName !== "konva" || name === "konva") && (!name || evtName === name) && (!callback || callback === handler)) {
            evtListeners.splice(i, 1);
            if (evtListeners.length === 0) {
              delete this.eventListeners[type];
              break;
            }
            i--;
          }
        }
      }
      _fireChangeEvent(attr, oldVal, newVal) {
        this._fire(attr + CHANGE, {
          oldVal,
          newVal
        });
      }
      addName(name) {
        if (!this.hasName(name)) {
          var oldName = this.name();
          var newName = oldName ? oldName + " " + name : name;
          this.name(newName);
        }
        return this;
      }
      hasName(name) {
        if (!name) {
          return false;
        }
        const fullName = this.name();
        if (!fullName) {
          return false;
        }
        var names = (fullName || "").split(/\s/g);
        return names.indexOf(name) !== -1;
      }
      removeName(name) {
        var names = (this.name() || "").split(/\s/g);
        var index = names.indexOf(name);
        if (index !== -1) {
          names.splice(index, 1);
          this.name(names.join(" "));
        }
        return this;
      }
      setAttr(attr, val) {
        var func = this[SET + Util_1.Util._capitalize(attr)];
        if (Util_1.Util._isFunction(func)) {
          func.call(this, val);
        } else {
          this._setAttr(attr, val);
        }
        return this;
      }
      _requestDraw() {
        if (Global_1.Konva.autoDrawEnabled) {
          const drawNode = this.getLayer() || this.getStage();
          drawNode === null || drawNode === void 0 ? void 0 : drawNode.batchDraw();
        }
      }
      _setAttr(key, val) {
        var oldVal = this.attrs[key];
        if (oldVal === val && !Util_1.Util.isObject(val)) {
          return;
        }
        if (val === void 0 || val === null) {
          delete this.attrs[key];
        } else {
          this.attrs[key] = val;
        }
        if (this._shouldFireChangeEvents) {
          this._fireChangeEvent(key, oldVal, val);
        }
        this._requestDraw();
      }
      _setComponentAttr(key, component, val) {
        var oldVal;
        if (val !== void 0) {
          oldVal = this.attrs[key];
          if (!oldVal) {
            this.attrs[key] = this.getAttr(key);
          }
          this.attrs[key][component] = val;
          this._fireChangeEvent(key, oldVal, val);
        }
      }
      _fireAndBubble(eventType, evt, compareShape) {
        if (evt && this.nodeType === SHAPE) {
          evt.target = this;
        }
        var shouldStop = (eventType === MOUSEENTER || eventType === MOUSELEAVE) && (compareShape && (this === compareShape || this.isAncestorOf && this.isAncestorOf(compareShape)) || this.nodeType === "Stage" && !compareShape);
        if (!shouldStop) {
          this._fire(eventType, evt);
          var stopBubble = (eventType === MOUSEENTER || eventType === MOUSELEAVE) && compareShape && compareShape.isAncestorOf && compareShape.isAncestorOf(this) && !compareShape.isAncestorOf(this.parent);
          if ((evt && !evt.cancelBubble || !evt) && this.parent && this.parent.isListening() && !stopBubble) {
            if (compareShape && compareShape.parent) {
              this._fireAndBubble.call(this.parent, eventType, evt, compareShape);
            } else {
              this._fireAndBubble.call(this.parent, eventType, evt);
            }
          }
        }
      }
      _getProtoListeners(eventType) {
        var _a, _b, _c;
        const allListeners = (_a = this._cache.get(ALL_LISTENERS)) !== null && _a !== void 0 ? _a : {};
        let events = allListeners === null || allListeners === void 0 ? void 0 : allListeners[eventType];
        if (events === void 0) {
          events = [];
          let obj = Object.getPrototypeOf(this);
          while (obj) {
            const hierarchyEvents = (_c = (_b = obj.eventListeners) === null || _b === void 0 ? void 0 : _b[eventType]) !== null && _c !== void 0 ? _c : [];
            events.push(...hierarchyEvents);
            obj = Object.getPrototypeOf(obj);
          }
          allListeners[eventType] = events;
          this._cache.set(ALL_LISTENERS, allListeners);
        }
        return events;
      }
      _fire(eventType, evt) {
        evt = evt || {};
        evt.currentTarget = this;
        evt.type = eventType;
        const topListeners = this._getProtoListeners(eventType);
        if (topListeners) {
          for (var i = 0; i < topListeners.length; i++) {
            topListeners[i].handler.call(this, evt);
          }
        }
        const selfListeners = this.eventListeners[eventType];
        if (selfListeners) {
          for (var i = 0; i < selfListeners.length; i++) {
            selfListeners[i].handler.call(this, evt);
          }
        }
      }
      draw() {
        this.drawScene();
        this.drawHit();
        return this;
      }
      _createDragElement(evt) {
        var pointerId = evt ? evt.pointerId : void 0;
        var stage = this.getStage();
        var ap = this.getAbsolutePosition();
        if (!stage) {
          return;
        }
        var pos = stage._getPointerById(pointerId) || stage._changedPointerPositions[0] || ap;
        DragAndDrop_1.DD._dragElements.set(this._id, {
          node: this,
          startPointerPos: pos,
          offset: {
            x: pos.x - ap.x,
            y: pos.y - ap.y
          },
          dragStatus: "ready",
          pointerId
        });
      }
      startDrag(evt, bubbleEvent = true) {
        if (!DragAndDrop_1.DD._dragElements.has(this._id)) {
          this._createDragElement(evt);
        }
        const elem = DragAndDrop_1.DD._dragElements.get(this._id);
        elem.dragStatus = "dragging";
        this.fire("dragstart", {
          type: "dragstart",
          target: this,
          evt: evt && evt.evt
        }, bubbleEvent);
      }
      _setDragPosition(evt, elem) {
        const pos = this.getStage()._getPointerById(elem.pointerId);
        if (!pos) {
          return;
        }
        var newNodePos = {
          x: pos.x - elem.offset.x,
          y: pos.y - elem.offset.y
        };
        var dbf = this.dragBoundFunc();
        if (dbf !== void 0) {
          const bounded = dbf.call(this, newNodePos, evt);
          if (!bounded) {
            Util_1.Util.warn("dragBoundFunc did not return any value. That is unexpected behavior. You must return new absolute position from dragBoundFunc.");
          } else {
            newNodePos = bounded;
          }
        }
        if (!this._lastPos || this._lastPos.x !== newNodePos.x || this._lastPos.y !== newNodePos.y) {
          this.setAbsolutePosition(newNodePos);
          this._requestDraw();
        }
        this._lastPos = newNodePos;
      }
      stopDrag(evt) {
        const elem = DragAndDrop_1.DD._dragElements.get(this._id);
        if (elem) {
          elem.dragStatus = "stopped";
        }
        DragAndDrop_1.DD._endDragBefore(evt);
        DragAndDrop_1.DD._endDragAfter(evt);
      }
      setDraggable(draggable) {
        this._setAttr("draggable", draggable);
        this._dragChange();
      }
      isDragging() {
        const elem = DragAndDrop_1.DD._dragElements.get(this._id);
        return elem ? elem.dragStatus === "dragging" : false;
      }
      _listenDrag() {
        this._dragCleanup();
        this.on("mousedown.konva touchstart.konva", function(evt) {
          var shouldCheckButton = evt.evt["button"] !== void 0;
          var canDrag = !shouldCheckButton || Global_1.Konva.dragButtons.indexOf(evt.evt["button"]) >= 0;
          if (!canDrag) {
            return;
          }
          if (this.isDragging()) {
            return;
          }
          var hasDraggingChild = false;
          DragAndDrop_1.DD._dragElements.forEach((elem) => {
            if (this.isAncestorOf(elem.node)) {
              hasDraggingChild = true;
            }
          });
          if (!hasDraggingChild) {
            this._createDragElement(evt);
          }
        });
      }
      _dragChange() {
        if (this.attrs.draggable) {
          this._listenDrag();
        } else {
          this._dragCleanup();
          var stage = this.getStage();
          if (!stage) {
            return;
          }
          const dragElement = DragAndDrop_1.DD._dragElements.get(this._id);
          const isDragging = dragElement && dragElement.dragStatus === "dragging";
          const isReady = dragElement && dragElement.dragStatus === "ready";
          if (isDragging) {
            this.stopDrag();
          } else if (isReady) {
            DragAndDrop_1.DD._dragElements.delete(this._id);
          }
        }
      }
      _dragCleanup() {
        this.off("mousedown.konva");
        this.off("touchstart.konva");
      }
      isClientRectOnScreen(margin = { x: 0, y: 0 }) {
        const stage = this.getStage();
        if (!stage) {
          return false;
        }
        const screenRect = {
          x: -margin.x,
          y: -margin.y,
          width: stage.width() + 2 * margin.x,
          height: stage.height() + 2 * margin.y
        };
        return Util_1.Util.haveIntersection(screenRect, this.getClientRect());
      }
      static create(data, container) {
        if (Util_1.Util._isString(data)) {
          data = JSON.parse(data);
        }
        return this._createNode(data, container);
      }
      static _createNode(obj, container) {
        var className = _Node.prototype.getClassName.call(obj), children = obj.children, no, len, n;
        if (container) {
          obj.attrs.container = container;
        }
        if (!Global_1.Konva[className]) {
          Util_1.Util.warn('Can not find a node with class name "' + className + '". Fallback to "Shape".');
          className = "Shape";
        }
        const Class = Global_1.Konva[className];
        no = new Class(obj.attrs);
        if (children) {
          len = children.length;
          for (n = 0; n < len; n++) {
            no.add(_Node._createNode(children[n]));
          }
        }
        return no;
      }
    };
    exports.Node = Node;
    Node.prototype.nodeType = "Node";
    Node.prototype._attrsAffectingSize = [];
    Node.prototype.eventListeners = {};
    Node.prototype.on.call(Node.prototype, TRANSFORM_CHANGE_STR, function() {
      if (this._batchingTransformChange) {
        this._needClearTransformCache = true;
        return;
      }
      this._clearCache(TRANSFORM);
      this._clearSelfAndDescendantCache(ABSOLUTE_TRANSFORM);
    });
    Node.prototype.on.call(Node.prototype, "visibleChange.konva", function() {
      this._clearSelfAndDescendantCache(VISIBLE);
    });
    Node.prototype.on.call(Node.prototype, "listeningChange.konva", function() {
      this._clearSelfAndDescendantCache(LISTENING);
    });
    Node.prototype.on.call(Node.prototype, "opacityChange.konva", function() {
      this._clearSelfAndDescendantCache(ABSOLUTE_OPACITY);
    });
    var addGetterSetter = Factory_1.Factory.addGetterSetter;
    addGetterSetter(Node, "zIndex");
    addGetterSetter(Node, "absolutePosition");
    addGetterSetter(Node, "position");
    addGetterSetter(Node, "x", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "y", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "globalCompositeOperation", "source-over", (0, Validators_1.getStringValidator)());
    addGetterSetter(Node, "opacity", 1, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "name", "", (0, Validators_1.getStringValidator)());
    addGetterSetter(Node, "id", "", (0, Validators_1.getStringValidator)());
    addGetterSetter(Node, "rotation", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Node, "scale", ["x", "y"]);
    addGetterSetter(Node, "scaleX", 1, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "scaleY", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Node, "skew", ["x", "y"]);
    addGetterSetter(Node, "skewX", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "skewY", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Node, "offset", ["x", "y"]);
    addGetterSetter(Node, "offsetX", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "offsetY", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "dragDistance", null, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "width", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "height", 0, (0, Validators_1.getNumberValidator)());
    addGetterSetter(Node, "listening", true, (0, Validators_1.getBooleanValidator)());
    addGetterSetter(Node, "preventDefault", true, (0, Validators_1.getBooleanValidator)());
    addGetterSetter(Node, "filters", null, function(val) {
      this._filterUpToDate = false;
      return val;
    });
    addGetterSetter(Node, "visible", true, (0, Validators_1.getBooleanValidator)());
    addGetterSetter(Node, "transformsEnabled", "all", (0, Validators_1.getStringValidator)());
    addGetterSetter(Node, "size");
    addGetterSetter(Node, "dragBoundFunc");
    addGetterSetter(Node, "draggable", false, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.backCompat(Node, {
      rotateDeg: "rotate",
      setRotationDeg: "setRotation",
      getRotationDeg: "getRotation"
    });
  }
});

// node_modules/konva/lib/PointerEvents.js
var require_PointerEvents = __commonJS({
  "node_modules/konva/lib/PointerEvents.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.releaseCapture = exports.setPointerCapture = exports.hasPointerCapture = exports.createEvent = exports.getCapturedShape = void 0;
    var Global_1 = require_Global();
    var Captures = /* @__PURE__ */ new Map();
    var SUPPORT_POINTER_EVENTS = Global_1.Konva._global["PointerEvent"] !== void 0;
    function getCapturedShape(pointerId) {
      return Captures.get(pointerId);
    }
    exports.getCapturedShape = getCapturedShape;
    function createEvent(evt) {
      return {
        evt,
        pointerId: evt.pointerId
      };
    }
    exports.createEvent = createEvent;
    function hasPointerCapture(pointerId, shape) {
      return Captures.get(pointerId) === shape;
    }
    exports.hasPointerCapture = hasPointerCapture;
    function setPointerCapture(pointerId, shape) {
      releaseCapture(pointerId);
      const stage = shape.getStage();
      if (!stage)
        return;
      Captures.set(pointerId, shape);
      if (SUPPORT_POINTER_EVENTS) {
        shape._fire("gotpointercapture", createEvent(new PointerEvent("gotpointercapture")));
      }
    }
    exports.setPointerCapture = setPointerCapture;
    function releaseCapture(pointerId, target) {
      const shape = Captures.get(pointerId);
      if (!shape)
        return;
      const stage = shape.getStage();
      if (stage && stage.content) {
      }
      Captures.delete(pointerId);
      if (SUPPORT_POINTER_EVENTS) {
        shape._fire("lostpointercapture", createEvent(new PointerEvent("lostpointercapture")));
      }
    }
    exports.releaseCapture = releaseCapture;
  }
});

// node_modules/konva/lib/Shape.js
var require_Shape = __commonJS({
  "node_modules/konva/lib/Shape.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Shape = exports.shapes = void 0;
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Global_2 = require_Global();
    var PointerEvents = require_PointerEvents();
    var HAS_SHADOW = "hasShadow";
    var SHADOW_RGBA = "shadowRGBA";
    var patternImage = "patternImage";
    var linearGradient = "linearGradient";
    var radialGradient = "radialGradient";
    var dummyContext;
    function getDummyContext() {
      if (dummyContext) {
        return dummyContext;
      }
      dummyContext = Util_1.Util.createCanvasElement().getContext("2d");
      return dummyContext;
    }
    exports.shapes = {};
    function _fillFunc(context) {
      const fillRule = this.attrs.fillRule;
      if (fillRule) {
        context.fill(fillRule);
      } else {
        context.fill();
      }
    }
    function _strokeFunc(context) {
      context.stroke();
    }
    function _fillFuncHit(context) {
      const fillRule = this.attrs.fillRule;
      if (fillRule) {
        context.fill(fillRule);
      } else {
        context.fill();
      }
    }
    function _strokeFuncHit(context) {
      context.stroke();
    }
    function _clearHasShadowCache() {
      this._clearCache(HAS_SHADOW);
    }
    function _clearGetShadowRGBACache() {
      this._clearCache(SHADOW_RGBA);
    }
    function _clearFillPatternCache() {
      this._clearCache(patternImage);
    }
    function _clearLinearGradientCache() {
      this._clearCache(linearGradient);
    }
    function _clearRadialGradientCache() {
      this._clearCache(radialGradient);
    }
    var Shape = class extends Node_1.Node {
      constructor(config) {
        super(config);
        let key;
        while (true) {
          key = Util_1.Util.getRandomColor();
          if (key && !(key in exports.shapes)) {
            break;
          }
        }
        this.colorKey = key;
        exports.shapes[key] = this;
      }
      getContext() {
        Util_1.Util.warn("shape.getContext() method is deprecated. Please do not use it.");
        return this.getLayer().getContext();
      }
      getCanvas() {
        Util_1.Util.warn("shape.getCanvas() method is deprecated. Please do not use it.");
        return this.getLayer().getCanvas();
      }
      getSceneFunc() {
        return this.attrs.sceneFunc || this["_sceneFunc"];
      }
      getHitFunc() {
        return this.attrs.hitFunc || this["_hitFunc"];
      }
      hasShadow() {
        return this._getCache(HAS_SHADOW, this._hasShadow);
      }
      _hasShadow() {
        return this.shadowEnabled() && this.shadowOpacity() !== 0 && !!(this.shadowColor() || this.shadowBlur() || this.shadowOffsetX() || this.shadowOffsetY());
      }
      _getFillPattern() {
        return this._getCache(patternImage, this.__getFillPattern);
      }
      __getFillPattern() {
        if (this.fillPatternImage()) {
          var ctx = getDummyContext();
          const pattern = ctx.createPattern(this.fillPatternImage(), this.fillPatternRepeat() || "repeat");
          if (pattern && pattern.setTransform) {
            const tr = new Util_1.Transform();
            tr.translate(this.fillPatternX(), this.fillPatternY());
            tr.rotate(Global_1.Konva.getAngle(this.fillPatternRotation()));
            tr.scale(this.fillPatternScaleX(), this.fillPatternScaleY());
            tr.translate(-1 * this.fillPatternOffsetX(), -1 * this.fillPatternOffsetY());
            const m = tr.getMatrix();
            const matrix = typeof DOMMatrix === "undefined" ? {
              a: m[0],
              b: m[1],
              c: m[2],
              d: m[3],
              e: m[4],
              f: m[5]
            } : new DOMMatrix(m);
            pattern.setTransform(matrix);
          }
          return pattern;
        }
      }
      _getLinearGradient() {
        return this._getCache(linearGradient, this.__getLinearGradient);
      }
      __getLinearGradient() {
        var colorStops = this.fillLinearGradientColorStops();
        if (colorStops) {
          var ctx = getDummyContext();
          var start = this.fillLinearGradientStartPoint();
          var end = this.fillLinearGradientEndPoint();
          var grd = ctx.createLinearGradient(start.x, start.y, end.x, end.y);
          for (var n = 0; n < colorStops.length; n += 2) {
            grd.addColorStop(colorStops[n], colorStops[n + 1]);
          }
          return grd;
        }
      }
      _getRadialGradient() {
        return this._getCache(radialGradient, this.__getRadialGradient);
      }
      __getRadialGradient() {
        var colorStops = this.fillRadialGradientColorStops();
        if (colorStops) {
          var ctx = getDummyContext();
          var start = this.fillRadialGradientStartPoint();
          var end = this.fillRadialGradientEndPoint();
          var grd = ctx.createRadialGradient(start.x, start.y, this.fillRadialGradientStartRadius(), end.x, end.y, this.fillRadialGradientEndRadius());
          for (var n = 0; n < colorStops.length; n += 2) {
            grd.addColorStop(colorStops[n], colorStops[n + 1]);
          }
          return grd;
        }
      }
      getShadowRGBA() {
        return this._getCache(SHADOW_RGBA, this._getShadowRGBA);
      }
      _getShadowRGBA() {
        if (!this.hasShadow()) {
          return;
        }
        var rgba = Util_1.Util.colorToRGBA(this.shadowColor());
        if (rgba) {
          return "rgba(" + rgba.r + "," + rgba.g + "," + rgba.b + "," + rgba.a * (this.shadowOpacity() || 1) + ")";
        }
      }
      hasFill() {
        return this._calculate("hasFill", [
          "fillEnabled",
          "fill",
          "fillPatternImage",
          "fillLinearGradientColorStops",
          "fillRadialGradientColorStops"
        ], () => {
          return this.fillEnabled() && !!(this.fill() || this.fillPatternImage() || this.fillLinearGradientColorStops() || this.fillRadialGradientColorStops());
        });
      }
      hasStroke() {
        return this._calculate("hasStroke", [
          "strokeEnabled",
          "strokeWidth",
          "stroke",
          "strokeLinearGradientColorStops"
        ], () => {
          return this.strokeEnabled() && this.strokeWidth() && !!(this.stroke() || this.strokeLinearGradientColorStops());
        });
      }
      hasHitStroke() {
        const width = this.hitStrokeWidth();
        if (width === "auto") {
          return this.hasStroke();
        }
        return this.strokeEnabled() && !!width;
      }
      intersects(point) {
        var stage = this.getStage();
        if (!stage) {
          return false;
        }
        const bufferHitCanvas = stage.bufferHitCanvas;
        bufferHitCanvas.getContext().clear();
        this.drawHit(bufferHitCanvas, void 0, true);
        const p = bufferHitCanvas.context.getImageData(Math.round(point.x), Math.round(point.y), 1, 1).data;
        return p[3] > 0;
      }
      destroy() {
        Node_1.Node.prototype.destroy.call(this);
        delete exports.shapes[this.colorKey];
        delete this.colorKey;
        return this;
      }
      _useBufferCanvas(forceFill) {
        var _a;
        const perfectDrawEnabled = (_a = this.attrs.perfectDrawEnabled) !== null && _a !== void 0 ? _a : true;
        if (!perfectDrawEnabled) {
          return false;
        }
        const hasFill = forceFill || this.hasFill();
        const hasStroke = this.hasStroke();
        const isTransparent = this.getAbsoluteOpacity() !== 1;
        if (hasFill && hasStroke && isTransparent) {
          return true;
        }
        const hasShadow = this.hasShadow();
        const strokeForShadow = this.shadowForStrokeEnabled();
        if (hasFill && hasStroke && hasShadow && strokeForShadow) {
          return true;
        }
        return false;
      }
      setStrokeHitEnabled(val) {
        Util_1.Util.warn("strokeHitEnabled property is deprecated. Please use hitStrokeWidth instead.");
        if (val) {
          this.hitStrokeWidth("auto");
        } else {
          this.hitStrokeWidth(0);
        }
      }
      getStrokeHitEnabled() {
        if (this.hitStrokeWidth() === 0) {
          return false;
        } else {
          return true;
        }
      }
      getSelfRect() {
        var size = this.size();
        return {
          x: this._centroid ? -size.width / 2 : 0,
          y: this._centroid ? -size.height / 2 : 0,
          width: size.width,
          height: size.height
        };
      }
      getClientRect(config = {}) {
        let hasCachedParent = false;
        let parent = this.getParent();
        while (parent) {
          if (parent.isCached()) {
            hasCachedParent = true;
            break;
          }
          parent = parent.getParent();
        }
        const skipTransform = config.skipTransform;
        const relativeTo = config.relativeTo || hasCachedParent && this.getStage() || void 0;
        const fillRect = this.getSelfRect();
        const applyStroke = !config.skipStroke && this.hasStroke();
        const strokeWidth = applyStroke && this.strokeWidth() || 0;
        const fillAndStrokeWidth = fillRect.width + strokeWidth;
        const fillAndStrokeHeight = fillRect.height + strokeWidth;
        const applyShadow = !config.skipShadow && this.hasShadow();
        const shadowOffsetX = applyShadow ? this.shadowOffsetX() : 0;
        const shadowOffsetY = applyShadow ? this.shadowOffsetY() : 0;
        const preWidth = fillAndStrokeWidth + Math.abs(shadowOffsetX);
        const preHeight = fillAndStrokeHeight + Math.abs(shadowOffsetY);
        const blurRadius = applyShadow && this.shadowBlur() || 0;
        const width = preWidth + blurRadius * 2;
        const height = preHeight + blurRadius * 2;
        const rect = {
          width,
          height,
          x: -(strokeWidth / 2 + blurRadius) + Math.min(shadowOffsetX, 0) + fillRect.x,
          y: -(strokeWidth / 2 + blurRadius) + Math.min(shadowOffsetY, 0) + fillRect.y
        };
        if (!skipTransform) {
          return this._transformedRect(rect, relativeTo);
        }
        return rect;
      }
      drawScene(can, top, bufferCanvas) {
        var layer = this.getLayer();
        var canvas = can || layer.getCanvas(), context = canvas.getContext(), cachedCanvas = this._getCanvasCache(), drawFunc = this.getSceneFunc(), hasShadow = this.hasShadow(), stage, bufferContext;
        var skipBuffer = canvas.isCache;
        var cachingSelf = top === this;
        if (!this.isVisible() && !cachingSelf) {
          return this;
        }
        if (cachedCanvas) {
          context.save();
          var m = this.getAbsoluteTransform(top).getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
          this._drawCachedSceneCanvas(context);
          context.restore();
          return this;
        }
        if (!drawFunc) {
          return this;
        }
        context.save();
        if (this._useBufferCanvas() && !skipBuffer) {
          stage = this.getStage();
          const bc = bufferCanvas || stage.bufferCanvas;
          bufferContext = bc.getContext();
          bufferContext.clear();
          bufferContext.save();
          bufferContext._applyLineJoin(this);
          var o = this.getAbsoluteTransform(top).getMatrix();
          bufferContext.transform(o[0], o[1], o[2], o[3], o[4], o[5]);
          drawFunc.call(this, bufferContext, this);
          bufferContext.restore();
          var ratio = bc.pixelRatio;
          if (hasShadow) {
            context._applyShadow(this);
          }
          context._applyOpacity(this);
          context._applyGlobalCompositeOperation(this);
          context.drawImage(bc._canvas, 0, 0, bc.width / ratio, bc.height / ratio);
        } else {
          context._applyLineJoin(this);
          if (!cachingSelf) {
            var o = this.getAbsoluteTransform(top).getMatrix();
            context.transform(o[0], o[1], o[2], o[3], o[4], o[5]);
            context._applyOpacity(this);
            context._applyGlobalCompositeOperation(this);
          }
          if (hasShadow) {
            context._applyShadow(this);
          }
          drawFunc.call(this, context, this);
        }
        context.restore();
        return this;
      }
      drawHit(can, top, skipDragCheck = false) {
        if (!this.shouldDrawHit(top, skipDragCheck)) {
          return this;
        }
        var layer = this.getLayer(), canvas = can || layer.hitCanvas, context = canvas && canvas.getContext(), drawFunc = this.hitFunc() || this.sceneFunc(), cachedCanvas = this._getCanvasCache(), cachedHitCanvas = cachedCanvas && cachedCanvas.hit;
        if (!this.colorKey) {
          Util_1.Util.warn("Looks like your canvas has a destroyed shape in it. Do not reuse shape after you destroyed it. If you want to reuse shape you should call remove() instead of destroy()");
        }
        if (cachedHitCanvas) {
          context.save();
          var m = this.getAbsoluteTransform(top).getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
          this._drawCachedHitCanvas(context);
          context.restore();
          return this;
        }
        if (!drawFunc) {
          return this;
        }
        context.save();
        context._applyLineJoin(this);
        const selfCache = this === top;
        if (!selfCache) {
          var o = this.getAbsoluteTransform(top).getMatrix();
          context.transform(o[0], o[1], o[2], o[3], o[4], o[5]);
        }
        drawFunc.call(this, context, this);
        context.restore();
        return this;
      }
      drawHitFromCache(alphaThreshold = 0) {
        var cachedCanvas = this._getCanvasCache(), sceneCanvas = this._getCachedSceneCanvas(), hitCanvas = cachedCanvas.hit, hitContext = hitCanvas.getContext(), hitWidth = hitCanvas.getWidth(), hitHeight = hitCanvas.getHeight(), hitImageData, hitData, len, rgbColorKey, i, alpha;
        hitContext.clear();
        hitContext.drawImage(sceneCanvas._canvas, 0, 0, hitWidth, hitHeight);
        try {
          hitImageData = hitContext.getImageData(0, 0, hitWidth, hitHeight);
          hitData = hitImageData.data;
          len = hitData.length;
          rgbColorKey = Util_1.Util._hexToRgb(this.colorKey);
          for (i = 0; i < len; i += 4) {
            alpha = hitData[i + 3];
            if (alpha > alphaThreshold) {
              hitData[i] = rgbColorKey.r;
              hitData[i + 1] = rgbColorKey.g;
              hitData[i + 2] = rgbColorKey.b;
              hitData[i + 3] = 255;
            } else {
              hitData[i + 3] = 0;
            }
          }
          hitContext.putImageData(hitImageData, 0, 0);
        } catch (e) {
          Util_1.Util.error("Unable to draw hit graph from cached scene canvas. " + e.message);
        }
        return this;
      }
      hasPointerCapture(pointerId) {
        return PointerEvents.hasPointerCapture(pointerId, this);
      }
      setPointerCapture(pointerId) {
        PointerEvents.setPointerCapture(pointerId, this);
      }
      releaseCapture(pointerId) {
        PointerEvents.releaseCapture(pointerId, this);
      }
    };
    exports.Shape = Shape;
    Shape.prototype._fillFunc = _fillFunc;
    Shape.prototype._strokeFunc = _strokeFunc;
    Shape.prototype._fillFuncHit = _fillFuncHit;
    Shape.prototype._strokeFuncHit = _strokeFuncHit;
    Shape.prototype._centroid = false;
    Shape.prototype.nodeType = "Shape";
    (0, Global_2._registerNode)(Shape);
    Shape.prototype.eventListeners = {};
    Shape.prototype.on.call(Shape.prototype, "shadowColorChange.konva shadowBlurChange.konva shadowOffsetChange.konva shadowOpacityChange.konva shadowEnabledChange.konva", _clearHasShadowCache);
    Shape.prototype.on.call(Shape.prototype, "shadowColorChange.konva shadowOpacityChange.konva shadowEnabledChange.konva", _clearGetShadowRGBACache);
    Shape.prototype.on.call(Shape.prototype, "fillPriorityChange.konva fillPatternImageChange.konva fillPatternRepeatChange.konva fillPatternScaleXChange.konva fillPatternScaleYChange.konva fillPatternOffsetXChange.konva fillPatternOffsetYChange.konva fillPatternXChange.konva fillPatternYChange.konva fillPatternRotationChange.konva", _clearFillPatternCache);
    Shape.prototype.on.call(Shape.prototype, "fillPriorityChange.konva fillLinearGradientColorStopsChange.konva fillLinearGradientStartPointXChange.konva fillLinearGradientStartPointYChange.konva fillLinearGradientEndPointXChange.konva fillLinearGradientEndPointYChange.konva", _clearLinearGradientCache);
    Shape.prototype.on.call(Shape.prototype, "fillPriorityChange.konva fillRadialGradientColorStopsChange.konva fillRadialGradientStartPointXChange.konva fillRadialGradientStartPointYChange.konva fillRadialGradientEndPointXChange.konva fillRadialGradientEndPointYChange.konva fillRadialGradientStartRadiusChange.konva fillRadialGradientEndRadiusChange.konva", _clearRadialGradientCache);
    Factory_1.Factory.addGetterSetter(Shape, "stroke", void 0, (0, Validators_1.getStringOrGradientValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "strokeWidth", 2, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillAfterStrokeEnabled", false);
    Factory_1.Factory.addGetterSetter(Shape, "hitStrokeWidth", "auto", (0, Validators_1.getNumberOrAutoValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "strokeHitEnabled", true, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "perfectDrawEnabled", true, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "shadowForStrokeEnabled", true, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "lineJoin");
    Factory_1.Factory.addGetterSetter(Shape, "lineCap");
    Factory_1.Factory.addGetterSetter(Shape, "sceneFunc");
    Factory_1.Factory.addGetterSetter(Shape, "hitFunc");
    Factory_1.Factory.addGetterSetter(Shape, "dash");
    Factory_1.Factory.addGetterSetter(Shape, "dashOffset", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "shadowColor", void 0, (0, Validators_1.getStringValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "shadowBlur", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "shadowOpacity", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Shape, "shadowOffset", ["x", "y"]);
    Factory_1.Factory.addGetterSetter(Shape, "shadowOffsetX", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "shadowOffsetY", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternImage");
    Factory_1.Factory.addGetterSetter(Shape, "fill", void 0, (0, Validators_1.getStringOrGradientValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternX", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternY", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillLinearGradientColorStops");
    Factory_1.Factory.addGetterSetter(Shape, "strokeLinearGradientColorStops");
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientStartRadius", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientEndRadius", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientColorStops");
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternRepeat", "repeat");
    Factory_1.Factory.addGetterSetter(Shape, "fillEnabled", true);
    Factory_1.Factory.addGetterSetter(Shape, "strokeEnabled", true);
    Factory_1.Factory.addGetterSetter(Shape, "shadowEnabled", true);
    Factory_1.Factory.addGetterSetter(Shape, "dashEnabled", true);
    Factory_1.Factory.addGetterSetter(Shape, "strokeScaleEnabled", true);
    Factory_1.Factory.addGetterSetter(Shape, "fillPriority", "color");
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillPatternOffset", ["x", "y"]);
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternOffsetX", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternOffsetY", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillPatternScale", ["x", "y"]);
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternScaleX", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternScaleY", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillLinearGradientStartPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addComponentsGetterSetter(Shape, "strokeLinearGradientStartPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addGetterSetter(Shape, "fillLinearGradientStartPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "strokeLinearGradientStartPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillLinearGradientStartPointY", 0);
    Factory_1.Factory.addGetterSetter(Shape, "strokeLinearGradientStartPointY", 0);
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillLinearGradientEndPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addComponentsGetterSetter(Shape, "strokeLinearGradientEndPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addGetterSetter(Shape, "fillLinearGradientEndPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "strokeLinearGradientEndPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillLinearGradientEndPointY", 0);
    Factory_1.Factory.addGetterSetter(Shape, "strokeLinearGradientEndPointY", 0);
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillRadialGradientStartPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientStartPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientStartPointY", 0);
    Factory_1.Factory.addComponentsGetterSetter(Shape, "fillRadialGradientEndPoint", [
      "x",
      "y"
    ]);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientEndPointX", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillRadialGradientEndPointY", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillPatternRotation", 0);
    Factory_1.Factory.addGetterSetter(Shape, "fillRule", void 0, (0, Validators_1.getStringValidator)());
    Factory_1.Factory.backCompat(Shape, {
      dashArray: "dash",
      getDashArray: "getDash",
      setDashArray: "getDash",
      drawFunc: "sceneFunc",
      getDrawFunc: "getSceneFunc",
      setDrawFunc: "setSceneFunc",
      drawHitFunc: "hitFunc",
      getDrawHitFunc: "getHitFunc",
      setDrawHitFunc: "setHitFunc"
    });
  }
});

export {
  require_Util,
  require_Validators,
  require_Factory,
  require_Context,
  require_Canvas,
  require_DragAndDrop,
  require_Node,
  require_PointerEvents,
  require_Shape
};
//# sourceMappingURL=chunk-HC2KSO22.js.map
