import {
  require_Factory,
  require_Shape,
  require_Util,
  require_Validators
} from "./chunk-HC2KSO22.js";
import {
  require_Global
} from "./chunk-M3JPOOL7.js";
import {
  __commonJS
} from "./chunk-V4OQ3NZ2.js";

// node_modules/konva/lib/shapes/Rect.js
var require_Rect = __commonJS({
  "node_modules/konva/lib/shapes/Rect.js"(exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Rect = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    var Validators_1 = require_Validators();
    var Rect = class extends Shape_1.Shape {
      _sceneFunc(context) {
        var cornerRadius = this.cornerRadius(), width = this.width(), height = this.height();
        context.beginPath();
        if (!cornerRadius) {
          context.rect(0, 0, width, height);
        } else {
          Util_1.Util.drawRoundedRectPath(context, width, height, cornerRadius);
        }
        context.closePath();
        context.fillStrokeShape(this);
      }
    };
    exports.Rect = Rect;
    Rect.prototype.className = "Rect";
    (0, Global_1._registerNode)(Rect);
    Factory_1.Factory.addGetterSetter(Rect, "cornerRadius", 0, (0, Validators_1.getNumberOrArrayOfNumbersValidator)(4));
  }
});

export {
  require_Rect
};
//# sourceMappingURL=chunk-6JNWGPFD.js.map
