import {
  require_Ring
} from "./chunk-D42GQH4N.js";
import {
  require_Rect
} from "./chunk-6JNWGPFD.js";
import {
  require_Canvas,
  require_Context,
  require_DragAndDrop,
  require_Factory,
  require_Node,
  require_PointerEvents,
  require_Shape,
  require_Util,
  require_Validators
} from "./chunk-HC2KSO22.js";
import {
  require_Global
} from "./chunk-M3JPOOL7.js";
import {
  __commonJS
} from "./chunk-V4OQ3NZ2.js";

// node_modules/konva/lib/Container.js
var require_Container = __commonJS({
  "node_modules/konva/lib/Container.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Container = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Container = class extends Node_1.Node {
      constructor() {
        super(...arguments);
        this.children = [];
      }
      getChildren(filterFunc) {
        if (!filterFunc) {
          return this.children || [];
        }
        const children = this.children || [];
        var results = [];
        children.forEach(function(child) {
          if (filterFunc(child)) {
            results.push(child);
          }
        });
        return results;
      }
      hasChildren() {
        return this.getChildren().length > 0;
      }
      removeChildren() {
        this.getChildren().forEach((child) => {
          child.parent = null;
          child.index = 0;
          child.remove();
        });
        this.children = [];
        this._requestDraw();
        return this;
      }
      destroyChildren() {
        this.getChildren().forEach((child) => {
          child.parent = null;
          child.index = 0;
          child.destroy();
        });
        this.children = [];
        this._requestDraw();
        return this;
      }
      add(...children) {
        if (children.length === 0) {
          return this;
        }
        if (children.length > 1) {
          for (var i = 0; i < children.length; i++) {
            this.add(children[i]);
          }
          return this;
        }
        const child = children[0];
        if (child.getParent()) {
          child.moveTo(this);
          return this;
        }
        this._validateAdd(child);
        child.index = this.getChildren().length;
        child.parent = this;
        child._clearCaches();
        this.getChildren().push(child);
        this._fire("add", {
          child
        });
        this._requestDraw();
        return this;
      }
      destroy() {
        if (this.hasChildren()) {
          this.destroyChildren();
        }
        super.destroy();
        return this;
      }
      find(selector) {
        return this._generalFind(selector, false);
      }
      findOne(selector) {
        var result = this._generalFind(selector, true);
        return result.length > 0 ? result[0] : void 0;
      }
      _generalFind(selector, findOne) {
        var retArr = [];
        this._descendants((node) => {
          const valid = node._isMatch(selector);
          if (valid) {
            retArr.push(node);
          }
          if (valid && findOne) {
            return true;
          }
          return false;
        });
        return retArr;
      }
      _descendants(fn) {
        let shouldStop = false;
        const children = this.getChildren();
        for (const child of children) {
          shouldStop = fn(child);
          if (shouldStop) {
            return true;
          }
          if (!child.hasChildren()) {
            continue;
          }
          shouldStop = child._descendants(fn);
          if (shouldStop) {
            return true;
          }
        }
        return false;
      }
      toObject() {
        var obj = Node_1.Node.prototype.toObject.call(this);
        obj.children = [];
        this.getChildren().forEach((child) => {
          obj.children.push(child.toObject());
        });
        return obj;
      }
      isAncestorOf(node) {
        var parent = node.getParent();
        while (parent) {
          if (parent._id === this._id) {
            return true;
          }
          parent = parent.getParent();
        }
        return false;
      }
      clone(obj) {
        var node = Node_1.Node.prototype.clone.call(this, obj);
        this.getChildren().forEach(function(no) {
          node.add(no.clone());
        });
        return node;
      }
      getAllIntersections(pos) {
        var arr = [];
        this.find("Shape").forEach((shape) => {
          if (shape.isVisible() && shape.intersects(pos)) {
            arr.push(shape);
          }
        });
        return arr;
      }
      _clearSelfAndDescendantCache(attr) {
        var _a;
        super._clearSelfAndDescendantCache(attr);
        if (this.isCached()) {
          return;
        }
        (_a = this.children) === null || _a === void 0 ? void 0 : _a.forEach(function(node) {
          node._clearSelfAndDescendantCache(attr);
        });
      }
      _setChildrenIndices() {
        var _a;
        (_a = this.children) === null || _a === void 0 ? void 0 : _a.forEach(function(child, n) {
          child.index = n;
        });
        this._requestDraw();
      }
      drawScene(can, top, bufferCanvas) {
        var layer = this.getLayer(), canvas = can || layer && layer.getCanvas(), context = canvas && canvas.getContext(), cachedCanvas = this._getCanvasCache(), cachedSceneCanvas = cachedCanvas && cachedCanvas.scene;
        var caching = canvas && canvas.isCache;
        if (!this.isVisible() && !caching) {
          return this;
        }
        if (cachedSceneCanvas) {
          context.save();
          var m = this.getAbsoluteTransform(top).getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
          this._drawCachedSceneCanvas(context);
          context.restore();
        } else {
          this._drawChildren("drawScene", canvas, top, bufferCanvas);
        }
        return this;
      }
      drawHit(can, top) {
        if (!this.shouldDrawHit(top)) {
          return this;
        }
        var layer = this.getLayer(), canvas = can || layer && layer.hitCanvas, context = canvas && canvas.getContext(), cachedCanvas = this._getCanvasCache(), cachedHitCanvas = cachedCanvas && cachedCanvas.hit;
        if (cachedHitCanvas) {
          context.save();
          var m = this.getAbsoluteTransform(top).getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
          this._drawCachedHitCanvas(context);
          context.restore();
        } else {
          this._drawChildren("drawHit", canvas, top);
        }
        return this;
      }
      _drawChildren(drawMethod, canvas, top, bufferCanvas) {
        var _a;
        var context = canvas && canvas.getContext(), clipWidth = this.clipWidth(), clipHeight = this.clipHeight(), clipFunc = this.clipFunc(), hasClip = typeof clipWidth === "number" && typeof clipHeight === "number" || clipFunc;
        const selfCache = top === this;
        if (hasClip) {
          context.save();
          var transform = this.getAbsoluteTransform(top);
          var m = transform.getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
          context.beginPath();
          let clipArgs;
          if (clipFunc) {
            clipArgs = clipFunc.call(this, context, this);
          } else {
            var clipX = this.clipX();
            var clipY = this.clipY();
            context.rect(clipX || 0, clipY || 0, clipWidth, clipHeight);
          }
          context.clip.apply(context, clipArgs);
          m = transform.copy().invert().getMatrix();
          context.transform(m[0], m[1], m[2], m[3], m[4], m[5]);
        }
        var hasComposition = !selfCache && this.globalCompositeOperation() !== "source-over" && drawMethod === "drawScene";
        if (hasComposition) {
          context.save();
          context._applyGlobalCompositeOperation(this);
        }
        (_a = this.children) === null || _a === void 0 ? void 0 : _a.forEach(function(child) {
          child[drawMethod](canvas, top, bufferCanvas);
        });
        if (hasComposition) {
          context.restore();
        }
        if (hasClip) {
          context.restore();
        }
      }
      getClientRect(config = {}) {
        var _a;
        var skipTransform = config.skipTransform;
        var relativeTo = config.relativeTo;
        var minX, minY, maxX, maxY;
        var selfRect = {
          x: Infinity,
          y: Infinity,
          width: 0,
          height: 0
        };
        var that = this;
        (_a = this.children) === null || _a === void 0 ? void 0 : _a.forEach(function(child) {
          if (!child.visible()) {
            return;
          }
          var rect = child.getClientRect({
            relativeTo: that,
            skipShadow: config.skipShadow,
            skipStroke: config.skipStroke
          });
          if (rect.width === 0 && rect.height === 0) {
            return;
          }
          if (minX === void 0) {
            minX = rect.x;
            minY = rect.y;
            maxX = rect.x + rect.width;
            maxY = rect.y + rect.height;
          } else {
            minX = Math.min(minX, rect.x);
            minY = Math.min(minY, rect.y);
            maxX = Math.max(maxX, rect.x + rect.width);
            maxY = Math.max(maxY, rect.y + rect.height);
          }
        });
        var shapes = this.find("Shape");
        var hasVisible = false;
        for (var i = 0; i < shapes.length; i++) {
          var shape = shapes[i];
          if (shape._isVisible(this)) {
            hasVisible = true;
            break;
          }
        }
        if (hasVisible && minX !== void 0) {
          selfRect = {
            x: minX,
            y: minY,
            width: maxX - minX,
            height: maxY - minY
          };
        } else {
          selfRect = {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          };
        }
        if (!skipTransform) {
          return this._transformedRect(selfRect, relativeTo);
        }
        return selfRect;
      }
    };
    exports.Container = Container;
    Factory_1.Factory.addComponentsGetterSetter(Container, "clip", [
      "x",
      "y",
      "width",
      "height"
    ]);
    Factory_1.Factory.addGetterSetter(Container, "clipX", void 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Container, "clipY", void 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Container, "clipWidth", void 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Container, "clipHeight", void 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Container, "clipFunc");
  }
});

// node_modules/konva/lib/Stage.js
var require_Stage = __commonJS({
  "node_modules/konva/lib/Stage.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Stage = exports.stages = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Container_1 = require_Container();
    var Global_1 = require_Global();
    var Canvas_1 = require_Canvas();
    var DragAndDrop_1 = require_DragAndDrop();
    var Global_2 = require_Global();
    var PointerEvents = require_PointerEvents();
    var STAGE = "Stage";
    var STRING = "string";
    var PX = "px";
    var MOUSEOUT = "mouseout";
    var MOUSELEAVE = "mouseleave";
    var MOUSEOVER = "mouseover";
    var MOUSEENTER = "mouseenter";
    var MOUSEMOVE = "mousemove";
    var MOUSEDOWN = "mousedown";
    var MOUSEUP = "mouseup";
    var POINTERMOVE = "pointermove";
    var POINTERDOWN = "pointerdown";
    var POINTERUP = "pointerup";
    var POINTERCANCEL = "pointercancel";
    var LOSTPOINTERCAPTURE = "lostpointercapture";
    var POINTEROUT = "pointerout";
    var POINTERLEAVE = "pointerleave";
    var POINTEROVER = "pointerover";
    var POINTERENTER = "pointerenter";
    var CONTEXTMENU = "contextmenu";
    var TOUCHSTART = "touchstart";
    var TOUCHEND = "touchend";
    var TOUCHMOVE = "touchmove";
    var TOUCHCANCEL = "touchcancel";
    var WHEEL = "wheel";
    var MAX_LAYERS_NUMBER = 5;
    var EVENTS = [
      [MOUSEENTER, "_pointerenter"],
      [MOUSEDOWN, "_pointerdown"],
      [MOUSEMOVE, "_pointermove"],
      [MOUSEUP, "_pointerup"],
      [MOUSELEAVE, "_pointerleave"],
      [TOUCHSTART, "_pointerdown"],
      [TOUCHMOVE, "_pointermove"],
      [TOUCHEND, "_pointerup"],
      [TOUCHCANCEL, "_pointercancel"],
      [MOUSEOVER, "_pointerover"],
      [WHEEL, "_wheel"],
      [CONTEXTMENU, "_contextmenu"],
      [POINTERDOWN, "_pointerdown"],
      [POINTERMOVE, "_pointermove"],
      [POINTERUP, "_pointerup"],
      [POINTERCANCEL, "_pointercancel"],
      [LOSTPOINTERCAPTURE, "_lostpointercapture"]
    ];
    var EVENTS_MAP = {
      mouse: {
        [POINTEROUT]: MOUSEOUT,
        [POINTERLEAVE]: MOUSELEAVE,
        [POINTEROVER]: MOUSEOVER,
        [POINTERENTER]: MOUSEENTER,
        [POINTERMOVE]: MOUSEMOVE,
        [POINTERDOWN]: MOUSEDOWN,
        [POINTERUP]: MOUSEUP,
        [POINTERCANCEL]: "mousecancel",
        pointerclick: "click",
        pointerdblclick: "dblclick"
      },
      touch: {
        [POINTEROUT]: "touchout",
        [POINTERLEAVE]: "touchleave",
        [POINTEROVER]: "touchover",
        [POINTERENTER]: "touchenter",
        [POINTERMOVE]: TOUCHMOVE,
        [POINTERDOWN]: TOUCHSTART,
        [POINTERUP]: TOUCHEND,
        [POINTERCANCEL]: TOUCHCANCEL,
        pointerclick: "tap",
        pointerdblclick: "dbltap"
      },
      pointer: {
        [POINTEROUT]: POINTEROUT,
        [POINTERLEAVE]: POINTERLEAVE,
        [POINTEROVER]: POINTEROVER,
        [POINTERENTER]: POINTERENTER,
        [POINTERMOVE]: POINTERMOVE,
        [POINTERDOWN]: POINTERDOWN,
        [POINTERUP]: POINTERUP,
        [POINTERCANCEL]: POINTERCANCEL,
        pointerclick: "pointerclick",
        pointerdblclick: "pointerdblclick"
      }
    };
    var getEventType = (type) => {
      if (type.indexOf("pointer") >= 0) {
        return "pointer";
      }
      if (type.indexOf("touch") >= 0) {
        return "touch";
      }
      return "mouse";
    };
    var getEventsMap = (eventType) => {
      const type = getEventType(eventType);
      if (type === "pointer") {
        return Global_1.Konva.pointerEventsEnabled && EVENTS_MAP.pointer;
      }
      if (type === "touch") {
        return EVENTS_MAP.touch;
      }
      if (type === "mouse") {
        return EVENTS_MAP.mouse;
      }
    };
    function checkNoClip(attrs = {}) {
      if (attrs.clipFunc || attrs.clipWidth || attrs.clipHeight) {
        Util_1.Util.warn("Stage does not support clipping. Please use clip for Layers or Groups.");
      }
      return attrs;
    }
    var NO_POINTERS_MESSAGE = `Pointer position is missing and not registered by the stage. Looks like it is outside of the stage container. You can set it manually from event: stage.setPointersPositions(event);`;
    exports.stages = [];
    var Stage = class extends Container_1.Container {
      constructor(config) {
        super(checkNoClip(config));
        this._pointerPositions = [];
        this._changedPointerPositions = [];
        this._buildDOM();
        this._bindContentEvents();
        exports.stages.push(this);
        this.on("widthChange.konva heightChange.konva", this._resizeDOM);
        this.on("visibleChange.konva", this._checkVisibility);
        this.on("clipWidthChange.konva clipHeightChange.konva clipFuncChange.konva", () => {
          checkNoClip(this.attrs);
        });
        this._checkVisibility();
      }
      _validateAdd(child) {
        const isLayer = child.getType() === "Layer";
        const isFastLayer = child.getType() === "FastLayer";
        const valid = isLayer || isFastLayer;
        if (!valid) {
          Util_1.Util.throw("You may only add layers to the stage.");
        }
      }
      _checkVisibility() {
        if (!this.content) {
          return;
        }
        const style = this.visible() ? "" : "none";
        this.content.style.display = style;
      }
      setContainer(container) {
        if (typeof container === STRING) {
          if (container.charAt(0) === ".") {
            var className = container.slice(1);
            container = document.getElementsByClassName(className)[0];
          } else {
            var id;
            if (container.charAt(0) !== "#") {
              id = container;
            } else {
              id = container.slice(1);
            }
            container = document.getElementById(id);
          }
          if (!container) {
            throw "Can not find container in document with id " + id;
          }
        }
        this._setAttr("container", container);
        if (this.content) {
          if (this.content.parentElement) {
            this.content.parentElement.removeChild(this.content);
          }
          container.appendChild(this.content);
        }
        return this;
      }
      shouldDrawHit() {
        return true;
      }
      clear() {
        var layers = this.children, len = layers.length, n;
        for (n = 0; n < len; n++) {
          layers[n].clear();
        }
        return this;
      }
      clone(obj) {
        if (!obj) {
          obj = {};
        }
        obj.container = typeof document !== "undefined" && document.createElement("div");
        return Container_1.Container.prototype.clone.call(this, obj);
      }
      destroy() {
        super.destroy();
        var content = this.content;
        if (content && Util_1.Util._isInDocument(content)) {
          this.container().removeChild(content);
        }
        var index = exports.stages.indexOf(this);
        if (index > -1) {
          exports.stages.splice(index, 1);
        }
        Util_1.Util.releaseCanvas(this.bufferCanvas._canvas, this.bufferHitCanvas._canvas);
        return this;
      }
      getPointerPosition() {
        const pos = this._pointerPositions[0] || this._changedPointerPositions[0];
        if (!pos) {
          Util_1.Util.warn(NO_POINTERS_MESSAGE);
          return null;
        }
        return {
          x: pos.x,
          y: pos.y
        };
      }
      _getPointerById(id) {
        return this._pointerPositions.find((p) => p.id === id);
      }
      getPointersPositions() {
        return this._pointerPositions;
      }
      getStage() {
        return this;
      }
      getContent() {
        return this.content;
      }
      _toKonvaCanvas(config) {
        config = config || {};
        config.x = config.x || 0;
        config.y = config.y || 0;
        config.width = config.width || this.width();
        config.height = config.height || this.height();
        var canvas = new Canvas_1.SceneCanvas({
          width: config.width,
          height: config.height,
          pixelRatio: config.pixelRatio || 1
        });
        var _context = canvas.getContext()._context;
        var layers = this.children;
        if (config.x || config.y) {
          _context.translate(-1 * config.x, -1 * config.y);
        }
        layers.forEach(function(layer) {
          if (!layer.isVisible()) {
            return;
          }
          var layerCanvas = layer._toKonvaCanvas(config);
          _context.drawImage(layerCanvas._canvas, config.x, config.y, layerCanvas.getWidth() / layerCanvas.getPixelRatio(), layerCanvas.getHeight() / layerCanvas.getPixelRatio());
        });
        return canvas;
      }
      getIntersection(pos) {
        if (!pos) {
          return null;
        }
        var layers = this.children, len = layers.length, end = len - 1, n;
        for (n = end; n >= 0; n--) {
          const shape = layers[n].getIntersection(pos);
          if (shape) {
            return shape;
          }
        }
        return null;
      }
      _resizeDOM() {
        var width = this.width();
        var height = this.height();
        if (this.content) {
          this.content.style.width = width + PX;
          this.content.style.height = height + PX;
        }
        this.bufferCanvas.setSize(width, height);
        this.bufferHitCanvas.setSize(width, height);
        this.children.forEach((layer) => {
          layer.setSize({ width, height });
          layer.draw();
        });
      }
      add(layer, ...rest) {
        if (arguments.length > 1) {
          for (var i = 0; i < arguments.length; i++) {
            this.add(arguments[i]);
          }
          return this;
        }
        super.add(layer);
        var length = this.children.length;
        if (length > MAX_LAYERS_NUMBER) {
          Util_1.Util.warn("The stage has " + length + " layers. Recommended maximum number of layers is 3-5. Adding more layers into the stage may drop the performance. Rethink your tree structure, you can use Konva.Group.");
        }
        layer.setSize({ width: this.width(), height: this.height() });
        layer.draw();
        if (Global_1.Konva.isBrowser) {
          this.content.appendChild(layer.canvas._canvas);
        }
        return this;
      }
      getParent() {
        return null;
      }
      getLayer() {
        return null;
      }
      hasPointerCapture(pointerId) {
        return PointerEvents.hasPointerCapture(pointerId, this);
      }
      setPointerCapture(pointerId) {
        PointerEvents.setPointerCapture(pointerId, this);
      }
      releaseCapture(pointerId) {
        PointerEvents.releaseCapture(pointerId, this);
      }
      getLayers() {
        return this.children;
      }
      _bindContentEvents() {
        if (!Global_1.Konva.isBrowser) {
          return;
        }
        EVENTS.forEach(([event, methodName]) => {
          this.content.addEventListener(event, (evt) => {
            this[methodName](evt);
          }, { passive: false });
        });
      }
      _pointerenter(evt) {
        this.setPointersPositions(evt);
        const events = getEventsMap(evt.type);
        if (events) {
          this._fire(events.pointerenter, {
            evt,
            target: this,
            currentTarget: this
          });
        }
      }
      _pointerover(evt) {
        this.setPointersPositions(evt);
        const events = getEventsMap(evt.type);
        if (events) {
          this._fire(events.pointerover, {
            evt,
            target: this,
            currentTarget: this
          });
        }
      }
      _getTargetShape(evenType) {
        let shape = this[evenType + "targetShape"];
        if (shape && !shape.getStage()) {
          shape = null;
        }
        return shape;
      }
      _pointerleave(evt) {
        const events = getEventsMap(evt.type);
        const eventType = getEventType(evt.type);
        if (!events) {
          return;
        }
        this.setPointersPositions(evt);
        var targetShape = this._getTargetShape(eventType);
        var eventsEnabled = !(Global_1.Konva.isDragging() || Global_1.Konva.isTransforming()) || Global_1.Konva.hitOnDragEnabled;
        if (targetShape && eventsEnabled) {
          targetShape._fireAndBubble(events.pointerout, { evt });
          targetShape._fireAndBubble(events.pointerleave, { evt });
          this._fire(events.pointerleave, {
            evt,
            target: this,
            currentTarget: this
          });
          this[eventType + "targetShape"] = null;
        } else if (eventsEnabled) {
          this._fire(events.pointerleave, {
            evt,
            target: this,
            currentTarget: this
          });
          this._fire(events.pointerout, {
            evt,
            target: this,
            currentTarget: this
          });
        }
        this.pointerPos = null;
        this._pointerPositions = [];
      }
      _pointerdown(evt) {
        const events = getEventsMap(evt.type);
        const eventType = getEventType(evt.type);
        if (!events) {
          return;
        }
        this.setPointersPositions(evt);
        var triggeredOnShape = false;
        this._changedPointerPositions.forEach((pos) => {
          var shape = this.getIntersection(pos);
          DragAndDrop_1.DD.justDragged = false;
          Global_1.Konva["_" + eventType + "ListenClick"] = true;
          if (!shape || !shape.isListening()) {
            this[eventType + "ClickStartShape"] = void 0;
            return;
          }
          if (Global_1.Konva.capturePointerEventsEnabled) {
            shape.setPointerCapture(pos.id);
          }
          this[eventType + "ClickStartShape"] = shape;
          shape._fireAndBubble(events.pointerdown, {
            evt,
            pointerId: pos.id
          });
          triggeredOnShape = true;
          const isTouch = evt.type.indexOf("touch") >= 0;
          if (shape.preventDefault() && evt.cancelable && isTouch) {
            evt.preventDefault();
          }
        });
        if (!triggeredOnShape) {
          this._fire(events.pointerdown, {
            evt,
            target: this,
            currentTarget: this,
            pointerId: this._pointerPositions[0].id
          });
        }
      }
      _pointermove(evt) {
        const events = getEventsMap(evt.type);
        const eventType = getEventType(evt.type);
        if (!events) {
          return;
        }
        if (Global_1.Konva.isDragging() && DragAndDrop_1.DD.node.preventDefault() && evt.cancelable) {
          evt.preventDefault();
        }
        this.setPointersPositions(evt);
        var eventsEnabled = !(Global_1.Konva.isDragging() || Global_1.Konva.isTransforming()) || Global_1.Konva.hitOnDragEnabled;
        if (!eventsEnabled) {
          return;
        }
        var processedShapesIds = {};
        let triggeredOnShape = false;
        var targetShape = this._getTargetShape(eventType);
        this._changedPointerPositions.forEach((pos) => {
          const shape = PointerEvents.getCapturedShape(pos.id) || this.getIntersection(pos);
          const pointerId = pos.id;
          const event = { evt, pointerId };
          var differentTarget = targetShape !== shape;
          if (differentTarget && targetShape) {
            targetShape._fireAndBubble(events.pointerout, { ...event }, shape);
            targetShape._fireAndBubble(events.pointerleave, { ...event }, shape);
          }
          if (shape) {
            if (processedShapesIds[shape._id]) {
              return;
            }
            processedShapesIds[shape._id] = true;
          }
          if (shape && shape.isListening()) {
            triggeredOnShape = true;
            if (differentTarget) {
              shape._fireAndBubble(events.pointerover, { ...event }, targetShape);
              shape._fireAndBubble(events.pointerenter, { ...event }, targetShape);
              this[eventType + "targetShape"] = shape;
            }
            shape._fireAndBubble(events.pointermove, { ...event });
          } else {
            if (targetShape) {
              this._fire(events.pointerover, {
                evt,
                target: this,
                currentTarget: this,
                pointerId
              });
              this[eventType + "targetShape"] = null;
            }
          }
        });
        if (!triggeredOnShape) {
          this._fire(events.pointermove, {
            evt,
            target: this,
            currentTarget: this,
            pointerId: this._changedPointerPositions[0].id
          });
        }
      }
      _pointerup(evt) {
        const events = getEventsMap(evt.type);
        const eventType = getEventType(evt.type);
        if (!events) {
          return;
        }
        this.setPointersPositions(evt);
        const clickStartShape = this[eventType + "ClickStartShape"];
        const clickEndShape = this[eventType + "ClickEndShape"];
        var processedShapesIds = {};
        let triggeredOnShape = false;
        this._changedPointerPositions.forEach((pos) => {
          const shape = PointerEvents.getCapturedShape(pos.id) || this.getIntersection(pos);
          if (shape) {
            shape.releaseCapture(pos.id);
            if (processedShapesIds[shape._id]) {
              return;
            }
            processedShapesIds[shape._id] = true;
          }
          const pointerId = pos.id;
          const event = { evt, pointerId };
          let fireDblClick = false;
          if (Global_1.Konva["_" + eventType + "InDblClickWindow"]) {
            fireDblClick = true;
            clearTimeout(this[eventType + "DblTimeout"]);
          } else if (!DragAndDrop_1.DD.justDragged) {
            Global_1.Konva["_" + eventType + "InDblClickWindow"] = true;
            clearTimeout(this[eventType + "DblTimeout"]);
          }
          this[eventType + "DblTimeout"] = setTimeout(function() {
            Global_1.Konva["_" + eventType + "InDblClickWindow"] = false;
          }, Global_1.Konva.dblClickWindow);
          if (shape && shape.isListening()) {
            triggeredOnShape = true;
            this[eventType + "ClickEndShape"] = shape;
            shape._fireAndBubble(events.pointerup, { ...event });
            if (Global_1.Konva["_" + eventType + "ListenClick"] && clickStartShape && clickStartShape === shape) {
              shape._fireAndBubble(events.pointerclick, { ...event });
              if (fireDblClick && clickEndShape && clickEndShape === shape) {
                shape._fireAndBubble(events.pointerdblclick, { ...event });
              }
            }
          } else {
            this[eventType + "ClickEndShape"] = null;
            if (Global_1.Konva["_" + eventType + "ListenClick"]) {
              this._fire(events.pointerclick, {
                evt,
                target: this,
                currentTarget: this,
                pointerId
              });
            }
            if (fireDblClick) {
              this._fire(events.pointerdblclick, {
                evt,
                target: this,
                currentTarget: this,
                pointerId
              });
            }
          }
        });
        if (!triggeredOnShape) {
          this._fire(events.pointerup, {
            evt,
            target: this,
            currentTarget: this,
            pointerId: this._changedPointerPositions[0].id
          });
        }
        Global_1.Konva["_" + eventType + "ListenClick"] = false;
        if (evt.cancelable && eventType !== "touch") {
          evt.preventDefault();
        }
      }
      _contextmenu(evt) {
        this.setPointersPositions(evt);
        var shape = this.getIntersection(this.getPointerPosition());
        if (shape && shape.isListening()) {
          shape._fireAndBubble(CONTEXTMENU, { evt });
        } else {
          this._fire(CONTEXTMENU, {
            evt,
            target: this,
            currentTarget: this
          });
        }
      }
      _wheel(evt) {
        this.setPointersPositions(evt);
        var shape = this.getIntersection(this.getPointerPosition());
        if (shape && shape.isListening()) {
          shape._fireAndBubble(WHEEL, { evt });
        } else {
          this._fire(WHEEL, {
            evt,
            target: this,
            currentTarget: this
          });
        }
      }
      _pointercancel(evt) {
        this.setPointersPositions(evt);
        const shape = PointerEvents.getCapturedShape(evt.pointerId) || this.getIntersection(this.getPointerPosition());
        if (shape) {
          shape._fireAndBubble(POINTERUP, PointerEvents.createEvent(evt));
        }
        PointerEvents.releaseCapture(evt.pointerId);
      }
      _lostpointercapture(evt) {
        PointerEvents.releaseCapture(evt.pointerId);
      }
      setPointersPositions(evt) {
        var contentPosition = this._getContentPosition(), x = null, y = null;
        evt = evt ? evt : window.event;
        if (evt.touches !== void 0) {
          this._pointerPositions = [];
          this._changedPointerPositions = [];
          Array.prototype.forEach.call(evt.touches, (touch) => {
            this._pointerPositions.push({
              id: touch.identifier,
              x: (touch.clientX - contentPosition.left) / contentPosition.scaleX,
              y: (touch.clientY - contentPosition.top) / contentPosition.scaleY
            });
          });
          Array.prototype.forEach.call(evt.changedTouches || evt.touches, (touch) => {
            this._changedPointerPositions.push({
              id: touch.identifier,
              x: (touch.clientX - contentPosition.left) / contentPosition.scaleX,
              y: (touch.clientY - contentPosition.top) / contentPosition.scaleY
            });
          });
        } else {
          x = (evt.clientX - contentPosition.left) / contentPosition.scaleX;
          y = (evt.clientY - contentPosition.top) / contentPosition.scaleY;
          this.pointerPos = {
            x,
            y
          };
          this._pointerPositions = [{ x, y, id: Util_1.Util._getFirstPointerId(evt) }];
          this._changedPointerPositions = [
            { x, y, id: Util_1.Util._getFirstPointerId(evt) }
          ];
        }
      }
      _setPointerPosition(evt) {
        Util_1.Util.warn('Method _setPointerPosition is deprecated. Use "stage.setPointersPositions(event)" instead.');
        this.setPointersPositions(evt);
      }
      _getContentPosition() {
        if (!this.content || !this.content.getBoundingClientRect) {
          return {
            top: 0,
            left: 0,
            scaleX: 1,
            scaleY: 1
          };
        }
        var rect = this.content.getBoundingClientRect();
        return {
          top: rect.top,
          left: rect.left,
          scaleX: rect.width / this.content.clientWidth || 1,
          scaleY: rect.height / this.content.clientHeight || 1
        };
      }
      _buildDOM() {
        this.bufferCanvas = new Canvas_1.SceneCanvas({
          width: this.width(),
          height: this.height()
        });
        this.bufferHitCanvas = new Canvas_1.HitCanvas({
          pixelRatio: 1,
          width: this.width(),
          height: this.height()
        });
        if (!Global_1.Konva.isBrowser) {
          return;
        }
        var container = this.container();
        if (!container) {
          throw "Stage has no container. A container is required.";
        }
        container.innerHTML = "";
        this.content = document.createElement("div");
        this.content.style.position = "relative";
        this.content.style.userSelect = "none";
        this.content.className = "konvajs-content";
        this.content.setAttribute("role", "presentation");
        container.appendChild(this.content);
        this._resizeDOM();
      }
      cache() {
        Util_1.Util.warn("Cache function is not allowed for stage. You may use cache only for layers, groups and shapes.");
        return this;
      }
      clearCache() {
        return this;
      }
      batchDraw() {
        this.getChildren().forEach(function(layer) {
          layer.batchDraw();
        });
        return this;
      }
    };
    exports.Stage = Stage;
    Stage.prototype.nodeType = STAGE;
    (0, Global_2._registerNode)(Stage);
    Factory_1.Factory.addGetterSetter(Stage, "container");
    if (Global_1.Konva.isBrowser) {
      document.addEventListener("visibilitychange", () => {
        exports.stages.forEach((stage) => {
          stage.batchDraw();
        });
      });
    }
  }
});

// node_modules/konva/lib/Layer.js
var require_Layer = __commonJS({
  "node_modules/konva/lib/Layer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Layer = void 0;
    var Util_1 = require_Util();
    var Container_1 = require_Container();
    var Node_1 = require_Node();
    var Factory_1 = require_Factory();
    var Canvas_1 = require_Canvas();
    var Validators_1 = require_Validators();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var HASH = "#";
    var BEFORE_DRAW = "beforeDraw";
    var DRAW = "draw";
    var INTERSECTION_OFFSETS = [
      { x: 0, y: 0 },
      { x: -1, y: -1 },
      { x: 1, y: -1 },
      { x: 1, y: 1 },
      { x: -1, y: 1 }
    ];
    var INTERSECTION_OFFSETS_LEN = INTERSECTION_OFFSETS.length;
    var Layer = class extends Container_1.Container {
      constructor(config) {
        super(config);
        this.canvas = new Canvas_1.SceneCanvas();
        this.hitCanvas = new Canvas_1.HitCanvas({
          pixelRatio: 1
        });
        this._waitingForDraw = false;
        this.on("visibleChange.konva", this._checkVisibility);
        this._checkVisibility();
        this.on("imageSmoothingEnabledChange.konva", this._setSmoothEnabled);
        this._setSmoothEnabled();
      }
      createPNGStream() {
        const c = this.canvas._canvas;
        return c.createPNGStream();
      }
      getCanvas() {
        return this.canvas;
      }
      getNativeCanvasElement() {
        return this.canvas._canvas;
      }
      getHitCanvas() {
        return this.hitCanvas;
      }
      getContext() {
        return this.getCanvas().getContext();
      }
      clear(bounds) {
        this.getContext().clear(bounds);
        this.getHitCanvas().getContext().clear(bounds);
        return this;
      }
      setZIndex(index) {
        super.setZIndex(index);
        var stage = this.getStage();
        if (stage && stage.content) {
          stage.content.removeChild(this.getNativeCanvasElement());
          if (index < stage.children.length - 1) {
            stage.content.insertBefore(this.getNativeCanvasElement(), stage.children[index + 1].getCanvas()._canvas);
          } else {
            stage.content.appendChild(this.getNativeCanvasElement());
          }
        }
        return this;
      }
      moveToTop() {
        Node_1.Node.prototype.moveToTop.call(this);
        var stage = this.getStage();
        if (stage && stage.content) {
          stage.content.removeChild(this.getNativeCanvasElement());
          stage.content.appendChild(this.getNativeCanvasElement());
        }
        return true;
      }
      moveUp() {
        var moved = Node_1.Node.prototype.moveUp.call(this);
        if (!moved) {
          return false;
        }
        var stage = this.getStage();
        if (!stage || !stage.content) {
          return false;
        }
        stage.content.removeChild(this.getNativeCanvasElement());
        if (this.index < stage.children.length - 1) {
          stage.content.insertBefore(this.getNativeCanvasElement(), stage.children[this.index + 1].getCanvas()._canvas);
        } else {
          stage.content.appendChild(this.getNativeCanvasElement());
        }
        return true;
      }
      moveDown() {
        if (Node_1.Node.prototype.moveDown.call(this)) {
          var stage = this.getStage();
          if (stage) {
            var children = stage.children;
            if (stage.content) {
              stage.content.removeChild(this.getNativeCanvasElement());
              stage.content.insertBefore(this.getNativeCanvasElement(), children[this.index + 1].getCanvas()._canvas);
            }
          }
          return true;
        }
        return false;
      }
      moveToBottom() {
        if (Node_1.Node.prototype.moveToBottom.call(this)) {
          var stage = this.getStage();
          if (stage) {
            var children = stage.children;
            if (stage.content) {
              stage.content.removeChild(this.getNativeCanvasElement());
              stage.content.insertBefore(this.getNativeCanvasElement(), children[1].getCanvas()._canvas);
            }
          }
          return true;
        }
        return false;
      }
      getLayer() {
        return this;
      }
      remove() {
        var _canvas = this.getNativeCanvasElement();
        Node_1.Node.prototype.remove.call(this);
        if (_canvas && _canvas.parentNode && Util_1.Util._isInDocument(_canvas)) {
          _canvas.parentNode.removeChild(_canvas);
        }
        return this;
      }
      getStage() {
        return this.parent;
      }
      setSize({ width, height }) {
        this.canvas.setSize(width, height);
        this.hitCanvas.setSize(width, height);
        this._setSmoothEnabled();
        return this;
      }
      _validateAdd(child) {
        var type = child.getType();
        if (type !== "Group" && type !== "Shape") {
          Util_1.Util.throw("You may only add groups and shapes to a layer.");
        }
      }
      _toKonvaCanvas(config) {
        config = config || {};
        config.width = config.width || this.getWidth();
        config.height = config.height || this.getHeight();
        config.x = config.x !== void 0 ? config.x : this.x();
        config.y = config.y !== void 0 ? config.y : this.y();
        return Node_1.Node.prototype._toKonvaCanvas.call(this, config);
      }
      _checkVisibility() {
        const visible = this.visible();
        if (visible) {
          this.canvas._canvas.style.display = "block";
        } else {
          this.canvas._canvas.style.display = "none";
        }
      }
      _setSmoothEnabled() {
        this.getContext()._context.imageSmoothingEnabled = this.imageSmoothingEnabled();
      }
      getWidth() {
        if (this.parent) {
          return this.parent.width();
        }
      }
      setWidth() {
        Util_1.Util.warn('Can not change width of layer. Use "stage.width(value)" function instead.');
      }
      getHeight() {
        if (this.parent) {
          return this.parent.height();
        }
      }
      setHeight() {
        Util_1.Util.warn('Can not change height of layer. Use "stage.height(value)" function instead.');
      }
      batchDraw() {
        if (!this._waitingForDraw) {
          this._waitingForDraw = true;
          Util_1.Util.requestAnimFrame(() => {
            this.draw();
            this._waitingForDraw = false;
          });
        }
        return this;
      }
      getIntersection(pos) {
        if (!this.isListening() || !this.isVisible()) {
          return null;
        }
        var spiralSearchDistance = 1;
        var continueSearch = false;
        while (true) {
          for (let i = 0; i < INTERSECTION_OFFSETS_LEN; i++) {
            const intersectionOffset = INTERSECTION_OFFSETS[i];
            const obj = this._getIntersection({
              x: pos.x + intersectionOffset.x * spiralSearchDistance,
              y: pos.y + intersectionOffset.y * spiralSearchDistance
            });
            const shape = obj.shape;
            if (shape) {
              return shape;
            }
            continueSearch = !!obj.antialiased;
            if (!obj.antialiased) {
              break;
            }
          }
          if (continueSearch) {
            spiralSearchDistance += 1;
          } else {
            return null;
          }
        }
      }
      _getIntersection(pos) {
        const ratio = this.hitCanvas.pixelRatio;
        const p = this.hitCanvas.context.getImageData(Math.round(pos.x * ratio), Math.round(pos.y * ratio), 1, 1).data;
        const p3 = p[3];
        if (p3 === 255) {
          const colorKey = Util_1.Util._rgbToHex(p[0], p[1], p[2]);
          const shape = Shape_1.shapes[HASH + colorKey];
          if (shape) {
            return {
              shape
            };
          }
          return {
            antialiased: true
          };
        } else if (p3 > 0) {
          return {
            antialiased: true
          };
        }
        return {};
      }
      drawScene(can, top) {
        var layer = this.getLayer(), canvas = can || layer && layer.getCanvas();
        this._fire(BEFORE_DRAW, {
          node: this
        });
        if (this.clearBeforeDraw()) {
          canvas.getContext().clear();
        }
        Container_1.Container.prototype.drawScene.call(this, canvas, top);
        this._fire(DRAW, {
          node: this
        });
        return this;
      }
      drawHit(can, top) {
        var layer = this.getLayer(), canvas = can || layer && layer.hitCanvas;
        if (layer && layer.clearBeforeDraw()) {
          layer.getHitCanvas().getContext().clear();
        }
        Container_1.Container.prototype.drawHit.call(this, canvas, top);
        return this;
      }
      enableHitGraph() {
        this.hitGraphEnabled(true);
        return this;
      }
      disableHitGraph() {
        this.hitGraphEnabled(false);
        return this;
      }
      setHitGraphEnabled(val) {
        Util_1.Util.warn("hitGraphEnabled method is deprecated. Please use layer.listening() instead.");
        this.listening(val);
      }
      getHitGraphEnabled(val) {
        Util_1.Util.warn("hitGraphEnabled method is deprecated. Please use layer.listening() instead.");
        return this.listening();
      }
      toggleHitCanvas() {
        if (!this.parent || !this.parent["content"]) {
          return;
        }
        var parent = this.parent;
        var added = !!this.hitCanvas._canvas.parentNode;
        if (added) {
          parent.content.removeChild(this.hitCanvas._canvas);
        } else {
          parent.content.appendChild(this.hitCanvas._canvas);
        }
      }
      destroy() {
        Util_1.Util.releaseCanvas(this.getNativeCanvasElement(), this.getHitCanvas()._canvas);
        return super.destroy();
      }
    };
    exports.Layer = Layer;
    Layer.prototype.nodeType = "Layer";
    (0, Global_1._registerNode)(Layer);
    Factory_1.Factory.addGetterSetter(Layer, "imageSmoothingEnabled", true);
    Factory_1.Factory.addGetterSetter(Layer, "clearBeforeDraw", true);
    Factory_1.Factory.addGetterSetter(Layer, "hitGraphEnabled", true, (0, Validators_1.getBooleanValidator)());
  }
});

// node_modules/konva/lib/FastLayer.js
var require_FastLayer = __commonJS({
  "node_modules/konva/lib/FastLayer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.FastLayer = void 0;
    var Util_1 = require_Util();
    var Layer_1 = require_Layer();
    var Global_1 = require_Global();
    var FastLayer = class extends Layer_1.Layer {
      constructor(attrs) {
        super(attrs);
        this.listening(false);
        Util_1.Util.warn('Konva.Fast layer is deprecated. Please use "new Konva.Layer({ listening: false })" instead.');
      }
    };
    exports.FastLayer = FastLayer;
    FastLayer.prototype.nodeType = "FastLayer";
    (0, Global_1._registerNode)(FastLayer);
  }
});

// node_modules/konva/lib/Group.js
var require_Group = __commonJS({
  "node_modules/konva/lib/Group.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Group = void 0;
    var Util_1 = require_Util();
    var Container_1 = require_Container();
    var Global_1 = require_Global();
    var Group = class extends Container_1.Container {
      _validateAdd(child) {
        var type = child.getType();
        if (type !== "Group" && type !== "Shape") {
          Util_1.Util.throw("You may only add groups and shapes to groups.");
        }
      }
    };
    exports.Group = Group;
    Group.prototype.nodeType = "Group";
    (0, Global_1._registerNode)(Group);
  }
});

// node_modules/konva/lib/Animation.js
var require_Animation = __commonJS({
  "node_modules/konva/lib/Animation.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Animation = void 0;
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    var now = function() {
      if (Global_1.glob.performance && Global_1.glob.performance.now) {
        return function() {
          return Global_1.glob.performance.now();
        };
      }
      return function() {
        return (/* @__PURE__ */ new Date()).getTime();
      };
    }();
    var Animation = class _Animation {
      constructor(func, layers) {
        this.id = _Animation.animIdCounter++;
        this.frame = {
          time: 0,
          timeDiff: 0,
          lastTime: now(),
          frameRate: 0
        };
        this.func = func;
        this.setLayers(layers);
      }
      setLayers(layers) {
        let lays = [];
        if (layers) {
          lays = Array.isArray(layers) ? layers : [layers];
        }
        this.layers = lays;
        return this;
      }
      getLayers() {
        return this.layers;
      }
      addLayer(layer) {
        const layers = this.layers;
        const len = layers.length;
        for (let n = 0; n < len; n++) {
          if (layers[n]._id === layer._id) {
            return false;
          }
        }
        this.layers.push(layer);
        return true;
      }
      isRunning() {
        const a = _Animation;
        const animations = a.animations;
        const len = animations.length;
        for (let n = 0; n < len; n++) {
          if (animations[n].id === this.id) {
            return true;
          }
        }
        return false;
      }
      start() {
        this.stop();
        this.frame.timeDiff = 0;
        this.frame.lastTime = now();
        _Animation._addAnimation(this);
        return this;
      }
      stop() {
        _Animation._removeAnimation(this);
        return this;
      }
      _updateFrameObject(time) {
        this.frame.timeDiff = time - this.frame.lastTime;
        this.frame.lastTime = time;
        this.frame.time += this.frame.timeDiff;
        this.frame.frameRate = 1e3 / this.frame.timeDiff;
      }
      static _addAnimation(anim) {
        this.animations.push(anim);
        this._handleAnimation();
      }
      static _removeAnimation(anim) {
        const id = anim.id;
        const animations = this.animations;
        const len = animations.length;
        for (let n = 0; n < len; n++) {
          if (animations[n].id === id) {
            this.animations.splice(n, 1);
            break;
          }
        }
      }
      static _runFrames() {
        const layerHash = {};
        const animations = this.animations;
        for (let n = 0; n < animations.length; n++) {
          const anim = animations[n];
          const layers = anim.layers;
          const func = anim.func;
          anim._updateFrameObject(now());
          const layersLen = layers.length;
          let needRedraw;
          if (func) {
            needRedraw = func.call(anim, anim.frame) !== false;
          } else {
            needRedraw = true;
          }
          if (!needRedraw) {
            continue;
          }
          for (let i = 0; i < layersLen; i++) {
            const layer = layers[i];
            if (layer._id !== void 0) {
              layerHash[layer._id] = layer;
            }
          }
        }
        for (let key in layerHash) {
          if (!layerHash.hasOwnProperty(key)) {
            continue;
          }
          layerHash[key].batchDraw();
        }
      }
      static _animationLoop() {
        const Anim = _Animation;
        if (Anim.animations.length) {
          Anim._runFrames();
          Util_1.Util.requestAnimFrame(Anim._animationLoop);
        } else {
          Anim.animRunning = false;
        }
      }
      static _handleAnimation() {
        if (!this.animRunning) {
          this.animRunning = true;
          Util_1.Util.requestAnimFrame(this._animationLoop);
        }
      }
    };
    exports.Animation = Animation;
    Animation.animations = [];
    Animation.animIdCounter = 0;
    Animation.animRunning = false;
  }
});

// node_modules/konva/lib/Tween.js
var require_Tween = __commonJS({
  "node_modules/konva/lib/Tween.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Easings = exports.Tween = void 0;
    var Util_1 = require_Util();
    var Animation_1 = require_Animation();
    var Node_1 = require_Node();
    var Global_1 = require_Global();
    var blacklist = {
      node: 1,
      duration: 1,
      easing: 1,
      onFinish: 1,
      yoyo: 1
    };
    var PAUSED = 1;
    var PLAYING = 2;
    var REVERSING = 3;
    var idCounter = 0;
    var colorAttrs = ["fill", "stroke", "shadowColor"];
    var TweenEngine = class {
      constructor(prop, propFunc, func, begin, finish, duration, yoyo) {
        this.prop = prop;
        this.propFunc = propFunc;
        this.begin = begin;
        this._pos = begin;
        this.duration = duration;
        this._change = 0;
        this.prevPos = 0;
        this.yoyo = yoyo;
        this._time = 0;
        this._position = 0;
        this._startTime = 0;
        this._finish = 0;
        this.func = func;
        this._change = finish - this.begin;
        this.pause();
      }
      fire(str) {
        var handler = this[str];
        if (handler) {
          handler();
        }
      }
      setTime(t) {
        if (t > this.duration) {
          if (this.yoyo) {
            this._time = this.duration;
            this.reverse();
          } else {
            this.finish();
          }
        } else if (t < 0) {
          if (this.yoyo) {
            this._time = 0;
            this.play();
          } else {
            this.reset();
          }
        } else {
          this._time = t;
          this.update();
        }
      }
      getTime() {
        return this._time;
      }
      setPosition(p) {
        this.prevPos = this._pos;
        this.propFunc(p);
        this._pos = p;
      }
      getPosition(t) {
        if (t === void 0) {
          t = this._time;
        }
        return this.func(t, this.begin, this._change, this.duration);
      }
      play() {
        this.state = PLAYING;
        this._startTime = this.getTimer() - this._time;
        this.onEnterFrame();
        this.fire("onPlay");
      }
      reverse() {
        this.state = REVERSING;
        this._time = this.duration - this._time;
        this._startTime = this.getTimer() - this._time;
        this.onEnterFrame();
        this.fire("onReverse");
      }
      seek(t) {
        this.pause();
        this._time = t;
        this.update();
        this.fire("onSeek");
      }
      reset() {
        this.pause();
        this._time = 0;
        this.update();
        this.fire("onReset");
      }
      finish() {
        this.pause();
        this._time = this.duration;
        this.update();
        this.fire("onFinish");
      }
      update() {
        this.setPosition(this.getPosition(this._time));
        this.fire("onUpdate");
      }
      onEnterFrame() {
        var t = this.getTimer() - this._startTime;
        if (this.state === PLAYING) {
          this.setTime(t);
        } else if (this.state === REVERSING) {
          this.setTime(this.duration - t);
        }
      }
      pause() {
        this.state = PAUSED;
        this.fire("onPause");
      }
      getTimer() {
        return (/* @__PURE__ */ new Date()).getTime();
      }
    };
    var Tween = class _Tween {
      constructor(config) {
        var that = this, node = config.node, nodeId = node._id, duration, easing = config.easing || exports.Easings.Linear, yoyo = !!config.yoyo, key;
        if (typeof config.duration === "undefined") {
          duration = 0.3;
        } else if (config.duration === 0) {
          duration = 1e-3;
        } else {
          duration = config.duration;
        }
        this.node = node;
        this._id = idCounter++;
        var layers = node.getLayer() || (node instanceof Global_1.Konva["Stage"] ? node.getLayers() : null);
        if (!layers) {
          Util_1.Util.error("Tween constructor have `node` that is not in a layer. Please add node into layer first.");
        }
        this.anim = new Animation_1.Animation(function() {
          that.tween.onEnterFrame();
        }, layers);
        this.tween = new TweenEngine(key, function(i) {
          that._tweenFunc(i);
        }, easing, 0, 1, duration * 1e3, yoyo);
        this._addListeners();
        if (!_Tween.attrs[nodeId]) {
          _Tween.attrs[nodeId] = {};
        }
        if (!_Tween.attrs[nodeId][this._id]) {
          _Tween.attrs[nodeId][this._id] = {};
        }
        if (!_Tween.tweens[nodeId]) {
          _Tween.tweens[nodeId] = {};
        }
        for (key in config) {
          if (blacklist[key] === void 0) {
            this._addAttr(key, config[key]);
          }
        }
        this.reset();
        this.onFinish = config.onFinish;
        this.onReset = config.onReset;
        this.onUpdate = config.onUpdate;
      }
      _addAttr(key, end) {
        var node = this.node, nodeId = node._id, start, diff, tweenId, n, len, trueEnd, trueStart, endRGBA;
        tweenId = _Tween.tweens[nodeId][key];
        if (tweenId) {
          delete _Tween.attrs[nodeId][tweenId][key];
        }
        start = node.getAttr(key);
        if (Util_1.Util._isArray(end)) {
          diff = [];
          len = Math.max(end.length, start.length);
          if (key === "points" && end.length !== start.length) {
            if (end.length > start.length) {
              trueStart = start;
              start = Util_1.Util._prepareArrayForTween(start, end, node.closed());
            } else {
              trueEnd = end;
              end = Util_1.Util._prepareArrayForTween(end, start, node.closed());
            }
          }
          if (key.indexOf("fill") === 0) {
            for (n = 0; n < len; n++) {
              if (n % 2 === 0) {
                diff.push(end[n] - start[n]);
              } else {
                var startRGBA = Util_1.Util.colorToRGBA(start[n]);
                endRGBA = Util_1.Util.colorToRGBA(end[n]);
                start[n] = startRGBA;
                diff.push({
                  r: endRGBA.r - startRGBA.r,
                  g: endRGBA.g - startRGBA.g,
                  b: endRGBA.b - startRGBA.b,
                  a: endRGBA.a - startRGBA.a
                });
              }
            }
          } else {
            for (n = 0; n < len; n++) {
              diff.push(end[n] - start[n]);
            }
          }
        } else if (colorAttrs.indexOf(key) !== -1) {
          start = Util_1.Util.colorToRGBA(start);
          endRGBA = Util_1.Util.colorToRGBA(end);
          diff = {
            r: endRGBA.r - start.r,
            g: endRGBA.g - start.g,
            b: endRGBA.b - start.b,
            a: endRGBA.a - start.a
          };
        } else {
          diff = end - start;
        }
        _Tween.attrs[nodeId][this._id][key] = {
          start,
          diff,
          end,
          trueEnd,
          trueStart
        };
        _Tween.tweens[nodeId][key] = this._id;
      }
      _tweenFunc(i) {
        var node = this.node, attrs = _Tween.attrs[node._id][this._id], key, attr, start, diff, newVal, n, len, end;
        for (key in attrs) {
          attr = attrs[key];
          start = attr.start;
          diff = attr.diff;
          end = attr.end;
          if (Util_1.Util._isArray(start)) {
            newVal = [];
            len = Math.max(start.length, end.length);
            if (key.indexOf("fill") === 0) {
              for (n = 0; n < len; n++) {
                if (n % 2 === 0) {
                  newVal.push((start[n] || 0) + diff[n] * i);
                } else {
                  newVal.push("rgba(" + Math.round(start[n].r + diff[n].r * i) + "," + Math.round(start[n].g + diff[n].g * i) + "," + Math.round(start[n].b + diff[n].b * i) + "," + (start[n].a + diff[n].a * i) + ")");
                }
              }
            } else {
              for (n = 0; n < len; n++) {
                newVal.push((start[n] || 0) + diff[n] * i);
              }
            }
          } else if (colorAttrs.indexOf(key) !== -1) {
            newVal = "rgba(" + Math.round(start.r + diff.r * i) + "," + Math.round(start.g + diff.g * i) + "," + Math.round(start.b + diff.b * i) + "," + (start.a + diff.a * i) + ")";
          } else {
            newVal = start + diff * i;
          }
          node.setAttr(key, newVal);
        }
      }
      _addListeners() {
        this.tween.onPlay = () => {
          this.anim.start();
        };
        this.tween.onReverse = () => {
          this.anim.start();
        };
        this.tween.onPause = () => {
          this.anim.stop();
        };
        this.tween.onFinish = () => {
          var node = this.node;
          var attrs = _Tween.attrs[node._id][this._id];
          if (attrs.points && attrs.points.trueEnd) {
            node.setAttr("points", attrs.points.trueEnd);
          }
          if (this.onFinish) {
            this.onFinish.call(this);
          }
        };
        this.tween.onReset = () => {
          var node = this.node;
          var attrs = _Tween.attrs[node._id][this._id];
          if (attrs.points && attrs.points.trueStart) {
            node.points(attrs.points.trueStart);
          }
          if (this.onReset) {
            this.onReset();
          }
        };
        this.tween.onUpdate = () => {
          if (this.onUpdate) {
            this.onUpdate.call(this);
          }
        };
      }
      play() {
        this.tween.play();
        return this;
      }
      reverse() {
        this.tween.reverse();
        return this;
      }
      reset() {
        this.tween.reset();
        return this;
      }
      seek(t) {
        this.tween.seek(t * 1e3);
        return this;
      }
      pause() {
        this.tween.pause();
        return this;
      }
      finish() {
        this.tween.finish();
        return this;
      }
      destroy() {
        var nodeId = this.node._id, thisId = this._id, attrs = _Tween.tweens[nodeId], key;
        this.pause();
        for (key in attrs) {
          delete _Tween.tweens[nodeId][key];
        }
        delete _Tween.attrs[nodeId][thisId];
      }
    };
    exports.Tween = Tween;
    Tween.attrs = {};
    Tween.tweens = {};
    Node_1.Node.prototype.to = function(params) {
      var onFinish = params.onFinish;
      params.node = this;
      params.onFinish = function() {
        this.destroy();
        if (onFinish) {
          onFinish();
        }
      };
      var tween = new Tween(params);
      tween.play();
    };
    exports.Easings = {
      BackEaseIn(t, b, c, d) {
        var s = 1.70158;
        return c * (t /= d) * t * ((s + 1) * t - s) + b;
      },
      BackEaseOut(t, b, c, d) {
        var s = 1.70158;
        return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
      },
      BackEaseInOut(t, b, c, d) {
        var s = 1.70158;
        if ((t /= d / 2) < 1) {
          return c / 2 * (t * t * (((s *= 1.525) + 1) * t - s)) + b;
        }
        return c / 2 * ((t -= 2) * t * (((s *= 1.525) + 1) * t + s) + 2) + b;
      },
      ElasticEaseIn(t, b, c, d, a, p) {
        var s = 0;
        if (t === 0) {
          return b;
        }
        if ((t /= d) === 1) {
          return b + c;
        }
        if (!p) {
          p = d * 0.3;
        }
        if (!a || a < Math.abs(c)) {
          a = c;
          s = p / 4;
        } else {
          s = p / (2 * Math.PI) * Math.asin(c / a);
        }
        return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p)) + b;
      },
      ElasticEaseOut(t, b, c, d, a, p) {
        var s = 0;
        if (t === 0) {
          return b;
        }
        if ((t /= d) === 1) {
          return b + c;
        }
        if (!p) {
          p = d * 0.3;
        }
        if (!a || a < Math.abs(c)) {
          a = c;
          s = p / 4;
        } else {
          s = p / (2 * Math.PI) * Math.asin(c / a);
        }
        return a * Math.pow(2, -10 * t) * Math.sin((t * d - s) * (2 * Math.PI) / p) + c + b;
      },
      ElasticEaseInOut(t, b, c, d, a, p) {
        var s = 0;
        if (t === 0) {
          return b;
        }
        if ((t /= d / 2) === 2) {
          return b + c;
        }
        if (!p) {
          p = d * (0.3 * 1.5);
        }
        if (!a || a < Math.abs(c)) {
          a = c;
          s = p / 4;
        } else {
          s = p / (2 * Math.PI) * Math.asin(c / a);
        }
        if (t < 1) {
          return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p)) + b;
        }
        return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t * d - s) * (2 * Math.PI) / p) * 0.5 + c + b;
      },
      BounceEaseOut(t, b, c, d) {
        if ((t /= d) < 1 / 2.75) {
          return c * (7.5625 * t * t) + b;
        } else if (t < 2 / 2.75) {
          return c * (7.5625 * (t -= 1.5 / 2.75) * t + 0.75) + b;
        } else if (t < 2.5 / 2.75) {
          return c * (7.5625 * (t -= 2.25 / 2.75) * t + 0.9375) + b;
        } else {
          return c * (7.5625 * (t -= 2.625 / 2.75) * t + 0.984375) + b;
        }
      },
      BounceEaseIn(t, b, c, d) {
        return c - exports.Easings.BounceEaseOut(d - t, 0, c, d) + b;
      },
      BounceEaseInOut(t, b, c, d) {
        if (t < d / 2) {
          return exports.Easings.BounceEaseIn(t * 2, 0, c, d) * 0.5 + b;
        } else {
          return exports.Easings.BounceEaseOut(t * 2 - d, 0, c, d) * 0.5 + c * 0.5 + b;
        }
      },
      EaseIn(t, b, c, d) {
        return c * (t /= d) * t + b;
      },
      EaseOut(t, b, c, d) {
        return -c * (t /= d) * (t - 2) + b;
      },
      EaseInOut(t, b, c, d) {
        if ((t /= d / 2) < 1) {
          return c / 2 * t * t + b;
        }
        return -c / 2 * (--t * (t - 2) - 1) + b;
      },
      StrongEaseIn(t, b, c, d) {
        return c * (t /= d) * t * t * t * t + b;
      },
      StrongEaseOut(t, b, c, d) {
        return c * ((t = t / d - 1) * t * t * t * t + 1) + b;
      },
      StrongEaseInOut(t, b, c, d) {
        if ((t /= d / 2) < 1) {
          return c / 2 * t * t * t * t * t + b;
        }
        return c / 2 * ((t -= 2) * t * t * t * t + 2) + b;
      },
      Linear(t, b, c, d) {
        return c * t / d + b;
      }
    };
  }
});

// node_modules/konva/lib/_CoreInternals.js
var require_CoreInternals = __commonJS({
  "node_modules/konva/lib/_CoreInternals.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Konva = void 0;
    var Global_1 = require_Global();
    var Util_1 = require_Util();
    var Node_1 = require_Node();
    var Container_1 = require_Container();
    var Stage_1 = require_Stage();
    var Layer_1 = require_Layer();
    var FastLayer_1 = require_FastLayer();
    var Group_1 = require_Group();
    var DragAndDrop_1 = require_DragAndDrop();
    var Shape_1 = require_Shape();
    var Animation_1 = require_Animation();
    var Tween_1 = require_Tween();
    var Context_1 = require_Context();
    var Canvas_1 = require_Canvas();
    exports.Konva = Util_1.Util._assign(Global_1.Konva, {
      Util: Util_1.Util,
      Transform: Util_1.Transform,
      Node: Node_1.Node,
      Container: Container_1.Container,
      Stage: Stage_1.Stage,
      stages: Stage_1.stages,
      Layer: Layer_1.Layer,
      FastLayer: FastLayer_1.FastLayer,
      Group: Group_1.Group,
      DD: DragAndDrop_1.DD,
      Shape: Shape_1.Shape,
      shapes: Shape_1.shapes,
      Animation: Animation_1.Animation,
      Tween: Tween_1.Tween,
      Easings: Tween_1.Easings,
      Context: Context_1.Context,
      Canvas: Canvas_1.Canvas
    });
    exports.default = exports.Konva;
  }
});

// node_modules/konva/lib/shapes/Arc.js
var require_Arc = __commonJS({
  "node_modules/konva/lib/shapes/Arc.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Arc = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var Validators_1 = require_Validators();
    var Global_2 = require_Global();
    var Arc = class extends Shape_1.Shape {
      _sceneFunc(context) {
        var angle = Global_1.Konva.getAngle(this.angle()), clockwise = this.clockwise();
        context.beginPath();
        context.arc(0, 0, this.outerRadius(), 0, angle, clockwise);
        context.arc(0, 0, this.innerRadius(), angle, 0, !clockwise);
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        return this.outerRadius() * 2;
      }
      getHeight() {
        return this.outerRadius() * 2;
      }
      setWidth(width) {
        this.outerRadius(width / 2);
      }
      setHeight(height) {
        this.outerRadius(height / 2);
      }
      getSelfRect() {
        const innerRadius = this.innerRadius();
        const outerRadius = this.outerRadius();
        const clockwise = this.clockwise();
        const angle = Global_1.Konva.getAngle(clockwise ? 360 - this.angle() : this.angle());
        const boundLeftRatio = Math.cos(Math.min(angle, Math.PI));
        const boundRightRatio = 1;
        const boundTopRatio = Math.sin(Math.min(Math.max(Math.PI, angle), 3 * Math.PI / 2));
        const boundBottomRatio = Math.sin(Math.min(angle, Math.PI / 2));
        const boundLeft = boundLeftRatio * (boundLeftRatio > 0 ? innerRadius : outerRadius);
        const boundRight = boundRightRatio * (boundRightRatio > 0 ? outerRadius : innerRadius);
        const boundTop = boundTopRatio * (boundTopRatio > 0 ? innerRadius : outerRadius);
        const boundBottom = boundBottomRatio * (boundBottomRatio > 0 ? outerRadius : innerRadius);
        return {
          x: boundLeft,
          y: clockwise ? -1 * boundBottom : boundTop,
          width: boundRight - boundLeft,
          height: boundBottom - boundTop
        };
      }
    };
    exports.Arc = Arc;
    Arc.prototype._centroid = true;
    Arc.prototype.className = "Arc";
    Arc.prototype._attrsAffectingSize = ["innerRadius", "outerRadius"];
    (0, Global_2._registerNode)(Arc);
    Factory_1.Factory.addGetterSetter(Arc, "innerRadius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Arc, "outerRadius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Arc, "angle", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Arc, "clockwise", false, (0, Validators_1.getBooleanValidator)());
  }
});

// node_modules/konva/lib/shapes/Line.js
var require_Line = __commonJS({
  "node_modules/konva/lib/shapes/Line.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Line = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    function getControlPoints(x0, y0, x1, y1, x2, y2, t) {
      var d01 = Math.sqrt(Math.pow(x1 - x0, 2) + Math.pow(y1 - y0, 2)), d12 = Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2)), fa = t * d01 / (d01 + d12), fb = t * d12 / (d01 + d12), p1x = x1 - fa * (x2 - x0), p1y = y1 - fa * (y2 - y0), p2x = x1 + fb * (x2 - x0), p2y = y1 + fb * (y2 - y0);
      return [p1x, p1y, p2x, p2y];
    }
    function expandPoints(p, tension) {
      var len = p.length, allPoints = [], n, cp;
      for (n = 2; n < len - 2; n += 2) {
        cp = getControlPoints(p[n - 2], p[n - 1], p[n], p[n + 1], p[n + 2], p[n + 3], tension);
        if (isNaN(cp[0])) {
          continue;
        }
        allPoints.push(cp[0]);
        allPoints.push(cp[1]);
        allPoints.push(p[n]);
        allPoints.push(p[n + 1]);
        allPoints.push(cp[2]);
        allPoints.push(cp[3]);
      }
      return allPoints;
    }
    var Line = class extends Shape_1.Shape {
      constructor(config) {
        super(config);
        this.on("pointsChange.konva tensionChange.konva closedChange.konva bezierChange.konva", function() {
          this._clearCache("tensionPoints");
        });
      }
      _sceneFunc(context) {
        var points = this.points(), length = points.length, tension = this.tension(), closed = this.closed(), bezier = this.bezier(), tp, len, n;
        if (!length) {
          return;
        }
        context.beginPath();
        context.moveTo(points[0], points[1]);
        if (tension !== 0 && length > 4) {
          tp = this.getTensionPoints();
          len = tp.length;
          n = closed ? 0 : 4;
          if (!closed) {
            context.quadraticCurveTo(tp[0], tp[1], tp[2], tp[3]);
          }
          while (n < len - 2) {
            context.bezierCurveTo(tp[n++], tp[n++], tp[n++], tp[n++], tp[n++], tp[n++]);
          }
          if (!closed) {
            context.quadraticCurveTo(tp[len - 2], tp[len - 1], points[length - 2], points[length - 1]);
          }
        } else if (bezier) {
          n = 2;
          while (n < length) {
            context.bezierCurveTo(points[n++], points[n++], points[n++], points[n++], points[n++], points[n++]);
          }
        } else {
          for (n = 2; n < length; n += 2) {
            context.lineTo(points[n], points[n + 1]);
          }
        }
        if (closed) {
          context.closePath();
          context.fillStrokeShape(this);
        } else {
          context.strokeShape(this);
        }
      }
      getTensionPoints() {
        return this._getCache("tensionPoints", this._getTensionPoints);
      }
      _getTensionPoints() {
        if (this.closed()) {
          return this._getTensionPointsClosed();
        } else {
          return expandPoints(this.points(), this.tension());
        }
      }
      _getTensionPointsClosed() {
        var p = this.points(), len = p.length, tension = this.tension(), firstControlPoints = getControlPoints(p[len - 2], p[len - 1], p[0], p[1], p[2], p[3], tension), lastControlPoints = getControlPoints(p[len - 4], p[len - 3], p[len - 2], p[len - 1], p[0], p[1], tension), middle = expandPoints(p, tension), tp = [firstControlPoints[2], firstControlPoints[3]].concat(middle).concat([
          lastControlPoints[0],
          lastControlPoints[1],
          p[len - 2],
          p[len - 1],
          lastControlPoints[2],
          lastControlPoints[3],
          firstControlPoints[0],
          firstControlPoints[1],
          p[0],
          p[1]
        ]);
        return tp;
      }
      getWidth() {
        return this.getSelfRect().width;
      }
      getHeight() {
        return this.getSelfRect().height;
      }
      getSelfRect() {
        var points = this.points();
        if (points.length < 4) {
          return {
            x: points[0] || 0,
            y: points[1] || 0,
            width: 0,
            height: 0
          };
        }
        if (this.tension() !== 0) {
          points = [
            points[0],
            points[1],
            ...this._getTensionPoints(),
            points[points.length - 2],
            points[points.length - 1]
          ];
        } else {
          points = this.points();
        }
        var minX = points[0];
        var maxX = points[0];
        var minY = points[1];
        var maxY = points[1];
        var x, y;
        for (var i = 0; i < points.length / 2; i++) {
          x = points[i * 2];
          y = points[i * 2 + 1];
          minX = Math.min(minX, x);
          maxX = Math.max(maxX, x);
          minY = Math.min(minY, y);
          maxY = Math.max(maxY, y);
        }
        return {
          x: minX,
          y: minY,
          width: maxX - minX,
          height: maxY - minY
        };
      }
    };
    exports.Line = Line;
    Line.prototype.className = "Line";
    Line.prototype._attrsAffectingSize = ["points", "bezier", "tension"];
    (0, Global_1._registerNode)(Line);
    Factory_1.Factory.addGetterSetter(Line, "closed", false);
    Factory_1.Factory.addGetterSetter(Line, "bezier", false);
    Factory_1.Factory.addGetterSetter(Line, "tension", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Line, "points", [], (0, Validators_1.getNumberArrayValidator)());
  }
});

// node_modules/konva/lib/BezierFunctions.js
var require_BezierFunctions = __commonJS({
  "node_modules/konva/lib/BezierFunctions.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.t2length = exports.getQuadraticArcLength = exports.getCubicArcLength = exports.binomialCoefficients = exports.cValues = exports.tValues = void 0;
    exports.tValues = [
      [],
      [],
      [
        -0.5773502691896257,
        0.5773502691896257
      ],
      [
        0,
        -0.7745966692414834,
        0.7745966692414834
      ],
      [
        -0.33998104358485626,
        0.33998104358485626,
        -0.8611363115940526,
        0.8611363115940526
      ],
      [
        0,
        -0.5384693101056831,
        0.5384693101056831,
        -0.906179845938664,
        0.906179845938664
      ],
      [
        0.6612093864662645,
        -0.6612093864662645,
        -0.2386191860831969,
        0.2386191860831969,
        -0.932469514203152,
        0.932469514203152
      ],
      [
        0,
        0.4058451513773972,
        -0.4058451513773972,
        -0.7415311855993945,
        0.7415311855993945,
        -0.9491079123427585,
        0.9491079123427585
      ],
      [
        -0.1834346424956498,
        0.1834346424956498,
        -0.525532409916329,
        0.525532409916329,
        -0.7966664774136267,
        0.7966664774136267,
        -0.9602898564975363,
        0.9602898564975363
      ],
      [
        0,
        -0.8360311073266358,
        0.8360311073266358,
        -0.9681602395076261,
        0.9681602395076261,
        -0.3242534234038089,
        0.3242534234038089,
        -0.6133714327005904,
        0.6133714327005904
      ],
      [
        -0.14887433898163122,
        0.14887433898163122,
        -0.4333953941292472,
        0.4333953941292472,
        -0.6794095682990244,
        0.6794095682990244,
        -0.8650633666889845,
        0.8650633666889845,
        -0.9739065285171717,
        0.9739065285171717
      ],
      [
        0,
        -0.26954315595234496,
        0.26954315595234496,
        -0.5190961292068118,
        0.5190961292068118,
        -0.7301520055740494,
        0.7301520055740494,
        -0.8870625997680953,
        0.8870625997680953,
        -0.978228658146057,
        0.978228658146057
      ],
      [
        -0.1252334085114689,
        0.1252334085114689,
        -0.3678314989981802,
        0.3678314989981802,
        -0.5873179542866175,
        0.5873179542866175,
        -0.7699026741943047,
        0.7699026741943047,
        -0.9041172563704749,
        0.9041172563704749,
        -0.9815606342467192,
        0.9815606342467192
      ],
      [
        0,
        -0.2304583159551348,
        0.2304583159551348,
        -0.44849275103644687,
        0.44849275103644687,
        -0.6423493394403402,
        0.6423493394403402,
        -0.8015780907333099,
        0.8015780907333099,
        -0.9175983992229779,
        0.9175983992229779,
        -0.9841830547185881,
        0.9841830547185881
      ],
      [
        -0.10805494870734367,
        0.10805494870734367,
        -0.31911236892788974,
        0.31911236892788974,
        -0.5152486363581541,
        0.5152486363581541,
        -0.6872929048116855,
        0.6872929048116855,
        -0.827201315069765,
        0.827201315069765,
        -0.9284348836635735,
        0.9284348836635735,
        -0.9862838086968123,
        0.9862838086968123
      ],
      [
        0,
        -0.20119409399743451,
        0.20119409399743451,
        -0.3941513470775634,
        0.3941513470775634,
        -0.5709721726085388,
        0.5709721726085388,
        -0.7244177313601701,
        0.7244177313601701,
        -0.8482065834104272,
        0.8482065834104272,
        -0.937273392400706,
        0.937273392400706,
        -0.9879925180204854,
        0.9879925180204854
      ],
      [
        -0.09501250983763744,
        0.09501250983763744,
        -0.2816035507792589,
        0.2816035507792589,
        -0.45801677765722737,
        0.45801677765722737,
        -0.6178762444026438,
        0.6178762444026438,
        -0.755404408355003,
        0.755404408355003,
        -0.8656312023878318,
        0.8656312023878318,
        -0.9445750230732326,
        0.9445750230732326,
        -0.9894009349916499,
        0.9894009349916499
      ],
      [
        0,
        -0.17848418149584785,
        0.17848418149584785,
        -0.3512317634538763,
        0.3512317634538763,
        -0.5126905370864769,
        0.5126905370864769,
        -0.6576711592166907,
        0.6576711592166907,
        -0.7815140038968014,
        0.7815140038968014,
        -0.8802391537269859,
        0.8802391537269859,
        -0.9506755217687678,
        0.9506755217687678,
        -0.9905754753144174,
        0.9905754753144174
      ],
      [
        -0.0847750130417353,
        0.0847750130417353,
        -0.2518862256915055,
        0.2518862256915055,
        -0.41175116146284263,
        0.41175116146284263,
        -0.5597708310739475,
        0.5597708310739475,
        -0.6916870430603532,
        0.6916870430603532,
        -0.8037049589725231,
        0.8037049589725231,
        -0.8926024664975557,
        0.8926024664975557,
        -0.9558239495713977,
        0.9558239495713977,
        -0.9915651684209309,
        0.9915651684209309
      ],
      [
        0,
        -0.16035864564022537,
        0.16035864564022537,
        -0.31656409996362983,
        0.31656409996362983,
        -0.46457074137596094,
        0.46457074137596094,
        -0.600545304661681,
        0.600545304661681,
        -0.7209661773352294,
        0.7209661773352294,
        -0.8227146565371428,
        0.8227146565371428,
        -0.9031559036148179,
        0.9031559036148179,
        -0.96020815213483,
        0.96020815213483,
        -0.9924068438435844,
        0.9924068438435844
      ],
      [
        -0.07652652113349734,
        0.07652652113349734,
        -0.22778585114164507,
        0.22778585114164507,
        -0.37370608871541955,
        0.37370608871541955,
        -0.5108670019508271,
        0.5108670019508271,
        -0.636053680726515,
        0.636053680726515,
        -0.7463319064601508,
        0.7463319064601508,
        -0.8391169718222188,
        0.8391169718222188,
        -0.912234428251326,
        0.912234428251326,
        -0.9639719272779138,
        0.9639719272779138,
        -0.9931285991850949,
        0.9931285991850949
      ],
      [
        0,
        -0.1455618541608951,
        0.1455618541608951,
        -0.2880213168024011,
        0.2880213168024011,
        -0.4243421202074388,
        0.4243421202074388,
        -0.5516188358872198,
        0.5516188358872198,
        -0.6671388041974123,
        0.6671388041974123,
        -0.7684399634756779,
        0.7684399634756779,
        -0.8533633645833173,
        0.8533633645833173,
        -0.9200993341504008,
        0.9200993341504008,
        -0.9672268385663063,
        0.9672268385663063,
        -0.9937521706203895,
        0.9937521706203895
      ],
      [
        -0.06973927331972223,
        0.06973927331972223,
        -0.20786042668822127,
        0.20786042668822127,
        -0.34193582089208424,
        0.34193582089208424,
        -0.469355837986757,
        0.469355837986757,
        -0.5876404035069116,
        0.5876404035069116,
        -0.6944872631866827,
        0.6944872631866827,
        -0.7878168059792081,
        0.7878168059792081,
        -0.8658125777203002,
        0.8658125777203002,
        -0.926956772187174,
        0.926956772187174,
        -0.9700604978354287,
        0.9700604978354287,
        -0.9942945854823992,
        0.9942945854823992
      ],
      [
        0,
        -0.1332568242984661,
        0.1332568242984661,
        -0.26413568097034495,
        0.26413568097034495,
        -0.3903010380302908,
        0.3903010380302908,
        -0.5095014778460075,
        0.5095014778460075,
        -0.6196098757636461,
        0.6196098757636461,
        -0.7186613631319502,
        0.7186613631319502,
        -0.8048884016188399,
        0.8048884016188399,
        -0.8767523582704416,
        0.8767523582704416,
        -0.9329710868260161,
        0.9329710868260161,
        -0.9725424712181152,
        0.9725424712181152,
        -0.9947693349975522,
        0.9947693349975522
      ],
      [
        -0.06405689286260563,
        0.06405689286260563,
        -0.1911188674736163,
        0.1911188674736163,
        -0.3150426796961634,
        0.3150426796961634,
        -0.4337935076260451,
        0.4337935076260451,
        -0.5454214713888396,
        0.5454214713888396,
        -0.6480936519369755,
        0.6480936519369755,
        -0.7401241915785544,
        0.7401241915785544,
        -0.820001985973903,
        0.820001985973903,
        -0.8864155270044011,
        0.8864155270044011,
        -0.9382745520027328,
        0.9382745520027328,
        -0.9747285559713095,
        0.9747285559713095,
        -0.9951872199970213,
        0.9951872199970213
      ]
    ];
    exports.cValues = [
      [],
      [],
      [1, 1],
      [
        0.8888888888888888,
        0.5555555555555556,
        0.5555555555555556
      ],
      [
        0.6521451548625461,
        0.6521451548625461,
        0.34785484513745385,
        0.34785484513745385
      ],
      [
        0.5688888888888889,
        0.47862867049936647,
        0.47862867049936647,
        0.23692688505618908,
        0.23692688505618908
      ],
      [
        0.3607615730481386,
        0.3607615730481386,
        0.46791393457269104,
        0.46791393457269104,
        0.17132449237917036,
        0.17132449237917036
      ],
      [
        0.4179591836734694,
        0.3818300505051189,
        0.3818300505051189,
        0.27970539148927664,
        0.27970539148927664,
        0.1294849661688697,
        0.1294849661688697
      ],
      [
        0.362683783378362,
        0.362683783378362,
        0.31370664587788727,
        0.31370664587788727,
        0.22238103445337448,
        0.22238103445337448,
        0.10122853629037626,
        0.10122853629037626
      ],
      [
        0.3302393550012598,
        0.1806481606948574,
        0.1806481606948574,
        0.08127438836157441,
        0.08127438836157441,
        0.31234707704000286,
        0.31234707704000286,
        0.26061069640293544,
        0.26061069640293544
      ],
      [
        0.29552422471475287,
        0.29552422471475287,
        0.26926671930999635,
        0.26926671930999635,
        0.21908636251598204,
        0.21908636251598204,
        0.1494513491505806,
        0.1494513491505806,
        0.06667134430868814,
        0.06667134430868814
      ],
      [
        0.2729250867779006,
        0.26280454451024665,
        0.26280454451024665,
        0.23319376459199048,
        0.23319376459199048,
        0.18629021092773426,
        0.18629021092773426,
        0.1255803694649046,
        0.1255803694649046,
        0.05566856711617366,
        0.05566856711617366
      ],
      [
        0.24914704581340277,
        0.24914704581340277,
        0.2334925365383548,
        0.2334925365383548,
        0.20316742672306592,
        0.20316742672306592,
        0.16007832854334622,
        0.16007832854334622,
        0.10693932599531843,
        0.10693932599531843,
        0.04717533638651183,
        0.04717533638651183
      ],
      [
        0.2325515532308739,
        0.22628318026289723,
        0.22628318026289723,
        0.2078160475368885,
        0.2078160475368885,
        0.17814598076194574,
        0.17814598076194574,
        0.13887351021978725,
        0.13887351021978725,
        0.09212149983772845,
        0.09212149983772845,
        0.04048400476531588,
        0.04048400476531588
      ],
      [
        0.2152638534631578,
        0.2152638534631578,
        0.2051984637212956,
        0.2051984637212956,
        0.18553839747793782,
        0.18553839747793782,
        0.15720316715819355,
        0.15720316715819355,
        0.12151857068790319,
        0.12151857068790319,
        0.08015808715976021,
        0.08015808715976021,
        0.03511946033175186,
        0.03511946033175186
      ],
      [
        0.2025782419255613,
        0.19843148532711158,
        0.19843148532711158,
        0.1861610000155622,
        0.1861610000155622,
        0.16626920581699392,
        0.16626920581699392,
        0.13957067792615432,
        0.13957067792615432,
        0.10715922046717194,
        0.10715922046717194,
        0.07036604748810812,
        0.07036604748810812,
        0.03075324199611727,
        0.03075324199611727
      ],
      [
        0.1894506104550685,
        0.1894506104550685,
        0.18260341504492358,
        0.18260341504492358,
        0.16915651939500254,
        0.16915651939500254,
        0.14959598881657674,
        0.14959598881657674,
        0.12462897125553388,
        0.12462897125553388,
        0.09515851168249279,
        0.09515851168249279,
        0.062253523938647894,
        0.062253523938647894,
        0.027152459411754096,
        0.027152459411754096
      ],
      [
        0.17944647035620653,
        0.17656270536699264,
        0.17656270536699264,
        0.16800410215645004,
        0.16800410215645004,
        0.15404576107681028,
        0.15404576107681028,
        0.13513636846852548,
        0.13513636846852548,
        0.11188384719340397,
        0.11188384719340397,
        0.08503614831717918,
        0.08503614831717918,
        0.0554595293739872,
        0.0554595293739872,
        0.02414830286854793,
        0.02414830286854793
      ],
      [
        0.1691423829631436,
        0.1691423829631436,
        0.16427648374583273,
        0.16427648374583273,
        0.15468467512626524,
        0.15468467512626524,
        0.14064291467065065,
        0.14064291467065065,
        0.12255520671147846,
        0.12255520671147846,
        0.10094204410628717,
        0.10094204410628717,
        0.07642573025488905,
        0.07642573025488905,
        0.0497145488949698,
        0.0497145488949698,
        0.02161601352648331,
        0.02161601352648331
      ],
      [
        0.1610544498487837,
        0.15896884339395434,
        0.15896884339395434,
        0.15276604206585967,
        0.15276604206585967,
        0.1426067021736066,
        0.1426067021736066,
        0.12875396253933621,
        0.12875396253933621,
        0.11156664554733399,
        0.11156664554733399,
        0.09149002162245,
        0.09149002162245,
        0.06904454273764123,
        0.06904454273764123,
        0.0448142267656996,
        0.0448142267656996,
        0.019461788229726478,
        0.019461788229726478
      ],
      [
        0.15275338713072584,
        0.15275338713072584,
        0.14917298647260374,
        0.14917298647260374,
        0.14209610931838204,
        0.14209610931838204,
        0.13168863844917664,
        0.13168863844917664,
        0.11819453196151841,
        0.11819453196151841,
        0.10193011981724044,
        0.10193011981724044,
        0.08327674157670475,
        0.08327674157670475,
        0.06267204833410907,
        0.06267204833410907,
        0.04060142980038694,
        0.04060142980038694,
        0.017614007139152118,
        0.017614007139152118
      ],
      [
        0.14608113364969041,
        0.14452440398997005,
        0.14452440398997005,
        0.13988739479107315,
        0.13988739479107315,
        0.13226893863333747,
        0.13226893863333747,
        0.12183141605372853,
        0.12183141605372853,
        0.10879729916714838,
        0.10879729916714838,
        0.09344442345603386,
        0.09344442345603386,
        0.0761001136283793,
        0.0761001136283793,
        0.057134425426857205,
        0.057134425426857205,
        0.036953789770852494,
        0.036953789770852494,
        0.016017228257774335,
        0.016017228257774335
      ],
      [
        0.13925187285563198,
        0.13925187285563198,
        0.13654149834601517,
        0.13654149834601517,
        0.13117350478706238,
        0.13117350478706238,
        0.12325237681051242,
        0.12325237681051242,
        0.11293229608053922,
        0.11293229608053922,
        0.10041414444288096,
        0.10041414444288096,
        0.08594160621706773,
        0.08594160621706773,
        0.06979646842452049,
        0.06979646842452049,
        0.052293335152683286,
        0.052293335152683286,
        0.03377490158481415,
        0.03377490158481415,
        0.0146279952982722,
        0.0146279952982722
      ],
      [
        0.13365457218610619,
        0.1324620394046966,
        0.1324620394046966,
        0.12890572218808216,
        0.12890572218808216,
        0.12304908430672953,
        0.12304908430672953,
        0.11499664022241136,
        0.11499664022241136,
        0.10489209146454141,
        0.10489209146454141,
        0.09291576606003515,
        0.09291576606003515,
        0.07928141177671895,
        0.07928141177671895,
        0.06423242140852585,
        0.06423242140852585,
        0.04803767173108467,
        0.04803767173108467,
        0.030988005856979445,
        0.030988005856979445,
        0.013411859487141771,
        0.013411859487141771
      ],
      [
        0.12793819534675216,
        0.12793819534675216,
        0.1258374563468283,
        0.1258374563468283,
        0.12167047292780339,
        0.12167047292780339,
        0.1155056680537256,
        0.1155056680537256,
        0.10744427011596563,
        0.10744427011596563,
        0.09761865210411388,
        0.09761865210411388,
        0.08619016153195327,
        0.08619016153195327,
        0.0733464814110803,
        0.0733464814110803,
        0.05929858491543678,
        0.05929858491543678,
        0.04427743881741981,
        0.04427743881741981,
        0.028531388628933663,
        0.028531388628933663,
        0.0123412297999872,
        0.0123412297999872
      ]
    ];
    exports.binomialCoefficients = [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1]];
    var getCubicArcLength = (xs, ys, t) => {
      let z;
      let sum;
      let correctedT;
      const n = 20;
      z = t / 2;
      sum = 0;
      for (let i = 0; i < n; i++) {
        correctedT = z * exports.tValues[n][i] + z;
        sum += exports.cValues[n][i] * BFunc(xs, ys, correctedT);
      }
      return z * sum;
    };
    exports.getCubicArcLength = getCubicArcLength;
    var getQuadraticArcLength = (xs, ys, t) => {
      if (t === void 0) {
        t = 1;
      }
      const ax = xs[0] - 2 * xs[1] + xs[2];
      const ay = ys[0] - 2 * ys[1] + ys[2];
      const bx = 2 * xs[1] - 2 * xs[0];
      const by = 2 * ys[1] - 2 * ys[0];
      const A = 4 * (ax * ax + ay * ay);
      const B = 4 * (ax * bx + ay * by);
      const C = bx * bx + by * by;
      if (A === 0) {
        return t * Math.sqrt(Math.pow(xs[2] - xs[0], 2) + Math.pow(ys[2] - ys[0], 2));
      }
      const b = B / (2 * A);
      const c = C / A;
      const u = t + b;
      const k = c - b * b;
      const uuk = u * u + k > 0 ? Math.sqrt(u * u + k) : 0;
      const bbk = b * b + k > 0 ? Math.sqrt(b * b + k) : 0;
      const term = b + Math.sqrt(b * b + k) !== 0 ? k * Math.log(Math.abs((u + uuk) / (b + bbk))) : 0;
      return Math.sqrt(A) / 2 * (u * uuk - b * bbk + term);
    };
    exports.getQuadraticArcLength = getQuadraticArcLength;
    function BFunc(xs, ys, t) {
      const xbase = getDerivative(1, t, xs);
      const ybase = getDerivative(1, t, ys);
      const combined = xbase * xbase + ybase * ybase;
      return Math.sqrt(combined);
    }
    var getDerivative = (derivative, t, vs) => {
      const n = vs.length - 1;
      let _vs;
      let value;
      if (n === 0) {
        return 0;
      }
      if (derivative === 0) {
        value = 0;
        for (let k = 0; k <= n; k++) {
          value += exports.binomialCoefficients[n][k] * Math.pow(1 - t, n - k) * Math.pow(t, k) * vs[k];
        }
        return value;
      } else {
        _vs = new Array(n);
        for (let k = 0; k < n; k++) {
          _vs[k] = n * (vs[k + 1] - vs[k]);
        }
        return getDerivative(derivative - 1, t, _vs);
      }
    };
    var t2length = (length, totalLength, func) => {
      let error = 1;
      let t = length / totalLength;
      let step = (length - func(t)) / totalLength;
      let numIterations = 0;
      while (error > 1e-3) {
        const increasedTLength = func(t + step);
        const increasedTError = Math.abs(length - increasedTLength) / totalLength;
        if (increasedTError < error) {
          error = increasedTError;
          t += step;
        } else {
          const decreasedTLength = func(t - step);
          const decreasedTError = Math.abs(length - decreasedTLength) / totalLength;
          if (decreasedTError < error) {
            error = decreasedTError;
            t -= step;
          } else {
            step /= 2;
          }
        }
        numIterations++;
        if (numIterations > 500) {
          break;
        }
      }
      return t;
    };
    exports.t2length = t2length;
  }
});

// node_modules/konva/lib/shapes/Path.js
var require_Path = __commonJS({
  "node_modules/konva/lib/shapes/Path.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Path = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var BezierFunctions_1 = require_BezierFunctions();
    var Path = class _Path extends Shape_1.Shape {
      constructor(config) {
        super(config);
        this.dataArray = [];
        this.pathLength = 0;
        this._readDataAttribute();
        this.on("dataChange.konva", function() {
          this._readDataAttribute();
        });
      }
      _readDataAttribute() {
        this.dataArray = _Path.parsePathData(this.data());
        this.pathLength = _Path.getPathLength(this.dataArray);
      }
      _sceneFunc(context) {
        var ca = this.dataArray;
        context.beginPath();
        var isClosed = false;
        for (var n = 0; n < ca.length; n++) {
          var c = ca[n].command;
          var p = ca[n].points;
          switch (c) {
            case "L":
              context.lineTo(p[0], p[1]);
              break;
            case "M":
              context.moveTo(p[0], p[1]);
              break;
            case "C":
              context.bezierCurveTo(p[0], p[1], p[2], p[3], p[4], p[5]);
              break;
            case "Q":
              context.quadraticCurveTo(p[0], p[1], p[2], p[3]);
              break;
            case "A":
              var cx = p[0], cy = p[1], rx = p[2], ry = p[3], theta = p[4], dTheta = p[5], psi = p[6], fs = p[7];
              var r = rx > ry ? rx : ry;
              var scaleX = rx > ry ? 1 : rx / ry;
              var scaleY = rx > ry ? ry / rx : 1;
              context.translate(cx, cy);
              context.rotate(psi);
              context.scale(scaleX, scaleY);
              context.arc(0, 0, r, theta, theta + dTheta, 1 - fs);
              context.scale(1 / scaleX, 1 / scaleY);
              context.rotate(-psi);
              context.translate(-cx, -cy);
              break;
            case "z":
              isClosed = true;
              context.closePath();
              break;
          }
        }
        if (!isClosed && !this.hasFill()) {
          context.strokeShape(this);
        } else {
          context.fillStrokeShape(this);
        }
      }
      getSelfRect() {
        var points = [];
        this.dataArray.forEach(function(data) {
          if (data.command === "A") {
            var start = data.points[4];
            var dTheta = data.points[5];
            var end = data.points[4] + dTheta;
            var inc = Math.PI / 180;
            if (Math.abs(start - end) < inc) {
              inc = Math.abs(start - end);
            }
            if (dTheta < 0) {
              for (let t = start - inc; t > end; t -= inc) {
                const point = _Path.getPointOnEllipticalArc(data.points[0], data.points[1], data.points[2], data.points[3], t, 0);
                points.push(point.x, point.y);
              }
            } else {
              for (let t = start + inc; t < end; t += inc) {
                const point = _Path.getPointOnEllipticalArc(data.points[0], data.points[1], data.points[2], data.points[3], t, 0);
                points.push(point.x, point.y);
              }
            }
          } else if (data.command === "C") {
            for (let t = 0; t <= 1; t += 0.01) {
              const point = _Path.getPointOnCubicBezier(t, data.start.x, data.start.y, data.points[0], data.points[1], data.points[2], data.points[3], data.points[4], data.points[5]);
              points.push(point.x, point.y);
            }
          } else {
            points = points.concat(data.points);
          }
        });
        var minX = points[0];
        var maxX = points[0];
        var minY = points[1];
        var maxY = points[1];
        var x, y;
        for (var i = 0; i < points.length / 2; i++) {
          x = points[i * 2];
          y = points[i * 2 + 1];
          if (!isNaN(x)) {
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
          }
          if (!isNaN(y)) {
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
          }
        }
        return {
          x: minX,
          y: minY,
          width: maxX - minX,
          height: maxY - minY
        };
      }
      getLength() {
        return this.pathLength;
      }
      getPointAtLength(length) {
        return _Path.getPointAtLengthOfDataArray(length, this.dataArray);
      }
      static getLineLength(x1, y1, x2, y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
      }
      static getPathLength(dataArray) {
        let pathLength = 0;
        for (var i = 0; i < dataArray.length; ++i) {
          pathLength += dataArray[i].pathLength;
        }
        return pathLength;
      }
      static getPointAtLengthOfDataArray(length, dataArray) {
        var point, i = 0, ii = dataArray.length;
        if (!ii) {
          return null;
        }
        while (i < ii && length > dataArray[i].pathLength) {
          length -= dataArray[i].pathLength;
          ++i;
        }
        if (i === ii) {
          point = dataArray[i - 1].points.slice(-2);
          return {
            x: point[0],
            y: point[1]
          };
        }
        if (length < 0.01) {
          point = dataArray[i].points.slice(0, 2);
          return {
            x: point[0],
            y: point[1]
          };
        }
        var cp = dataArray[i];
        var p = cp.points;
        switch (cp.command) {
          case "L":
            return _Path.getPointOnLine(length, cp.start.x, cp.start.y, p[0], p[1]);
          case "C":
            return _Path.getPointOnCubicBezier((0, BezierFunctions_1.t2length)(length, _Path.getPathLength(dataArray), (i2) => {
              return (0, BezierFunctions_1.getCubicArcLength)([cp.start.x, p[0], p[2], p[4]], [cp.start.y, p[1], p[3], p[5]], i2);
            }), cp.start.x, cp.start.y, p[0], p[1], p[2], p[3], p[4], p[5]);
          case "Q":
            return _Path.getPointOnQuadraticBezier((0, BezierFunctions_1.t2length)(length, _Path.getPathLength(dataArray), (i2) => {
              return (0, BezierFunctions_1.getQuadraticArcLength)([cp.start.x, p[0], p[2]], [cp.start.y, p[1], p[3]], i2);
            }), cp.start.x, cp.start.y, p[0], p[1], p[2], p[3]);
          case "A":
            var cx = p[0], cy = p[1], rx = p[2], ry = p[3], theta = p[4], dTheta = p[5], psi = p[6];
            theta += dTheta * length / cp.pathLength;
            return _Path.getPointOnEllipticalArc(cx, cy, rx, ry, theta, psi);
        }
        return null;
      }
      static getPointOnLine(dist, P1x, P1y, P2x, P2y, fromX, fromY) {
        fromX = fromX !== null && fromX !== void 0 ? fromX : P1x;
        fromY = fromY !== null && fromY !== void 0 ? fromY : P1y;
        const len = this.getLineLength(P1x, P1y, P2x, P2y);
        if (len < 1e-10) {
          return { x: P1x, y: P1y };
        }
        if (P2x === P1x) {
          return { x: fromX, y: fromY + (P2y > P1y ? dist : -dist) };
        }
        const m = (P2y - P1y) / (P2x - P1x);
        const run = Math.sqrt(dist * dist / (1 + m * m)) * (P2x < P1x ? -1 : 1);
        const rise = m * run;
        if (Math.abs(fromY - P1y - m * (fromX - P1x)) < 1e-10) {
          return { x: fromX + run, y: fromY + rise };
        }
        const u = ((fromX - P1x) * (P2x - P1x) + (fromY - P1y) * (P2y - P1y)) / (len * len);
        const ix = P1x + u * (P2x - P1x);
        const iy = P1y + u * (P2y - P1y);
        const pRise = this.getLineLength(fromX, fromY, ix, iy);
        const pRun = Math.sqrt(dist * dist - pRise * pRise);
        const adjustedRun = Math.sqrt(pRun * pRun / (1 + m * m)) * (P2x < P1x ? -1 : 1);
        const adjustedRise = m * adjustedRun;
        return { x: ix + adjustedRun, y: iy + adjustedRise };
      }
      static getPointOnCubicBezier(pct, P1x, P1y, P2x, P2y, P3x, P3y, P4x, P4y) {
        function CB1(t) {
          return t * t * t;
        }
        function CB2(t) {
          return 3 * t * t * (1 - t);
        }
        function CB3(t) {
          return 3 * t * (1 - t) * (1 - t);
        }
        function CB4(t) {
          return (1 - t) * (1 - t) * (1 - t);
        }
        var x = P4x * CB1(pct) + P3x * CB2(pct) + P2x * CB3(pct) + P1x * CB4(pct);
        var y = P4y * CB1(pct) + P3y * CB2(pct) + P2y * CB3(pct) + P1y * CB4(pct);
        return {
          x,
          y
        };
      }
      static getPointOnQuadraticBezier(pct, P1x, P1y, P2x, P2y, P3x, P3y) {
        function QB1(t) {
          return t * t;
        }
        function QB2(t) {
          return 2 * t * (1 - t);
        }
        function QB3(t) {
          return (1 - t) * (1 - t);
        }
        var x = P3x * QB1(pct) + P2x * QB2(pct) + P1x * QB3(pct);
        var y = P3y * QB1(pct) + P2y * QB2(pct) + P1y * QB3(pct);
        return {
          x,
          y
        };
      }
      static getPointOnEllipticalArc(cx, cy, rx, ry, theta, psi) {
        var cosPsi = Math.cos(psi), sinPsi = Math.sin(psi);
        var pt = {
          x: rx * Math.cos(theta),
          y: ry * Math.sin(theta)
        };
        return {
          x: cx + (pt.x * cosPsi - pt.y * sinPsi),
          y: cy + (pt.x * sinPsi + pt.y * cosPsi)
        };
      }
      static parsePathData(data) {
        if (!data) {
          return [];
        }
        var cs = data;
        var cc = [
          "m",
          "M",
          "l",
          "L",
          "v",
          "V",
          "h",
          "H",
          "z",
          "Z",
          "c",
          "C",
          "q",
          "Q",
          "t",
          "T",
          "s",
          "S",
          "a",
          "A"
        ];
        cs = cs.replace(new RegExp(" ", "g"), ",");
        for (var n = 0; n < cc.length; n++) {
          cs = cs.replace(new RegExp(cc[n], "g"), "|" + cc[n]);
        }
        var arr = cs.split("|");
        var ca = [];
        var coords = [];
        var cpx = 0;
        var cpy = 0;
        var re = /([-+]?((\d+\.\d+)|((\d+)|(\.\d+)))(?:e[-+]?\d+)?)/gi;
        var match;
        for (n = 1; n < arr.length; n++) {
          var str = arr[n];
          var c = str.charAt(0);
          str = str.slice(1);
          coords.length = 0;
          while (match = re.exec(str)) {
            coords.push(match[0]);
          }
          var p = [];
          for (var j = 0, jlen = coords.length; j < jlen; j++) {
            if (coords[j] === "00") {
              p.push(0, 0);
              continue;
            }
            var parsed = parseFloat(coords[j]);
            if (!isNaN(parsed)) {
              p.push(parsed);
            } else {
              p.push(0);
            }
          }
          while (p.length > 0) {
            if (isNaN(p[0])) {
              break;
            }
            var cmd = "";
            var points = [];
            var startX = cpx, startY = cpy;
            var prevCmd, ctlPtx, ctlPty;
            var rx, ry, psi, fa, fs, x1, y1;
            switch (c) {
              case "l":
                cpx += p.shift();
                cpy += p.shift();
                cmd = "L";
                points.push(cpx, cpy);
                break;
              case "L":
                cpx = p.shift();
                cpy = p.shift();
                points.push(cpx, cpy);
                break;
              case "m":
                var dx = p.shift();
                var dy = p.shift();
                cpx += dx;
                cpy += dy;
                cmd = "M";
                if (ca.length > 2 && ca[ca.length - 1].command === "z") {
                  for (var idx = ca.length - 2; idx >= 0; idx--) {
                    if (ca[idx].command === "M") {
                      cpx = ca[idx].points[0] + dx;
                      cpy = ca[idx].points[1] + dy;
                      break;
                    }
                  }
                }
                points.push(cpx, cpy);
                c = "l";
                break;
              case "M":
                cpx = p.shift();
                cpy = p.shift();
                cmd = "M";
                points.push(cpx, cpy);
                c = "L";
                break;
              case "h":
                cpx += p.shift();
                cmd = "L";
                points.push(cpx, cpy);
                break;
              case "H":
                cpx = p.shift();
                cmd = "L";
                points.push(cpx, cpy);
                break;
              case "v":
                cpy += p.shift();
                cmd = "L";
                points.push(cpx, cpy);
                break;
              case "V":
                cpy = p.shift();
                cmd = "L";
                points.push(cpx, cpy);
                break;
              case "C":
                points.push(p.shift(), p.shift(), p.shift(), p.shift());
                cpx = p.shift();
                cpy = p.shift();
                points.push(cpx, cpy);
                break;
              case "c":
                points.push(cpx + p.shift(), cpy + p.shift(), cpx + p.shift(), cpy + p.shift());
                cpx += p.shift();
                cpy += p.shift();
                cmd = "C";
                points.push(cpx, cpy);
                break;
              case "S":
                ctlPtx = cpx;
                ctlPty = cpy;
                prevCmd = ca[ca.length - 1];
                if (prevCmd.command === "C") {
                  ctlPtx = cpx + (cpx - prevCmd.points[2]);
                  ctlPty = cpy + (cpy - prevCmd.points[3]);
                }
                points.push(ctlPtx, ctlPty, p.shift(), p.shift());
                cpx = p.shift();
                cpy = p.shift();
                cmd = "C";
                points.push(cpx, cpy);
                break;
              case "s":
                ctlPtx = cpx;
                ctlPty = cpy;
                prevCmd = ca[ca.length - 1];
                if (prevCmd.command === "C") {
                  ctlPtx = cpx + (cpx - prevCmd.points[2]);
                  ctlPty = cpy + (cpy - prevCmd.points[3]);
                }
                points.push(ctlPtx, ctlPty, cpx + p.shift(), cpy + p.shift());
                cpx += p.shift();
                cpy += p.shift();
                cmd = "C";
                points.push(cpx, cpy);
                break;
              case "Q":
                points.push(p.shift(), p.shift());
                cpx = p.shift();
                cpy = p.shift();
                points.push(cpx, cpy);
                break;
              case "q":
                points.push(cpx + p.shift(), cpy + p.shift());
                cpx += p.shift();
                cpy += p.shift();
                cmd = "Q";
                points.push(cpx, cpy);
                break;
              case "T":
                ctlPtx = cpx;
                ctlPty = cpy;
                prevCmd = ca[ca.length - 1];
                if (prevCmd.command === "Q") {
                  ctlPtx = cpx + (cpx - prevCmd.points[0]);
                  ctlPty = cpy + (cpy - prevCmd.points[1]);
                }
                cpx = p.shift();
                cpy = p.shift();
                cmd = "Q";
                points.push(ctlPtx, ctlPty, cpx, cpy);
                break;
              case "t":
                ctlPtx = cpx;
                ctlPty = cpy;
                prevCmd = ca[ca.length - 1];
                if (prevCmd.command === "Q") {
                  ctlPtx = cpx + (cpx - prevCmd.points[0]);
                  ctlPty = cpy + (cpy - prevCmd.points[1]);
                }
                cpx += p.shift();
                cpy += p.shift();
                cmd = "Q";
                points.push(ctlPtx, ctlPty, cpx, cpy);
                break;
              case "A":
                rx = p.shift();
                ry = p.shift();
                psi = p.shift();
                fa = p.shift();
                fs = p.shift();
                x1 = cpx;
                y1 = cpy;
                cpx = p.shift();
                cpy = p.shift();
                cmd = "A";
                points = this.convertEndpointToCenterParameterization(x1, y1, cpx, cpy, fa, fs, rx, ry, psi);
                break;
              case "a":
                rx = p.shift();
                ry = p.shift();
                psi = p.shift();
                fa = p.shift();
                fs = p.shift();
                x1 = cpx;
                y1 = cpy;
                cpx += p.shift();
                cpy += p.shift();
                cmd = "A";
                points = this.convertEndpointToCenterParameterization(x1, y1, cpx, cpy, fa, fs, rx, ry, psi);
                break;
            }
            ca.push({
              command: cmd || c,
              points,
              start: {
                x: startX,
                y: startY
              },
              pathLength: this.calcLength(startX, startY, cmd || c, points)
            });
          }
          if (c === "z" || c === "Z") {
            ca.push({
              command: "z",
              points: [],
              start: void 0,
              pathLength: 0
            });
          }
        }
        return ca;
      }
      static calcLength(x, y, cmd, points) {
        var len, p1, p2, t;
        var path = _Path;
        switch (cmd) {
          case "L":
            return path.getLineLength(x, y, points[0], points[1]);
          case "C":
            return (0, BezierFunctions_1.getCubicArcLength)([x, points[0], points[2], points[4]], [y, points[1], points[3], points[5]], 1);
          case "Q":
            return (0, BezierFunctions_1.getQuadraticArcLength)([x, points[0], points[2]], [y, points[1], points[3]], 1);
          case "A":
            len = 0;
            var start = points[4];
            var dTheta = points[5];
            var end = points[4] + dTheta;
            var inc = Math.PI / 180;
            if (Math.abs(start - end) < inc) {
              inc = Math.abs(start - end);
            }
            p1 = path.getPointOnEllipticalArc(points[0], points[1], points[2], points[3], start, 0);
            if (dTheta < 0) {
              for (t = start - inc; t > end; t -= inc) {
                p2 = path.getPointOnEllipticalArc(points[0], points[1], points[2], points[3], t, 0);
                len += path.getLineLength(p1.x, p1.y, p2.x, p2.y);
                p1 = p2;
              }
            } else {
              for (t = start + inc; t < end; t += inc) {
                p2 = path.getPointOnEllipticalArc(points[0], points[1], points[2], points[3], t, 0);
                len += path.getLineLength(p1.x, p1.y, p2.x, p2.y);
                p1 = p2;
              }
            }
            p2 = path.getPointOnEllipticalArc(points[0], points[1], points[2], points[3], end, 0);
            len += path.getLineLength(p1.x, p1.y, p2.x, p2.y);
            return len;
        }
        return 0;
      }
      static convertEndpointToCenterParameterization(x1, y1, x2, y2, fa, fs, rx, ry, psiDeg) {
        var psi = psiDeg * (Math.PI / 180);
        var xp = Math.cos(psi) * (x1 - x2) / 2 + Math.sin(psi) * (y1 - y2) / 2;
        var yp = -1 * Math.sin(psi) * (x1 - x2) / 2 + Math.cos(psi) * (y1 - y2) / 2;
        var lambda = xp * xp / (rx * rx) + yp * yp / (ry * ry);
        if (lambda > 1) {
          rx *= Math.sqrt(lambda);
          ry *= Math.sqrt(lambda);
        }
        var f = Math.sqrt((rx * rx * (ry * ry) - rx * rx * (yp * yp) - ry * ry * (xp * xp)) / (rx * rx * (yp * yp) + ry * ry * (xp * xp)));
        if (fa === fs) {
          f *= -1;
        }
        if (isNaN(f)) {
          f = 0;
        }
        var cxp = f * rx * yp / ry;
        var cyp = f * -ry * xp / rx;
        var cx = (x1 + x2) / 2 + Math.cos(psi) * cxp - Math.sin(psi) * cyp;
        var cy = (y1 + y2) / 2 + Math.sin(psi) * cxp + Math.cos(psi) * cyp;
        var vMag = function(v2) {
          return Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1]);
        };
        var vRatio = function(u2, v2) {
          return (u2[0] * v2[0] + u2[1] * v2[1]) / (vMag(u2) * vMag(v2));
        };
        var vAngle = function(u2, v2) {
          return (u2[0] * v2[1] < u2[1] * v2[0] ? -1 : 1) * Math.acos(vRatio(u2, v2));
        };
        var theta = vAngle([1, 0], [(xp - cxp) / rx, (yp - cyp) / ry]);
        var u = [(xp - cxp) / rx, (yp - cyp) / ry];
        var v = [(-1 * xp - cxp) / rx, (-1 * yp - cyp) / ry];
        var dTheta = vAngle(u, v);
        if (vRatio(u, v) <= -1) {
          dTheta = Math.PI;
        }
        if (vRatio(u, v) >= 1) {
          dTheta = 0;
        }
        if (fs === 0 && dTheta > 0) {
          dTheta = dTheta - 2 * Math.PI;
        }
        if (fs === 1 && dTheta < 0) {
          dTheta = dTheta + 2 * Math.PI;
        }
        return [cx, cy, rx, ry, theta, dTheta, psi, fs];
      }
    };
    exports.Path = Path;
    Path.prototype.className = "Path";
    Path.prototype._attrsAffectingSize = ["data"];
    (0, Global_1._registerNode)(Path);
    Factory_1.Factory.addGetterSetter(Path, "data");
  }
});

// node_modules/konva/lib/shapes/Arrow.js
var require_Arrow = __commonJS({
  "node_modules/konva/lib/shapes/Arrow.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Arrow = void 0;
    var Factory_1 = require_Factory();
    var Line_1 = require_Line();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var Path_1 = require_Path();
    var Arrow = class extends Line_1.Line {
      _sceneFunc(ctx) {
        super._sceneFunc(ctx);
        var PI2 = Math.PI * 2;
        var points = this.points();
        var tp = points;
        var fromTension = this.tension() !== 0 && points.length > 4;
        if (fromTension) {
          tp = this.getTensionPoints();
        }
        var length = this.pointerLength();
        var n = points.length;
        var dx, dy;
        if (fromTension) {
          const lp = [
            tp[tp.length - 4],
            tp[tp.length - 3],
            tp[tp.length - 2],
            tp[tp.length - 1],
            points[n - 2],
            points[n - 1]
          ];
          const lastLength = Path_1.Path.calcLength(tp[tp.length - 4], tp[tp.length - 3], "C", lp);
          const previous = Path_1.Path.getPointOnQuadraticBezier(Math.min(1, 1 - length / lastLength), lp[0], lp[1], lp[2], lp[3], lp[4], lp[5]);
          dx = points[n - 2] - previous.x;
          dy = points[n - 1] - previous.y;
        } else {
          dx = points[n - 2] - points[n - 4];
          dy = points[n - 1] - points[n - 3];
        }
        var radians = (Math.atan2(dy, dx) + PI2) % PI2;
        var width = this.pointerWidth();
        if (this.pointerAtEnding()) {
          ctx.save();
          ctx.beginPath();
          ctx.translate(points[n - 2], points[n - 1]);
          ctx.rotate(radians);
          ctx.moveTo(0, 0);
          ctx.lineTo(-length, width / 2);
          ctx.lineTo(-length, -width / 2);
          ctx.closePath();
          ctx.restore();
          this.__fillStroke(ctx);
        }
        if (this.pointerAtBeginning()) {
          ctx.save();
          ctx.beginPath();
          ctx.translate(points[0], points[1]);
          if (fromTension) {
            dx = (tp[0] + tp[2]) / 2 - points[0];
            dy = (tp[1] + tp[3]) / 2 - points[1];
          } else {
            dx = points[2] - points[0];
            dy = points[3] - points[1];
          }
          ctx.rotate((Math.atan2(-dy, -dx) + PI2) % PI2);
          ctx.moveTo(0, 0);
          ctx.lineTo(-length, width / 2);
          ctx.lineTo(-length, -width / 2);
          ctx.closePath();
          ctx.restore();
          this.__fillStroke(ctx);
        }
      }
      __fillStroke(ctx) {
        var isDashEnabled = this.dashEnabled();
        if (isDashEnabled) {
          this.attrs.dashEnabled = false;
          ctx.setLineDash([]);
        }
        ctx.fillStrokeShape(this);
        if (isDashEnabled) {
          this.attrs.dashEnabled = true;
        }
      }
      getSelfRect() {
        const lineRect = super.getSelfRect();
        const offset = this.pointerWidth() / 2;
        return {
          x: lineRect.x - offset,
          y: lineRect.y - offset,
          width: lineRect.width + offset * 2,
          height: lineRect.height + offset * 2
        };
      }
    };
    exports.Arrow = Arrow;
    Arrow.prototype.className = "Arrow";
    (0, Global_1._registerNode)(Arrow);
    Factory_1.Factory.addGetterSetter(Arrow, "pointerLength", 10, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Arrow, "pointerWidth", 10, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Arrow, "pointerAtBeginning", false);
    Factory_1.Factory.addGetterSetter(Arrow, "pointerAtEnding", true);
  }
});

// node_modules/konva/lib/shapes/Circle.js
var require_Circle = __commonJS({
  "node_modules/konva/lib/shapes/Circle.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Circle = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var Circle = class extends Shape_1.Shape {
      _sceneFunc(context) {
        context.beginPath();
        context.arc(0, 0, this.attrs.radius || 0, 0, Math.PI * 2, false);
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        return this.radius() * 2;
      }
      getHeight() {
        return this.radius() * 2;
      }
      setWidth(width) {
        if (this.radius() !== width / 2) {
          this.radius(width / 2);
        }
      }
      setHeight(height) {
        if (this.radius() !== height / 2) {
          this.radius(height / 2);
        }
      }
    };
    exports.Circle = Circle;
    Circle.prototype._centroid = true;
    Circle.prototype.className = "Circle";
    Circle.prototype._attrsAffectingSize = ["radius"];
    (0, Global_1._registerNode)(Circle);
    Factory_1.Factory.addGetterSetter(Circle, "radius", 0, (0, Validators_1.getNumberValidator)());
  }
});

// node_modules/konva/lib/shapes/Ellipse.js
var require_Ellipse = __commonJS({
  "node_modules/konva/lib/shapes/Ellipse.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Ellipse = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var Ellipse = class extends Shape_1.Shape {
      _sceneFunc(context) {
        var rx = this.radiusX(), ry = this.radiusY();
        context.beginPath();
        context.save();
        if (rx !== ry) {
          context.scale(1, ry / rx);
        }
        context.arc(0, 0, rx, 0, Math.PI * 2, false);
        context.restore();
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        return this.radiusX() * 2;
      }
      getHeight() {
        return this.radiusY() * 2;
      }
      setWidth(width) {
        this.radiusX(width / 2);
      }
      setHeight(height) {
        this.radiusY(height / 2);
      }
    };
    exports.Ellipse = Ellipse;
    Ellipse.prototype.className = "Ellipse";
    Ellipse.prototype._centroid = true;
    Ellipse.prototype._attrsAffectingSize = ["radiusX", "radiusY"];
    (0, Global_1._registerNode)(Ellipse);
    Factory_1.Factory.addComponentsGetterSetter(Ellipse, "radius", ["x", "y"]);
    Factory_1.Factory.addGetterSetter(Ellipse, "radiusX", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Ellipse, "radiusY", 0, (0, Validators_1.getNumberValidator)());
  }
});

// node_modules/konva/lib/shapes/Image.js
var require_Image = __commonJS({
  "node_modules/konva/lib/shapes/Image.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Image = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var Validators_1 = require_Validators();
    var Image = class _Image extends Shape_1.Shape {
      constructor(attrs) {
        super(attrs);
        this.on("imageChange.konva", () => {
          this._setImageLoad();
        });
        this._setImageLoad();
      }
      _setImageLoad() {
        const image = this.image();
        if (image && image.complete) {
          return;
        }
        if (image && image.readyState === 4) {
          return;
        }
        if (image && image["addEventListener"]) {
          image["addEventListener"]("load", () => {
            this._requestDraw();
          });
        }
      }
      _useBufferCanvas() {
        const hasCornerRadius = !!this.cornerRadius();
        const hasShadow = this.hasShadow();
        if (hasCornerRadius && hasShadow) {
          return true;
        }
        return super._useBufferCanvas(true);
      }
      _sceneFunc(context) {
        const width = this.getWidth();
        const height = this.getHeight();
        const cornerRadius = this.cornerRadius();
        const image = this.attrs.image;
        let params;
        if (image) {
          const cropWidth = this.attrs.cropWidth;
          const cropHeight = this.attrs.cropHeight;
          if (cropWidth && cropHeight) {
            params = [
              image,
              this.cropX(),
              this.cropY(),
              cropWidth,
              cropHeight,
              0,
              0,
              width,
              height
            ];
          } else {
            params = [image, 0, 0, width, height];
          }
        }
        if (this.hasFill() || this.hasStroke() || cornerRadius) {
          context.beginPath();
          cornerRadius ? Util_1.Util.drawRoundedRectPath(context, width, height, cornerRadius) : context.rect(0, 0, width, height);
          context.closePath();
          context.fillStrokeShape(this);
        }
        if (image) {
          if (cornerRadius) {
            context.clip();
          }
          context.drawImage.apply(context, params);
        }
      }
      _hitFunc(context) {
        var width = this.width(), height = this.height(), cornerRadius = this.cornerRadius();
        context.beginPath();
        if (!cornerRadius) {
          context.rect(0, 0, width, height);
        } else {
          Util_1.Util.drawRoundedRectPath(context, width, height, cornerRadius);
        }
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        var _a, _b;
        return (_a = this.attrs.width) !== null && _a !== void 0 ? _a : (_b = this.image()) === null || _b === void 0 ? void 0 : _b.width;
      }
      getHeight() {
        var _a, _b;
        return (_a = this.attrs.height) !== null && _a !== void 0 ? _a : (_b = this.image()) === null || _b === void 0 ? void 0 : _b.height;
      }
      static fromURL(url, callback, onError = null) {
        var img = Util_1.Util.createImageElement();
        img.onload = function() {
          var image = new _Image({
            image: img
          });
          callback(image);
        };
        img.onerror = onError;
        img.crossOrigin = "Anonymous";
        img.src = url;
      }
    };
    exports.Image = Image;
    Image.prototype.className = "Image";
    (0, Global_1._registerNode)(Image);
    Factory_1.Factory.addGetterSetter(Image, "cornerRadius", 0, (0, Validators_1.getNumberOrArrayOfNumbersValidator)(4));
    Factory_1.Factory.addGetterSetter(Image, "image");
    Factory_1.Factory.addComponentsGetterSetter(Image, "crop", ["x", "y", "width", "height"]);
    Factory_1.Factory.addGetterSetter(Image, "cropX", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Image, "cropY", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Image, "cropWidth", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Image, "cropHeight", 0, (0, Validators_1.getNumberValidator)());
  }
});

// node_modules/konva/lib/shapes/Label.js
var require_Label = __commonJS({
  "node_modules/konva/lib/shapes/Label.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Tag = exports.Label = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Group_1 = require_Group();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var ATTR_CHANGE_LIST = [
      "fontFamily",
      "fontSize",
      "fontStyle",
      "padding",
      "lineHeight",
      "text",
      "width",
      "height",
      "pointerDirection",
      "pointerWidth",
      "pointerHeight"
    ];
    var CHANGE_KONVA = "Change.konva";
    var NONE = "none";
    var UP = "up";
    var RIGHT = "right";
    var DOWN = "down";
    var LEFT = "left";
    var attrChangeListLen = ATTR_CHANGE_LIST.length;
    var Label = class extends Group_1.Group {
      constructor(config) {
        super(config);
        this.on("add.konva", function(evt) {
          this._addListeners(evt.child);
          this._sync();
        });
      }
      getText() {
        return this.find("Text")[0];
      }
      getTag() {
        return this.find("Tag")[0];
      }
      _addListeners(text) {
        var that = this, n;
        var func = function() {
          that._sync();
        };
        for (n = 0; n < attrChangeListLen; n++) {
          text.on(ATTR_CHANGE_LIST[n] + CHANGE_KONVA, func);
        }
      }
      getWidth() {
        return this.getText().width();
      }
      getHeight() {
        return this.getText().height();
      }
      _sync() {
        var text = this.getText(), tag = this.getTag(), width, height, pointerDirection, pointerWidth, x, y, pointerHeight;
        if (text && tag) {
          width = text.width();
          height = text.height();
          pointerDirection = tag.pointerDirection();
          pointerWidth = tag.pointerWidth();
          pointerHeight = tag.pointerHeight();
          x = 0;
          y = 0;
          switch (pointerDirection) {
            case UP:
              x = width / 2;
              y = -1 * pointerHeight;
              break;
            case RIGHT:
              x = width + pointerWidth;
              y = height / 2;
              break;
            case DOWN:
              x = width / 2;
              y = height + pointerHeight;
              break;
            case LEFT:
              x = -1 * pointerWidth;
              y = height / 2;
              break;
          }
          tag.setAttrs({
            x: -1 * x,
            y: -1 * y,
            width,
            height
          });
          text.setAttrs({
            x: -1 * x,
            y: -1 * y
          });
        }
      }
    };
    exports.Label = Label;
    Label.prototype.className = "Label";
    (0, Global_1._registerNode)(Label);
    var Tag = class extends Shape_1.Shape {
      _sceneFunc(context) {
        var width = this.width(), height = this.height(), pointerDirection = this.pointerDirection(), pointerWidth = this.pointerWidth(), pointerHeight = this.pointerHeight(), cornerRadius = this.cornerRadius();
        let topLeft = 0;
        let topRight = 0;
        let bottomLeft = 0;
        let bottomRight = 0;
        if (typeof cornerRadius === "number") {
          topLeft = topRight = bottomLeft = bottomRight = Math.min(cornerRadius, width / 2, height / 2);
        } else {
          topLeft = Math.min(cornerRadius[0] || 0, width / 2, height / 2);
          topRight = Math.min(cornerRadius[1] || 0, width / 2, height / 2);
          bottomRight = Math.min(cornerRadius[2] || 0, width / 2, height / 2);
          bottomLeft = Math.min(cornerRadius[3] || 0, width / 2, height / 2);
        }
        context.beginPath();
        context.moveTo(topLeft, 0);
        if (pointerDirection === UP) {
          context.lineTo((width - pointerWidth) / 2, 0);
          context.lineTo(width / 2, -1 * pointerHeight);
          context.lineTo((width + pointerWidth) / 2, 0);
        }
        context.lineTo(width - topRight, 0);
        context.arc(width - topRight, topRight, topRight, Math.PI * 3 / 2, 0, false);
        if (pointerDirection === RIGHT) {
          context.lineTo(width, (height - pointerHeight) / 2);
          context.lineTo(width + pointerWidth, height / 2);
          context.lineTo(width, (height + pointerHeight) / 2);
        }
        context.lineTo(width, height - bottomRight);
        context.arc(width - bottomRight, height - bottomRight, bottomRight, 0, Math.PI / 2, false);
        if (pointerDirection === DOWN) {
          context.lineTo((width + pointerWidth) / 2, height);
          context.lineTo(width / 2, height + pointerHeight);
          context.lineTo((width - pointerWidth) / 2, height);
        }
        context.lineTo(bottomLeft, height);
        context.arc(bottomLeft, height - bottomLeft, bottomLeft, Math.PI / 2, Math.PI, false);
        if (pointerDirection === LEFT) {
          context.lineTo(0, (height + pointerHeight) / 2);
          context.lineTo(-1 * pointerWidth, height / 2);
          context.lineTo(0, (height - pointerHeight) / 2);
        }
        context.lineTo(0, topLeft);
        context.arc(topLeft, topLeft, topLeft, Math.PI, Math.PI * 3 / 2, false);
        context.closePath();
        context.fillStrokeShape(this);
      }
      getSelfRect() {
        var x = 0, y = 0, pointerWidth = this.pointerWidth(), pointerHeight = this.pointerHeight(), direction = this.pointerDirection(), width = this.width(), height = this.height();
        if (direction === UP) {
          y -= pointerHeight;
          height += pointerHeight;
        } else if (direction === DOWN) {
          height += pointerHeight;
        } else if (direction === LEFT) {
          x -= pointerWidth * 1.5;
          width += pointerWidth;
        } else if (direction === RIGHT) {
          width += pointerWidth * 1.5;
        }
        return {
          x,
          y,
          width,
          height
        };
      }
    };
    exports.Tag = Tag;
    Tag.prototype.className = "Tag";
    (0, Global_1._registerNode)(Tag);
    Factory_1.Factory.addGetterSetter(Tag, "pointerDirection", NONE);
    Factory_1.Factory.addGetterSetter(Tag, "pointerWidth", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Tag, "pointerHeight", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Tag, "cornerRadius", 0, (0, Validators_1.getNumberOrArrayOfNumbersValidator)(4));
  }
});

// node_modules/konva/lib/shapes/RegularPolygon.js
var require_RegularPolygon = __commonJS({
  "node_modules/konva/lib/shapes/RegularPolygon.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RegularPolygon = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var RegularPolygon = class extends Shape_1.Shape {
      _sceneFunc(context) {
        const points = this._getPoints();
        context.beginPath();
        context.moveTo(points[0].x, points[0].y);
        for (var n = 1; n < points.length; n++) {
          context.lineTo(points[n].x, points[n].y);
        }
        context.closePath();
        context.fillStrokeShape(this);
      }
      _getPoints() {
        const sides = this.attrs.sides;
        const radius = this.attrs.radius || 0;
        const points = [];
        for (var n = 0; n < sides; n++) {
          points.push({
            x: radius * Math.sin(n * 2 * Math.PI / sides),
            y: -1 * radius * Math.cos(n * 2 * Math.PI / sides)
          });
        }
        return points;
      }
      getSelfRect() {
        const points = this._getPoints();
        var minX = points[0].x;
        var maxX = points[0].y;
        var minY = points[0].x;
        var maxY = points[0].y;
        points.forEach((point) => {
          minX = Math.min(minX, point.x);
          maxX = Math.max(maxX, point.x);
          minY = Math.min(minY, point.y);
          maxY = Math.max(maxY, point.y);
        });
        return {
          x: minX,
          y: minY,
          width: maxX - minX,
          height: maxY - minY
        };
      }
      getWidth() {
        return this.radius() * 2;
      }
      getHeight() {
        return this.radius() * 2;
      }
      setWidth(width) {
        this.radius(width / 2);
      }
      setHeight(height) {
        this.radius(height / 2);
      }
    };
    exports.RegularPolygon = RegularPolygon;
    RegularPolygon.prototype.className = "RegularPolygon";
    RegularPolygon.prototype._centroid = true;
    RegularPolygon.prototype._attrsAffectingSize = ["radius"];
    (0, Global_1._registerNode)(RegularPolygon);
    Factory_1.Factory.addGetterSetter(RegularPolygon, "radius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(RegularPolygon, "sides", 0, (0, Validators_1.getNumberValidator)());
  }
});

// node_modules/konva/lib/shapes/Sprite.js
var require_Sprite = __commonJS({
  "node_modules/konva/lib/shapes/Sprite.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Sprite = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Animation_1 = require_Animation();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var Sprite = class extends Shape_1.Shape {
      constructor(config) {
        super(config);
        this._updated = true;
        this.anim = new Animation_1.Animation(() => {
          var updated = this._updated;
          this._updated = false;
          return updated;
        });
        this.on("animationChange.konva", function() {
          this.frameIndex(0);
        });
        this.on("frameIndexChange.konva", function() {
          this._updated = true;
        });
        this.on("frameRateChange.konva", function() {
          if (!this.anim.isRunning()) {
            return;
          }
          clearInterval(this.interval);
          this._setInterval();
        });
      }
      _sceneFunc(context) {
        var anim = this.animation(), index = this.frameIndex(), ix4 = index * 4, set = this.animations()[anim], offsets = this.frameOffsets(), x = set[ix4 + 0], y = set[ix4 + 1], width = set[ix4 + 2], height = set[ix4 + 3], image = this.image();
        if (this.hasFill() || this.hasStroke()) {
          context.beginPath();
          context.rect(0, 0, width, height);
          context.closePath();
          context.fillStrokeShape(this);
        }
        if (image) {
          if (offsets) {
            var offset = offsets[anim], ix2 = index * 2;
            context.drawImage(image, x, y, width, height, offset[ix2 + 0], offset[ix2 + 1], width, height);
          } else {
            context.drawImage(image, x, y, width, height, 0, 0, width, height);
          }
        }
      }
      _hitFunc(context) {
        var anim = this.animation(), index = this.frameIndex(), ix4 = index * 4, set = this.animations()[anim], offsets = this.frameOffsets(), width = set[ix4 + 2], height = set[ix4 + 3];
        context.beginPath();
        if (offsets) {
          var offset = offsets[anim];
          var ix2 = index * 2;
          context.rect(offset[ix2 + 0], offset[ix2 + 1], width, height);
        } else {
          context.rect(0, 0, width, height);
        }
        context.closePath();
        context.fillShape(this);
      }
      _useBufferCanvas() {
        return super._useBufferCanvas(true);
      }
      _setInterval() {
        var that = this;
        this.interval = setInterval(function() {
          that._updateIndex();
        }, 1e3 / this.frameRate());
      }
      start() {
        if (this.isRunning()) {
          return;
        }
        var layer = this.getLayer();
        this.anim.setLayers(layer);
        this._setInterval();
        this.anim.start();
      }
      stop() {
        this.anim.stop();
        clearInterval(this.interval);
      }
      isRunning() {
        return this.anim.isRunning();
      }
      _updateIndex() {
        var index = this.frameIndex(), animation = this.animation(), animations = this.animations(), anim = animations[animation], len = anim.length / 4;
        if (index < len - 1) {
          this.frameIndex(index + 1);
        } else {
          this.frameIndex(0);
        }
      }
    };
    exports.Sprite = Sprite;
    Sprite.prototype.className = "Sprite";
    (0, Global_1._registerNode)(Sprite);
    Factory_1.Factory.addGetterSetter(Sprite, "animation");
    Factory_1.Factory.addGetterSetter(Sprite, "animations");
    Factory_1.Factory.addGetterSetter(Sprite, "frameOffsets");
    Factory_1.Factory.addGetterSetter(Sprite, "image");
    Factory_1.Factory.addGetterSetter(Sprite, "frameIndex", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Sprite, "frameRate", 17, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.backCompat(Sprite, {
      index: "frameIndex",
      getIndex: "getFrameIndex",
      setIndex: "setFrameIndex"
    });
  }
});

// node_modules/konva/lib/shapes/Star.js
var require_Star = __commonJS({
  "node_modules/konva/lib/shapes/Star.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Star = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var Star = class extends Shape_1.Shape {
      _sceneFunc(context) {
        var innerRadius = this.innerRadius(), outerRadius = this.outerRadius(), numPoints = this.numPoints();
        context.beginPath();
        context.moveTo(0, 0 - outerRadius);
        for (var n = 1; n < numPoints * 2; n++) {
          var radius = n % 2 === 0 ? outerRadius : innerRadius;
          var x = radius * Math.sin(n * Math.PI / numPoints);
          var y = -1 * radius * Math.cos(n * Math.PI / numPoints);
          context.lineTo(x, y);
        }
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        return this.outerRadius() * 2;
      }
      getHeight() {
        return this.outerRadius() * 2;
      }
      setWidth(width) {
        this.outerRadius(width / 2);
      }
      setHeight(height) {
        this.outerRadius(height / 2);
      }
    };
    exports.Star = Star;
    Star.prototype.className = "Star";
    Star.prototype._centroid = true;
    Star.prototype._attrsAffectingSize = ["innerRadius", "outerRadius"];
    (0, Global_1._registerNode)(Star);
    Factory_1.Factory.addGetterSetter(Star, "numPoints", 5, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Star, "innerRadius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Star, "outerRadius", 0, (0, Validators_1.getNumberValidator)());
  }
});

// node_modules/konva/lib/shapes/Text.js
var require_Text = __commonJS({
  "node_modules/konva/lib/shapes/Text.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Text = exports.stringToArray = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var Validators_1 = require_Validators();
    var Global_2 = require_Global();
    function stringToArray(string) {
      return Array.from(string);
    }
    exports.stringToArray = stringToArray;
    var AUTO = "auto";
    var CENTER = "center";
    var INHERIT = "inherit";
    var JUSTIFY = "justify";
    var CHANGE_KONVA = "Change.konva";
    var CONTEXT_2D = "2d";
    var DASH = "-";
    var LEFT = "left";
    var TEXT = "text";
    var TEXT_UPPER = "Text";
    var TOP = "top";
    var BOTTOM = "bottom";
    var MIDDLE = "middle";
    var NORMAL = "normal";
    var PX_SPACE = "px ";
    var SPACE = " ";
    var RIGHT = "right";
    var RTL = "rtl";
    var WORD = "word";
    var CHAR = "char";
    var NONE = "none";
    var ELLIPSIS = "…";
    var ATTR_CHANGE_LIST = [
      "direction",
      "fontFamily",
      "fontSize",
      "fontStyle",
      "fontVariant",
      "padding",
      "align",
      "verticalAlign",
      "lineHeight",
      "text",
      "width",
      "height",
      "wrap",
      "ellipsis",
      "letterSpacing"
    ];
    var attrChangeListLen = ATTR_CHANGE_LIST.length;
    function normalizeFontFamily(fontFamily) {
      return fontFamily.split(",").map((family) => {
        family = family.trim();
        const hasSpace = family.indexOf(" ") >= 0;
        const hasQuotes = family.indexOf('"') >= 0 || family.indexOf("'") >= 0;
        if (hasSpace && !hasQuotes) {
          family = `"${family}"`;
        }
        return family;
      }).join(", ");
    }
    var dummyContext;
    function getDummyContext() {
      if (dummyContext) {
        return dummyContext;
      }
      dummyContext = Util_1.Util.createCanvasElement().getContext(CONTEXT_2D);
      return dummyContext;
    }
    function _fillFunc(context) {
      context.fillText(this._partialText, this._partialTextX, this._partialTextY);
    }
    function _strokeFunc(context) {
      context.setAttr("miterLimit", 2);
      context.strokeText(this._partialText, this._partialTextX, this._partialTextY);
    }
    function checkDefaultFill(config) {
      config = config || {};
      if (!config.fillLinearGradientColorStops && !config.fillRadialGradientColorStops && !config.fillPatternImage) {
        config.fill = config.fill || "black";
      }
      return config;
    }
    var Text = class extends Shape_1.Shape {
      constructor(config) {
        super(checkDefaultFill(config));
        this._partialTextX = 0;
        this._partialTextY = 0;
        for (var n = 0; n < attrChangeListLen; n++) {
          this.on(ATTR_CHANGE_LIST[n] + CHANGE_KONVA, this._setTextData);
        }
        this._setTextData();
      }
      _sceneFunc(context) {
        var textArr = this.textArr, textArrLen = textArr.length;
        if (!this.text()) {
          return;
        }
        var padding = this.padding(), fontSize = this.fontSize(), lineHeightPx = this.lineHeight() * fontSize, verticalAlign = this.verticalAlign(), direction = this.direction(), alignY = 0, align = this.align(), totalWidth = this.getWidth(), letterSpacing = this.letterSpacing(), fill = this.fill(), textDecoration = this.textDecoration(), shouldUnderline = textDecoration.indexOf("underline") !== -1, shouldLineThrough = textDecoration.indexOf("line-through") !== -1, n;
        direction = direction === INHERIT ? context.direction : direction;
        var translateY = lineHeightPx / 2;
        var baseline = MIDDLE;
        if (Global_1.Konva._fixTextRendering) {
          var metrics = this.measureSize("M");
          baseline = "alphabetic";
          translateY = (metrics.fontBoundingBoxAscent - metrics.fontBoundingBoxDescent) / 2 + lineHeightPx / 2;
        }
        var lineTranslateX = 0;
        var lineTranslateY = 0;
        if (direction === RTL) {
          context.setAttr("direction", direction);
        }
        context.setAttr("font", this._getContextFont());
        context.setAttr("textBaseline", baseline);
        context.setAttr("textAlign", LEFT);
        if (verticalAlign === MIDDLE) {
          alignY = (this.getHeight() - textArrLen * lineHeightPx - padding * 2) / 2;
        } else if (verticalAlign === BOTTOM) {
          alignY = this.getHeight() - textArrLen * lineHeightPx - padding * 2;
        }
        context.translate(padding, alignY + padding);
        for (n = 0; n < textArrLen; n++) {
          var lineTranslateX = 0;
          var lineTranslateY = 0;
          var obj = textArr[n], text = obj.text, width = obj.width, lastLine = obj.lastInParagraph, spacesNumber, oneWord, lineWidth;
          context.save();
          if (align === RIGHT) {
            lineTranslateX += totalWidth - width - padding * 2;
          } else if (align === CENTER) {
            lineTranslateX += (totalWidth - width - padding * 2) / 2;
          }
          if (shouldUnderline) {
            context.save();
            context.beginPath();
            let yOffset = Global_1.Konva._fixTextRendering ? Math.round(fontSize / 4) : Math.round(fontSize / 2);
            const x = lineTranslateX;
            const y = translateY + lineTranslateY + yOffset;
            context.moveTo(x, y);
            spacesNumber = text.split(" ").length - 1;
            oneWord = spacesNumber === 0;
            lineWidth = align === JUSTIFY && !lastLine ? totalWidth - padding * 2 : width;
            context.lineTo(x + Math.round(lineWidth), y);
            context.lineWidth = fontSize / 15;
            const gradient = this._getLinearGradient();
            context.strokeStyle = gradient || fill;
            context.stroke();
            context.restore();
          }
          if (shouldLineThrough) {
            context.save();
            context.beginPath();
            let yOffset = Global_1.Konva._fixTextRendering ? -Math.round(fontSize / 4) : 0;
            context.moveTo(lineTranslateX, translateY + lineTranslateY + yOffset);
            spacesNumber = text.split(" ").length - 1;
            oneWord = spacesNumber === 0;
            lineWidth = align === JUSTIFY && lastLine && !oneWord ? totalWidth - padding * 2 : width;
            context.lineTo(lineTranslateX + Math.round(lineWidth), translateY + lineTranslateY + yOffset);
            context.lineWidth = fontSize / 15;
            const gradient = this._getLinearGradient();
            context.strokeStyle = gradient || fill;
            context.stroke();
            context.restore();
          }
          if (direction !== RTL && (letterSpacing !== 0 || align === JUSTIFY)) {
            spacesNumber = text.split(" ").length - 1;
            var array = stringToArray(text);
            for (var li = 0; li < array.length; li++) {
              var letter = array[li];
              if (letter === " " && !lastLine && align === JUSTIFY) {
                lineTranslateX += (totalWidth - padding * 2 - width) / spacesNumber;
              }
              this._partialTextX = lineTranslateX;
              this._partialTextY = translateY + lineTranslateY;
              this._partialText = letter;
              context.fillStrokeShape(this);
              lineTranslateX += this.measureSize(letter).width + letterSpacing;
            }
          } else {
            if (letterSpacing !== 0) {
              context.setAttr("letterSpacing", `${letterSpacing}px`);
            }
            this._partialTextX = lineTranslateX;
            this._partialTextY = translateY + lineTranslateY;
            this._partialText = text;
            context.fillStrokeShape(this);
          }
          context.restore();
          if (textArrLen > 1) {
            translateY += lineHeightPx;
          }
        }
      }
      _hitFunc(context) {
        var width = this.getWidth(), height = this.getHeight();
        context.beginPath();
        context.rect(0, 0, width, height);
        context.closePath();
        context.fillStrokeShape(this);
      }
      setText(text) {
        var str = Util_1.Util._isString(text) ? text : text === null || text === void 0 ? "" : text + "";
        this._setAttr(TEXT, str);
        return this;
      }
      getWidth() {
        var isAuto = this.attrs.width === AUTO || this.attrs.width === void 0;
        return isAuto ? this.getTextWidth() + this.padding() * 2 : this.attrs.width;
      }
      getHeight() {
        var isAuto = this.attrs.height === AUTO || this.attrs.height === void 0;
        return isAuto ? this.fontSize() * this.textArr.length * this.lineHeight() + this.padding() * 2 : this.attrs.height;
      }
      getTextWidth() {
        return this.textWidth;
      }
      getTextHeight() {
        Util_1.Util.warn("text.getTextHeight() method is deprecated. Use text.height() - for full height and text.fontSize() - for one line height.");
        return this.textHeight;
      }
      measureSize(text) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
        var _context = getDummyContext(), fontSize = this.fontSize(), metrics;
        _context.save();
        _context.font = this._getContextFont();
        metrics = _context.measureText(text);
        _context.restore();
        const scaleFactor = fontSize / 100;
        return {
          actualBoundingBoxAscent: (_a = metrics.actualBoundingBoxAscent) !== null && _a !== void 0 ? _a : 71.58203125 * scaleFactor,
          actualBoundingBoxDescent: (_b = metrics.actualBoundingBoxDescent) !== null && _b !== void 0 ? _b : 0,
          actualBoundingBoxLeft: (_c = metrics.actualBoundingBoxLeft) !== null && _c !== void 0 ? _c : -7.421875 * scaleFactor,
          actualBoundingBoxRight: (_d = metrics.actualBoundingBoxRight) !== null && _d !== void 0 ? _d : 75.732421875 * scaleFactor,
          alphabeticBaseline: (_e = metrics.alphabeticBaseline) !== null && _e !== void 0 ? _e : 0,
          emHeightAscent: (_f = metrics.emHeightAscent) !== null && _f !== void 0 ? _f : 100 * scaleFactor,
          emHeightDescent: (_g = metrics.emHeightDescent) !== null && _g !== void 0 ? _g : -20 * scaleFactor,
          fontBoundingBoxAscent: (_h = metrics.fontBoundingBoxAscent) !== null && _h !== void 0 ? _h : 91 * scaleFactor,
          fontBoundingBoxDescent: (_j = metrics.fontBoundingBoxDescent) !== null && _j !== void 0 ? _j : 21 * scaleFactor,
          hangingBaseline: (_k = metrics.hangingBaseline) !== null && _k !== void 0 ? _k : 72.80000305175781 * scaleFactor,
          ideographicBaseline: (_l = metrics.ideographicBaseline) !== null && _l !== void 0 ? _l : -21 * scaleFactor,
          width: metrics.width,
          height: fontSize
        };
      }
      _getContextFont() {
        return this.fontStyle() + SPACE + this.fontVariant() + SPACE + (this.fontSize() + PX_SPACE) + normalizeFontFamily(this.fontFamily());
      }
      _addTextLine(line) {
        const align = this.align();
        if (align === JUSTIFY) {
          line = line.trim();
        }
        var width = this._getTextWidth(line);
        return this.textArr.push({
          text: line,
          width,
          lastInParagraph: false
        });
      }
      _getTextWidth(text) {
        var letterSpacing = this.letterSpacing();
        var length = text.length;
        return getDummyContext().measureText(text).width + (length ? letterSpacing * (length - 1) : 0);
      }
      _setTextData() {
        var lines = this.text().split("\n"), fontSize = +this.fontSize(), textWidth = 0, lineHeightPx = this.lineHeight() * fontSize, width = this.attrs.width, height = this.attrs.height, fixedWidth = width !== AUTO && width !== void 0, fixedHeight = height !== AUTO && height !== void 0, padding = this.padding(), maxWidth = width - padding * 2, maxHeightPx = height - padding * 2, currentHeightPx = 0, wrap = this.wrap(), shouldWrap = wrap !== NONE, wrapAtWord = wrap !== CHAR && shouldWrap, shouldAddEllipsis = this.ellipsis();
        this.textArr = [];
        getDummyContext().font = this._getContextFont();
        var additionalWidth = shouldAddEllipsis ? this._getTextWidth(ELLIPSIS) : 0;
        for (var i = 0, max = lines.length; i < max; ++i) {
          var line = lines[i];
          var lineWidth = this._getTextWidth(line);
          if (fixedWidth && lineWidth > maxWidth) {
            while (line.length > 0) {
              var low = 0, high = line.length, match = "", matchWidth = 0;
              while (low < high) {
                var mid = low + high >>> 1, substr = line.slice(0, mid + 1), substrWidth = this._getTextWidth(substr) + additionalWidth;
                if (substrWidth <= maxWidth) {
                  low = mid + 1;
                  match = substr;
                  matchWidth = substrWidth;
                } else {
                  high = mid;
                }
              }
              if (match) {
                if (wrapAtWord) {
                  var wrapIndex;
                  var nextChar = line[match.length];
                  var nextIsSpaceOrDash = nextChar === SPACE || nextChar === DASH;
                  if (nextIsSpaceOrDash && matchWidth <= maxWidth) {
                    wrapIndex = match.length;
                  } else {
                    wrapIndex = Math.max(match.lastIndexOf(SPACE), match.lastIndexOf(DASH)) + 1;
                  }
                  if (wrapIndex > 0) {
                    low = wrapIndex;
                    match = match.slice(0, low);
                    matchWidth = this._getTextWidth(match);
                  }
                }
                match = match.trimRight();
                this._addTextLine(match);
                textWidth = Math.max(textWidth, matchWidth);
                currentHeightPx += lineHeightPx;
                var shouldHandleEllipsis = this._shouldHandleEllipsis(currentHeightPx);
                if (shouldHandleEllipsis) {
                  this._tryToAddEllipsisToLastLine();
                  break;
                }
                line = line.slice(low);
                line = line.trimLeft();
                if (line.length > 0) {
                  lineWidth = this._getTextWidth(line);
                  if (lineWidth <= maxWidth) {
                    this._addTextLine(line);
                    currentHeightPx += lineHeightPx;
                    textWidth = Math.max(textWidth, lineWidth);
                    break;
                  }
                }
              } else {
                break;
              }
            }
          } else {
            this._addTextLine(line);
            currentHeightPx += lineHeightPx;
            textWidth = Math.max(textWidth, lineWidth);
            if (this._shouldHandleEllipsis(currentHeightPx) && i < max - 1) {
              this._tryToAddEllipsisToLastLine();
            }
          }
          if (this.textArr[this.textArr.length - 1]) {
            this.textArr[this.textArr.length - 1].lastInParagraph = true;
          }
          if (fixedHeight && currentHeightPx + lineHeightPx > maxHeightPx) {
            break;
          }
        }
        this.textHeight = fontSize;
        this.textWidth = textWidth;
      }
      _shouldHandleEllipsis(currentHeightPx) {
        var fontSize = +this.fontSize(), lineHeightPx = this.lineHeight() * fontSize, height = this.attrs.height, fixedHeight = height !== AUTO && height !== void 0, padding = this.padding(), maxHeightPx = height - padding * 2, wrap = this.wrap(), shouldWrap = wrap !== NONE;
        return !shouldWrap || fixedHeight && currentHeightPx + lineHeightPx > maxHeightPx;
      }
      _tryToAddEllipsisToLastLine() {
        var width = this.attrs.width, fixedWidth = width !== AUTO && width !== void 0, padding = this.padding(), maxWidth = width - padding * 2, shouldAddEllipsis = this.ellipsis();
        var lastLine = this.textArr[this.textArr.length - 1];
        if (!lastLine || !shouldAddEllipsis) {
          return;
        }
        if (fixedWidth) {
          var haveSpace = this._getTextWidth(lastLine.text + ELLIPSIS) < maxWidth;
          if (!haveSpace) {
            lastLine.text = lastLine.text.slice(0, lastLine.text.length - 3);
          }
        }
        this.textArr.splice(this.textArr.length - 1, 1);
        this._addTextLine(lastLine.text + ELLIPSIS);
      }
      getStrokeScaleEnabled() {
        return true;
      }
      _useBufferCanvas() {
        const hasLine = this.textDecoration().indexOf("underline") !== -1 || this.textDecoration().indexOf("line-through") !== -1;
        const hasShadow = this.hasShadow();
        if (hasLine && hasShadow) {
          return true;
        }
        return super._useBufferCanvas();
      }
    };
    exports.Text = Text;
    Text.prototype._fillFunc = _fillFunc;
    Text.prototype._strokeFunc = _strokeFunc;
    Text.prototype.className = TEXT_UPPER;
    Text.prototype._attrsAffectingSize = [
      "text",
      "fontSize",
      "padding",
      "wrap",
      "lineHeight",
      "letterSpacing"
    ];
    (0, Global_2._registerNode)(Text);
    Factory_1.Factory.overWriteSetter(Text, "width", (0, Validators_1.getNumberOrAutoValidator)());
    Factory_1.Factory.overWriteSetter(Text, "height", (0, Validators_1.getNumberOrAutoValidator)());
    Factory_1.Factory.addGetterSetter(Text, "direction", INHERIT);
    Factory_1.Factory.addGetterSetter(Text, "fontFamily", "Arial");
    Factory_1.Factory.addGetterSetter(Text, "fontSize", 12, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Text, "fontStyle", NORMAL);
    Factory_1.Factory.addGetterSetter(Text, "fontVariant", NORMAL);
    Factory_1.Factory.addGetterSetter(Text, "padding", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Text, "align", LEFT);
    Factory_1.Factory.addGetterSetter(Text, "verticalAlign", TOP);
    Factory_1.Factory.addGetterSetter(Text, "lineHeight", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Text, "wrap", WORD);
    Factory_1.Factory.addGetterSetter(Text, "ellipsis", false, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.addGetterSetter(Text, "letterSpacing", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Text, "text", "", (0, Validators_1.getStringValidator)());
    Factory_1.Factory.addGetterSetter(Text, "textDecoration", "");
  }
});

// node_modules/konva/lib/shapes/TextPath.js
var require_TextPath = __commonJS({
  "node_modules/konva/lib/shapes/TextPath.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TextPath = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Path_1 = require_Path();
    var Text_1 = require_Text();
    var Validators_1 = require_Validators();
    var Global_1 = require_Global();
    var EMPTY_STRING = "";
    var NORMAL = "normal";
    function _fillFunc(context) {
      context.fillText(this.partialText, 0, 0);
    }
    function _strokeFunc(context) {
      context.strokeText(this.partialText, 0, 0);
    }
    var TextPath = class extends Shape_1.Shape {
      constructor(config) {
        super(config);
        this.dummyCanvas = Util_1.Util.createCanvasElement();
        this.dataArray = [];
        this._readDataAttribute();
        this.on("dataChange.konva", function() {
          this._readDataAttribute();
          this._setTextData();
        });
        this.on("textChange.konva alignChange.konva letterSpacingChange.konva kerningFuncChange.konva fontSizeChange.konva fontFamilyChange.konva", this._setTextData);
        this._setTextData();
      }
      _getTextPathLength() {
        return Path_1.Path.getPathLength(this.dataArray);
      }
      _getPointAtLength(length) {
        if (!this.attrs.data) {
          return null;
        }
        const totalLength = this.pathLength;
        if (length - 1 > totalLength) {
          return null;
        }
        return Path_1.Path.getPointAtLengthOfDataArray(length, this.dataArray);
      }
      _readDataAttribute() {
        this.dataArray = Path_1.Path.parsePathData(this.attrs.data);
        this.pathLength = this._getTextPathLength();
      }
      _sceneFunc(context) {
        context.setAttr("font", this._getContextFont());
        context.setAttr("textBaseline", this.textBaseline());
        context.setAttr("textAlign", "left");
        context.save();
        var textDecoration = this.textDecoration();
        var fill = this.fill();
        var fontSize = this.fontSize();
        var glyphInfo = this.glyphInfo;
        if (textDecoration === "underline") {
          context.beginPath();
        }
        for (var i = 0; i < glyphInfo.length; i++) {
          context.save();
          var p0 = glyphInfo[i].p0;
          context.translate(p0.x, p0.y);
          context.rotate(glyphInfo[i].rotation);
          this.partialText = glyphInfo[i].text;
          context.fillStrokeShape(this);
          if (textDecoration === "underline") {
            if (i === 0) {
              context.moveTo(0, fontSize / 2 + 1);
            }
            context.lineTo(fontSize, fontSize / 2 + 1);
          }
          context.restore();
        }
        if (textDecoration === "underline") {
          context.strokeStyle = fill;
          context.lineWidth = fontSize / 20;
          context.stroke();
        }
        context.restore();
      }
      _hitFunc(context) {
        context.beginPath();
        var glyphInfo = this.glyphInfo;
        if (glyphInfo.length >= 1) {
          var p0 = glyphInfo[0].p0;
          context.moveTo(p0.x, p0.y);
        }
        for (var i = 0; i < glyphInfo.length; i++) {
          var p1 = glyphInfo[i].p1;
          context.lineTo(p1.x, p1.y);
        }
        context.setAttr("lineWidth", this.fontSize());
        context.setAttr("strokeStyle", this.colorKey);
        context.stroke();
      }
      getTextWidth() {
        return this.textWidth;
      }
      getTextHeight() {
        Util_1.Util.warn("text.getTextHeight() method is deprecated. Use text.height() - for full height and text.fontSize() - for one line height.");
        return this.textHeight;
      }
      setText(text) {
        return Text_1.Text.prototype.setText.call(this, text);
      }
      _getContextFont() {
        return Text_1.Text.prototype._getContextFont.call(this);
      }
      _getTextSize(text) {
        var dummyCanvas = this.dummyCanvas;
        var _context = dummyCanvas.getContext("2d");
        _context.save();
        _context.font = this._getContextFont();
        var metrics = _context.measureText(text);
        _context.restore();
        return {
          width: metrics.width,
          height: parseInt(`${this.fontSize()}`, 10)
        };
      }
      _setTextData() {
        const { width, height } = this._getTextSize(this.attrs.text);
        this.textWidth = width;
        this.textHeight = height;
        this.glyphInfo = [];
        if (!this.attrs.data) {
          return null;
        }
        const letterSpacing = this.letterSpacing();
        const align = this.align();
        const kerningFunc = this.kerningFunc();
        const textWidth = Math.max(this.textWidth + ((this.attrs.text || "").length - 1) * letterSpacing, 0);
        let offset = 0;
        if (align === "center") {
          offset = Math.max(0, this.pathLength / 2 - textWidth / 2);
        }
        if (align === "right") {
          offset = Math.max(0, this.pathLength - textWidth);
        }
        const charArr = (0, Text_1.stringToArray)(this.text());
        let offsetToGlyph = offset;
        for (var i = 0; i < charArr.length; i++) {
          const charStartPoint = this._getPointAtLength(offsetToGlyph);
          if (!charStartPoint)
            return;
          let glyphWidth = this._getTextSize(charArr[i]).width + letterSpacing;
          if (charArr[i] === " " && align === "justify") {
            const numberOfSpaces = this.text().split(" ").length - 1;
            glyphWidth += (this.pathLength - textWidth) / numberOfSpaces;
          }
          const charEndPoint = this._getPointAtLength(offsetToGlyph + glyphWidth);
          if (!charEndPoint)
            return;
          const width2 = Path_1.Path.getLineLength(charStartPoint.x, charStartPoint.y, charEndPoint.x, charEndPoint.y);
          let kern = 0;
          if (kerningFunc) {
            try {
              kern = kerningFunc(charArr[i - 1], charArr[i]) * this.fontSize();
            } catch (e) {
              kern = 0;
            }
          }
          charStartPoint.x += kern;
          charEndPoint.x += kern;
          this.textWidth += kern;
          const midpoint = Path_1.Path.getPointOnLine(kern + width2 / 2, charStartPoint.x, charStartPoint.y, charEndPoint.x, charEndPoint.y);
          const rotation = Math.atan2(charEndPoint.y - charStartPoint.y, charEndPoint.x - charStartPoint.x);
          this.glyphInfo.push({
            transposeX: midpoint.x,
            transposeY: midpoint.y,
            text: charArr[i],
            rotation,
            p0: charStartPoint,
            p1: charEndPoint
          });
          offsetToGlyph += glyphWidth;
        }
      }
      getSelfRect() {
        if (!this.glyphInfo.length) {
          return {
            x: 0,
            y: 0,
            width: 0,
            height: 0
          };
        }
        var points = [];
        this.glyphInfo.forEach(function(info) {
          points.push(info.p0.x);
          points.push(info.p0.y);
          points.push(info.p1.x);
          points.push(info.p1.y);
        });
        var minX = points[0] || 0;
        var maxX = points[0] || 0;
        var minY = points[1] || 0;
        var maxY = points[1] || 0;
        var x, y;
        for (var i = 0; i < points.length / 2; i++) {
          x = points[i * 2];
          y = points[i * 2 + 1];
          minX = Math.min(minX, x);
          maxX = Math.max(maxX, x);
          minY = Math.min(minY, y);
          maxY = Math.max(maxY, y);
        }
        var fontSize = this.fontSize();
        return {
          x: minX - fontSize / 2,
          y: minY - fontSize / 2,
          width: maxX - minX + fontSize,
          height: maxY - minY + fontSize
        };
      }
      destroy() {
        Util_1.Util.releaseCanvas(this.dummyCanvas);
        return super.destroy();
      }
    };
    exports.TextPath = TextPath;
    TextPath.prototype._fillFunc = _fillFunc;
    TextPath.prototype._strokeFunc = _strokeFunc;
    TextPath.prototype._fillFuncHit = _fillFunc;
    TextPath.prototype._strokeFuncHit = _strokeFunc;
    TextPath.prototype.className = "TextPath";
    TextPath.prototype._attrsAffectingSize = ["text", "fontSize", "data"];
    (0, Global_1._registerNode)(TextPath);
    Factory_1.Factory.addGetterSetter(TextPath, "data");
    Factory_1.Factory.addGetterSetter(TextPath, "fontFamily", "Arial");
    Factory_1.Factory.addGetterSetter(TextPath, "fontSize", 12, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(TextPath, "fontStyle", NORMAL);
    Factory_1.Factory.addGetterSetter(TextPath, "align", "left");
    Factory_1.Factory.addGetterSetter(TextPath, "letterSpacing", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(TextPath, "textBaseline", "middle");
    Factory_1.Factory.addGetterSetter(TextPath, "fontVariant", NORMAL);
    Factory_1.Factory.addGetterSetter(TextPath, "text", EMPTY_STRING);
    Factory_1.Factory.addGetterSetter(TextPath, "textDecoration", null);
    Factory_1.Factory.addGetterSetter(TextPath, "kerningFunc", null);
  }
});

// node_modules/konva/lib/shapes/Transformer.js
var require_Transformer = __commonJS({
  "node_modules/konva/lib/shapes/Transformer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Transformer = void 0;
    var Util_1 = require_Util();
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Shape_1 = require_Shape();
    var Rect_1 = require_Rect();
    var Group_1 = require_Group();
    var Global_1 = require_Global();
    var Validators_1 = require_Validators();
    var Global_2 = require_Global();
    var EVENTS_NAME = "tr-konva";
    var ATTR_CHANGE_LIST = [
      "resizeEnabledChange",
      "rotateAnchorOffsetChange",
      "rotateEnabledChange",
      "enabledAnchorsChange",
      "anchorSizeChange",
      "borderEnabledChange",
      "borderStrokeChange",
      "borderStrokeWidthChange",
      "borderDashChange",
      "anchorStrokeChange",
      "anchorStrokeWidthChange",
      "anchorFillChange",
      "anchorCornerRadiusChange",
      "ignoreStrokeChange",
      "anchorStyleFuncChange"
    ].map((e) => e + `.${EVENTS_NAME}`).join(" ");
    var NODES_RECT = "nodesRect";
    var TRANSFORM_CHANGE_STR = [
      "widthChange",
      "heightChange",
      "scaleXChange",
      "scaleYChange",
      "skewXChange",
      "skewYChange",
      "rotationChange",
      "offsetXChange",
      "offsetYChange",
      "transformsEnabledChange",
      "strokeWidthChange"
    ];
    var ANGLES = {
      "top-left": -45,
      "top-center": 0,
      "top-right": 45,
      "middle-right": -90,
      "middle-left": 90,
      "bottom-left": -135,
      "bottom-center": 180,
      "bottom-right": 135
    };
    var TOUCH_DEVICE = "ontouchstart" in Global_1.Konva._global;
    function getCursor(anchorName, rad, rotateCursor) {
      if (anchorName === "rotater") {
        return rotateCursor;
      }
      rad += Util_1.Util.degToRad(ANGLES[anchorName] || 0);
      var angle = (Util_1.Util.radToDeg(rad) % 360 + 360) % 360;
      if (Util_1.Util._inRange(angle, 315 + 22.5, 360) || Util_1.Util._inRange(angle, 0, 22.5)) {
        return "ns-resize";
      } else if (Util_1.Util._inRange(angle, 45 - 22.5, 45 + 22.5)) {
        return "nesw-resize";
      } else if (Util_1.Util._inRange(angle, 90 - 22.5, 90 + 22.5)) {
        return "ew-resize";
      } else if (Util_1.Util._inRange(angle, 135 - 22.5, 135 + 22.5)) {
        return "nwse-resize";
      } else if (Util_1.Util._inRange(angle, 180 - 22.5, 180 + 22.5)) {
        return "ns-resize";
      } else if (Util_1.Util._inRange(angle, 225 - 22.5, 225 + 22.5)) {
        return "nesw-resize";
      } else if (Util_1.Util._inRange(angle, 270 - 22.5, 270 + 22.5)) {
        return "ew-resize";
      } else if (Util_1.Util._inRange(angle, 315 - 22.5, 315 + 22.5)) {
        return "nwse-resize";
      } else {
        Util_1.Util.error("Transformer has unknown angle for cursor detection: " + angle);
        return "pointer";
      }
    }
    var ANCHORS_NAMES = [
      "top-left",
      "top-center",
      "top-right",
      "middle-right",
      "middle-left",
      "bottom-left",
      "bottom-center",
      "bottom-right"
    ];
    var MAX_SAFE_INTEGER = 1e8;
    function getCenter(shape) {
      return {
        x: shape.x + shape.width / 2 * Math.cos(shape.rotation) + shape.height / 2 * Math.sin(-shape.rotation),
        y: shape.y + shape.height / 2 * Math.cos(shape.rotation) + shape.width / 2 * Math.sin(shape.rotation)
      };
    }
    function rotateAroundPoint(shape, angleRad, point) {
      const x = point.x + (shape.x - point.x) * Math.cos(angleRad) - (shape.y - point.y) * Math.sin(angleRad);
      const y = point.y + (shape.x - point.x) * Math.sin(angleRad) + (shape.y - point.y) * Math.cos(angleRad);
      return {
        ...shape,
        rotation: shape.rotation + angleRad,
        x,
        y
      };
    }
    function rotateAroundCenter(shape, deltaRad) {
      const center = getCenter(shape);
      return rotateAroundPoint(shape, deltaRad, center);
    }
    function getSnap(snaps, newRotationRad, tol) {
      let snapped = newRotationRad;
      for (let i = 0; i < snaps.length; i++) {
        const angle = Global_1.Konva.getAngle(snaps[i]);
        const absDiff = Math.abs(angle - newRotationRad) % (Math.PI * 2);
        const dif = Math.min(absDiff, Math.PI * 2 - absDiff);
        if (dif < tol) {
          snapped = angle;
        }
      }
      return snapped;
    }
    var activeTransformersCount = 0;
    var Transformer = class extends Group_1.Group {
      constructor(config) {
        super(config);
        this._movingAnchorName = null;
        this._transforming = false;
        this._createElements();
        this._handleMouseMove = this._handleMouseMove.bind(this);
        this._handleMouseUp = this._handleMouseUp.bind(this);
        this.update = this.update.bind(this);
        this.on(ATTR_CHANGE_LIST, this.update);
        if (this.getNode()) {
          this.update();
        }
      }
      attachTo(node) {
        this.setNode(node);
        return this;
      }
      setNode(node) {
        Util_1.Util.warn("tr.setNode(shape), tr.node(shape) and tr.attachTo(shape) methods are deprecated. Please use tr.nodes(nodesArray) instead.");
        return this.setNodes([node]);
      }
      getNode() {
        return this._nodes && this._nodes[0];
      }
      _getEventNamespace() {
        return EVENTS_NAME + this._id;
      }
      setNodes(nodes = []) {
        if (this._nodes && this._nodes.length) {
          this.detach();
        }
        const filteredNodes = nodes.filter((node) => {
          if (node.isAncestorOf(this)) {
            Util_1.Util.error("Konva.Transformer cannot be an a child of the node you are trying to attach");
            return false;
          }
          return true;
        });
        this._nodes = nodes = filteredNodes;
        if (nodes.length === 1 && this.useSingleNodeRotation()) {
          this.rotation(nodes[0].getAbsoluteRotation());
        } else {
          this.rotation(0);
        }
        this._nodes.forEach((node) => {
          const onChange = () => {
            if (this.nodes().length === 1 && this.useSingleNodeRotation()) {
              this.rotation(this.nodes()[0].getAbsoluteRotation());
            }
            this._resetTransformCache();
            if (!this._transforming && !this.isDragging()) {
              this.update();
            }
          };
          const additionalEvents = node._attrsAffectingSize.map((prop) => prop + "Change." + this._getEventNamespace()).join(" ");
          node.on(additionalEvents, onChange);
          node.on(TRANSFORM_CHANGE_STR.map((e) => e + `.${this._getEventNamespace()}`).join(" "), onChange);
          node.on(`absoluteTransformChange.${this._getEventNamespace()}`, onChange);
          this._proxyDrag(node);
        });
        this._resetTransformCache();
        var elementsCreated = !!this.findOne(".top-left");
        if (elementsCreated) {
          this.update();
        }
        return this;
      }
      _proxyDrag(node) {
        let lastPos;
        node.on(`dragstart.${this._getEventNamespace()}`, (e) => {
          lastPos = node.getAbsolutePosition();
          if (!this.isDragging() && node !== this.findOne(".back")) {
            this.startDrag(e, false);
          }
        });
        node.on(`dragmove.${this._getEventNamespace()}`, (e) => {
          if (!lastPos) {
            return;
          }
          const abs = node.getAbsolutePosition();
          const dx = abs.x - lastPos.x;
          const dy = abs.y - lastPos.y;
          this.nodes().forEach((otherNode) => {
            if (otherNode === node) {
              return;
            }
            if (otherNode.isDragging()) {
              return;
            }
            const otherAbs = otherNode.getAbsolutePosition();
            otherNode.setAbsolutePosition({
              x: otherAbs.x + dx,
              y: otherAbs.y + dy
            });
            otherNode.startDrag(e);
          });
          lastPos = null;
        });
      }
      getNodes() {
        return this._nodes || [];
      }
      getActiveAnchor() {
        return this._movingAnchorName;
      }
      detach() {
        if (this._nodes) {
          this._nodes.forEach((node) => {
            node.off("." + this._getEventNamespace());
          });
        }
        this._nodes = [];
        this._resetTransformCache();
      }
      _resetTransformCache() {
        this._clearCache(NODES_RECT);
        this._clearCache("transform");
        this._clearSelfAndDescendantCache("absoluteTransform");
      }
      _getNodeRect() {
        return this._getCache(NODES_RECT, this.__getNodeRect);
      }
      __getNodeShape(node, rot = this.rotation(), relative) {
        var rect = node.getClientRect({
          skipTransform: true,
          skipShadow: true,
          skipStroke: this.ignoreStroke()
        });
        var absScale = node.getAbsoluteScale(relative);
        var absPos = node.getAbsolutePosition(relative);
        var dx = rect.x * absScale.x - node.offsetX() * absScale.x;
        var dy = rect.y * absScale.y - node.offsetY() * absScale.y;
        const rotation = (Global_1.Konva.getAngle(node.getAbsoluteRotation()) + Math.PI * 2) % (Math.PI * 2);
        const box = {
          x: absPos.x + dx * Math.cos(rotation) + dy * Math.sin(-rotation),
          y: absPos.y + dy * Math.cos(rotation) + dx * Math.sin(rotation),
          width: rect.width * absScale.x,
          height: rect.height * absScale.y,
          rotation
        };
        return rotateAroundPoint(box, -Global_1.Konva.getAngle(rot), {
          x: 0,
          y: 0
        });
      }
      __getNodeRect() {
        var node = this.getNode();
        if (!node) {
          return {
            x: -MAX_SAFE_INTEGER,
            y: -MAX_SAFE_INTEGER,
            width: 0,
            height: 0,
            rotation: 0
          };
        }
        const totalPoints = [];
        this.nodes().map((node2) => {
          const box = node2.getClientRect({
            skipTransform: true,
            skipShadow: true,
            skipStroke: this.ignoreStroke()
          });
          var points = [
            { x: box.x, y: box.y },
            { x: box.x + box.width, y: box.y },
            { x: box.x + box.width, y: box.y + box.height },
            { x: box.x, y: box.y + box.height }
          ];
          var trans = node2.getAbsoluteTransform();
          points.forEach(function(point) {
            var transformed = trans.point(point);
            totalPoints.push(transformed);
          });
        });
        const tr = new Util_1.Transform();
        tr.rotate(-Global_1.Konva.getAngle(this.rotation()));
        var minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity;
        totalPoints.forEach(function(point) {
          var transformed = tr.point(point);
          if (minX === void 0) {
            minX = maxX = transformed.x;
            minY = maxY = transformed.y;
          }
          minX = Math.min(minX, transformed.x);
          minY = Math.min(minY, transformed.y);
          maxX = Math.max(maxX, transformed.x);
          maxY = Math.max(maxY, transformed.y);
        });
        tr.invert();
        const p = tr.point({ x: minX, y: minY });
        return {
          x: p.x,
          y: p.y,
          width: maxX - minX,
          height: maxY - minY,
          rotation: Global_1.Konva.getAngle(this.rotation())
        };
      }
      getX() {
        return this._getNodeRect().x;
      }
      getY() {
        return this._getNodeRect().y;
      }
      getWidth() {
        return this._getNodeRect().width;
      }
      getHeight() {
        return this._getNodeRect().height;
      }
      _createElements() {
        this._createBack();
        ANCHORS_NAMES.forEach((name) => {
          this._createAnchor(name);
        });
        this._createAnchor("rotater");
      }
      _createAnchor(name) {
        var anchor = new Rect_1.Rect({
          stroke: "rgb(0, 161, 255)",
          fill: "white",
          strokeWidth: 1,
          name: name + " _anchor",
          dragDistance: 0,
          draggable: true,
          hitStrokeWidth: TOUCH_DEVICE ? 10 : "auto"
        });
        var self = this;
        anchor.on("mousedown touchstart", function(e) {
          self._handleMouseDown(e);
        });
        anchor.on("dragstart", (e) => {
          anchor.stopDrag();
          e.cancelBubble = true;
        });
        anchor.on("dragend", (e) => {
          e.cancelBubble = true;
        });
        anchor.on("mouseenter", () => {
          var rad = Global_1.Konva.getAngle(this.rotation());
          var rotateCursor = this.rotateAnchorCursor();
          var cursor = getCursor(name, rad, rotateCursor);
          anchor.getStage().content && (anchor.getStage().content.style.cursor = cursor);
          this._cursorChange = true;
        });
        anchor.on("mouseout", () => {
          anchor.getStage().content && (anchor.getStage().content.style.cursor = "");
          this._cursorChange = false;
        });
        this.add(anchor);
      }
      _createBack() {
        var back = new Shape_1.Shape({
          name: "back",
          width: 0,
          height: 0,
          draggable: true,
          sceneFunc(ctx, shape) {
            var tr = shape.getParent();
            var padding = tr.padding();
            ctx.beginPath();
            ctx.rect(-padding, -padding, shape.width() + padding * 2, shape.height() + padding * 2);
            ctx.moveTo(shape.width() / 2, -padding);
            if (tr.rotateEnabled() && tr.rotateLineVisible()) {
              ctx.lineTo(shape.width() / 2, -tr.rotateAnchorOffset() * Util_1.Util._sign(shape.height()) - padding);
            }
            ctx.fillStrokeShape(shape);
          },
          hitFunc: (ctx, shape) => {
            if (!this.shouldOverdrawWholeArea()) {
              return;
            }
            var padding = this.padding();
            ctx.beginPath();
            ctx.rect(-padding, -padding, shape.width() + padding * 2, shape.height() + padding * 2);
            ctx.fillStrokeShape(shape);
          }
        });
        this.add(back);
        this._proxyDrag(back);
        back.on("dragstart", (e) => {
          e.cancelBubble = true;
        });
        back.on("dragmove", (e) => {
          e.cancelBubble = true;
        });
        back.on("dragend", (e) => {
          e.cancelBubble = true;
        });
        this.on("dragmove", (e) => {
          this.update();
        });
      }
      _handleMouseDown(e) {
        if (this._transforming) {
          return;
        }
        this._movingAnchorName = e.target.name().split(" ")[0];
        var attrs = this._getNodeRect();
        var width = attrs.width;
        var height = attrs.height;
        var hypotenuse = Math.sqrt(Math.pow(width, 2) + Math.pow(height, 2));
        this.sin = Math.abs(height / hypotenuse);
        this.cos = Math.abs(width / hypotenuse);
        if (typeof window !== "undefined") {
          window.addEventListener("mousemove", this._handleMouseMove);
          window.addEventListener("touchmove", this._handleMouseMove);
          window.addEventListener("mouseup", this._handleMouseUp, true);
          window.addEventListener("touchend", this._handleMouseUp, true);
        }
        this._transforming = true;
        var ap = e.target.getAbsolutePosition();
        var pos = e.target.getStage().getPointerPosition();
        this._anchorDragOffset = {
          x: pos.x - ap.x,
          y: pos.y - ap.y
        };
        activeTransformersCount++;
        this._fire("transformstart", { evt: e.evt, target: this.getNode() });
        this._nodes.forEach((target) => {
          target._fire("transformstart", { evt: e.evt, target });
        });
      }
      _handleMouseMove(e) {
        var x, y, newHypotenuse;
        var anchorNode = this.findOne("." + this._movingAnchorName);
        var stage = anchorNode.getStage();
        stage.setPointersPositions(e);
        const pp = stage.getPointerPosition();
        let newNodePos = {
          x: pp.x - this._anchorDragOffset.x,
          y: pp.y - this._anchorDragOffset.y
        };
        const oldAbs = anchorNode.getAbsolutePosition();
        if (this.anchorDragBoundFunc()) {
          newNodePos = this.anchorDragBoundFunc()(oldAbs, newNodePos, e);
        }
        anchorNode.setAbsolutePosition(newNodePos);
        const newAbs = anchorNode.getAbsolutePosition();
        if (oldAbs.x === newAbs.x && oldAbs.y === newAbs.y) {
          return;
        }
        if (this._movingAnchorName === "rotater") {
          var attrs = this._getNodeRect();
          x = anchorNode.x() - attrs.width / 2;
          y = -anchorNode.y() + attrs.height / 2;
          let delta = Math.atan2(-y, x) + Math.PI / 2;
          if (attrs.height < 0) {
            delta -= Math.PI;
          }
          var oldRotation = Global_1.Konva.getAngle(this.rotation());
          const newRotation = oldRotation + delta;
          const tol = Global_1.Konva.getAngle(this.rotationSnapTolerance());
          const snappedRot = getSnap(this.rotationSnaps(), newRotation, tol);
          const diff = snappedRot - attrs.rotation;
          const shape = rotateAroundCenter(attrs, diff);
          this._fitNodesInto(shape, e);
          return;
        }
        var shiftBehavior = this.shiftBehavior();
        var keepProportion;
        if (shiftBehavior === "inverted") {
          keepProportion = this.keepRatio() && !e.shiftKey;
        } else if (shiftBehavior === "none") {
          keepProportion = this.keepRatio();
        } else {
          keepProportion = this.keepRatio() || e.shiftKey;
        }
        var centeredScaling = this.centeredScaling() || e.altKey;
        if (this._movingAnchorName === "top-left") {
          if (keepProportion) {
            var comparePoint = centeredScaling ? {
              x: this.width() / 2,
              y: this.height() / 2
            } : {
              x: this.findOne(".bottom-right").x(),
              y: this.findOne(".bottom-right").y()
            };
            newHypotenuse = Math.sqrt(Math.pow(comparePoint.x - anchorNode.x(), 2) + Math.pow(comparePoint.y - anchorNode.y(), 2));
            var reverseX = this.findOne(".top-left").x() > comparePoint.x ? -1 : 1;
            var reverseY = this.findOne(".top-left").y() > comparePoint.y ? -1 : 1;
            x = newHypotenuse * this.cos * reverseX;
            y = newHypotenuse * this.sin * reverseY;
            this.findOne(".top-left").x(comparePoint.x - x);
            this.findOne(".top-left").y(comparePoint.y - y);
          }
        } else if (this._movingAnchorName === "top-center") {
          this.findOne(".top-left").y(anchorNode.y());
        } else if (this._movingAnchorName === "top-right") {
          if (keepProportion) {
            var comparePoint = centeredScaling ? {
              x: this.width() / 2,
              y: this.height() / 2
            } : {
              x: this.findOne(".bottom-left").x(),
              y: this.findOne(".bottom-left").y()
            };
            newHypotenuse = Math.sqrt(Math.pow(anchorNode.x() - comparePoint.x, 2) + Math.pow(comparePoint.y - anchorNode.y(), 2));
            var reverseX = this.findOne(".top-right").x() < comparePoint.x ? -1 : 1;
            var reverseY = this.findOne(".top-right").y() > comparePoint.y ? -1 : 1;
            x = newHypotenuse * this.cos * reverseX;
            y = newHypotenuse * this.sin * reverseY;
            this.findOne(".top-right").x(comparePoint.x + x);
            this.findOne(".top-right").y(comparePoint.y - y);
          }
          var pos = anchorNode.position();
          this.findOne(".top-left").y(pos.y);
          this.findOne(".bottom-right").x(pos.x);
        } else if (this._movingAnchorName === "middle-left") {
          this.findOne(".top-left").x(anchorNode.x());
        } else if (this._movingAnchorName === "middle-right") {
          this.findOne(".bottom-right").x(anchorNode.x());
        } else if (this._movingAnchorName === "bottom-left") {
          if (keepProportion) {
            var comparePoint = centeredScaling ? {
              x: this.width() / 2,
              y: this.height() / 2
            } : {
              x: this.findOne(".top-right").x(),
              y: this.findOne(".top-right").y()
            };
            newHypotenuse = Math.sqrt(Math.pow(comparePoint.x - anchorNode.x(), 2) + Math.pow(anchorNode.y() - comparePoint.y, 2));
            var reverseX = comparePoint.x < anchorNode.x() ? -1 : 1;
            var reverseY = anchorNode.y() < comparePoint.y ? -1 : 1;
            x = newHypotenuse * this.cos * reverseX;
            y = newHypotenuse * this.sin * reverseY;
            anchorNode.x(comparePoint.x - x);
            anchorNode.y(comparePoint.y + y);
          }
          pos = anchorNode.position();
          this.findOne(".top-left").x(pos.x);
          this.findOne(".bottom-right").y(pos.y);
        } else if (this._movingAnchorName === "bottom-center") {
          this.findOne(".bottom-right").y(anchorNode.y());
        } else if (this._movingAnchorName === "bottom-right") {
          if (keepProportion) {
            var comparePoint = centeredScaling ? {
              x: this.width() / 2,
              y: this.height() / 2
            } : {
              x: this.findOne(".top-left").x(),
              y: this.findOne(".top-left").y()
            };
            newHypotenuse = Math.sqrt(Math.pow(anchorNode.x() - comparePoint.x, 2) + Math.pow(anchorNode.y() - comparePoint.y, 2));
            var reverseX = this.findOne(".bottom-right").x() < comparePoint.x ? -1 : 1;
            var reverseY = this.findOne(".bottom-right").y() < comparePoint.y ? -1 : 1;
            x = newHypotenuse * this.cos * reverseX;
            y = newHypotenuse * this.sin * reverseY;
            this.findOne(".bottom-right").x(comparePoint.x + x);
            this.findOne(".bottom-right").y(comparePoint.y + y);
          }
        } else {
          console.error(new Error("Wrong position argument of selection resizer: " + this._movingAnchorName));
        }
        var centeredScaling = this.centeredScaling() || e.altKey;
        if (centeredScaling) {
          var topLeft = this.findOne(".top-left");
          var bottomRight = this.findOne(".bottom-right");
          var topOffsetX = topLeft.x();
          var topOffsetY = topLeft.y();
          var bottomOffsetX = this.getWidth() - bottomRight.x();
          var bottomOffsetY = this.getHeight() - bottomRight.y();
          bottomRight.move({
            x: -topOffsetX,
            y: -topOffsetY
          });
          topLeft.move({
            x: bottomOffsetX,
            y: bottomOffsetY
          });
        }
        var absPos = this.findOne(".top-left").getAbsolutePosition();
        x = absPos.x;
        y = absPos.y;
        var width = this.findOne(".bottom-right").x() - this.findOne(".top-left").x();
        var height = this.findOne(".bottom-right").y() - this.findOne(".top-left").y();
        this._fitNodesInto({
          x,
          y,
          width,
          height,
          rotation: Global_1.Konva.getAngle(this.rotation())
        }, e);
      }
      _handleMouseUp(e) {
        this._removeEvents(e);
      }
      getAbsoluteTransform() {
        return this.getTransform();
      }
      _removeEvents(e) {
        var _a;
        if (this._transforming) {
          this._transforming = false;
          if (typeof window !== "undefined") {
            window.removeEventListener("mousemove", this._handleMouseMove);
            window.removeEventListener("touchmove", this._handleMouseMove);
            window.removeEventListener("mouseup", this._handleMouseUp, true);
            window.removeEventListener("touchend", this._handleMouseUp, true);
          }
          var node = this.getNode();
          activeTransformersCount--;
          this._fire("transformend", { evt: e, target: node });
          (_a = this.getLayer()) === null || _a === void 0 ? void 0 : _a.batchDraw();
          if (node) {
            this._nodes.forEach((target) => {
              var _a2;
              target._fire("transformend", { evt: e, target });
              (_a2 = target.getLayer()) === null || _a2 === void 0 ? void 0 : _a2.batchDraw();
            });
          }
          this._movingAnchorName = null;
        }
      }
      _fitNodesInto(newAttrs, evt) {
        var oldAttrs = this._getNodeRect();
        const minSize = 1;
        if (Util_1.Util._inRange(newAttrs.width, -this.padding() * 2 - minSize, minSize)) {
          this.update();
          return;
        }
        if (Util_1.Util._inRange(newAttrs.height, -this.padding() * 2 - minSize, minSize)) {
          this.update();
          return;
        }
        var t = new Util_1.Transform();
        t.rotate(Global_1.Konva.getAngle(this.rotation()));
        if (this._movingAnchorName && newAttrs.width < 0 && this._movingAnchorName.indexOf("left") >= 0) {
          const offset = t.point({
            x: -this.padding() * 2,
            y: 0
          });
          newAttrs.x += offset.x;
          newAttrs.y += offset.y;
          newAttrs.width += this.padding() * 2;
          this._movingAnchorName = this._movingAnchorName.replace("left", "right");
          this._anchorDragOffset.x -= offset.x;
          this._anchorDragOffset.y -= offset.y;
        } else if (this._movingAnchorName && newAttrs.width < 0 && this._movingAnchorName.indexOf("right") >= 0) {
          const offset = t.point({
            x: this.padding() * 2,
            y: 0
          });
          this._movingAnchorName = this._movingAnchorName.replace("right", "left");
          this._anchorDragOffset.x -= offset.x;
          this._anchorDragOffset.y -= offset.y;
          newAttrs.width += this.padding() * 2;
        }
        if (this._movingAnchorName && newAttrs.height < 0 && this._movingAnchorName.indexOf("top") >= 0) {
          const offset = t.point({
            x: 0,
            y: -this.padding() * 2
          });
          newAttrs.x += offset.x;
          newAttrs.y += offset.y;
          this._movingAnchorName = this._movingAnchorName.replace("top", "bottom");
          this._anchorDragOffset.x -= offset.x;
          this._anchorDragOffset.y -= offset.y;
          newAttrs.height += this.padding() * 2;
        } else if (this._movingAnchorName && newAttrs.height < 0 && this._movingAnchorName.indexOf("bottom") >= 0) {
          const offset = t.point({
            x: 0,
            y: this.padding() * 2
          });
          this._movingAnchorName = this._movingAnchorName.replace("bottom", "top");
          this._anchorDragOffset.x -= offset.x;
          this._anchorDragOffset.y -= offset.y;
          newAttrs.height += this.padding() * 2;
        }
        if (this.boundBoxFunc()) {
          const bounded = this.boundBoxFunc()(oldAttrs, newAttrs);
          if (bounded) {
            newAttrs = bounded;
          } else {
            Util_1.Util.warn("boundBoxFunc returned falsy. You should return new bound rect from it!");
          }
        }
        const baseSize = 1e7;
        const oldTr = new Util_1.Transform();
        oldTr.translate(oldAttrs.x, oldAttrs.y);
        oldTr.rotate(oldAttrs.rotation);
        oldTr.scale(oldAttrs.width / baseSize, oldAttrs.height / baseSize);
        const newTr = new Util_1.Transform();
        const newScaleX = newAttrs.width / baseSize;
        const newScaleY = newAttrs.height / baseSize;
        if (this.flipEnabled() === false) {
          newTr.translate(newAttrs.x, newAttrs.y);
          newTr.rotate(newAttrs.rotation);
          newTr.translate(newAttrs.width < 0 ? newAttrs.width : 0, newAttrs.height < 0 ? newAttrs.height : 0);
          newTr.scale(Math.abs(newScaleX), Math.abs(newScaleY));
        } else {
          newTr.translate(newAttrs.x, newAttrs.y);
          newTr.rotate(newAttrs.rotation);
          newTr.scale(newScaleX, newScaleY);
        }
        const delta = newTr.multiply(oldTr.invert());
        this._nodes.forEach((node) => {
          var _a;
          const parentTransform = node.getParent().getAbsoluteTransform();
          const localTransform = node.getTransform().copy();
          localTransform.translate(node.offsetX(), node.offsetY());
          const newLocalTransform = new Util_1.Transform();
          newLocalTransform.multiply(parentTransform.copy().invert()).multiply(delta).multiply(parentTransform).multiply(localTransform);
          const attrs = newLocalTransform.decompose();
          node.setAttrs(attrs);
          (_a = node.getLayer()) === null || _a === void 0 ? void 0 : _a.batchDraw();
        });
        this.rotation(Util_1.Util._getRotation(newAttrs.rotation));
        this._nodes.forEach((node) => {
          this._fire("transform", { evt, target: node });
          node._fire("transform", { evt, target: node });
        });
        this._resetTransformCache();
        this.update();
        this.getLayer().batchDraw();
      }
      forceUpdate() {
        this._resetTransformCache();
        this.update();
      }
      _batchChangeChild(selector, attrs) {
        const anchor = this.findOne(selector);
        anchor.setAttrs(attrs);
      }
      update() {
        var _a;
        var attrs = this._getNodeRect();
        this.rotation(Util_1.Util._getRotation(attrs.rotation));
        var width = attrs.width;
        var height = attrs.height;
        var enabledAnchors = this.enabledAnchors();
        var resizeEnabled = this.resizeEnabled();
        var padding = this.padding();
        var anchorSize = this.anchorSize();
        const anchors = this.find("._anchor");
        anchors.forEach((node) => {
          node.setAttrs({
            width: anchorSize,
            height: anchorSize,
            offsetX: anchorSize / 2,
            offsetY: anchorSize / 2,
            stroke: this.anchorStroke(),
            strokeWidth: this.anchorStrokeWidth(),
            fill: this.anchorFill(),
            cornerRadius: this.anchorCornerRadius()
          });
        });
        this._batchChangeChild(".top-left", {
          x: 0,
          y: 0,
          offsetX: anchorSize / 2 + padding,
          offsetY: anchorSize / 2 + padding,
          visible: resizeEnabled && enabledAnchors.indexOf("top-left") >= 0
        });
        this._batchChangeChild(".top-center", {
          x: width / 2,
          y: 0,
          offsetY: anchorSize / 2 + padding,
          visible: resizeEnabled && enabledAnchors.indexOf("top-center") >= 0
        });
        this._batchChangeChild(".top-right", {
          x: width,
          y: 0,
          offsetX: anchorSize / 2 - padding,
          offsetY: anchorSize / 2 + padding,
          visible: resizeEnabled && enabledAnchors.indexOf("top-right") >= 0
        });
        this._batchChangeChild(".middle-left", {
          x: 0,
          y: height / 2,
          offsetX: anchorSize / 2 + padding,
          visible: resizeEnabled && enabledAnchors.indexOf("middle-left") >= 0
        });
        this._batchChangeChild(".middle-right", {
          x: width,
          y: height / 2,
          offsetX: anchorSize / 2 - padding,
          visible: resizeEnabled && enabledAnchors.indexOf("middle-right") >= 0
        });
        this._batchChangeChild(".bottom-left", {
          x: 0,
          y: height,
          offsetX: anchorSize / 2 + padding,
          offsetY: anchorSize / 2 - padding,
          visible: resizeEnabled && enabledAnchors.indexOf("bottom-left") >= 0
        });
        this._batchChangeChild(".bottom-center", {
          x: width / 2,
          y: height,
          offsetY: anchorSize / 2 - padding,
          visible: resizeEnabled && enabledAnchors.indexOf("bottom-center") >= 0
        });
        this._batchChangeChild(".bottom-right", {
          x: width,
          y: height,
          offsetX: anchorSize / 2 - padding,
          offsetY: anchorSize / 2 - padding,
          visible: resizeEnabled && enabledAnchors.indexOf("bottom-right") >= 0
        });
        this._batchChangeChild(".rotater", {
          x: width / 2,
          y: -this.rotateAnchorOffset() * Util_1.Util._sign(height) - padding,
          visible: this.rotateEnabled()
        });
        this._batchChangeChild(".back", {
          width,
          height,
          visible: this.borderEnabled(),
          stroke: this.borderStroke(),
          strokeWidth: this.borderStrokeWidth(),
          dash: this.borderDash(),
          x: 0,
          y: 0
        });
        const styleFunc = this.anchorStyleFunc();
        if (styleFunc) {
          anchors.forEach((node) => {
            styleFunc(node);
          });
        }
        (_a = this.getLayer()) === null || _a === void 0 ? void 0 : _a.batchDraw();
      }
      isTransforming() {
        return this._transforming;
      }
      stopTransform() {
        if (this._transforming) {
          this._removeEvents();
          var anchorNode = this.findOne("." + this._movingAnchorName);
          if (anchorNode) {
            anchorNode.stopDrag();
          }
        }
      }
      destroy() {
        if (this.getStage() && this._cursorChange) {
          this.getStage().content && (this.getStage().content.style.cursor = "");
        }
        Group_1.Group.prototype.destroy.call(this);
        this.detach();
        this._removeEvents();
        return this;
      }
      toObject() {
        return Node_1.Node.prototype.toObject.call(this);
      }
      clone(obj) {
        var node = Node_1.Node.prototype.clone.call(this, obj);
        return node;
      }
      getClientRect() {
        if (this.nodes().length > 0) {
          return super.getClientRect();
        } else {
          return { x: 0, y: 0, width: 0, height: 0 };
        }
      }
    };
    exports.Transformer = Transformer;
    Transformer.isTransforming = () => {
      return activeTransformersCount > 0;
    };
    function validateAnchors(val) {
      if (!(val instanceof Array)) {
        Util_1.Util.warn("enabledAnchors value should be an array");
      }
      if (val instanceof Array) {
        val.forEach(function(name) {
          if (ANCHORS_NAMES.indexOf(name) === -1) {
            Util_1.Util.warn("Unknown anchor name: " + name + ". Available names are: " + ANCHORS_NAMES.join(", "));
          }
        });
      }
      return val || [];
    }
    Transformer.prototype.className = "Transformer";
    (0, Global_2._registerNode)(Transformer);
    Factory_1.Factory.addGetterSetter(Transformer, "enabledAnchors", ANCHORS_NAMES, validateAnchors);
    Factory_1.Factory.addGetterSetter(Transformer, "flipEnabled", true, (0, Validators_1.getBooleanValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "resizeEnabled", true);
    Factory_1.Factory.addGetterSetter(Transformer, "anchorSize", 10, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "rotateEnabled", true);
    Factory_1.Factory.addGetterSetter(Transformer, "rotateLineVisible", true);
    Factory_1.Factory.addGetterSetter(Transformer, "rotationSnaps", []);
    Factory_1.Factory.addGetterSetter(Transformer, "rotateAnchorOffset", 50, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "rotateAnchorCursor", "crosshair");
    Factory_1.Factory.addGetterSetter(Transformer, "rotationSnapTolerance", 5, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "borderEnabled", true);
    Factory_1.Factory.addGetterSetter(Transformer, "anchorStroke", "rgb(0, 161, 255)");
    Factory_1.Factory.addGetterSetter(Transformer, "anchorStrokeWidth", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "anchorFill", "white");
    Factory_1.Factory.addGetterSetter(Transformer, "anchorCornerRadius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "borderStroke", "rgb(0, 161, 255)");
    Factory_1.Factory.addGetterSetter(Transformer, "borderStrokeWidth", 1, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "borderDash");
    Factory_1.Factory.addGetterSetter(Transformer, "keepRatio", true);
    Factory_1.Factory.addGetterSetter(Transformer, "shiftBehavior", "default");
    Factory_1.Factory.addGetterSetter(Transformer, "centeredScaling", false);
    Factory_1.Factory.addGetterSetter(Transformer, "ignoreStroke", false);
    Factory_1.Factory.addGetterSetter(Transformer, "padding", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Transformer, "node");
    Factory_1.Factory.addGetterSetter(Transformer, "nodes");
    Factory_1.Factory.addGetterSetter(Transformer, "boundBoxFunc");
    Factory_1.Factory.addGetterSetter(Transformer, "anchorDragBoundFunc");
    Factory_1.Factory.addGetterSetter(Transformer, "anchorStyleFunc");
    Factory_1.Factory.addGetterSetter(Transformer, "shouldOverdrawWholeArea", false);
    Factory_1.Factory.addGetterSetter(Transformer, "useSingleNodeRotation", true);
    Factory_1.Factory.backCompat(Transformer, {
      lineEnabled: "borderEnabled",
      rotateHandlerOffset: "rotateAnchorOffset",
      enabledHandlers: "enabledAnchors"
    });
  }
});

// node_modules/konva/lib/shapes/Wedge.js
var require_Wedge = __commonJS({
  "node_modules/konva/lib/shapes/Wedge.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Wedge = void 0;
    var Factory_1 = require_Factory();
    var Shape_1 = require_Shape();
    var Global_1 = require_Global();
    var Validators_1 = require_Validators();
    var Global_2 = require_Global();
    var Wedge = class extends Shape_1.Shape {
      _sceneFunc(context) {
        context.beginPath();
        context.arc(0, 0, this.radius(), 0, Global_1.Konva.getAngle(this.angle()), this.clockwise());
        context.lineTo(0, 0);
        context.closePath();
        context.fillStrokeShape(this);
      }
      getWidth() {
        return this.radius() * 2;
      }
      getHeight() {
        return this.radius() * 2;
      }
      setWidth(width) {
        this.radius(width / 2);
      }
      setHeight(height) {
        this.radius(height / 2);
      }
    };
    exports.Wedge = Wedge;
    Wedge.prototype.className = "Wedge";
    Wedge.prototype._centroid = true;
    Wedge.prototype._attrsAffectingSize = ["radius"];
    (0, Global_2._registerNode)(Wedge);
    Factory_1.Factory.addGetterSetter(Wedge, "radius", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Wedge, "angle", 0, (0, Validators_1.getNumberValidator)());
    Factory_1.Factory.addGetterSetter(Wedge, "clockwise", false);
    Factory_1.Factory.backCompat(Wedge, {
      angleDeg: "angle",
      getAngleDeg: "getAngle",
      setAngleDeg: "setAngle"
    });
  }
});

// node_modules/konva/lib/filters/Blur.js
var require_Blur = __commonJS({
  "node_modules/konva/lib/filters/Blur.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Blur = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    function BlurStack() {
      this.r = 0;
      this.g = 0;
      this.b = 0;
      this.a = 0;
      this.next = null;
    }
    var mul_table = [
      512,
      512,
      456,
      512,
      328,
      456,
      335,
      512,
      405,
      328,
      271,
      456,
      388,
      335,
      292,
      512,
      454,
      405,
      364,
      328,
      298,
      271,
      496,
      456,
      420,
      388,
      360,
      335,
      312,
      292,
      273,
      512,
      482,
      454,
      428,
      405,
      383,
      364,
      345,
      328,
      312,
      298,
      284,
      271,
      259,
      496,
      475,
      456,
      437,
      420,
      404,
      388,
      374,
      360,
      347,
      335,
      323,
      312,
      302,
      292,
      282,
      273,
      265,
      512,
      497,
      482,
      468,
      454,
      441,
      428,
      417,
      405,
      394,
      383,
      373,
      364,
      354,
      345,
      337,
      328,
      320,
      312,
      305,
      298,
      291,
      284,
      278,
      271,
      265,
      259,
      507,
      496,
      485,
      475,
      465,
      456,
      446,
      437,
      428,
      420,
      412,
      404,
      396,
      388,
      381,
      374,
      367,
      360,
      354,
      347,
      341,
      335,
      329,
      323,
      318,
      312,
      307,
      302,
      297,
      292,
      287,
      282,
      278,
      273,
      269,
      265,
      261,
      512,
      505,
      497,
      489,
      482,
      475,
      468,
      461,
      454,
      447,
      441,
      435,
      428,
      422,
      417,
      411,
      405,
      399,
      394,
      389,
      383,
      378,
      373,
      368,
      364,
      359,
      354,
      350,
      345,
      341,
      337,
      332,
      328,
      324,
      320,
      316,
      312,
      309,
      305,
      301,
      298,
      294,
      291,
      287,
      284,
      281,
      278,
      274,
      271,
      268,
      265,
      262,
      259,
      257,
      507,
      501,
      496,
      491,
      485,
      480,
      475,
      470,
      465,
      460,
      456,
      451,
      446,
      442,
      437,
      433,
      428,
      424,
      420,
      416,
      412,
      408,
      404,
      400,
      396,
      392,
      388,
      385,
      381,
      377,
      374,
      370,
      367,
      363,
      360,
      357,
      354,
      350,
      347,
      344,
      341,
      338,
      335,
      332,
      329,
      326,
      323,
      320,
      318,
      315,
      312,
      310,
      307,
      304,
      302,
      299,
      297,
      294,
      292,
      289,
      287,
      285,
      282,
      280,
      278,
      275,
      273,
      271,
      269,
      267,
      265,
      263,
      261,
      259
    ];
    var shg_table = [
      9,
      11,
      12,
      13,
      13,
      14,
      14,
      15,
      15,
      15,
      15,
      16,
      16,
      16,
      16,
      17,
      17,
      17,
      17,
      17,
      17,
      17,
      18,
      18,
      18,
      18,
      18,
      18,
      18,
      18,
      18,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      19,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      20,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      21,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      22,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      23,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24,
      24
    ];
    function filterGaussBlurRGBA(imageData, radius) {
      var pixels = imageData.data, width = imageData.width, height = imageData.height;
      var x, y, i, p, yp, yi, yw, r_sum, g_sum, b_sum, a_sum, r_out_sum, g_out_sum, b_out_sum, a_out_sum, r_in_sum, g_in_sum, b_in_sum, a_in_sum, pr, pg, pb, pa, rbs;
      var div = radius + radius + 1, widthMinus1 = width - 1, heightMinus1 = height - 1, radiusPlus1 = radius + 1, sumFactor = radiusPlus1 * (radiusPlus1 + 1) / 2, stackStart = new BlurStack(), stackEnd = null, stack = stackStart, stackIn = null, stackOut = null, mul_sum = mul_table[radius], shg_sum = shg_table[radius];
      for (i = 1; i < div; i++) {
        stack = stack.next = new BlurStack();
        if (i === radiusPlus1) {
          stackEnd = stack;
        }
      }
      stack.next = stackStart;
      yw = yi = 0;
      for (y = 0; y < height; y++) {
        r_in_sum = g_in_sum = b_in_sum = a_in_sum = r_sum = g_sum = b_sum = a_sum = 0;
        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi + 1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi + 2]);
        a_out_sum = radiusPlus1 * (pa = pixels[yi + 3]);
        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;
        a_sum += sumFactor * pa;
        stack = stackStart;
        for (i = 0; i < radiusPlus1; i++) {
          stack.r = pr;
          stack.g = pg;
          stack.b = pb;
          stack.a = pa;
          stack = stack.next;
        }
        for (i = 1; i < radiusPlus1; i++) {
          p = yi + ((widthMinus1 < i ? widthMinus1 : i) << 2);
          r_sum += (stack.r = pr = pixels[p]) * (rbs = radiusPlus1 - i);
          g_sum += (stack.g = pg = pixels[p + 1]) * rbs;
          b_sum += (stack.b = pb = pixels[p + 2]) * rbs;
          a_sum += (stack.a = pa = pixels[p + 3]) * rbs;
          r_in_sum += pr;
          g_in_sum += pg;
          b_in_sum += pb;
          a_in_sum += pa;
          stack = stack.next;
        }
        stackIn = stackStart;
        stackOut = stackEnd;
        for (x = 0; x < width; x++) {
          pixels[yi + 3] = pa = a_sum * mul_sum >> shg_sum;
          if (pa !== 0) {
            pa = 255 / pa;
            pixels[yi] = (r_sum * mul_sum >> shg_sum) * pa;
            pixels[yi + 1] = (g_sum * mul_sum >> shg_sum) * pa;
            pixels[yi + 2] = (b_sum * mul_sum >> shg_sum) * pa;
          } else {
            pixels[yi] = pixels[yi + 1] = pixels[yi + 2] = 0;
          }
          r_sum -= r_out_sum;
          g_sum -= g_out_sum;
          b_sum -= b_out_sum;
          a_sum -= a_out_sum;
          r_out_sum -= stackIn.r;
          g_out_sum -= stackIn.g;
          b_out_sum -= stackIn.b;
          a_out_sum -= stackIn.a;
          p = yw + ((p = x + radius + 1) < widthMinus1 ? p : widthMinus1) << 2;
          r_in_sum += stackIn.r = pixels[p];
          g_in_sum += stackIn.g = pixels[p + 1];
          b_in_sum += stackIn.b = pixels[p + 2];
          a_in_sum += stackIn.a = pixels[p + 3];
          r_sum += r_in_sum;
          g_sum += g_in_sum;
          b_sum += b_in_sum;
          a_sum += a_in_sum;
          stackIn = stackIn.next;
          r_out_sum += pr = stackOut.r;
          g_out_sum += pg = stackOut.g;
          b_out_sum += pb = stackOut.b;
          a_out_sum += pa = stackOut.a;
          r_in_sum -= pr;
          g_in_sum -= pg;
          b_in_sum -= pb;
          a_in_sum -= pa;
          stackOut = stackOut.next;
          yi += 4;
        }
        yw += width;
      }
      for (x = 0; x < width; x++) {
        g_in_sum = b_in_sum = a_in_sum = r_in_sum = g_sum = b_sum = a_sum = r_sum = 0;
        yi = x << 2;
        r_out_sum = radiusPlus1 * (pr = pixels[yi]);
        g_out_sum = radiusPlus1 * (pg = pixels[yi + 1]);
        b_out_sum = radiusPlus1 * (pb = pixels[yi + 2]);
        a_out_sum = radiusPlus1 * (pa = pixels[yi + 3]);
        r_sum += sumFactor * pr;
        g_sum += sumFactor * pg;
        b_sum += sumFactor * pb;
        a_sum += sumFactor * pa;
        stack = stackStart;
        for (i = 0; i < radiusPlus1; i++) {
          stack.r = pr;
          stack.g = pg;
          stack.b = pb;
          stack.a = pa;
          stack = stack.next;
        }
        yp = width;
        for (i = 1; i <= radius; i++) {
          yi = yp + x << 2;
          r_sum += (stack.r = pr = pixels[yi]) * (rbs = radiusPlus1 - i);
          g_sum += (stack.g = pg = pixels[yi + 1]) * rbs;
          b_sum += (stack.b = pb = pixels[yi + 2]) * rbs;
          a_sum += (stack.a = pa = pixels[yi + 3]) * rbs;
          r_in_sum += pr;
          g_in_sum += pg;
          b_in_sum += pb;
          a_in_sum += pa;
          stack = stack.next;
          if (i < heightMinus1) {
            yp += width;
          }
        }
        yi = x;
        stackIn = stackStart;
        stackOut = stackEnd;
        for (y = 0; y < height; y++) {
          p = yi << 2;
          pixels[p + 3] = pa = a_sum * mul_sum >> shg_sum;
          if (pa > 0) {
            pa = 255 / pa;
            pixels[p] = (r_sum * mul_sum >> shg_sum) * pa;
            pixels[p + 1] = (g_sum * mul_sum >> shg_sum) * pa;
            pixels[p + 2] = (b_sum * mul_sum >> shg_sum) * pa;
          } else {
            pixels[p] = pixels[p + 1] = pixels[p + 2] = 0;
          }
          r_sum -= r_out_sum;
          g_sum -= g_out_sum;
          b_sum -= b_out_sum;
          a_sum -= a_out_sum;
          r_out_sum -= stackIn.r;
          g_out_sum -= stackIn.g;
          b_out_sum -= stackIn.b;
          a_out_sum -= stackIn.a;
          p = x + ((p = y + radiusPlus1) < heightMinus1 ? p : heightMinus1) * width << 2;
          r_sum += r_in_sum += stackIn.r = pixels[p];
          g_sum += g_in_sum += stackIn.g = pixels[p + 1];
          b_sum += b_in_sum += stackIn.b = pixels[p + 2];
          a_sum += a_in_sum += stackIn.a = pixels[p + 3];
          stackIn = stackIn.next;
          r_out_sum += pr = stackOut.r;
          g_out_sum += pg = stackOut.g;
          b_out_sum += pb = stackOut.b;
          a_out_sum += pa = stackOut.a;
          r_in_sum -= pr;
          g_in_sum -= pg;
          b_in_sum -= pb;
          a_in_sum -= pa;
          stackOut = stackOut.next;
          yi += width;
        }
      }
    }
    var Blur = function Blur2(imageData) {
      var radius = Math.round(this.blurRadius());
      if (radius > 0) {
        filterGaussBlurRGBA(imageData, radius);
      }
    };
    exports.Blur = Blur;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "blurRadius", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Brighten.js
var require_Brighten = __commonJS({
  "node_modules/konva/lib/filters/Brighten.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Brighten = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Brighten = function(imageData) {
      var brightness = this.brightness() * 255, data = imageData.data, len = data.length, i;
      for (i = 0; i < len; i += 4) {
        data[i] += brightness;
        data[i + 1] += brightness;
        data[i + 2] += brightness;
      }
    };
    exports.Brighten = Brighten;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "brightness", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Contrast.js
var require_Contrast = __commonJS({
  "node_modules/konva/lib/filters/Contrast.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Contrast = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Contrast = function(imageData) {
      var adjust = Math.pow((this.contrast() + 100) / 100, 2);
      var data = imageData.data, nPixels = data.length, red = 150, green = 150, blue = 150, i;
      for (i = 0; i < nPixels; i += 4) {
        red = data[i];
        green = data[i + 1];
        blue = data[i + 2];
        red /= 255;
        red -= 0.5;
        red *= adjust;
        red += 0.5;
        red *= 255;
        green /= 255;
        green -= 0.5;
        green *= adjust;
        green += 0.5;
        green *= 255;
        blue /= 255;
        blue -= 0.5;
        blue *= adjust;
        blue += 0.5;
        blue *= 255;
        red = red < 0 ? 0 : red > 255 ? 255 : red;
        green = green < 0 ? 0 : green > 255 ? 255 : green;
        blue = blue < 0 ? 0 : blue > 255 ? 255 : blue;
        data[i] = red;
        data[i + 1] = green;
        data[i + 2] = blue;
      }
    };
    exports.Contrast = Contrast;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "contrast", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Emboss.js
var require_Emboss = __commonJS({
  "node_modules/konva/lib/filters/Emboss.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Emboss = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Util_1 = require_Util();
    var Validators_1 = require_Validators();
    var Emboss = function(imageData) {
      var strength = this.embossStrength() * 10, greyLevel = this.embossWhiteLevel() * 255, direction = this.embossDirection(), blend = this.embossBlend(), dirY = 0, dirX = 0, data = imageData.data, w = imageData.width, h = imageData.height, w4 = w * 4, y = h;
      switch (direction) {
        case "top-left":
          dirY = -1;
          dirX = -1;
          break;
        case "top":
          dirY = -1;
          dirX = 0;
          break;
        case "top-right":
          dirY = -1;
          dirX = 1;
          break;
        case "right":
          dirY = 0;
          dirX = 1;
          break;
        case "bottom-right":
          dirY = 1;
          dirX = 1;
          break;
        case "bottom":
          dirY = 1;
          dirX = 0;
          break;
        case "bottom-left":
          dirY = 1;
          dirX = -1;
          break;
        case "left":
          dirY = 0;
          dirX = -1;
          break;
        default:
          Util_1.Util.error("Unknown emboss direction: " + direction);
      }
      do {
        var offsetY = (y - 1) * w4;
        var otherY = dirY;
        if (y + otherY < 1) {
          otherY = 0;
        }
        if (y + otherY > h) {
          otherY = 0;
        }
        var offsetYOther = (y - 1 + otherY) * w * 4;
        var x = w;
        do {
          var offset = offsetY + (x - 1) * 4;
          var otherX = dirX;
          if (x + otherX < 1) {
            otherX = 0;
          }
          if (x + otherX > w) {
            otherX = 0;
          }
          var offsetOther = offsetYOther + (x - 1 + otherX) * 4;
          var dR = data[offset] - data[offsetOther];
          var dG = data[offset + 1] - data[offsetOther + 1];
          var dB = data[offset + 2] - data[offsetOther + 2];
          var dif = dR;
          var absDif = dif > 0 ? dif : -dif;
          var absG = dG > 0 ? dG : -dG;
          var absB = dB > 0 ? dB : -dB;
          if (absG > absDif) {
            dif = dG;
          }
          if (absB > absDif) {
            dif = dB;
          }
          dif *= strength;
          if (blend) {
            var r = data[offset] + dif;
            var g = data[offset + 1] + dif;
            var b = data[offset + 2] + dif;
            data[offset] = r > 255 ? 255 : r < 0 ? 0 : r;
            data[offset + 1] = g > 255 ? 255 : g < 0 ? 0 : g;
            data[offset + 2] = b > 255 ? 255 : b < 0 ? 0 : b;
          } else {
            var grey = greyLevel - dif;
            if (grey < 0) {
              grey = 0;
            } else if (grey > 255) {
              grey = 255;
            }
            data[offset] = data[offset + 1] = data[offset + 2] = grey;
          }
        } while (--x);
      } while (--y);
    };
    exports.Emboss = Emboss;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "embossStrength", 0.5, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "embossWhiteLevel", 0.5, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "embossDirection", "top-left", null, Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "embossBlend", false, null, Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Enhance.js
var require_Enhance = __commonJS({
  "node_modules/konva/lib/filters/Enhance.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Enhance = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    function remap(fromValue, fromMin, fromMax, toMin, toMax) {
      var fromRange = fromMax - fromMin, toRange = toMax - toMin, toValue;
      if (fromRange === 0) {
        return toMin + toRange / 2;
      }
      if (toRange === 0) {
        return toMin;
      }
      toValue = (fromValue - fromMin) / fromRange;
      toValue = toRange * toValue + toMin;
      return toValue;
    }
    var Enhance = function(imageData) {
      var data = imageData.data, nSubPixels = data.length, rMin = data[0], rMax = rMin, r, gMin = data[1], gMax = gMin, g, bMin = data[2], bMax = bMin, b, i;
      var enhanceAmount = this.enhance();
      if (enhanceAmount === 0) {
        return;
      }
      for (i = 0; i < nSubPixels; i += 4) {
        r = data[i + 0];
        if (r < rMin) {
          rMin = r;
        } else if (r > rMax) {
          rMax = r;
        }
        g = data[i + 1];
        if (g < gMin) {
          gMin = g;
        } else if (g > gMax) {
          gMax = g;
        }
        b = data[i + 2];
        if (b < bMin) {
          bMin = b;
        } else if (b > bMax) {
          bMax = b;
        }
      }
      if (rMax === rMin) {
        rMax = 255;
        rMin = 0;
      }
      if (gMax === gMin) {
        gMax = 255;
        gMin = 0;
      }
      if (bMax === bMin) {
        bMax = 255;
        bMin = 0;
      }
      var rMid, rGoalMax, rGoalMin, gMid, gGoalMax, gGoalMin, bMid, bGoalMax, bGoalMin;
      if (enhanceAmount > 0) {
        rGoalMax = rMax + enhanceAmount * (255 - rMax);
        rGoalMin = rMin - enhanceAmount * (rMin - 0);
        gGoalMax = gMax + enhanceAmount * (255 - gMax);
        gGoalMin = gMin - enhanceAmount * (gMin - 0);
        bGoalMax = bMax + enhanceAmount * (255 - bMax);
        bGoalMin = bMin - enhanceAmount * (bMin - 0);
      } else {
        rMid = (rMax + rMin) * 0.5;
        rGoalMax = rMax + enhanceAmount * (rMax - rMid);
        rGoalMin = rMin + enhanceAmount * (rMin - rMid);
        gMid = (gMax + gMin) * 0.5;
        gGoalMax = gMax + enhanceAmount * (gMax - gMid);
        gGoalMin = gMin + enhanceAmount * (gMin - gMid);
        bMid = (bMax + bMin) * 0.5;
        bGoalMax = bMax + enhanceAmount * (bMax - bMid);
        bGoalMin = bMin + enhanceAmount * (bMin - bMid);
      }
      for (i = 0; i < nSubPixels; i += 4) {
        data[i + 0] = remap(data[i + 0], rMin, rMax, rGoalMin, rGoalMax);
        data[i + 1] = remap(data[i + 1], gMin, gMax, gGoalMin, gGoalMax);
        data[i + 2] = remap(data[i + 2], bMin, bMax, bGoalMin, bGoalMax);
      }
    };
    exports.Enhance = Enhance;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "enhance", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Grayscale.js
var require_Grayscale = __commonJS({
  "node_modules/konva/lib/filters/Grayscale.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Grayscale = void 0;
    var Grayscale = function(imageData) {
      var data = imageData.data, len = data.length, i, brightness;
      for (i = 0; i < len; i += 4) {
        brightness = 0.34 * data[i] + 0.5 * data[i + 1] + 0.16 * data[i + 2];
        data[i] = brightness;
        data[i + 1] = brightness;
        data[i + 2] = brightness;
      }
    };
    exports.Grayscale = Grayscale;
  }
});

// node_modules/konva/lib/filters/HSL.js
var require_HSL = __commonJS({
  "node_modules/konva/lib/filters/HSL.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.HSL = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    Factory_1.Factory.addGetterSetter(Node_1.Node, "hue", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "saturation", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "luminance", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    var HSL = function(imageData) {
      var data = imageData.data, nPixels = data.length, v = 1, s = Math.pow(2, this.saturation()), h = Math.abs(this.hue() + 360) % 360, l = this.luminance() * 127, i;
      var vsu = v * s * Math.cos(h * Math.PI / 180), vsw = v * s * Math.sin(h * Math.PI / 180);
      var rr = 0.299 * v + 0.701 * vsu + 0.167 * vsw, rg = 0.587 * v - 0.587 * vsu + 0.33 * vsw, rb = 0.114 * v - 0.114 * vsu - 0.497 * vsw;
      var gr = 0.299 * v - 0.299 * vsu - 0.328 * vsw, gg = 0.587 * v + 0.413 * vsu + 0.035 * vsw, gb = 0.114 * v - 0.114 * vsu + 0.293 * vsw;
      var br = 0.299 * v - 0.3 * vsu + 1.25 * vsw, bg = 0.587 * v - 0.586 * vsu - 1.05 * vsw, bb = 0.114 * v + 0.886 * vsu - 0.2 * vsw;
      var r, g, b, a;
      for (i = 0; i < nPixels; i += 4) {
        r = data[i + 0];
        g = data[i + 1];
        b = data[i + 2];
        a = data[i + 3];
        data[i + 0] = rr * r + rg * g + rb * b + l;
        data[i + 1] = gr * r + gg * g + gb * b + l;
        data[i + 2] = br * r + bg * g + bb * b + l;
        data[i + 3] = a;
      }
    };
    exports.HSL = HSL;
  }
});

// node_modules/konva/lib/filters/HSV.js
var require_HSV = __commonJS({
  "node_modules/konva/lib/filters/HSV.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.HSV = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var HSV = function(imageData) {
      var data = imageData.data, nPixels = data.length, v = Math.pow(2, this.value()), s = Math.pow(2, this.saturation()), h = Math.abs(this.hue() + 360) % 360, i;
      var vsu = v * s * Math.cos(h * Math.PI / 180), vsw = v * s * Math.sin(h * Math.PI / 180);
      var rr = 0.299 * v + 0.701 * vsu + 0.167 * vsw, rg = 0.587 * v - 0.587 * vsu + 0.33 * vsw, rb = 0.114 * v - 0.114 * vsu - 0.497 * vsw;
      var gr = 0.299 * v - 0.299 * vsu - 0.328 * vsw, gg = 0.587 * v + 0.413 * vsu + 0.035 * vsw, gb = 0.114 * v - 0.114 * vsu + 0.293 * vsw;
      var br = 0.299 * v - 0.3 * vsu + 1.25 * vsw, bg = 0.587 * v - 0.586 * vsu - 1.05 * vsw, bb = 0.114 * v + 0.886 * vsu - 0.2 * vsw;
      var r, g, b, a;
      for (i = 0; i < nPixels; i += 4) {
        r = data[i + 0];
        g = data[i + 1];
        b = data[i + 2];
        a = data[i + 3];
        data[i + 0] = rr * r + rg * g + rb * b;
        data[i + 1] = gr * r + gg * g + gb * b;
        data[i + 2] = br * r + bg * g + bb * b;
        data[i + 3] = a;
      }
    };
    exports.HSV = HSV;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "hue", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "saturation", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "value", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Invert.js
var require_Invert = __commonJS({
  "node_modules/konva/lib/filters/Invert.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Invert = void 0;
    var Invert = function(imageData) {
      var data = imageData.data, len = data.length, i;
      for (i = 0; i < len; i += 4) {
        data[i] = 255 - data[i];
        data[i + 1] = 255 - data[i + 1];
        data[i + 2] = 255 - data[i + 2];
      }
    };
    exports.Invert = Invert;
  }
});

// node_modules/konva/lib/filters/Kaleidoscope.js
var require_Kaleidoscope = __commonJS({
  "node_modules/konva/lib/filters/Kaleidoscope.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Kaleidoscope = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Util_1 = require_Util();
    var Validators_1 = require_Validators();
    var ToPolar = function(src, dst, opt) {
      var srcPixels = src.data, dstPixels = dst.data, xSize = src.width, ySize = src.height, xMid = opt.polarCenterX || xSize / 2, yMid = opt.polarCenterY || ySize / 2, i, x, y, r = 0, g = 0, b = 0, a = 0;
      var rad, rMax = Math.sqrt(xMid * xMid + yMid * yMid);
      x = xSize - xMid;
      y = ySize - yMid;
      rad = Math.sqrt(x * x + y * y);
      rMax = rad > rMax ? rad : rMax;
      var rSize = ySize, tSize = xSize, radius, theta;
      var conversion = 360 / tSize * Math.PI / 180, sin, cos;
      for (theta = 0; theta < tSize; theta += 1) {
        sin = Math.sin(theta * conversion);
        cos = Math.cos(theta * conversion);
        for (radius = 0; radius < rSize; radius += 1) {
          x = Math.floor(xMid + rMax * radius / rSize * cos);
          y = Math.floor(yMid + rMax * radius / rSize * sin);
          i = (y * xSize + x) * 4;
          r = srcPixels[i + 0];
          g = srcPixels[i + 1];
          b = srcPixels[i + 2];
          a = srcPixels[i + 3];
          i = (theta + radius * xSize) * 4;
          dstPixels[i + 0] = r;
          dstPixels[i + 1] = g;
          dstPixels[i + 2] = b;
          dstPixels[i + 3] = a;
        }
      }
    };
    var FromPolar = function(src, dst, opt) {
      var srcPixels = src.data, dstPixels = dst.data, xSize = src.width, ySize = src.height, xMid = opt.polarCenterX || xSize / 2, yMid = opt.polarCenterY || ySize / 2, i, x, y, dx, dy, r = 0, g = 0, b = 0, a = 0;
      var rad, rMax = Math.sqrt(xMid * xMid + yMid * yMid);
      x = xSize - xMid;
      y = ySize - yMid;
      rad = Math.sqrt(x * x + y * y);
      rMax = rad > rMax ? rad : rMax;
      var rSize = ySize, tSize = xSize, radius, theta, phaseShift = opt.polarRotation || 0;
      var x1, y1;
      for (x = 0; x < xSize; x += 1) {
        for (y = 0; y < ySize; y += 1) {
          dx = x - xMid;
          dy = y - yMid;
          radius = Math.sqrt(dx * dx + dy * dy) * rSize / rMax;
          theta = (Math.atan2(dy, dx) * 180 / Math.PI + 360 + phaseShift) % 360;
          theta = theta * tSize / 360;
          x1 = Math.floor(theta);
          y1 = Math.floor(radius);
          i = (y1 * xSize + x1) * 4;
          r = srcPixels[i + 0];
          g = srcPixels[i + 1];
          b = srcPixels[i + 2];
          a = srcPixels[i + 3];
          i = (y * xSize + x) * 4;
          dstPixels[i + 0] = r;
          dstPixels[i + 1] = g;
          dstPixels[i + 2] = b;
          dstPixels[i + 3] = a;
        }
      }
    };
    var Kaleidoscope = function(imageData) {
      var xSize = imageData.width, ySize = imageData.height;
      var x, y, xoff, i, r, g, b, a, srcPos, dstPos;
      var power = Math.round(this.kaleidoscopePower());
      var angle = Math.round(this.kaleidoscopeAngle());
      var offset = Math.floor(xSize * (angle % 360) / 360);
      if (power < 1) {
        return;
      }
      var tempCanvas = Util_1.Util.createCanvasElement();
      tempCanvas.width = xSize;
      tempCanvas.height = ySize;
      var scratchData = tempCanvas.getContext("2d").getImageData(0, 0, xSize, ySize);
      Util_1.Util.releaseCanvas(tempCanvas);
      ToPolar(imageData, scratchData, {
        polarCenterX: xSize / 2,
        polarCenterY: ySize / 2
      });
      var minSectionSize = xSize / Math.pow(2, power);
      while (minSectionSize <= 8) {
        minSectionSize = minSectionSize * 2;
        power -= 1;
      }
      minSectionSize = Math.ceil(minSectionSize);
      var sectionSize = minSectionSize;
      var xStart = 0, xEnd = sectionSize, xDelta = 1;
      if (offset + minSectionSize > xSize) {
        xStart = sectionSize;
        xEnd = 0;
        xDelta = -1;
      }
      for (y = 0; y < ySize; y += 1) {
        for (x = xStart; x !== xEnd; x += xDelta) {
          xoff = Math.round(x + offset) % xSize;
          srcPos = (xSize * y + xoff) * 4;
          r = scratchData.data[srcPos + 0];
          g = scratchData.data[srcPos + 1];
          b = scratchData.data[srcPos + 2];
          a = scratchData.data[srcPos + 3];
          dstPos = (xSize * y + x) * 4;
          scratchData.data[dstPos + 0] = r;
          scratchData.data[dstPos + 1] = g;
          scratchData.data[dstPos + 2] = b;
          scratchData.data[dstPos + 3] = a;
        }
      }
      for (y = 0; y < ySize; y += 1) {
        sectionSize = Math.floor(minSectionSize);
        for (i = 0; i < power; i += 1) {
          for (x = 0; x < sectionSize + 1; x += 1) {
            srcPos = (xSize * y + x) * 4;
            r = scratchData.data[srcPos + 0];
            g = scratchData.data[srcPos + 1];
            b = scratchData.data[srcPos + 2];
            a = scratchData.data[srcPos + 3];
            dstPos = (xSize * y + sectionSize * 2 - x - 1) * 4;
            scratchData.data[dstPos + 0] = r;
            scratchData.data[dstPos + 1] = g;
            scratchData.data[dstPos + 2] = b;
            scratchData.data[dstPos + 3] = a;
          }
          sectionSize *= 2;
        }
      }
      FromPolar(scratchData, imageData, { polarRotation: 0 });
    };
    exports.Kaleidoscope = Kaleidoscope;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "kaleidoscopePower", 2, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "kaleidoscopeAngle", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Mask.js
var require_Mask = __commonJS({
  "node_modules/konva/lib/filters/Mask.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Mask = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    function pixelAt(idata, x, y) {
      var idx = (y * idata.width + x) * 4;
      var d = [];
      d.push(idata.data[idx++], idata.data[idx++], idata.data[idx++], idata.data[idx++]);
      return d;
    }
    function rgbDistance(p1, p2) {
      return Math.sqrt(Math.pow(p1[0] - p2[0], 2) + Math.pow(p1[1] - p2[1], 2) + Math.pow(p1[2] - p2[2], 2));
    }
    function rgbMean(pTab) {
      var m = [0, 0, 0];
      for (var i = 0; i < pTab.length; i++) {
        m[0] += pTab[i][0];
        m[1] += pTab[i][1];
        m[2] += pTab[i][2];
      }
      m[0] /= pTab.length;
      m[1] /= pTab.length;
      m[2] /= pTab.length;
      return m;
    }
    function backgroundMask(idata, threshold) {
      var rgbv_no = pixelAt(idata, 0, 0);
      var rgbv_ne = pixelAt(idata, idata.width - 1, 0);
      var rgbv_so = pixelAt(idata, 0, idata.height - 1);
      var rgbv_se = pixelAt(idata, idata.width - 1, idata.height - 1);
      var thres = threshold || 10;
      if (rgbDistance(rgbv_no, rgbv_ne) < thres && rgbDistance(rgbv_ne, rgbv_se) < thres && rgbDistance(rgbv_se, rgbv_so) < thres && rgbDistance(rgbv_so, rgbv_no) < thres) {
        var mean = rgbMean([rgbv_ne, rgbv_no, rgbv_se, rgbv_so]);
        var mask = [];
        for (var i = 0; i < idata.width * idata.height; i++) {
          var d = rgbDistance(mean, [
            idata.data[i * 4],
            idata.data[i * 4 + 1],
            idata.data[i * 4 + 2]
          ]);
          mask[i] = d < thres ? 0 : 255;
        }
        return mask;
      }
    }
    function applyMask(idata, mask) {
      for (var i = 0; i < idata.width * idata.height; i++) {
        idata.data[4 * i + 3] = mask[i];
      }
    }
    function erodeMask(mask, sw, sh) {
      var weights = [1, 1, 1, 1, 0, 1, 1, 1, 1];
      var side = Math.round(Math.sqrt(weights.length));
      var halfSide = Math.floor(side / 2);
      var maskResult = [];
      for (var y = 0; y < sh; y++) {
        for (var x = 0; x < sw; x++) {
          var so = y * sw + x;
          var a = 0;
          for (var cy = 0; cy < side; cy++) {
            for (var cx = 0; cx < side; cx++) {
              var scy = y + cy - halfSide;
              var scx = x + cx - halfSide;
              if (scy >= 0 && scy < sh && scx >= 0 && scx < sw) {
                var srcOff = scy * sw + scx;
                var wt = weights[cy * side + cx];
                a += mask[srcOff] * wt;
              }
            }
          }
          maskResult[so] = a === 255 * 8 ? 255 : 0;
        }
      }
      return maskResult;
    }
    function dilateMask(mask, sw, sh) {
      var weights = [1, 1, 1, 1, 1, 1, 1, 1, 1];
      var side = Math.round(Math.sqrt(weights.length));
      var halfSide = Math.floor(side / 2);
      var maskResult = [];
      for (var y = 0; y < sh; y++) {
        for (var x = 0; x < sw; x++) {
          var so = y * sw + x;
          var a = 0;
          for (var cy = 0; cy < side; cy++) {
            for (var cx = 0; cx < side; cx++) {
              var scy = y + cy - halfSide;
              var scx = x + cx - halfSide;
              if (scy >= 0 && scy < sh && scx >= 0 && scx < sw) {
                var srcOff = scy * sw + scx;
                var wt = weights[cy * side + cx];
                a += mask[srcOff] * wt;
              }
            }
          }
          maskResult[so] = a >= 255 * 4 ? 255 : 0;
        }
      }
      return maskResult;
    }
    function smoothEdgeMask(mask, sw, sh) {
      var weights = [1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9, 1 / 9];
      var side = Math.round(Math.sqrt(weights.length));
      var halfSide = Math.floor(side / 2);
      var maskResult = [];
      for (var y = 0; y < sh; y++) {
        for (var x = 0; x < sw; x++) {
          var so = y * sw + x;
          var a = 0;
          for (var cy = 0; cy < side; cy++) {
            for (var cx = 0; cx < side; cx++) {
              var scy = y + cy - halfSide;
              var scx = x + cx - halfSide;
              if (scy >= 0 && scy < sh && scx >= 0 && scx < sw) {
                var srcOff = scy * sw + scx;
                var wt = weights[cy * side + cx];
                a += mask[srcOff] * wt;
              }
            }
          }
          maskResult[so] = a;
        }
      }
      return maskResult;
    }
    var Mask = function(imageData) {
      var threshold = this.threshold(), mask = backgroundMask(imageData, threshold);
      if (mask) {
        mask = erodeMask(mask, imageData.width, imageData.height);
        mask = dilateMask(mask, imageData.width, imageData.height);
        mask = smoothEdgeMask(mask, imageData.width, imageData.height);
        applyMask(imageData, mask);
      }
      return imageData;
    };
    exports.Mask = Mask;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "threshold", 0, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Noise.js
var require_Noise = __commonJS({
  "node_modules/konva/lib/filters/Noise.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Noise = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Noise = function(imageData) {
      var amount = this.noise() * 255, data = imageData.data, nPixels = data.length, half = amount / 2, i;
      for (i = 0; i < nPixels; i += 4) {
        data[i + 0] += half - 2 * half * Math.random();
        data[i + 1] += half - 2 * half * Math.random();
        data[i + 2] += half - 2 * half * Math.random();
      }
    };
    exports.Noise = Noise;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "noise", 0.2, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Pixelate.js
var require_Pixelate = __commonJS({
  "node_modules/konva/lib/filters/Pixelate.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Pixelate = void 0;
    var Factory_1 = require_Factory();
    var Util_1 = require_Util();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Pixelate = function(imageData) {
      var pixelSize = Math.ceil(this.pixelSize()), width = imageData.width, height = imageData.height, x, y, i, red, green, blue, alpha, nBinsX = Math.ceil(width / pixelSize), nBinsY = Math.ceil(height / pixelSize), xBinStart, xBinEnd, yBinStart, yBinEnd, xBin, yBin, pixelsInBin, data = imageData.data;
      if (pixelSize <= 0) {
        Util_1.Util.error("pixelSize value can not be <= 0");
        return;
      }
      for (xBin = 0; xBin < nBinsX; xBin += 1) {
        for (yBin = 0; yBin < nBinsY; yBin += 1) {
          red = 0;
          green = 0;
          blue = 0;
          alpha = 0;
          xBinStart = xBin * pixelSize;
          xBinEnd = xBinStart + pixelSize;
          yBinStart = yBin * pixelSize;
          yBinEnd = yBinStart + pixelSize;
          pixelsInBin = 0;
          for (x = xBinStart; x < xBinEnd; x += 1) {
            if (x >= width) {
              continue;
            }
            for (y = yBinStart; y < yBinEnd; y += 1) {
              if (y >= height) {
                continue;
              }
              i = (width * y + x) * 4;
              red += data[i + 0];
              green += data[i + 1];
              blue += data[i + 2];
              alpha += data[i + 3];
              pixelsInBin += 1;
            }
          }
          red = red / pixelsInBin;
          green = green / pixelsInBin;
          blue = blue / pixelsInBin;
          alpha = alpha / pixelsInBin;
          for (x = xBinStart; x < xBinEnd; x += 1) {
            if (x >= width) {
              continue;
            }
            for (y = yBinStart; y < yBinEnd; y += 1) {
              if (y >= height) {
                continue;
              }
              i = (width * y + x) * 4;
              data[i + 0] = red;
              data[i + 1] = green;
              data[i + 2] = blue;
              data[i + 3] = alpha;
            }
          }
        }
      }
    };
    exports.Pixelate = Pixelate;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "pixelSize", 8, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/Posterize.js
var require_Posterize = __commonJS({
  "node_modules/konva/lib/filters/Posterize.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Posterize = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Posterize = function(imageData) {
      var levels = Math.round(this.levels() * 254) + 1, data = imageData.data, len = data.length, scale = 255 / levels, i;
      for (i = 0; i < len; i += 1) {
        data[i] = Math.floor(data[i] / scale) * scale;
      }
    };
    exports.Posterize = Posterize;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "levels", 0.5, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/RGB.js
var require_RGB = __commonJS({
  "node_modules/konva/lib/filters/RGB.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RGB = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var RGB = function(imageData) {
      var data = imageData.data, nPixels = data.length, red = this.red(), green = this.green(), blue = this.blue(), i, brightness;
      for (i = 0; i < nPixels; i += 4) {
        brightness = (0.34 * data[i] + 0.5 * data[i + 1] + 0.16 * data[i + 2]) / 255;
        data[i] = brightness * red;
        data[i + 1] = brightness * green;
        data[i + 2] = brightness * blue;
        data[i + 3] = data[i + 3];
      }
    };
    exports.RGB = RGB;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "red", 0, function(val) {
      this._filterUpToDate = false;
      if (val > 255) {
        return 255;
      } else if (val < 0) {
        return 0;
      } else {
        return Math.round(val);
      }
    });
    Factory_1.Factory.addGetterSetter(Node_1.Node, "green", 0, function(val) {
      this._filterUpToDate = false;
      if (val > 255) {
        return 255;
      } else if (val < 0) {
        return 0;
      } else {
        return Math.round(val);
      }
    });
    Factory_1.Factory.addGetterSetter(Node_1.Node, "blue", 0, Validators_1.RGBComponent, Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/filters/RGBA.js
var require_RGBA = __commonJS({
  "node_modules/konva/lib/filters/RGBA.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.RGBA = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var RGBA = function(imageData) {
      var data = imageData.data, nPixels = data.length, red = this.red(), green = this.green(), blue = this.blue(), alpha = this.alpha(), i, ia;
      for (i = 0; i < nPixels; i += 4) {
        ia = 1 - alpha;
        data[i] = red * alpha + data[i] * ia;
        data[i + 1] = green * alpha + data[i + 1] * ia;
        data[i + 2] = blue * alpha + data[i + 2] * ia;
      }
    };
    exports.RGBA = RGBA;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "red", 0, function(val) {
      this._filterUpToDate = false;
      if (val > 255) {
        return 255;
      } else if (val < 0) {
        return 0;
      } else {
        return Math.round(val);
      }
    });
    Factory_1.Factory.addGetterSetter(Node_1.Node, "green", 0, function(val) {
      this._filterUpToDate = false;
      if (val > 255) {
        return 255;
      } else if (val < 0) {
        return 0;
      } else {
        return Math.round(val);
      }
    });
    Factory_1.Factory.addGetterSetter(Node_1.Node, "blue", 0, Validators_1.RGBComponent, Factory_1.Factory.afterSetFilter);
    Factory_1.Factory.addGetterSetter(Node_1.Node, "alpha", 1, function(val) {
      this._filterUpToDate = false;
      if (val > 1) {
        return 1;
      } else if (val < 0) {
        return 0;
      } else {
        return val;
      }
    });
  }
});

// node_modules/konva/lib/filters/Sepia.js
var require_Sepia = __commonJS({
  "node_modules/konva/lib/filters/Sepia.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Sepia = void 0;
    var Sepia = function(imageData) {
      var data = imageData.data, nPixels = data.length, i, r, g, b;
      for (i = 0; i < nPixels; i += 4) {
        r = data[i + 0];
        g = data[i + 1];
        b = data[i + 2];
        data[i + 0] = Math.min(255, r * 0.393 + g * 0.769 + b * 0.189);
        data[i + 1] = Math.min(255, r * 0.349 + g * 0.686 + b * 0.168);
        data[i + 2] = Math.min(255, r * 0.272 + g * 0.534 + b * 0.131);
      }
    };
    exports.Sepia = Sepia;
  }
});

// node_modules/konva/lib/filters/Solarize.js
var require_Solarize = __commonJS({
  "node_modules/konva/lib/filters/Solarize.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Solarize = void 0;
    var Solarize = function(imageData) {
      var data = imageData.data, w = imageData.width, h = imageData.height, w4 = w * 4, y = h;
      do {
        var offsetY = (y - 1) * w4;
        var x = w;
        do {
          var offset = offsetY + (x - 1) * 4;
          var r = data[offset];
          var g = data[offset + 1];
          var b = data[offset + 2];
          if (r > 127) {
            r = 255 - r;
          }
          if (g > 127) {
            g = 255 - g;
          }
          if (b > 127) {
            b = 255 - b;
          }
          data[offset] = r;
          data[offset + 1] = g;
          data[offset + 2] = b;
        } while (--x);
      } while (--y);
    };
    exports.Solarize = Solarize;
  }
});

// node_modules/konva/lib/filters/Threshold.js
var require_Threshold = __commonJS({
  "node_modules/konva/lib/filters/Threshold.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Threshold = void 0;
    var Factory_1 = require_Factory();
    var Node_1 = require_Node();
    var Validators_1 = require_Validators();
    var Threshold = function(imageData) {
      var level = this.threshold() * 255, data = imageData.data, len = data.length, i;
      for (i = 0; i < len; i += 1) {
        data[i] = data[i] < level ? 0 : 255;
      }
    };
    exports.Threshold = Threshold;
    Factory_1.Factory.addGetterSetter(Node_1.Node, "threshold", 0.5, (0, Validators_1.getNumberValidator)(), Factory_1.Factory.afterSetFilter);
  }
});

// node_modules/konva/lib/_FullInternals.js
var require_FullInternals = __commonJS({
  "node_modules/konva/lib/_FullInternals.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Konva = void 0;
    var _CoreInternals_1 = require_CoreInternals();
    var Arc_1 = require_Arc();
    var Arrow_1 = require_Arrow();
    var Circle_1 = require_Circle();
    var Ellipse_1 = require_Ellipse();
    var Image_1 = require_Image();
    var Label_1 = require_Label();
    var Line_1 = require_Line();
    var Path_1 = require_Path();
    var Rect_1 = require_Rect();
    var RegularPolygon_1 = require_RegularPolygon();
    var Ring_1 = require_Ring();
    var Sprite_1 = require_Sprite();
    var Star_1 = require_Star();
    var Text_1 = require_Text();
    var TextPath_1 = require_TextPath();
    var Transformer_1 = require_Transformer();
    var Wedge_1 = require_Wedge();
    var Blur_1 = require_Blur();
    var Brighten_1 = require_Brighten();
    var Contrast_1 = require_Contrast();
    var Emboss_1 = require_Emboss();
    var Enhance_1 = require_Enhance();
    var Grayscale_1 = require_Grayscale();
    var HSL_1 = require_HSL();
    var HSV_1 = require_HSV();
    var Invert_1 = require_Invert();
    var Kaleidoscope_1 = require_Kaleidoscope();
    var Mask_1 = require_Mask();
    var Noise_1 = require_Noise();
    var Pixelate_1 = require_Pixelate();
    var Posterize_1 = require_Posterize();
    var RGB_1 = require_RGB();
    var RGBA_1 = require_RGBA();
    var Sepia_1 = require_Sepia();
    var Solarize_1 = require_Solarize();
    var Threshold_1 = require_Threshold();
    exports.Konva = _CoreInternals_1.Konva.Util._assign(_CoreInternals_1.Konva, {
      Arc: Arc_1.Arc,
      Arrow: Arrow_1.Arrow,
      Circle: Circle_1.Circle,
      Ellipse: Ellipse_1.Ellipse,
      Image: Image_1.Image,
      Label: Label_1.Label,
      Tag: Label_1.Tag,
      Line: Line_1.Line,
      Path: Path_1.Path,
      Rect: Rect_1.Rect,
      RegularPolygon: RegularPolygon_1.RegularPolygon,
      Ring: Ring_1.Ring,
      Sprite: Sprite_1.Sprite,
      Star: Star_1.Star,
      Text: Text_1.Text,
      TextPath: TextPath_1.TextPath,
      Transformer: Transformer_1.Transformer,
      Wedge: Wedge_1.Wedge,
      Filters: {
        Blur: Blur_1.Blur,
        Brighten: Brighten_1.Brighten,
        Contrast: Contrast_1.Contrast,
        Emboss: Emboss_1.Emboss,
        Enhance: Enhance_1.Enhance,
        Grayscale: Grayscale_1.Grayscale,
        HSL: HSL_1.HSL,
        HSV: HSV_1.HSV,
        Invert: Invert_1.Invert,
        Kaleidoscope: Kaleidoscope_1.Kaleidoscope,
        Mask: Mask_1.Mask,
        Noise: Noise_1.Noise,
        Pixelate: Pixelate_1.Pixelate,
        Posterize: Posterize_1.Posterize,
        RGB: RGB_1.RGB,
        RGBA: RGBA_1.RGBA,
        Sepia: Sepia_1.Sepia,
        Solarize: Solarize_1.Solarize,
        Threshold: Threshold_1.Threshold
      }
    });
  }
});

// node_modules/konva/lib/index.js
var require_lib = __commonJS({
  "node_modules/konva/lib/index.js"(exports, module) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var _FullInternals_1 = require_FullInternals();
    module.exports = _FullInternals_1.Konva;
  }
});
export default require_lib();
//# sourceMappingURL=konva.js.map
