/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.graph;

import internettehnologii.imaps.backendRender.graph.Edge;
import internettehnologii.imaps.backendRender.graph.MapNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class RouteGraph {
    private final Map<MapNode, Set<Edge>> graph = new HashMap();
    private final Map<String, MapNode> nameToNodeMap = new HashMap();

    public void loadNodeNames(List<MapNode> nodes) {
        for (MapNode mapNode : nodes) {
            this.nameToNodeMap.put(mapNode.getName(), mapNode);
        }
        for (Map.Entry entry : this.nameToNodeMap.entrySet()) {
            System.out.println((String)entry.getKey() + " " + String.valueOf(entry.getValue()));
        }
    }

    public void loadEdges() {
        for (MapNode mapNode : this.nameToNodeMap.values()) {
            for (String connectionName : mapNode.getConnectionNames()) {
                System.out.println("CONN: " + mapNode.getName() + " " + connectionName);
                MapNode connectedNode = (MapNode)this.nameToNodeMap.get(connectionName);
                if (connectedNode != null) {
                    this.addEdge(mapNode, connectedNode);
                    continue;
                }
                System.out.println("CANT ADD EDGE ========== FROM: " + mapNode.getName() + " TO: " + connectionName);
            }
        }
    }

    private double getDistanceBetweenPoints(MapNode a, MapNode b) {
        double x1 = (Double)a.getCoordinates().x;
        double y1 = (Double)a.getCoordinates().y;
        double x2 = (Double)b.getCoordinates().x;
        double y2 = (Double)b.getCoordinates().y;
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public List<MapNode> findRoute(String source, String target) {
        MapNode sourceNode = (MapNode)this.nameToNodeMap.get(source);
        MapNode targetNode = (MapNode)this.nameToNodeMap.get(target);
        if (sourceNode == null || targetNode == null) {
            System.out.println(this.toString());
            System.out.println("SOURCE NODE FROM MAP " + String.valueOf(sourceNode));
            System.out.println("TARGET NODE FROM MAP " + String.valueOf(targetNode));
            throw new IllegalArgumentException("Source or target node not found. SOURCE: " + source + " TARGET: " + target);
        }
        PriorityQueue<Edge> queue = new PriorityQueue<Edge>(Comparator.comparingDouble(Edge::getWeight));
        queue.add(new Edge(sourceNode, 0.0));
        HashMap<MapNode, Double> dist = new HashMap<MapNode, Double>();
        HashMap<MapNode, MapNode> parent = new HashMap<MapNode, MapNode>();
        HashSet<MapNode> visited = new HashSet<MapNode>();
        for (MapNode mapNode : this.graph.keySet()) {
            dist.put(mapNode, (Double)Double.MAX_VALUE);
        }
        dist.put(sourceNode, 0.0);
        while (!queue.isEmpty()) {
            Edge currentEdge = queue.poll();
            MapNode currentNode = currentEdge.getNode();
            if (visited.contains(currentNode)) continue;
            if (currentNode.equals(targetNode)) {
                return this.getPath(sourceNode, targetNode, parent);
            }
            visited.add(currentNode);
            for (Edge neighbor : (Set)this.graph.get(currentNode)) {
                double newDist = (Double)dist.get(currentNode) + neighbor.getWeight();
                if (!(newDist < (Double)dist.get(neighbor.getNode()))) continue;
                dist.put(neighbor.getNode(), newDist);
                parent.put(neighbor.getNode(), currentNode);
                queue.add(new Edge(neighbor.getNode(), newDist));
            }
        }
        System.out.println("No path found from: " + source + " to " + target);
        return new ArrayList<MapNode>();
    }

    private List<MapNode> getPath(MapNode sourceNode, MapNode targetNode, Map<MapNode, MapNode> parent) {
        ArrayList<MapNode> path = new ArrayList<MapNode>();
        MapNode at = targetNode;
        while (at != null) {
            path.add(at);
            at = parent.get(at);
        }
        Collections.reverse(path);
        if (!path.isEmpty() && ((MapNode)path.get(0)).equals(sourceNode)) {
            System.out.println("FOUND PATH: " + String.valueOf(path));
            return path;
        }
        System.out.println("err");
        return new ArrayList<MapNode>();
    }

    public void addEdge(MapNode from, MapNode to) {
        if (!this.graph.containsKey(from)) {
            this.graph.put(from, new HashSet());
        }
        if (!this.graph.containsKey(to)) {
            this.graph.put(to, new HashSet());
        }
        double distance = this.getDistanceBetweenPoints(from, to);
        ((Set)this.graph.get(from)).add(new Edge(to, distance));
        ((Set)this.graph.get(to)).add(new Edge(from, distance));
    }

    public String findNodeConnectedToEntrance(String roomName) {
        for (MapNode node : this.graph.keySet()) {
            if (!node.getConnectedRoom().equals(roomName)) continue;
            return node.getName();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RouteGraph: \n");
        for (Map.Entry entry : this.graph.entrySet()) {
            MapNode node = (MapNode)entry.getKey();
            Set connectedNodes = (Set)entry.getValue();
            System.out.println("CONN NODES PRINT: " + String.valueOf(connectedNodes));
            sb.append(node.getName()).append(" -> ");
            if (connectedNodes.isEmpty()) {
                sb.append("No connections");
            } else {
                sb.append("[");
                for (Edge connectedNode : connectedNodes) {
                    sb.append(connectedNode.getNode().getName()).append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("]");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

