/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import internettehnologii.imaps.backendRender.web.entities.Floor;
import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.entities.PublishRequest;
import internettehnologii.imaps.backendRender.web.service.interfaces.FloorService;
import internettehnologii.imaps.backendRender.web.service.interfaces.MapService;
import internettehnologii.imaps.backendRender.web.service.interfaces.PublishRequestService;
import internettehnologii.imaps.backendRender.web.service.interfaces.RoomTypeService;
import internettehnologii.imaps.backendRender.web.service.interfaces.UserService;
import internettehnologii.imaps.backendRender.web.util.DTO.CreateMapDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.FloorDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.MapDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.PublishMapDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.RoomTypeDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.SaveMapDTO;
import internettehnologii.imaps.backendRender.web.util.Util;
import internettehnologii.imaps.backendRender.web.util.json.JsonMapData;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/protected"})
public class MapDrawController {
    private final MapService mapService;
    private final FloorService floorService;
    private final RoomTypeService roomTypeService;
    private final UserService userService;
    private final PublishRequestService publishRequestService;

    @Autowired
    public MapDrawController(MapService mapService, FloorService floorService, RoomTypeService roomTypeService, UserService userService, PublishRequestService publishRequestService) {
        this.mapService = mapService;
        this.floorService = floorService;
        this.roomTypeService = roomTypeService;
        this.userService = userService;
        this.publishRequestService = publishRequestService;
    }

    @GetMapping(value={"/my-maps"})
    public ResponseEntity<List<MapDTO>> getMapsForUser(@RequestParam String username) {
        try {
            List maps = this.mapService.getAllMapsForUser(username);
            List mapDTOS = Util.convertToMapDTO((Collection)maps);
            return ResponseEntity.ok().body((Object)mapDTOS);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PostMapping(value={"/publish/add"})
    public ResponseEntity<MapDTO> sendPublishRequest(@RequestBody PublishMapDTO formData, @RequestParam String username) {
        System.out.println("FORM DATA: -------------------------------------------- " + String.valueOf(formData));
        try {
            IMapsUser user = this.userService.getUser(username);
            MapDTO updatedMap = this.publishRequestService.addPublishRequest(formData, user);
            return ResponseEntity.ok((Object)updatedMap);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @GetMapping(value={"/publish/get"})
    public ResponseEntity<PublishMapDTO> getPublishRequestForMap(@RequestParam String mapName) {
        PublishRequest pr = this.publishRequestService.getPublishRequestByMapName(mapName);
        PublishMapDTO dto = new PublishMapDTO(pr.getId().intValue(), pr.getName(), pr.getLastName(), pr.getMap().getName(), pr.getMapType(), pr.getGMapsUrl());
        return ResponseEntity.ok((Object)dto);
    }

    @GetMapping(value={"/favourites"})
    public ResponseEntity<List<MapDTO>> getFavouriteMapsForUser(@RequestParam String username) {
        try {
            IMapsUser user = this.userService.getUser(username);
            List mapDTOS = Util.convertToMapDTO((Collection)user.getFavoriteMaps());
            return ResponseEntity.ok().body((Object)mapDTOS);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PutMapping(value={"/my-maps/save"})
    public ResponseEntity<FloorDTO> updateMapData(@RequestBody SaveMapDTO saveMapDTO, @RequestParam String username) {
        try {
            IndoorMap map = this.mapService.getMapForUser(username, saveMapDTO.getMapName());
            Floor f = this.floorService.getFloorByNum(Integer.valueOf(saveMapDTO.getFloorNum()), map);
            ObjectMapper objectMapper = new ObjectMapper();
            String roomTypesJson = objectMapper.writeValueAsString(saveMapDTO.getRoomTypes());
            JsonMapData jsonMapData = new JsonMapData(saveMapDTO.getShapes().toString(), roomTypesJson);
            System.out.println("ROOM TYPES JSON : " + roomTypesJson);
            f.setMapData(jsonMapData);
            this.floorService.updateFloor(f);
            map.setModifiedAt(LocalDateTime.now());
            System.out.println("UPDATED FLOOR " + f.getFloorNumber());
            FloorDTO floorDTO = new FloorDTO(f.getFloorNumber(), saveMapDTO.getMapName(), f.getMapData().getShapeData());
            return ResponseEntity.ok((Object)floorDTO);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PutMapping(value={"/my-maps/create"})
    public ResponseEntity<MapDTO> createMap(@RequestBody CreateMapDTO mapData, @RequestParam String username) {
        try {
            this.mapService.createMap(mapData.getName(), username);
            IndoorMap map = this.mapService.getMapForUser(username, mapData.getName());
            MapDTO mapDTO = new MapDTO(map.getName(), map.getMapType(), map.getCreatedAt(), map.getModifiedAt(), map.getStatus().name(), map.getFavouriteCount(), map.getGmapsUrl());
            return ResponseEntity.ok((Object)mapDTO);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @GetMapping(value={"/my-maps/load"})
    public ResponseEntity<List<FloorDTO>> loadPersonalMap(@RequestParam String mapName, @RequestParam String username) {
        try {
            IndoorMap map = this.mapService.getMapForUser(username, mapName);
            List floors = map.getFloors();
            return ResponseEntity.ok().body((Object)Util.convertToFloorDTO((List)floors));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PostMapping(value={"/room-types/add"})
    public ResponseEntity<Map<String, Object>> addRoomType(@RequestParam String roomTypeName, @RequestParam String username, @RequestParam String mapName) {
        try {
            IndoorMap map = this.mapService.getMapForUser(username, mapName);
            this.roomTypeService.addRoomType(roomTypeName, map);
            return ResponseEntity.ok(new HashMap());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @GetMapping(value={"/room-types"})
    public ResponseEntity<List<RoomTypeDTO>> getRoomTypesForMap(@RequestParam String mapName, @RequestParam String username) {
        IndoorMap map = this.mapService.getMapForUser(username, mapName);
        List<RoomTypeDTO> roomTypeDTOS = map.getRoomTypes().stream().map(r -> new RoomTypeDTO(r.getName())).toList();
        return ResponseEntity.ok(roomTypeDTOS);
    }

    @DeleteMapping(value={"/floors/delete"})
    public ResponseEntity<Map<String, Object>> deleteFloor(@RequestParam String mapName, @RequestParam int floorNum) {
        try {
            this.floorService.deleteFloor(floorNum, mapName);
            return ResponseEntity.ok(new HashMap());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @PutMapping(value={"/floors/add"})
    public ResponseEntity<Map<String, Object>> addFloor(@RequestBody FloorDTO floorDTO) {
        HashMap response = new HashMap();
        try {
            this.floorService.addFloor(floorDTO.getNum(), floorDTO.getMapName());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
        }
    }

    @DeleteMapping(value={"/my-maps/delete"})
    public ResponseEntity<Map<String, Object>> deleteMap(@RequestParam String mapName, @RequestParam String username) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            IndoorMap map = this.mapService.getMapForUser(username, mapName);
            this.mapService.deleteMap(map);
            response.put("deleted", true);
            response.put("mapName", mapName);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            System.out.println("Error during map deletion: " + e.getMessage());
            e.printStackTrace();
            response.put("error", "Map not found or does not belong to the user.");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(response);
        }
    }
}

