/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.controllers;

import internettehnologii.imaps.backendRender.graph.MapNode;
import internettehnologii.imaps.backendRender.graph.RouteGraph;
import internettehnologii.imaps.backendRender.web.entities.IMapsUser;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.entities.Report;
import internettehnologii.imaps.backendRender.web.exceptions.EmptyMapException;
import internettehnologii.imaps.backendRender.web.service.interfaces.FloorService;
import internettehnologii.imaps.backendRender.web.service.interfaces.GraphService;
import internettehnologii.imaps.backendRender.web.service.interfaces.MapService;
import internettehnologii.imaps.backendRender.web.service.interfaces.ReportService;
import internettehnologii.imaps.backendRender.web.service.interfaces.UserService;
import internettehnologii.imaps.backendRender.web.util.DTO.FloorDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.MapDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.ReportDTO;
import internettehnologii.imaps.backendRender.web.util.DTO.RoomTypeDTO;
import internettehnologii.imaps.backendRender.web.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class MapViewController {
    private RouteGraph graph;
    private final MapService mapService;
    private final FloorService floorService;
    private final GraphService graphService;
    private final UserService userService;
    private final ReportService reportService;

    @Autowired
    public MapViewController(MapService mapService, FloorService floorService, GraphService graphService, UserService userService, ReportService reportService) {
        this.mapService = mapService;
        this.floorService = floorService;
        this.graphService = graphService;
        this.userService = userService;
        this.reportService = reportService;
    }

    @GetMapping(value={"/public/maps"})
    public ResponseEntity<List<MapDTO>> loadPublicMaps() {
        try {
            List maps = this.mapService.getPublicMaps();
            List mapDTOS = Util.convertToMapDTO((Collection)maps);
            return ResponseEntity.ok((Object)mapDTOS);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
    }

    @GetMapping(value={"/public/room-types"})
    public ResponseEntity<List<RoomTypeDTO>> loadRoomTypesPublic(@RequestParam String mapName) {
        IndoorMap map = this.mapService.getPublicMapByName(mapName);
        List<RoomTypeDTO> roomTypeDTOS = map.getRoomTypes().stream().map(r -> new RoomTypeDTO(r.getName())).toList();
        return ResponseEntity.ok(roomTypeDTOS);
    }

    @GetMapping(value={"/public/navigate"})
    public ResponseEntity<List<MapNode>> navigate(@RequestParam String from, @RequestParam String to) {
        String startNode = from;
        String endNode = to;
        String roomConnectedToEntranceFrom = this.graph.findNodeConnectedToEntrance(from);
        String roomConnectedToEntranceTo = this.graph.findNodeConnectedToEntrance(to);
        if (roomConnectedToEntranceFrom != null) {
            startNode = roomConnectedToEntranceFrom;
        }
        if (roomConnectedToEntranceTo != null) {
            endNode = roomConnectedToEntranceTo;
        }
        List path = this.graph.findRoute(startNode, endNode);
        return ResponseEntity.ok((Object)path);
    }

    @GetMapping(value={"/public/load-map"})
    public ResponseEntity<List<FloorDTO>> getMapData(@RequestParam String mapName) {
        try {
            IndoorMap map = this.mapService.getPublicMapByName(mapName);
            List floors = this.floorService.getAllFloorsForMap(mapName);
            this.graph = this.graphService.construct(floors);
            return ResponseEntity.ok((Object)Util.convertToFloorDTO((List)map.getFloors()));
        }
        catch (EmptyMapException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }

    @GetMapping(value={"/protected/load-map"})
    public ResponseEntity<List<FloorDTO>> getMapDataProtected(@RequestParam String mapName, @RequestParam String username) {
        try {
            IndoorMap map = this.mapService.getMapForUser(username, mapName);
            List floors = this.floorService.getAllFloorsForMap(mapName);
            this.graph = this.graphService.construct(floors);
            return ResponseEntity.ok((Object)Util.convertToFloorDTO((List)map.getFloors()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
    }

    @PostMapping(value={"/protected/favourites/add"})
    public ResponseEntity<Map<String, Object>> addFavourites(@RequestParam String username, @RequestParam String mapName) {
        try {
            IndoorMap map = this.mapService.getMapByName(mapName);
            IMapsUser user = this.userService.getUser(username);
            this.userService.addFavoriteMap(user, map);
            return ResponseEntity.ok(new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)404).body(new HashMap());
        }
    }

    @DeleteMapping(value={"/protected/favourites/delete"})
    public ResponseEntity<Map<String, Object>> removeFavourites(@RequestParam String username, @RequestParam String mapName) {
        try {
            IndoorMap map = this.mapService.getMapByName(mapName);
            IMapsUser user = this.userService.getUser(username);
            this.userService.removeFavoriteMap(user, map);
            return ResponseEntity.ok(new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)404).body(new HashMap());
        }
    }

    @PostMapping(value={"/protected/reports/create"})
    public ResponseEntity<Map<String, Object>> createReport(@RequestBody ReportDTO reportBody) {
        try {
            IMapsUser user = this.userService.getUser(reportBody.getUsername());
            IndoorMap map = this.mapService.getMapByName(reportBody.getMapName());
            Report report = new Report(user, map, reportBody.getSubject(), reportBody.getContent());
            this.reportService.saveReport(report);
            HashMap response = new HashMap();
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)404).body(new HashMap());
        }
    }
}

