/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.controllers;

import internettehnologii.imaps.backendRender.web.config.OAuthConfig;
import internettehnologii.imaps.backendRender.web.controllers.InvalidStateException;
import internettehnologii.imaps.backendRender.web.service.interfaces.OAuthService;
import internettehnologii.imaps.backendRender.web.service.interfaces.StateStore;
import internettehnologii.imaps.backendRender.web.util.DTO.UserAuthSuccessDTO;
import internettehnologii.imaps.backendRender.web.util.OAuthProviders;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/api/oauth"})
public class OAuthController {
    private final StateStore stateStore;
    private final OAuthService githubOAuthService;
    private final OAuthService googleOAuthService;
    private final OAuthConfig oAuthConfig;
    private final RestTemplate restTemplate = new RestTemplate();

    public OAuthController(StateStore stateStore, @Qualifier(value="githubOAuth") OAuthService githubOAuthService, @Qualifier(value="googleOAuth") OAuthService googleOAuthService, OAuthConfig oAuthConfig) {
        this.stateStore = stateStore;
        this.githubOAuthService = githubOAuthService;
        this.googleOAuthService = googleOAuthService;
        this.oAuthConfig = oAuthConfig;
    }

    @GetMapping(value={"/state"})
    public ResponseEntity<String> getState() {
        String uuid = UUID.randomUUID().toString();
        this.stateStore.storeState(uuid);
        return ResponseEntity.ok((Object)uuid);
    }

    @GetMapping(value={"/callback/github"})
    public ResponseEntity<UserAuthSuccessDTO> callbackGithub(@RequestParam(value="code") String code, @RequestParam(value="state") String state) {
        if (!this.stateStore.isValidState(state)) {
            throw new InvalidStateException("State is not valid: " + state);
        }
        String accessToken = this.exchangeCodeForAccessToken(code, OAuthProviders.GITHUB.name());
        String userInfo = this.fetchUserInfo(accessToken, OAuthProviders.GITHUB.name());
        System.out.println("User info: " + userInfo);
        UserAuthSuccessDTO userAuthSuccessDTO = this.githubOAuthService.login(userInfo, accessToken);
        String encodedUsrname = URLEncoder.encode(userAuthSuccessDTO.getUsername(), StandardCharsets.UTF_8);
        String encodedToken = URLEncoder.encode(userAuthSuccessDTO.getToken(), StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create("https://imaps.mk/auth-callback?token=" + encodedToken + "&username=" + encodedUsrname));
        headers.add("Set-Cookie", "Authorization=Bearer " + String.valueOf(userAuthSuccessDTO) + "; HttpOnly; Path=/; SameSite=Strict");
        return new ResponseEntity((Object)userAuthSuccessDTO, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.FOUND);
    }

    @GetMapping(value={"/callback/google"})
    public ResponseEntity<UserAuthSuccessDTO> callbackGoogle(@RequestParam(value="code") String code, @RequestParam(value="state") String state) {
        if (!this.stateStore.isValidState(state)) {
            throw new InvalidStateException("State is not valid: " + state);
        }
        String accessToken = this.exchangeCodeForAccessToken(code, OAuthProviders.GOOGLE.name());
        String userInfo = this.fetchUserInfo(accessToken, OAuthProviders.GOOGLE.name());
        UserAuthSuccessDTO userAuthSuccessDTO = this.googleOAuthService.login(userInfo, accessToken);
        String encodedUsrname = URLEncoder.encode(userAuthSuccessDTO.getUsername(), StandardCharsets.UTF_8);
        String encodedToken = URLEncoder.encode(userAuthSuccessDTO.getToken(), StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create("https://imaps.mk/auth-callback?token=" + encodedToken + "&username=" + encodedUsrname));
        headers.add("Set-Cookie", "Authorization=Bearer " + String.valueOf(userAuthSuccessDTO) + "; HttpOnly; Path=/; SameSite=Strict");
        return new ResponseEntity((Object)userAuthSuccessDTO, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.FOUND);
    }

    Map<String, String> getBodyByProvider(String provider, String code) {
        HashMap<String, String> body = new HashMap<String, String>();
        if (provider.equals(OAuthProviders.GOOGLE.name())) {
            body.put("client_id", this.oAuthConfig.getGOOGLE_CLIENT_ID());
            body.put("client_secret", this.oAuthConfig.getGOOGLE_CLIENT_SECRET());
            body.put("code", code);
            body.put("redirect_uri", this.oAuthConfig.getGOOGLE_REDIRECT_URI());
            body.put("grant_type", "authorization_code");
        } else {
            body.put("client_id", this.oAuthConfig.getGITHUB_CLIENT_ID());
            body.put("client_secret", this.oAuthConfig.getGITHUB_CLIENT_SECRET());
            body.put("code", code);
            body.put("redirect_uri", this.oAuthConfig.getGITHUB_REDIRECT_URI());
            body.put("scope", "user");
        }
        return body;
    }

    private String exchangeCodeForAccessToken(String code, String provider) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        String url = Objects.equals(provider, OAuthProviders.GOOGLE.name()) ? this.oAuthConfig.getGOOGLE_TOKEN_URL() : this.oAuthConfig.getGITHUB_TOKEN_URL();
        Map body = this.getBodyByProvider(provider, code);
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
        Map respBody = (Map)response.getBody();
        return (String)respBody.get("access_token");
    }

    private String fetchUserInfo(String accessToken, String provider) {
        String url = Objects.equals(provider, OAuthProviders.GOOGLE.name()) ? this.oAuthConfig.getGOOGLE_USER_URL() : this.oAuthConfig.getGITHUB_USER_URL();
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        return (String)response.getBody();
    }
}

