/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.entities;

import internettehnologii.imaps.backendRender.web.entities.FloorId;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.util.json.JsonMapData;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="floors")
@IdClass(value=FloorId.class)
public class Floor {
    @JdbcTypeCode(value=3001)
    @Column(name="map_data")
    private JsonMapData mapData;
    @Id
    @Column(name="num")
    private int floorNumber;
    @Id
    @ManyToOne
    @JoinColumn(name="map_id", referencedColumnName="id", nullable=false)
    private IndoorMap indoorMap;

    @PreUpdate
    public void preUpdate() {
        this.indoorMap.setModifiedAt(LocalDateTime.now());
    }

    @Generated
    public JsonMapData getMapData() {
        return this.mapData;
    }

    @Generated
    public int getFloorNumber() {
        return this.floorNumber;
    }

    @Generated
    public IndoorMap getIndoorMap() {
        return this.indoorMap;
    }

    @Generated
    public void setMapData(JsonMapData mapData) {
        this.mapData = mapData;
    }

    @Generated
    public void setFloorNumber(int floorNumber) {
        this.floorNumber = floorNumber;
    }

    @Generated
    public void setIndoorMap(IndoorMap indoorMap) {
        this.indoorMap = indoorMap;
    }

    @Generated
    public String toString() {
        return "Floor(mapData=" + String.valueOf(this.getMapData()) + ", floorNumber=" + this.getFloorNumber() + ", indoorMap=" + String.valueOf(this.getIndoorMap()) + ")";
    }
}

