/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.entities;

import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.entities.RBA.Role;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="users")
public class IMapsUser {
    @Id
    @SequenceGenerator(name="users_id_seq", sequenceName="users_id_seq", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="users_id_seq")
    private int id;
    private String username;
    private String email;
    private String password;
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @Column(name="last_login_at")
    private LocalDateTime lastLoginAt;
    @Column(name="profile_image_url")
    private String profileImageUrl;
    @Column(name="oauth_provider")
    private String OAuthProvider;
    @Column(name="oauth_id")
    private String oAuthId;
    @Column(name="access_token")
    private String accessToken;
    @Column(name="refresh_token")
    private String refreshToken;
    @ManyToMany
    @JoinTable(name="favourites", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="map_id")})
    private Set<IndoorMap> favoriteMaps;
    @ManyToMany(mappedBy="users", cascade={CascadeType.PERSIST})
    private Set<Role> roles = new HashSet();

    public IMapsUser() {
    }

    public IMapsUser(int id, String name, String email, String password) {
        this.id = id;
        this.username = name;
        this.email = email;
        this.password = password;
    }

    public IMapsUser(String name, String email, String password) {
        this.username = name;
        this.email = email;
        this.password = password;
    }

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + "', email='" + this.email + "'}";
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getLastLoginAt() {
        return this.lastLoginAt;
    }

    @Generated
    public String getProfileImageUrl() {
        return this.profileImageUrl;
    }

    @Generated
    public String getOAuthProvider() {
        return this.OAuthProvider;
    }

    @Generated
    public String getOAuthId() {
        return this.oAuthId;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }

    @Generated
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Generated
    public Set<IndoorMap> getFavoriteMaps() {
        return this.favoriteMaps;
    }

    @Generated
    public Set<Role> getRoles() {
        return this.roles;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastLoginAt(LocalDateTime lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @Generated
    public void setProfileImageUrl(String profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
    }

    @Generated
    public void setOAuthProvider(String OAuthProvider) {
        this.OAuthProvider = OAuthProvider;
    }

    @Generated
    public void setOAuthId(String oAuthId) {
        this.oAuthId = oAuthId;
    }

    @Generated
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Generated
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Generated
    public void setFavoriteMaps(Set<IndoorMap> favoriteMaps) {
        this.favoriteMaps = favoriteMaps;
    }

    @Generated
    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }
}

