/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.security;

import internettehnologii.imaps.backendRender.web.service.impl.JWTService;
import internettehnologii.imaps.backendRender.web.service.impl.MapUserDetailsService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtFilter
extends OncePerRequestFilter {
    @Autowired
    private JWTService jwtService;
    @Autowired
    private ApplicationContext context;

    private void sendErrorResponse(HttpServletResponse response, String message, int status) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        response.getWriter().write("{\"error\": \"" + message + "\"}");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        System.out.println(request.getRequestURI());
        if (request.getRequestURI().contains("/login") || request.getRequestURI().contains("/register") || request.getMethod().equals("OPTIONS")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        String authHeader = request.getHeader("Authorization");
        String token = null;
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            token = authHeader.substring(7);
            try {
                String username = this.jwtService.extractUsername(token);
                if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
                    UserDetails userDetails = ((MapUserDetailsService)this.context.getBean(MapUserDetailsService.class)).loadUserByUsername(username);
                    if (this.jwtService.validateToken(token, userDetails)) {
                        UsernamePasswordAuthenticationToken upAuthToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, this.jwtService.getAuthorities(token));
                        System.out.println("TOKEN CLAIMS: " + String.valueOf(this.jwtService.getAuthorities(token)));
                        upAuthToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                        SecurityContextHolder.getContext().setAuthentication((Authentication)upAuthToken);
                    } else {
                        System.out.println("Invalid token");
                        this.sendErrorResponse(response, "The token could not be validated, please try logging in again", 401);
                    }
                } else {
                    System.out.println("Bad auth");
                    this.sendErrorResponse(response, "Username could not be extracted or token not authenticated", 401);
                }
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getMessage());
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

