/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.service.impl;

import internettehnologii.imaps.backendRender.web.entities.Floor;
import internettehnologii.imaps.backendRender.web.entities.IndoorMap;
import internettehnologii.imaps.backendRender.web.exceptions.FloorAlreadyExistsException;
import internettehnologii.imaps.backendRender.web.exceptions.FloorNotFoundException;
import internettehnologii.imaps.backendRender.web.exceptions.InvalidParametersException;
import internettehnologii.imaps.backendRender.web.exceptions.MapNotFoundException;
import internettehnologii.imaps.backendRender.web.repo.FloorRepository;
import internettehnologii.imaps.backendRender.web.repo.MapRepository;
import internettehnologii.imaps.backendRender.web.service.interfaces.FloorService;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FloorServiceImpl
implements FloorService {
    private final FloorRepository floorRepository;
    private final MapRepository mapRepository;

    @Autowired
    public FloorServiceImpl(FloorRepository floorRepository, MapRepository mapRepository) {
        this.floorRepository = floorRepository;
        this.mapRepository = mapRepository;
    }

    public void addFloor(int num, String mapName) {
        IndoorMap indoorMap = (IndoorMap)this.mapRepository.findMapByName(mapName).orElseThrow(() -> new MapNotFoundException(mapName));
        if (this.floorRepository.existsFloorForMap(Integer.valueOf(num), indoorMap)) {
            throw new FloorAlreadyExistsException("Floor: " + num + " already exists for map: " + indoorMap.getName());
        }
        Floor floor = new Floor();
        floor.setFloorNumber(num);
        floor.setIndoorMap(indoorMap);
        this.floorRepository.save((Object)floor);
    }

    public void updateFloor(Floor floor) {
        this.floorRepository.save((Object)floor);
    }

    @Transactional
    public void deleteFloor(int floorNum, String mapName) {
        IndoorMap map = (IndoorMap)this.mapRepository.findMapByName(mapName).orElseThrow(() -> new MapNotFoundException(mapName));
        if (!this.floorRepository.existsFloorForMap(Integer.valueOf(floorNum), map)) {
            throw new FloorNotFoundException("Floor: " + floorNum + " does not exist for map: " + map.getName());
        }
        this.floorRepository.deleteFloorByFloorNumberAndIndoorMap(Integer.valueOf(floorNum), map);
    }

    public List<Floor> getAllFloorsForMap(String mapName) {
        IndoorMap map = (IndoorMap)this.mapRepository.findMapByName(mapName).orElseThrow(() -> new MapNotFoundException(mapName));
        return this.floorRepository.getAllFloorsForMapById(map.getId()).orElseGet(ArrayList::new);
    }

    public Floor getFloorByNum(Integer floorNum, IndoorMap indoorMap) throws InvalidParametersException {
        return indoorMap.getFloors().stream().filter(floor -> floor.getFloorNumber() == floorNum.intValue()).findFirst().orElseThrow(() -> new InvalidParametersException("Could not find floor.\n floorNum: " + floorNum + "\n indoorMap: " + String.valueOf(indoorMap)));
    }
}

