/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.service.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class JWTService {
    private final String secretKey;

    public JWTService() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("HmacSHA256");
            SecretKey sk = keyGen.generateKey();
            this.secretKey = Base64.getEncoder().encodeToString(sk.getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateToken(UserDetails userDetails) {
        HashMap<String, String> claims = new HashMap<String, String>();
        String authorities = userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        claims.put("roles", authorities);
        return ((JwtBuilder)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)Jwts.builder().claims().add(claims)).subject(userDetails.getUsername())).issuedAt(new Date(System.currentTimeMillis()))).expiration(new Date(System.currentTimeMillis() + 3600000L))).and()).signWith((Key)this.getKey()).compact();
    }

    public Collection<GrantedAuthority> getAuthorities(String token) {
        Claims claims = this.extractAllClaims(token);
        String roles = (String)claims.get("roles", String.class);
        return Arrays.stream(roles.split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    private SecretKey getKey() {
        byte[] keyBytes = this.secretKey.getBytes();
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    public String extractUsername(String token) {
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    private Claims extractAllClaims(String token) {
        return (Claims)Jwts.parser().verifyWith(this.getKey()).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    private <T> T extractClaim(String token, Function<Claims, T> claimResolver) {
        Claims claims = this.extractAllClaims(token);
        return claimResolver.apply(claims);
    }

    public boolean validateToken(String token, UserDetails details) {
        String username = this.extractUsername(token);
        return username.equals(details.getUsername()) && !this.isTokenExpired(token);
    }

    private boolean isTokenExpired(String token) {
        return this.extractExpiration(token).before(new Date());
    }

    private Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }
}

