/*
 * Decompiled with CFR 0.152.
 */
package internettehnologii.imaps.backendRender.web.service.impl;

import internettehnologii.imaps.backendRender.web.entities.Report;
import internettehnologii.imaps.backendRender.web.repo.ReportRepository;
import internettehnologii.imaps.backendRender.web.repo.UserRepository;
import internettehnologii.imaps.backendRender.web.service.interfaces.ReportService;
import java.util.List;
import java.util.Optional;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements ReportService {
    private final ReportRepository reportRepository;
    private final JavaMailSender mailSender;
    private final UserRepository userRepository;

    public ReportServiceImpl(ReportRepository reportRepository, JavaMailSender mailSender, UserRepository userRepository) {
        this.reportRepository = reportRepository;
        this.mailSender = mailSender;
        this.userRepository = userRepository;
    }

    public void saveReport(Report report) {
        this.reportRepository.save((Object)report);
    }

    public List<Report> getReports() {
        return this.reportRepository.findAll();
    }

    public void sendMailToAdmins(Report report) {
        SimpleMailMessage message = new SimpleMailMessage();
        Optional adminsOpt = this.userRepository.getAllAdmins();
        System.out.println("MAIL " + String.valueOf(report));
        adminsOpt.ifPresent(admins -> admins.forEach(admin -> {
            message.setTo(admin.getEmail());
            message.setSubject("New Report Submitted");
            String body = String.format("A new report has been submitted:\n\nReport Details:\n\tReport Id: %s\n\tSubject: %s\n\tContent: %s\n\tSubmitted By: %s\n\n", report.getId(), report.getSubject(), report.getContent(), report.getUser() != null ? report.getUser().getUsername() : "Unknown");
            message.setText(body);
            System.out.println("MESSAGE: " + String.valueOf(message));
            this.mailSender.send(message);
        }));
    }
}

