document.getElementById('startScraperButton').addEventListener('click', function() {

    fetch('/admin/start-scraper', { method: 'POST' })
        .then(response => response.json())
        .then(data => alert(data.message))
        .catch(error => console.error('Error:', error));

    fetchLastUpdateTime();
});
function popupConfirm(){
    const div = document.getElementById('warning').style.display = 'block';
}
function popupClose(){
    const div = document.getElementById('warning').style.display = 'none';
}
document.getElementById('confirmDrop').addEventListener('click', function() {

    fetch('/admin/drop-db', {method: 'GET'}).then(r => alert("Database dropped")).catch(err => console.error(err));
    popupClose();
});
function fetchLastUpdateTime() {
    fetch('/admin/last-update-time')
        .then(response => response.json())
        .then(data => {
            document.getElementById('lastUpdateTime').textContent = new Date(data.lastUpdateTime).toLocaleString();
        })
        .catch(error => console.error('Error fetching last update time:', error));
}
function fetchCurrentOptionsCount() {
    fetch('/admin/current-options-count')
        .then(response => response.json())
        .then(data => {
            document.getElementById('currentOptionsCount').textContent = data.currentOptionsCount;
        })
        .catch(error => console.error('Error fetching current options count:', error));
}

// Fetch data when the page loads
document.addEventListener('DOMContentLoaded', function() {
    fetchLastUpdateTime();
    fetchCurrentOptionsCount();
});


document.getElementById('logoutButton').addEventListener('click', function() {
    sessionStorage.removeItem('loggedIn');
    sessionStorage.removeItem('userEmail');
    window.location.href = 'index.html'; // Redirect
});