document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('form-id'); // Ensure the form has the correct ID
    const loadingOverlay = document.getElementById('loadingOverlay');

    form.addEventListener('submit', function(event) {
        event.preventDefault(); // Prevent the default form submission

        // Collect form data
        const formData = new FormData(form);
        const data = {};
        let isValid = true;
        let errorMessage = "";

        // Validate form data
        formData.forEach((value, key) => {
            data[key] = value;
            if (key === "departureDate") {
                const today = new Date();
                const departureDate = new Date(value);
                if (departureDate <= today) {
                    isValid = false;
                    errorMessage += "Датумот на поаѓање е грешен!.\n";
                }
            }
            if (key === "destination" && !value) {
                isValid = false;
                errorMessage += "Внесете дестинација.\n";
            }

        });

        if (!isValid) {
            alert(errorMessage);
            return;
        }

        // Show the loading overlay
        loadingOverlay.style.display = 'flex';

        // Send form data to the server
        fetch('/submit', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
            .then(response => response.json())
            .then(data => {

                loadingOverlay.style.display = 'none';

                const dataList = document.getElementById('givenOptions');
                dataList.innerHTML = '';
                if (data.length === 0) {
                    const wrapper = document.createElement('div');
                    const text = document.createElement('p');
                    text.textContent = "Не се пронајдени резултати за вашето пребарување!";
                    wrapper.appendChild(text);
                    dataList.appendChild(wrapper);
                }
                data.forEach(item => {

                    const optionDiv = document.createElement('div');
                    optionDiv.classList.add('option');
                    //Option from

                    //image
                    const img = document.createElement('img');
                    img.classList.add('image');
                    img.src = item.imgSrc; // Use item.imageSrc if available
                    optionDiv.appendChild(img);
                    const WrapperDiv = document.createElement('div');
                    optionDiv.appendChild(WrapperDiv);
                    //hotel
                    const nameParagraph = document.createElement('p');
                    nameParagraph.id = 'name';
                    nameParagraph.textContent = item.hotelName;
                    WrapperDiv.appendChild(nameParagraph);

                    //Destination
                    const countryParagraph = document.createElement('p');
                    countryParagraph.id = 'country';
                    countryParagraph.style.fontSize = '20px';
                    countryParagraph.textContent = item.country;
                    WrapperDiv.appendChild(countryParagraph);
                    const dateParagraph = document.createElement('h2');
                    dateParagraph.id = 'date';
                    dateParagraph.textContent = item.dateRange;
                    WrapperDiv.appendChild(dateParagraph);
                    //price
                    const priceHeading = document.createElement('h1');
                    priceHeading.textContent = 'Цена:';
                    WrapperDiv.appendChild(priceHeading);
                    const priceParagraph = document.createElement('h2');
                    priceParagraph.id = 'price';
                    priceParagraph.textContent = item.price + "EUR";
                    WrapperDiv.appendChild(priceParagraph);

                    //  link and button
                    const link = document.createElement('a');
                    link.id = 'link';
                    link.href = item.link; // Use item.link if available
                    link.target = '_blank'; // Open link in new tab

                    const button = document.createElement('button');
                    button.classList.add('btn', 'login-button');
                    button.textContent = 'Линк до страна';
                    const btnWrapDiv = document.createElement('div');
                    btnWrapDiv.classList.add('btnWrapper');
                    const favBtn = document.createElement('button');
                    favBtn.classList.add('favBtn','btn');
                    favBtn.id = 'favBtnId';
                    favBtn.textContent = 'Додадете во омилени';
                    favBtn.setAttribute('data-option-id', item.id);
                    favBtn.addEventListener('click', function () {
                        const optionId = this.getAttribute('data-option-id');
                        saveFavoriteOption(optionId);
                    });

                    btnWrapDiv.appendChild(link);
                    link.appendChild(button);
                    btnWrapDiv.appendChild(favBtn);

                    optionDiv.appendChild(btnWrapDiv);
                    // Append option div to dataList
                    dataList.appendChild(optionDiv);
                });
                updateFavoriteButtons();
            })
            .catch(error => {
                console.error('Error fetching data:', error);
                // Hide the loading overlay in case of error
                loadingOverlay.style.display = 'none';
            });
    });
});
