function getUserDetails() {
    return JSON.parse(sessionStorage.getItem('user'));
}

function deleteAccount() {
    fetch('/delete-account', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(getUserDetails())
    })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                sessionStorage.clear();
                logout();
                alert('Account deleted successfully');
            } else {
                alert('Failed to delete account: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to delete account: ' + error.message);
        });
}

function logout() {
    sessionStorage.clear();
    document.cookie = "sessionId=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
    showLoggedOutState();
    fetch('/account/logout', {
        method: 'POST',
        credentials: 'include'
    });
}

function openAccountDetails() {
    document.getElementById('AccountDetailsOverlay').style.display = 'block';
}

function confirmDelete() {
    document.getElementById('confDel').style.display = 'block';
}

function closeConfirmDelete() {
    document.getElementById('confDel').style.display = 'none';
}

function openLoginPopup() {
    document.getElementById('loginPopup').style.display = 'block';
}

function closeLoginPopup() {
    document.getElementById('loginPopup').style.display = 'none';
}

function openRegisterPopup() {
    document.getElementById('registerPopup').style.display = 'block';
}

function closeRegisterPopup() {
    document.getElementById('registerPopup').style.display = 'none';
}

function showLoggedInState() {
    document.getElementById('loginButton').style.display = 'none';
    document.getElementById('logoutButton').style.display = 'block';
    document.getElementById('savedTripsButton').style.display = 'block';
    document.getElementById('accBtn').style.display = 'block';

    var style = document.createElement('style');
    style.innerHTML = '.favBtn { display: block; }';
    document.head.appendChild(style);

    if (sessionStorage.getItem('isAdmin') === 'true') {
        document.getElementById('adminPanelButton').style.display = 'block';
    }
}


function showMessage(elementId, type, message) {
    const element = document.getElementById(elementId);
    if (!element) {
        console.error(`Element with id ${elementId} not found`);
        return;
    }
    element.textContent = message;
    element.className = `message ${type}`;
}


function showLoggedOutState() {
    document.getElementById('loginButton').style.display = 'block';
    document.getElementById('logoutButton').style.display = 'none';
    document.getElementById('savedTripsButton').style.display = 'none';
    document.getElementById('accBtn').style.display = 'none';
    var style = document.createElement('style');
    style.innerHTML = '.favBtn { display: none; }';
    document.head.appendChild(style);
    document.getElementById('loginResponse').style.display = 'none';
    document.getElementById('adminPanelButton').style.display = 'none';
}

function goToAdminPanel() {
    window.location.href = '/admin-panel';
}
function showLoginFeedback(success, message) {
    const loginResponse = document.getElementById('loginResponse');
    loginResponse.textContent = message;
    loginResponse.style.color = success ? 'green' : 'red';
    loginResponse.style.display = 'block';
}

window.onclick = function(event) {
    const loginPopup = document.getElementById('loginPopup');
    const registerPopup = document.getElementById('registerPopup');
    const accountPopup = document.getElementById('AccountDetailsOverlay');
    if (event.target === loginPopup) {
        loginPopup.style.display = 'none';
    }
    if (event.target === registerPopup) {
        registerPopup.style.display = 'none';
    }
    if (event.target === accountPopup) {
        accountPopup.style.display = 'none';
    }
}

document.addEventListener('DOMContentLoaded', function() {
    checkSession();

    document.querySelectorAll('.favBtn').forEach(button => {
        button.addEventListener('click', function() {
            const optionId = this.getAttribute('data-option-id');
            saveFavoriteOption(optionId);
        });
    });

    document.getElementById('savedTripsButton').addEventListener('click', function() {
        document.getElementById('savedTripsOverlay').style.display = 'block';
        fetchSavedTrips();
        //fetchPriceChanges();
    });

    document.querySelector('.close').addEventListener('click', function() {
        document.getElementById('savedTripsOverlay').style.display = 'none';
    });
});


function saveFavoriteOption(optionId) {
    const mail = sessionStorage.getItem('user').replace(/^"|"$/g, '');
    fetch('/save-favorite', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ optionId: optionId, user: mail })
    })
        .then(response => {
            if (response.ok) {
                return response.json();
            }
            throw new Error('Network response was not ok.');
        })
        .then(data => {
            console.log('Option saved:', data);
            // Update the UI to reflect that the option was saved
            updateFavoriteButtons();
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function updateFavoriteButtons() {
    const mail = sessionStorage.getItem('user').replace(/^"|"$/g, '');
    fetch('/get-saved-trips', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ userEmail: mail })
    })
        .then(response => response.json())
        .then(data => {
            // Extract the option IDs of saved trips
            const savedOptionIds = data.savedTrips.map(trip => trip.id);

            document.querySelectorAll('.favBtn').forEach(button => {
                const optionId = parseInt(button.getAttribute('data-option-id'), 10);
                if (savedOptionIds.includes(optionId)) {
                    button.disabled = true;
                    button.textContent = 'Зачувано';
                } else {
                    button.disabled = false;
                    button.textContent = 'Додадете во омилени';
                }
            });
        })
        .catch(error => {
            console.error('Error fetching saved options:', error);
        });
}

function fetchSavedTrips() {
    const userEmail = sessionStorage.getItem('user').replace(/^"|"$/g, '');
    fetch('/get-saved-trips', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ userEmail: userEmail })
    })
        .then(response => response.json())
        .then(data => {

            const savedTripsList = document.getElementById('savedTripsList');
            savedTripsList.innerHTML = '';
            data.savedTrips.forEach(trip => {
                const tripDiv = document.createElement('div');
                tripDiv.classList.add('option');

                const closeButton = document.createElement('button');
                closeButton.classList.add('remove-option');
                closeButton.textContent = '×';
                closeButton.onclick = function() {
                    removeFromSaved(trip.id);
                };
                tripDiv.appendChild(closeButton);

                const hotelName = document.createElement('p');
                hotelName.textContent = trip.hotelName;
                const country = document.createElement('p');
                country.textContent = trip.country;
                const price = document.createElement('p');
                price.textContent = trip.price + "€";

                tripDiv.appendChild(hotelName);
                tripDiv.appendChild(country);
                tripDiv.appendChild(price);

                savedTripsList.appendChild(tripDiv);
            });


            const priceChangesList = document.getElementById('priceChangesList');
            priceChangesList.innerHTML = '';
            const priceChanges = data.savedTrips.filter(trip => trip.priceChanged);
            if (priceChanges.length > 0) {
                priceChanges.forEach(change => {
                    const changeDiv = document.createElement('div');
                    changeDiv.classList.add('price-change');
                    changeDiv.textContent = `Цената на ${change.hotelName} има промена од ${change.price}€ во ${change.newPrice}€`;
                    priceChangesList.appendChild(changeDiv);
                });
            } else {
                priceChangesList.textContent = "нема промена на цената.";
            }
        })
        .catch(error => {
            console.error('Error fetching saved trips:', error);
        });
}
function removeFromSaved(optionId) {
    const userEmail = sessionStorage.getItem('user').replace(/^"|"$/g, '');
    fetch('/remove-from-saved', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ optionId: optionId, userEmail: userEmail })
    })
        .then(response => {
            if (response.ok) {
                return response.json();
            }
            throw new Error('Network response was not ok.');
        })
        .then(data => {
            if (data.success) {
                fetchSavedTrips();
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}
