document.addEventListener('DOMContentLoaded', function() {
    const loginForm = document.getElementById('loginForm');
    const registerForm = document.getElementById('registerForm');
    const loginResponse = document.getElementById('loginResponse');
    const registerResponse = document.getElementById('registerResponse');

    checkSession();

    loginForm.addEventListener('submit', function(event) {
        event.preventDefault();

        const email = loginForm.email.value;
        const password = loginForm.password.value;

        const data = {
            email: email,
            password: password
        };

        fetch('/account/login', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
            .then(response => response.json())
            .then(data => {
                if (data.sessionId) {
                    loginResponse.textContent = data.message;
                    sessionStorage.setItem('loggedIn', 'true');
                    sessionStorage.setItem('user', JSON.stringify(email));
                    sessionStorage.setItem('isAdmin', data.isAdmin);
                    document.cookie = `sessionId=${data.sessionId}; path=/`;
                    showLoggedInState();
                    closeLoginPopup();
                } else {
                    throw new Error(data.message);
                }
            })
            .catch(error => {
                showMessage('loginResponse', 'error', error.message);
            });
    });

    registerForm.addEventListener('submit', function(event) {
        event.preventDefault();

        const username = registerForm.username.value;
        const email = registerForm.email.value;
        const password = registerForm.password.value;

        const data = {
            username: username,
            email: email,
            password: password
        };

        fetch('/account/register', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
            .then(response => response.json())
            .then(data => {
                if (response.ok) {
                    showMessage('registerResponse', 'success', data.message);
                    closeRegisterPopup();
                } else {
                    throw new Error(data.message);
                }
            })
            .catch(error => {
                showMessage('registerResponse', 'error', error.message);
            });
    });
});

function checkSession() {
    fetch('/account/session', {
        method: 'GET',
        credentials: 'include'
    })
        .then(response => response.json())
        .then(data => {
            if (data.loggedIn) {
                sessionStorage.setItem('loggedIn', 'true');
                sessionStorage.setItem('user', JSON.stringify(data.user));
                sessionStorage.setItem('isAdmin', data.isAdmin);
                showLoggedInState();
            } else {
                sessionStorage.clear();
                showLoggedOutState();
            }
        })
        .catch(error => {
            console.error('Error checking session:', error);
            sessionStorage.clear();
            showLoggedOutState();
        });
}

function logout() {
    fetch('/account/logout', {
        method: 'POST',
        credentials: 'include'
    })
        .then(response => {
            if (response.ok) {
                sessionStorage.clear();
                document.cookie = "sessionId=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
                showLoggedOutState();
            } else {
                throw new Error('Logout failed');
            }
        })
        .catch(error => {
            console.error('Error logging out:', error);
        });
}


function handleCredentialResponse(response) {
    const email = JSON.parse(atob(response.credential.split('.')[1])).email;
    fetch('/account/login', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ id_token: response.credential })
    })
        .then(response => response.json())
        .then(data => {
            if (data.sessionId) {
                sessionStorage.setItem('loggedIn', 'true');
                sessionStorage.setItem('user', JSON.stringify(email));
                sessionStorage.setItem('isAdmin', data.isAdmin);
                document.cookie = `sessionId=${data.sessionId}; path=/`;
                showLoggedInState();
                closeLoginPopup();
            } else {
                throw new Error(data.message);
            }
        })
        .catch(error => {
            console.error(error);
            showMessage('loginResponse', 'error', 'Google login failed');
        });
}



