import java.util.Objects;

public class Option {
    private int id;
    private String hotelName;
    private String country;
    private float price;
    private String link;
    private String imgSrc;

    //Price changing
    private float newPrice = 0;
    private boolean isPriceChanged = false;
    private String dateRange;
    // Constructor
    public Option(){
        price = 0;
    }

    public void setDateRange(String dateRange) {
        this.dateRange = dateRange;
    }

    public String getDateRange() {
        return dateRange;
    }

    public boolean isEmpty(){
        return (hotelName == null || country == null || price == 0 || link == null || imgSrc == null);
    }
    public String getHotelName() {
        return hotelName;
    }

    public void setHotelName(String hotelName) {
        this.hotelName = hotelName;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public float getPrice() {
        return price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setImgSrc(String imgSrc) {
        this.imgSrc = imgSrc;
    }

    public String getImgSrc() {
        return imgSrc;
    }

    @Override
    public boolean equals(Object obj) {
        if(this==obj) return true;
        if(obj == null || getClass() != obj.getClass()) return false;
        Option option = (Option) obj;
        return Float.compare(option.price, price) == 0
                && Objects.equals(hotelName, option.hotelName)
                && Objects.equals(country, option.country)
                && Objects.equals(link, option.link);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hotelName,country,price,link);
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    //debug
    @Override
    public String toString() {
        return "Option{" +
                "id='" + id + '\'' +
                "dateRange='" + dateRange + '\'' +
                "hotelName='" + hotelName + '\'' +
                ", country='" + country + '\'' +
                ", price='" + price + '\'' +
                ", link='" + link + '\'' +
                ", image='" + imgSrc +
                '}';
    }

    public void setPriceChanged(boolean a){
        isPriceChanged = a;
    }
    public void setNewPrice(float a){
        newPrice = a;
    }

    public boolean isPriceChanged() {
        return isPriceChanged;
    }

    public float getNewPrice() {
        return newPrice;
    }
}
