document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('form-id');
    const loadingOverlay = document.getElementById('loadingOverlay');

    form.addEventListener('submit', function(event) {
        event.preventDefault();

        const formData = new FormData(form);
        const data = {};
        let isValid = true;
        let errorMessage = "";

        formData.forEach((value, key) => {
            data[key] = value;
            if (key === "departureDate") {
                const today = new Date();
                const departureDate = new Date(value);
                if (departureDate <= today) {
                    isValid = false;
                    errorMessage += "Датумот на поаѓање е грешен!.\n";
                }
            }
            if (key === "destination" && !value) {
                isValid = false;
                errorMessage += "Внесете дестинација.\n";
            }
        });

        if (!isValid) {
            alert(errorMessage);
            return;
        }

        loadingOverlay.style.display = 'flex';

        fetch('/submit', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                loadingOverlay.style.display = 'none';
                const dataList = document.getElementById('givenOptions');
                dataList.innerHTML = '';
                if (data.length === 0) {
                    const wrapper = document.createElement('div');
                    const text = document.createElement('p');
                    text.textContent = "Не се пронајдени резултати за вашето пребарување!";
                    wrapper.appendChild(text);
                    dataList.appendChild(wrapper);
                } else {
                    data.forEach(item => {
                        const optionDiv = document.createElement('div');
                        optionDiv.classList.add('option');

                        const img = document.createElement('img');
                        img.classList.add('image');
                        img.src = item.imgSrc || '';
                        optionDiv.appendChild(img);
                        const WrapperDiv = document.createElement('div');
                        optionDiv.appendChild(WrapperDiv);

                        const nameParagraph = document.createElement('p');
                        nameParagraph.id = 'name';
                        nameParagraph.textContent = item.hotelName || 'N/A';
                        WrapperDiv.appendChild(nameParagraph);

                        const countryParagraph = document.createElement('p');
                        countryParagraph.id = 'country';
                        countryParagraph.style.fontSize = '20px';
                        countryParagraph.textContent = item.country || 'N/A';
                        WrapperDiv.appendChild(countryParagraph);

                        const dateParagraph = document.createElement('h2');
                        dateParagraph.id = 'date';
                        dateParagraph.textContent = item.dateRange || 'N/A';
                        WrapperDiv.appendChild(dateParagraph);

                        const peopleParagraph = document.createElement('p');
                        peopleParagraph.id = 'numPeople';
                        peopleParagraph.textContent = item.numPeople === 1 ? item.numPeople + " лице" : item.numPeople + " лица";
                        WrapperDiv.appendChild(peopleParagraph);

                        const priceHeading = document.createElement('h1');
                        priceHeading.textContent = 'Цена:';
                        WrapperDiv.appendChild(priceHeading);
                        const priceParagraph = document.createElement('h2');
                        priceParagraph.id = 'price';
                        priceParagraph.textContent = (item.price || 0) + " EUR";
                        WrapperDiv.appendChild(priceParagraph);

                        const infoDiv = document.createElement('div');
                        infoDiv.classList.add("infoDiv");
                        const typeRoom = document.createElement('p');
                        typeRoom.textContent = "Тип на соба: " + (item.type || 'N/A');
                        infoDiv.appendChild(typeRoom);
                        const plan = document.createElement('p');
                        plan.textContent = "Услуга: " + (item.board || 'N/A');
                        infoDiv.appendChild(plan);
                        const amenities = document.createElement('p');
                        amenities.textContent = item.amenities && item.amenities.length > 0 ? "Поволности: " + item.amenities : "Нема информации од агенцијата за вклучените поволности.";
                        infoDiv.appendChild(amenities);
                        optionDiv.appendChild(infoDiv);

                        const link = document.createElement('a');
                        link.id = 'link';
                        link.href = item.link || '#';
                        link.target = '_blank';

                        const button = document.createElement('button');
                        button.classList.add('btn', 'login-button');
                        button.textContent = 'Линк до страна';
                        const btnWrapDiv = document.createElement('div');
                        btnWrapDiv.classList.add('btnWrapper');
                        const favBtn = document.createElement('button');
                        favBtn.classList.add('favBtn', 'btn');
                        favBtn.id = 'favBtnId';
                        favBtn.textContent = 'Додадете во омилени';
                        favBtn.setAttribute('data-option-id', item.id);
                        favBtn.addEventListener('click', function () {
                            const optionId = this.getAttribute('data-option-id');
                            saveFavoriteOption(optionId);
                        });

                        btnWrapDiv.appendChild(link);
                        link.appendChild(button);
                        btnWrapDiv.appendChild(favBtn);

                        optionDiv.appendChild(btnWrapDiv);
                        dataList.appendChild(optionDiv);
                    });
                    console.log('Finished processing data.');
                }
                updateFavoriteButtons();
            })
            .catch(error => {
                console.error('Error fetching data:', error);
                loadingOverlay.style.display = 'none';
            });
    });
});
