import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Option {
    private int id;
    private int detail_id;
    private String hotelName;
    private String country;
    private float price;
    private String link;
    private String imgSrc;
    private String type;
    private String board;
    private String amenities;
    private int numPeople;
    private String dateRange;
    private List<Change> changes = new ArrayList<>();

    public String getDateRange() {
        return dateRange;
    }

    public void setDateRange(String dateRange) {
        this.dateRange = dateRange;
    }

    public int getDetail_id() {
        return detail_id;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDetail_id(int detail_id) {
        this.detail_id = detail_id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBoard() {
        return board;
    }

    public void setBoard(String board) {
        this.board = board;
    }

    public String getAmenities() {
        return amenities;
    }

    public void setAmenities(String amenities) {
        this.amenities = amenities;
    }

    public int getNumPeople() {
        return numPeople;
    }

    public void setNumPeople(int numPeople) {
        this.numPeople = numPeople;
    }

    public String getHotelName() {
        return hotelName;
    }

    public void setHotelName(String hotelName) {
        this.hotelName = hotelName;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public float getPrice() {
        return price;
    }

    public void setPrice(float price) {
        this.price = price;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getImgSrc() {
        return imgSrc;
    }

    public void setImgSrc(String imgSrc) {
        this.imgSrc = imgSrc;
    }

    public void addChange(String attribute, String oldValue, String newValue) {
        this.changes.add(new Change(attribute, oldValue, newValue));
    }

    public List<Change> getChanges() {
        return changes;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        Option option = (Option) obj;
        return Float.compare(option.price, price) == 0
                && Objects.equals(hotelName, option.hotelName)
                && Objects.equals(country, option.country)
                && Objects.equals(link, option.link);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hotelName, country, price, link);
    }

    @Override
    public String toString() {
        return "Option{" +
                "id=" + id +
                ", dateRange='" + dateRange + '\'' +
                ", hotelName='" + hotelName + '\'' +
                ", country='" + country + '\'' +
                ", price=" + price +
                ", link='" + link + '\'' +
                ", imgSrc='" + imgSrc + '\'' +
                ", type='" + type + '\'' +
                ", board='" + board + '\'' +
                ", amenities='" + amenities + '\'' +
                ", numPeople=" + numPeople +
                ", changes=" + changes +
                '}';
    }

    public boolean isEmpty() {
        return (link.isEmpty() || country.isEmpty() || hotelName.isEmpty());
    }
}

