# Generated by Django 5.1.7 on 2025-07-12 11:56

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('auth_form', '0018_student_disliked_subjects_student_liked_subjects'),
        ('subjects', '0003_remove_subject_info_short'),
    ]

    operations = [
        migrations.CreateModel(
            name='EvaluationReview',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='EvaluationMethod',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('note', models.CharField(blank=True, max_length=64, null=True)),
                ('evaluation_review', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.evaluationreview')),
            ],
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_confirmed', models.BooleanField(default=False, help_text='Has an admin confirmed this post is valid.')),
                ('upvotes', models.IntegerField(default=0)),
                ('downvotes', models.IntegerField(default=0)),
                ('review_type', models.CharField(choices=[('evaluation', 'Evaluation'), ('other', 'Other')], max_length=16)),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='auth_form.student')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.subject')),
            ],
        ),
        migrations.CreateModel(
            name='OtherReview',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField()),
                ('category', models.CharField(choices=[('material', 'Material'), ('staff', 'Staff'), ('other', 'Other')], max_length=16)),
                ('review', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='subjects.review')),
            ],
        ),
        migrations.AddField(
            model_name='evaluationreview',
            name='review',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='subjects.review'),
        ),
        migrations.CreateModel(
            name='EvaluationComponent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(choices=[('project', 'Project'), ('theory', 'Theory'), ('practical', 'Practical'), ('homework', 'Homework'), ('labs', 'Labs'), ('presentation', 'Presentation'), ('attendance', 'Attendance')], max_length=16)),
                ('percentage', models.IntegerField(validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(100)])),
                ('evaluation_method', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.evaluationmethod')),
            ],
            options={
                'constraints': [models.UniqueConstraint(fields=('evaluation_method', 'category'), name='unique_component_per_method')],
            },
        ),
    ]
