"""
URL configuration for backend project.

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/5.1/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include
from subjects.views import index, all_subjects, get_suggestions

urlpatterns = [
    path('admin/', admin.site.urls),
    path('subjects/', all_subjects),
    path('suggestion/', get_suggestions),
    # path('subjects/<str:code>/', subject_view),
    path('auth/', include('auth_form.urls')),
    path('', index),
]
