import React, {useEffect, useState} from "react";
import "../shared_css/Modal.css";

import 'react-responsive-modal/styles.css';
import {Modal} from 'react-responsive-modal';
import Select from "react-select";

//Validation
import * as yup from "yup";
import {yupResolver} from "@hookform/resolvers/yup";
import {Controller, useForm} from "react-hook-form";


import {employmentStatusOptions, industryOptions, jobTypeOptions} from "../selectOptions";
import {useDispatch, useSelector} from "react-redux";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import Roles from "../../enumerations/Roles";
import {ApplicationActions} from "../../redux/actions/applicationActions";


export const ApplicationDetailsModal = (props) => {
    const {application} = props
    const [modal, setModal] = useState(false);
    const dispatch = useDispatch();
    const auth = useSelector(state => state.auth.currentUser)
    const [resumeUrl, setResumeUrl] = useState("");

    //const [resumeFile, setResumeFile] = useState(null);
    const toggleModal = () => {
        setModal(!modal);
    };

    useEffect(() => {
        if (application) {
            ApplicationActions.downloadResume(application.id, (success, response) => {
                if (success) {
                    setResumeUrl(response);
                }
            })
        }
    }, [])

    function getFileName(path) {
        let fileName = path.split('\\').pop().split('/').pop();

        fileName = fileName.trim();

        return fileName;
    }

    return (<div className="modal-wrap">
        <button onClick={toggleModal} className="application-button">View application</button>
        <Modal open={modal} onClose={toggleModal} center>
            <div className="head-modal">
                <h3>{application.jobSeekerName}'s application for {application.jobAdTitle}</h3>
                <i className="fa-solid fa-x btn-close-modal" onClick={toggleModal}></i>
            </div>

            <div className="modal-content">
                <form>
                    <div className="row">
                        <div className="col-md-6">
                            <label className="label">Why are you interested in joining our company?</label>
                            <textarea disabled type="text" defaultValue={application.questionAnswers[0]} disabled
                                      placeholder="Write your answer here..." className="application-textarea"/>
                            <br/><br/>
                            <label className="label">What makes you a good fit for this position?</label>
                            <textarea disabled type="text" defaultValue={application.questionAnswers[1]}
                                      placeholder="Write your answer here..." className="application-textarea"/>
                            <br/><br/>
                            <label className="label">What do you hope to achieve in your first 6 months in this
                                role?</label>
                            <textarea disabled type="text" defaultValue={application.questionAnswers[2]}
                                      placeholder="Write your answer here..." className="application-textarea"/>

                        </div>
                        <div className="col-md-6">
                            <label htmlFor="start">Curriculum vitae (CV)</label>
                            <br/>
                            <a className="resume-link" href={resumeUrl} target="_blank"
                               rel="noopener noreferrer">{getFileName(application.fileName)}</a>
                            <br/>

                            <br/>
                            <label className="label">Message to the recruiter</label>
                            <textarea disabled type="text" defaultValue={application.message} placeholder="Optional..."
                                      className="application-textarea"/>

                        </div>
                    </div>

                </form>
            </div>
        </Modal>
    </div>)
}