package mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.controllers;

import lombok.AllArgsConstructor;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users.DTO.RecruiterDetailsDTO;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.service.intef.RecruiterService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/recruiter")
@AllArgsConstructor
@CrossOrigin(origins = "*")
public class RecruiterController {

    private final RecruiterService recruiterService;

    @GetMapping("/info/{id}")
    public ResponseEntity<?> getRecruiterDetailsById(@PathVariable("id") Long id) {
        RecruiterDetailsDTO recruiterDetailsDTO = recruiterService.getRecruiterDetailsById(id);
        return new ResponseEntity<>(recruiterDetailsDTO, HttpStatus.OK);
    }
}
