import "./JobAdDetails.css"
import {useEffect, useState} from "react";
import {useDispatch, useSelector} from "react-redux";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import {useParams} from "react-router";
import Roles from "../../enumerations/Roles";
import JobType from "../../enumerations/JobType";
import EmploymentStatus from "../../enumerations/EmploymentStatus";
import {formatRelativeTime} from "../../utils/utils";
import {AddJobAdModal} from "./AddJobAdModal";


export const JobAdDetails = () => {
    const dispatch = useDispatch();
    const [jobAd, setJobAd] = useState("")
    const [recruiterDetails, setRecruiterDetails] = useState("");
    const [role, setRole] = useState("")
    const {id} = useParams();
    const auth = useSelector(state => state.auth.currentUser);

    useEffect(() => {
        setRole(auth.role)
    }, [auth])


    useEffect(() => {
        JobAdvertisementActions.fetchJobAdvertisementById(id, (success, response) => {
            if (success) {
                setJobAd(response.data)
                JobAdvertisementActions.fetchRecruiterDetailsById(response.data.recruiterId, (successAgain, responseAgain) => {
                    if(successAgain) {
                        setRecruiterDetails(responseAgain.data)
                    }
                })
            }
        });
    }, [])
    return (<div className="container">
        <div className="row">
            <div className="col-md-9">
                <div className="details-wrap">

                    <div className="title">
                        <h2>{jobAd.title} </h2>
                        <span className="job-type"> {jobAd.jobType===JobType.JOB ? "Job" : "Internship"}</span>
                        {!jobAd.active && <span className="expired">Expired</span>}
                    </div>

                    <p className="details-head-info">
                        <span><b>{jobAd.recruiterName}</b></span> • <span>{jobAd.industry}</span> • <span>{formatRelativeTime(jobAd.postedOn)}</span>
                    </p>

                    <p><i className="fa-solid fa-money-check-dollar"></i> <span>Hourly rate: ${jobAd.startingSalary}</span></p>
                    <p><i className="fa-solid fa-briefcase"></i> Employment status: {jobAd.employmentStatus===EmploymentStatus.FULL_TIME ? "Full-time" : "Part-time"}</p>
                    <p><i className="fa-solid fa-calendar-days"></i> Active until: {new Date(jobAd.activeUntil).toLocaleString('default', { day: 'numeric', month: 'long',  year: 'numeric' })}</p>

                    <h4>About the job</h4>
                    {jobAd.description && (
                        <p dangerouslySetInnerHTML={{ __html: jobAd.description.replace(/\n/g, "<br>") }}></p>
                    )}


                    {role===Roles.JOBSEEKER &&
                        <>
                            {jobAd.active && <button className="card-button apply">Apply now</button> }
                            {!jobAd.active && <button className="card-button apply disabled">Apply now</button> }
                        </>
                    }

                </div>
            </div>
            <div className="col-md-3">
                <div className="details-wrap">
                    <h3>{jobAd.recruiterName}</h3>

                    {/*TO DO - AFTER IMPLEMENTING FORM FOR UPDATING PERSONAL INFO*/}
                    <h4>About the company</h4>
                    <p>As a pioneering Swiss software company, we provide innovative IT products and tailored digital solutions. We bring decades of experience in designing, developing, and implementing highly scalable, secure, and user-centric software.
                        <br/><br/>
                        Working across the banking, payment, mobility, health, and publishing industries, we are experts at delivering seamless and secure user journeys within these privacy-driven environments. Our business-critical applications are designed to overcome complexity and drive growth.
                        <br/><br/>
                        We are based in Zurich, Switzerland, and have offices elsewhere in Europe, Asia, and the Middle East. Founded in 1996, we are a business of 800 experts, enabling our clients to create value with trusted software..
                    </p>
                    <p><span><i className="fa-solid fa-envelope"></i> {recruiterDetails.email}</span> • <span>
                <i className="fa-solid fa-phone"></i> {recruiterDetails.phoneNumber}</span>
                    </p>
                </div>
            </div>

        </div>



    </div>)
}