import {AddJobAdModal} from "./AddJobAdModal";

import "./JobAdvertisements.css"
import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import {formatRelativeTime, sortElementsByDateCreated} from "../../utils/utils";
import {dataRangeOptions, industryOptions, sortOptions} from "../selectOptions";
import Select from "react-select";
import {DeleteJobAdModal} from "./DeleteJobAdModal";
import {EditJobAdModal} from "./EditJobAdModal";
import {Link} from "react-router-dom";
import JobType from "../../enumerations/JobType";

export const JobAdvertisements = () => {

    const dispatch = useDispatch();
    const [jobAdvertisementsByRecruiter, setJobAdvertisementsByRecruiter] = useState([]);
    const auth = useSelector(state => (state.auth.currentUser))
    let jobAdvertisementsByRecruiterState = useSelector(state => (state.jobAd.jobAdvertisementsByRecruiter))

    const [role, setRole] = useState("");
    const [sortOrder, setSortOrder] = useState("newest");
    const [selectedDateRange, setSelectedDateRange] = useState("all");
    const [searchTerm, setSearchTerm] = useState("");
    const [dispatched, setDispatched] = useState(false)


    useEffect(() => {
        if (auth) {
            setRole(auth.role);
        }
    }, [auth]);

    useEffect(() => {
        if (!dispatched && jobAdvertisementsByRecruiterState.length === 0) {
            dispatch(JobAdvertisementActions.fetchJobAdvertisementsByRecruiter("deleteThis", (success, response) => {
                if (success && response.data.length > 0) {
                    setJobAdvertisementsByRecruiter(sortElementsByDateCreated(response.data))
                }
                console.log("Fetch job advertisements by recruiter GET")
            }))
            setDispatched(true);

        } else {
            setJobAdvertisementsByRecruiter(jobAdvertisementsByRecruiterState)
            console.log("Fetch job advertisements by recruiter STATE")
        }
    }, [jobAdvertisementsByRecruiterState])

    return (
        <div className="container">
            <div className="head-job-advertisements-box">
                <div className="row">
                    <div className="col-md-3">
                        <div className="search-container head-component">
                            <i className="fa-solid fa-magnifying-glass blue-colored"></i>
                            <input
                                className="search-input"
                                type="text"
                                placeholder="Search job advertisement by title..."
                                //value={searchTerm}
                                //onChange={event => setSearchTerm(event.target.value)}
                            />
                        </div>
                    </div>
                    <div className="col-md-9">

                        <AddJobAdModal/>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "newest", label: "Date (Newest First)"}}
                                //value={sortOrder.value}
                                //onChange ={option => setSortOrder(option.value)}
                                options={sortOptions}
                                className="sort-range sort"
                            />
                        </div>
                        <div className="date-range-section item">
                            <Select
                                defaultValue={{value: "all", label: "Lifetime"}}
                                //value={selectedDateRange.value}
                                //onChange={option => setSelectedDateRange(option.value)}
                                options={dataRangeOptions}
                                className="date-range sort"
                            />
                        </div>
                    </div>
                </div>
            </div>
            <div className="row row-cols-1 row-cols-md-4 g-4">

                {jobAdvertisementsByRecruiter &&
                    jobAdvertisementsByRecruiter.map((jobAd, index) => (
                        <div key={index} className="col">
                            <div className="custom-card">
                                <div className="card-head">
                                    <span className="hourly-salary"><b>${jobAd.startingSalary}/hr</b></span>
                                    <span className="job-type"> {jobAd.jobType===JobType.JOB ? "Job" : "Internship"}</span>
                                    {!jobAd.active && <span className="expired">Expired</span>}
                                    <div className="card-management-btns">
                                        <DeleteJobAdModal props={jobAd}/>
                                        <EditJobAdModal props={jobAd}/>
                                    </div>
                                </div>
                                <div className="card-body">
                                    <h5 className="card-title">{jobAd.title}</h5>
                                    <span>{jobAd.industry} • <span style={{color: "black", fontWeight: "bold"}}>{formatRelativeTime(jobAd.postedOn)}</span></span>
                                    <div className="card-info">
                                        <span><i className="fa-solid fa-building" style={{color: "#000000"}}></i> Company: <span style={{color: "black", fontWeight: "bold"}}>{jobAd.recruiterName}</span></span> <br/>
                                    </div>

                                    <div className="aligned">
                                        <Link to={`/my-job-advertisements/view/${jobAd.id}`} className="card-button solo">View applications</Link>
                                    </div>

                                </div>
                            </div>
                        </div>
                    ))}

            </div>
        </div>
    )
}