package mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.service.impl;

import lombok.RequiredArgsConstructor;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.enumerations.EmploymentStatus;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.enumerations.JobType;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.job_advertisements.DTO.JobAdDetailsDTO;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.job_advertisements.DTO.JobAdvertisementDTO;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.job_advertisements.JobAdvertisement;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users.User;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.repositories.JobAdvertisementRepository;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.repositories.UserRepository;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.service.intef.JobAdvertisementService;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Service
@RequiredArgsConstructor
public class JobAdvertisementServiceImpl implements JobAdvertisementService {
    private final UserRepository userRepository;
    private final JobAdvertisementRepository jobAdvertisementRepository;

    @Override
    public JobAdDetailsDTO addJobAdvertisement(JobAdvertisementDTO jobAdvertisementDTO) {
        User recruiter = userRepository.findByEmail(jobAdvertisementDTO.getEmail()).orElseThrow(() -> new IllegalArgumentException("User not found"));
        JobAdvertisement jobAdvertisement = new JobAdvertisement(
                recruiter,
                jobAdvertisementDTO.getTitle(),
                jobAdvertisementDTO.getDescription(),
                jobAdvertisementDTO.getIndustry(),
                jobAdvertisementDTO.getStartingSalary(),
                LocalDate.parse(jobAdvertisementDTO.getActiveUntil()),
                JobType.valueOf(jobAdvertisementDTO.getJobType()),
                EmploymentStatus.valueOf(jobAdvertisementDTO.getEmploymentStatus())
                );
        jobAdvertisementRepository.save(jobAdvertisement);
        return JobAdvertisement.mapToJobAdDetailsDTO(jobAdvertisement);
    }

    @Override
    public JobAdDetailsDTO editJobAdvertisement(Long id, JobAdvertisementDTO jobAdvertisementDTO) {
        JobAdvertisement jobAdvertisement = jobAdvertisementRepository.findById(id).orElseThrow(() -> new IllegalArgumentException("Job Advertisement not found"));
        jobAdvertisement.setTitle(jobAdvertisementDTO.getTitle());
        jobAdvertisement.setDescription(jobAdvertisementDTO.getDescription());
        jobAdvertisement.setIndustry(jobAdvertisementDTO.getIndustry());
        jobAdvertisement.setStartingSalary(jobAdvertisementDTO.getStartingSalary());
        jobAdvertisement.setActiveUntil(LocalDate.parse(jobAdvertisementDTO.getActiveUntil()));
        jobAdvertisement.setActive(jobAdvertisement.isJobAdActive());
        jobAdvertisement.setJobType(JobType.valueOf(jobAdvertisementDTO.getJobType()));
        jobAdvertisement.setEmploymentStatus(EmploymentStatus.valueOf(jobAdvertisementDTO.getEmploymentStatus()));
        jobAdvertisementRepository.save(jobAdvertisement);
        return JobAdvertisement.mapToJobAdDetailsDTO(jobAdvertisement);
    }

    @Override
    public void deleteJobAdvertisement(Long jobAdvertisementId) {
        jobAdvertisementRepository.deleteById(jobAdvertisementId);
    }

    @Override
    public List<JobAdDetailsDTO> findAllJobAdvertisements() {
        List<JobAdvertisement> jobAdvertisementList = jobAdvertisementRepository.findAll();
        jobAdvertisementList.forEach(jobAdvertisement -> {
            if (!jobAdvertisement.isJobAdActive() && jobAdvertisement.isActive()) {
                jobAdvertisement.setActive(false);
                jobAdvertisementRepository.save(jobAdvertisement);
            } else if (jobAdvertisement.isJobAdActive() && !jobAdvertisement.isActive()) {
                jobAdvertisement.setActive(true);
                jobAdvertisementRepository.save(jobAdvertisement);
            }
        });

        return jobAdvertisementList.stream()
                .map(JobAdvertisement::mapToJobAdDetailsDTO)
                .toList();
    }

    @Override
    public List<JobAdDetailsDTO> findAllJobAdvertisementsByRecruiterId(Long recruiterId) {
        List<JobAdvertisement> jobAdvertisementList = jobAdvertisementRepository.findAllByRecruiterId(recruiterId);
//        jobAdvertisementList.forEach(jobAdvertisement -> {
//            if (!jobAdvertisement.isJobAdActive() && jobAdvertisement.isActive()) {
//                jobAdvertisement.setActive(false);
//                jobAdvertisementRepository.save(jobAdvertisement);
//            } else if (jobAdvertisement.isJobAdActive() && !jobAdvertisement.isActive()) {
//                jobAdvertisement.setActive(true);
//                jobAdvertisementRepository.save(jobAdvertisement);
//            }
//        });

        return jobAdvertisementList.stream()
                .map(JobAdvertisement::mapToJobAdDetailsDTO)
                .toList();
    }
    @Override
    public JobAdDetailsDTO findJobAdvertisementById(Long id) {
        JobAdvertisement jobAdvertisement = jobAdvertisementRepository.findById(id).orElse(null);
        return JobAdvertisement.mapToJobAdDetailsDTO(jobAdvertisement);
    }
}
