package mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.service.impl;

import lombok.RequiredArgsConstructor;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users.DTO.RecruiterDetailsDTO;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users.Recruiter;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.models.users.mappers.RecruiterMapper;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.repositories.RecruiterRepository;
import mk.ukim.finki.predmeti.internettehnologii.jobvistabackend.service.intef.RecruiterService;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class RecruiterServiceImpl implements RecruiterService {

    private final RecruiterRepository recruiterRepository;

    @Override
    public RecruiterDetailsDTO getRecruiterDetailsById(Long recruiterId) {
        Recruiter recruiter = recruiterRepository.findById(recruiterId).orElse(null);
        return RecruiterMapper.mapToRecruiterDetailsDTO(recruiter);
    }
}
