import "./Dashboard.css"

import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import {formatRelativeTime, sortElementsByDateCreated} from "../../utils/utils";
import {dataRangeOptions, industryOptions, industryOptionsFilter, sortOptions} from "../selectOptions";
import Select from "react-select";
import Roles from "../../enumerations/Roles";
import {Link} from "react-router-dom";
import JobType from "../../enumerations/JobType";

export const Dashboard = () => {

    const dispatch = useDispatch();

    const [jobAdvertisements, setJobAdvertisements] = useState([]);
    let jobAdvertisementsState = useSelector(state => state.jobAd.jobAdvertisements)
    const auth = useSelector(state => state.auth.currentUser);

    const [role, setRole] = useState("");
    const [sortOrder, setSortOrder] = useState("newest");
    const [selectedDateRange, setSelectedDateRange] = useState("all");
    const [searchTerm, setSearchTerm] = useState("");
    const [dispatched, setDispatched] = useState(false)

    useEffect(() => {
        if (auth) {
            setRole(auth.role);
        }
    }, [auth]);

    useEffect(() => {
        if(!dispatched && jobAdvertisementsState.length == 0) {
            dispatch(JobAdvertisementActions.fetchJobAdvertisements((success, response) => {
                if (success && response.data.length > 0) {
                    setJobAdvertisements(sortElementsByDateCreated(response.data))
                }
                setDispatched(true)
                console.log("Fetch all job advertisements GET")
                console.log(response.data)
            }))

        } else {
            setJobAdvertisements(jobAdvertisementsState)
            console.log("Fetch all job advertisements STATE")
        }
    }, [])


    return (
        <div className="container">
            <div className="head-dashboard-box">
                <div className="row">
                    <div className="col-md-3">
                        <div className="search-container head-component">
                            <i className="fa-solid fa-magnifying-glass blue-colored"></i>
                            <input
                                className="search-input"
                                type="text"
                                placeholder="Search job advertisement by title..."
                                //value={searchTerm}
                                //onChange={event => setSearchTerm(event.target.value)}
                            />
                        </div>
                    </div>
                    <div className="col-md-9">
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "all", label: "All industries"}}
                                //value={sortOrder.value}
                                //onChange ={option => setSortOrder(option.value)}
                                options={industryOptionsFilter}
                                className="sort-range sort"
                            />
                        </div>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "newest", label: "Date (Newest First)"}}
                                //value={sortOrder.value}
                                //onChange ={option => setSortOrder(option.value)}
                                options = {sortOptions}
                                className="sort-range sort"
                            />
                        </div>
                        <div className="date-range-section item">
                            <Select
                                defaultValue={{value: "all", label: "Lifetime"}}
                                //value={selectedDateRange.value}
                                //onChange={option => setSelectedDateRange(option.value)}
                                options={dataRangeOptions}
                                className="date-range sort"
                            />
                        </div>
                    </div>
                </div>
            </div>
            <div className="row row-cols-1 row-cols-md-4 g-4">

                {jobAdvertisements &&
                    jobAdvertisements.map((jobAd, index) => (
                        <div key={index} className="col">
                            <div className="custom-card">
                                <div className="card-head">
                                    <span className="hourly-salary"><b>${jobAd.startingSalary}/hr</b></span>
                                    <span className="job-type"> {jobAd.jobType===JobType.JOB ? "Job" : "Internship"}</span>
                                    {!jobAd.active && <span className="expired">Expired</span>}
                                </div>
                                <div className="card-body">
                                    <h5 className="card-title">{jobAd.title}</h5>
                                    <span>{jobAd.industry} • <span style={{color: "black", fontWeight: "bold"}}>{formatRelativeTime(jobAd.postedOn)}</span></span>
                                    <div className="card-info">
                                        <span><i className="fa-solid fa-building" style={{color: "#000000"}}></i> Company: <span style={{color: "black", fontWeight: "bold"}}>{jobAd.recruiterName}</span></span> <br/>
                                    </div>

                                    <div className="aligned">
                                        <Link to={`/job-advertisements/view/${jobAd.id}`} className="card-button">Read more</Link>
                                        {role===Roles.JOBSEEKER &&
                                            <>
                                                {jobAd.active && <button className="card-button">Apply now</button> }
                                                {!jobAd.active && <button className="card-button disabled">Apply now</button> }
                                            </>
                                        }
                                    </div>

                                </div>
                            </div>
                        </div>
                    ))}

            </div>
        </div>
    )
}