import axios from "../../axios/axiosInstance";
import {
    CURRENT_USER,
    FETCH_APPLICATIONS_BY_JOB_ID,
    FETCH_APPLICATIONS_BY_JOB_SEEKER_ID,
    SUBMIT_APPLICATION, UPDATE_APPLICATION_STATUS
} from "../actionTypes";

export const ApplicationActions = {
    submitApplication: (application, callback) => {
        return dispatch => {
            axios.post("/job-advertisements/apply", application, {
                headers: {
                    'Content-Type': 'multipart/form-data'
                }
            })
                .then(response => {
                    dispatch({
                        type: SUBMIT_APPLICATION,
                        application: response.data
                    })
                    callback(true, response)
                }).catch(error => {
                callback(false, error)
                console.log(error)
            })
        }

    },
    updateApplicationStatus: (id, status, callback) => {
        console.log(status)
      return dispatch => {
            // TO DO: REFACTOR
          axios.post("/applications/" + id + "/update", {
              id: id,
              status: status
          })
              .then(response => {
                  dispatch({
                      type: UPDATE_APPLICATION_STATUS,
                      application: response.data,
                  })
                  callback(true, response)
              }).catch(error => {
              callback(false, error)
          })
      }
    },
    fetchApplicationsByJobSeeker: (callback) => {
      return dispatch => {
          let currentUser = JSON.parse(localStorage.getItem(CURRENT_USER));
          axios.get("/my-applications/" + currentUser.id)
              .then(response => {
                  dispatch({
                      type: FETCH_APPLICATIONS_BY_JOB_SEEKER_ID,
                      applicationsByJobSeeker: response.data
                  })
                  callback(true, response)
              }).catch(error => {
                  callback(false, error)
          })
      }
    },

    fetchApplicationsByJobAdId: (jobAdId, callback) => {
        return dispatch => {
            axios.get("/job-advertisements/" + jobAdId + "/applications")
                .then(response => {
                        dispatch({
                            type: FETCH_APPLICATIONS_BY_JOB_ID,
                            applicationsByJobAdId: response.data
                        })
                        callback(true, response)
                    }
                ).catch(error => {
                callback(false, error)
            })
        }
    },
    downloadResume: (fileName, callback) => {
        return dispatch => {
            return axios.get("/resume/" + fileName, {responseType: "blob"})
                .then(response => {
                    const blob = new Blob([response.data], { type: 'application/pdf' });
                    const url = window.URL.createObjectURL(blob);
                    callback(true, url);
                })

                .catch(error => {
                    callback(false, error)
                })
        }
    }
}