import {
    ADD_JOB_ADVERTISEMENT,
    CURRENT_USER, DELETE_JOB_ADVERTISEMENT, EDIT_JOB_ADVERTISEMENT,
    FETCH_JOB_ADVERTISEMENTS,
    FETCH_JOB_ADVERTISEMENTS_BY_RECRUITER, FILTER_JOB_ADVERTISEMENTS, FILTER_JOB_ADVERTISEMENTS_BY_RECRUITER
} from "../actionTypes";
import {sortElementsByDateCreated} from "../../utils/utils";
import {useSelector} from "react-redux";

const initialState = {
    jobAdvertisements: [],
    jobAdvertisementsByRecruiter: []
}

let currentUser = JSON.parse(localStorage.getItem(CURRENT_USER))
export const JobAdvertisementReducer = (state = initialState, action) => {
    let jobAdvertisements;
    let jobAdvertisementsByRecruiter;
    switch (action.type) {
        case ADD_JOB_ADVERTISEMENT:

            return {
                ...state,
                jobAdvertisements: sortElementsByDateCreated([...state.jobAdvertisements, action.jobAdvertisement]),
                jobAdvertisementsByRecruiter: sortElementsByDateCreated([...state.jobAdvertisementsByRecruiter, action.jobAdvertisement])
            }
        case EDIT_JOB_ADVERTISEMENT:
            jobAdvertisements = state.jobAdvertisements.filter(jobAd => jobAd.id !== action.jobAdvertisement.id)
            jobAdvertisementsByRecruiter = state.jobAdvertisementsByRecruiter.filter(jobAd => jobAd.id !== action.jobAdvertisement.id)

            return {
                jobAdvertisements: sortElementsByDateCreated([...jobAdvertisements, action.jobAdvertisement]),
                jobAdvertisementsByRecruiter: sortElementsByDateCreated([...jobAdvertisementsByRecruiter, action.jobAdvertisement])
            }
        case DELETE_JOB_ADVERTISEMENT:
            jobAdvertisements = state.jobAdvertisements.filter(jobAd => jobAd.id !== action.id)
            jobAdvertisementsByRecruiter = state.jobAdvertisementsByRecruiter.filter(jobAd => jobAd.id !== action.id)

            return {
                jobAdvertisements: sortElementsByDateCreated([...jobAdvertisements]),
                jobAdvertisementsByRecruiter: sortElementsByDateCreated([...jobAdvertisementsByRecruiter])
            }

        case FETCH_JOB_ADVERTISEMENTS:
            return {
                ...state,
                jobAdvertisements: sortElementsByDateCreated(action.jobAdvertisements)
            }


        case FETCH_JOB_ADVERTISEMENTS_BY_RECRUITER:
            return {
                ...state,
                jobAdvertisementsByRecruiter: sortElementsByDateCreated(action.jobAdvertisementsByRecruiter)
            }

        default:
            return {
                ...state,
            };
    }
}

export default JobAdvertisementReducer