import {useDispatch} from "react-redux";
import {useEffect, useState} from "react";
import {useParams} from "react-router";
import {ApplicationActions} from "../../redux/actions/applicationActions";
import {ViewApplicationDetails} from "./ViewApplicationDetails";
import "./Applications.css"
import Select from "react-select";

export const ApplicationsByJobAd = () => {

    const dispatch = useDispatch();
    let {advertisement_id} = useParams();
    const [applicationsByJobAd, setApplicationsByJobAd] = useState([]);
    const [jobAdTitle, setJobAdTitle] = useState("");

    useEffect(() => {
        dispatch(ApplicationActions.fetchApplicationsByJobAdId(advertisement_id, (success, reponse) => {
            if (success && reponse.data.length > 0) {
                setApplicationsByJobAd(reponse.data)
                setJobAdTitle(reponse.data[0].jobAdTitle)
            }
        }))
    }, [])

    const options = [
        {value: 'PROPOSED', label: <span><i className="fa-solid fa-paper-plane"></i> Proposed</span>},
        {value: 'UNDER_REVIEW', label: <span><i className="fa-solid fa-file-pen"></i> Under Review</span>},
        {value: 'ACCEPTED', label: <span><i className="fa-solid fa-user-check"></i> Accepted</span>},
        {value: 'DENIED', label: <span><i className="fa-solid fa-user-slash"></i> Denied</span>}
    ];

    let handleDefaultStatus = (status) => {
        return options.find(option => option.value === status);
    }

    let handleChangeStatus = (selectedOption, id) => {
        dispatch(ApplicationActions.updateApplicationStatus(id, selectedOption.value, (success, response) => {
            if(success) {
                console.log("Status updated.")
            }
        }))
    }


    return (<div className="applications-container">
        <div className="application-title">
            {jobAdTitle ?
                <h1>Applications for <span>{jobAdTitle}</span></h1> :
                <h1></h1>
            }

        </div>

        {applicationsByJobAd && applicationsByJobAd.map((application, index) => (
            <div className="application-card">
                <div className="left-box">
                    <span>Submitted on <b>{new Date(application.submittedOn).toLocaleString('default', {
                        day: 'numeric',
                        month: 'long',
                        year: 'numeric'
                    })}</b></span>
                    <br/><br/>
                    <div className="contact-info">
                        <div className="contact-item">
                            <i className="fa-solid fa-user"></i> <span>{application.jobSeekerName}</span>
                        </div>
                        <div className="contact-item">
                            <i className="fa-solid fa-envelope"></i> <span>{application.jobSeekerEmail}</span>
                        </div>
                        <div className="contact-item">
                            <i className="fa-solid fa-phone"></i> <span>{application.jobSeekerPhoneNumber}</span>
                        </div>
                    </div>
                </div>

                <div className="right-box">
                    <ViewApplicationDetails application={application}/>
                    <div className="select">
                        <Select options={options}  onChange={(selectedOption) => handleChangeStatus(selectedOption, application.id)} defaultValue={handleDefaultStatus(application.status)}/>
                    </div>

                </div>
            </div>
       ))}

    </div>)
}