import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {ApplicationActions} from "../../redux/actions/applicationActions";
import {ViewApplicationDetails} from "./ViewApplicationDetails";
import Select from "react-select";

export const ApplicationsByJobSeeker = () => {
    const dispatch = useDispatch();
    const [applicationsByJobSeeker, setApplicationsByJobSeeker] = useState([]);
    let applicationsByJobSeekerState = useSelector(state => state.appl.applicationsByJobSeeker);
    const [dispatched, setDispatched] = useState(false);

    useEffect(() => {
        if(!dispatched && applicationsByJobSeekerState.length === 0) {
            dispatch(ApplicationActions.fetchApplicationsByJobSeeker((success, response) => {
                if(success && response.data.length > 0) {
                    setApplicationsByJobSeeker(response.data);
                }
                console.log("Fetch applications by job seeker GET")
            }))
            setDispatched(true)
        } else {
            setApplicationsByJobSeeker(applicationsByJobSeekerState);
            console.log("Fetch applications by job seeker STATE")
        }
    }, [applicationsByJobSeekerState])

    const options = [
        {value: 'PROPOSED', label: <span><i className="fa-solid fa-paper-plane"></i> Proposed</span>},
        {value: 'UNDER_REVIEW', label: <span><i className="fa-solid fa-file-pen"></i> Under Review</span>},
        {value: 'ACCEPTED', label: <span><i className="fa-solid fa-user-check"></i> Accepted</span>},
        {value: 'DENIED', label: <span><i className="fa-solid fa-user-slash"></i> Denied</span>}
    ];

    let handleDefaultValue = (status) => {
        return options.find(option => option.value === status);
    }



    return (
        <div className="applications-container">
            <div className="application-title">

            </div>
            {applicationsByJobSeeker && applicationsByJobSeeker.map((application, index) => (
                <div key={index} className="application-card">
                    <div className="left-box">
                        <span className="jobAd-title">{application.jobAdTitle}</span>
                        <br/>
                        <br/>
                        <div className="contact-info">
                            <div className="contact-item">
                                <i className="fa-solid fa-building"></i> <span>{application.recruiterName}</span>
                            </div>
                            <div className="contact-item">
                                <i className="fa-solid fa-envelope"></i> <span>{application.recruiterEmail}</span>
                            </div>
                            <div className="contact-item">
                                <i className="fa-solid fa-phone"></i> <span>{application.recruiterPhoneNumber}</span>
                            </div>
                            <span> • Submitted on <b>{new Date(application.submittedOn).toLocaleString('default', {
                                day: 'numeric',
                                month: 'long',
                                year: 'numeric'
                            })}</b></span>
                        </div>
                    </div>

                    <div className="right-box">
                        <ViewApplicationDetails application={application}/>
                        <div className="select">
                            <Select isDisabled={true} options={options} defaultValue={handleDefaultValue(application.status)}/>
                        </div>

                    </div>
                </div>
            ))}

        </div>
    )
}