import {Link, NavLink} from "react-router-dom";
import "./Header.css"
import {useDispatch, useSelector} from 'react-redux';
import {useEffect, useState} from "react";
import {AuthActions} from "../../redux/actions/authActions";
import Roles from "../../enumerations/Roles";
import {useNavigate} from "react-router";

export const Header = (props) => {

    const auth = useSelector(state => state.auth.currentUser);
    const dispatch = useDispatch();
    const navigator = useNavigate();

    const [role, setRole] = useState("");
    const [username, setUsername] = useState("");

    const signOut = () => {
        dispatch(AuthActions.signOut());
        window.location = "/";
    }

    useEffect(() => {
        if (auth) {
            setRole(auth.role);
            setUsername(auth.name);
        }
    }, [auth]);

    return (
        <nav className="navbar navbar-expand-lg bg-light">
            <div className="container-fluid">
                <Link to="/" className="logo navbar-brand" />
                <Link to="/" className="brand-name navbar-brand" />
                <div className="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul className="navbar-nav me-auto mb-2 mb-lg-0">
                        <NavLink to="/" className="nav-item nav-link">Home</NavLink>
                        {role==Roles.JOBSEEKER &&
                            <>
                                <NavLink to="/my-applications" className="nav-item nav-link" >My Applications</NavLink>
                                {/*<NavLink to="/favoritejobs" className="nav-item nav-link" >Saved</NavLink>*/}
                            </>

                        }
                        {role==Roles.RECRUITER &&
                            <>
                                <NavLink to="/my-job-advertisements" className="nav-item nav-link" >My Advertisements</NavLink>
                                {/*<NavLink to="/favoritejobs" className="nav-item nav-link" >Saved</NavLink>*/}
                            </>
                        }
                        <NavLink to="/about" className="nav-item nav-link">About</NavLink>
                        <NavLink to="/contact" className="nav-item nav-link">Support</NavLink>
                    </ul>

                    {auth ?
                        <>
                            <img src="/images/user.png" width="45" height="45"/>
                            <div className="auth-box">
                                <p className="user"><b>{username}</b></p>
                                <p className="role">{role==Roles.RECRUITER ? "Recruiter" : "Job Seeker"}</p>
                            </div>


                            <Link onClick={signOut} className="btn auth-secondary-btn">Log out</Link>
                        </> :
                        <>
                            <Link to="/signin" className="btn auth-secondary-btn">Sign in</Link>
                        </>
                    }

                </div>
            </div>
        </nav>

    )
}