
import {Route, Router, Routes} from 'react-router-dom'
import {Dashboard} from "../views/dashboard/Dashboard";
import {SignInForm} from "../views/auth/SignInForm";
import {SignUpRecruiterForm} from "../views/auth/SignUpRecruiterForm";
import {SignUpJobSeekerForm} from "../views/auth/SignUpJobSeekerForm";
import {JobAdvertisements} from "../views/job_advertisements/JobAdvertisements";
import {JobAdDetails} from "../views/job_advertisements/JobAdDetails";
import {ApplicationsByJobAd} from "../views/applications/ApplicationsByJobAd";
import {ApplicationsByJobSeeker} from "../views/applications/ApplicationsByJobSeeker";
export const RoutesConfig = () => {

    return (
            <Routes>
                <Route path="/" element={<Dashboard/>}></Route>
                <Route path="/signin" element={<SignInForm/>}></Route>
                <Route path="/signup/recruiter" element={<SignUpRecruiterForm/>}></Route>
                <Route path="/signup/job-seeker" element={<SignUpJobSeekerForm/>}></Route>
                <Route path="/my-job-advertisements" element={<JobAdvertisements/>}></Route>
                <Route path="/my-applications" element={<ApplicationsByJobSeeker/>}></Route>
                <Route path="/job-advertisements/:id" element={<JobAdDetails/>}></Route>
                <Route path="/my-job-advertisements/:advertisement_id/applications" element={<ApplicationsByJobAd/>}></Route>
            </Routes>
    )
}