import {AddJobAdModal} from "./AddJobAdModal";

import "./JobAdvertisements.css"
import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import {formatRelativeTime, sortElementsByDateCreated} from "../../utils/utils";
import {dataRangeOptions, industryOptions, industryOptionsFilter, sortOptions} from "../selectOptions";
import Select from "react-select";
import {DeleteJobAdModal} from "./DeleteJobAdModal";
import {EditJobAdModal} from "./EditJobAdModal";
import {Link} from "react-router-dom";
import JobType from "../../enumerations/JobType";

export const JobAdvertisements = (props) => {

    const dispatch = useDispatch();
    const [jobAdvertisementsByRecruiter, setJobAdvertisementsByRecruiter] = useState([]);
    const auth = useSelector(state => (state.auth.currentUser))
    let jobAdvertisementsByRecruiterState = useSelector(state => (state.jobAd.jobAdvertisementsByRecruiter))

    const [role, setRole] = useState("");
    const [selectedSortOrder, setSelectedSortOrder] = useState("date_newest");
    const [selectedIndustry, setSelectedIndustry] = useState("all");
    const [searchTerm, setSearchTerm] = useState("");
    const [dispatched, setDispatched] = useState(false)


    useEffect(() => {
        if (auth) {
            setRole(auth.role);
        }
    }, [auth]);

    useEffect(() => {
        if (!dispatched && jobAdvertisementsByRecruiterState.length === 0) {
            dispatch(JobAdvertisementActions.fetchJobAdvertisementsByRecruiter((success, response) => {
                if (success && response.data.length > 0) {
                    setJobAdvertisementsByRecruiter(sortElementsByDateCreated(response.data))
                }
                console.log("Fetch job advertisements by recruiter GET")
            }))
            setDispatched(true);

        } else {
            setJobAdvertisementsByRecruiter(jobAdvertisementsByRecruiterState)
            console.log("Fetch job advertisements by recruiter STATE")
        }
    }, [jobAdvertisementsByRecruiterState])

    let filterJobAdvertisements = () => {
        JobAdvertisementActions.filterJobAdvertisementsByRecruiter(
            {
                searchTerm: searchTerm,
                industry: selectedIndustry,
                sortOrder: selectedSortOrder
            }, (success, response) => {
                if (success) {
                    setJobAdvertisementsByRecruiter(response.data);
                }
            }
        )
    }

    return (
        <div className="container">
            <div className="head-dashboard-box">
                <div className="row">
                    <div className="col-md-12 filter-container">
                        <div className="search-container">
                            <i className="fa-solid fa-magnifying-glass search-icon"></i>
                            <input
                                className="search-input"
                                type="text"
                                placeholder="Search job advertisement by title..."
                                value={searchTerm}
                                onChange={event => setSearchTerm(event.target.value)}
                            />
                        </div>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "all", label: "All industries"}}
                                value={selectedIndustry.value}
                                onChange={option => setSelectedIndustry(option.value)}
                                options={industryOptionsFilter}
                                className="sort-range sort"
                            />
                        </div>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "newest", label: "Date (Newest First)"}}
                                value={selectedSortOrder.value}
                                onChange={option => setSelectedSortOrder(option.value)}
                                options={sortOptions}
                                className="sort-range sort"
                            />
                        </div>
                        <button onClick={filterJobAdvertisements} className="btn-open-modal">Find jobs</button>
                    </div>
                </div>
            </div>
            <div className="row row-cols-1 row-cols-md-4 g-4">
                <AddJobAdModal/>

                {jobAdvertisementsByRecruiter &&
                    jobAdvertisementsByRecruiter.map((jobAd, index) => (
                        <div key={index} className="col">
                            <div className="custom-card">
                                <div className="card-head">
                                    <span className="hourly-salary"><b>${jobAd.startingSalary}/hr</b></span>
                                    <span
                                        className="job-type"> {jobAd.jobType === JobType.JOB ? "Job" : "Internship"}</span>
                                    {!jobAd.active && <span className="expired">Expired</span>}
                                    <div className="card-management-btns">
                                        <DeleteJobAdModal props={jobAd}/>
                                        <EditJobAdModal props={jobAd}/>
                                    </div>
                                </div>
                                <div className="card-body">
                                    <h5 className="card-title">{jobAd.title}</h5>
                                    <span>{jobAd.industry} • <span style={{
                                        color: "black",
                                        fontWeight: "bold"
                                    }}>{formatRelativeTime(jobAd.postedOn)}</span></span>
                                    <div className="card-info">
                                        <span><i className="fa-solid fa-building"
                                                 style={{color: "#000000"}}></i> Company: <span style={{
                                            color: "black",
                                            fontWeight: "bold"
                                        }}>{jobAd.recruiterName}</span></span> <br/>
                                    </div>

                                    <div className="aligned">
                                        <Link to={`/my-job-advertisements/${jobAd.id}/applications`}
                                              className="card-button solo">View applications</Link>
                                    </div>

                                </div>
                            </div>
                        </div>
                    ))}

            </div>
        </div>
    )
}