import logo from './logo.svg';
import './App.css';
import {useDispatch, useSelector} from "react-redux";
import {BrowserRouter} from "react-router-dom";
import {Header} from "./views/static/Header";
import {RoutesConfig} from "./auth/RoutesConfig";
import {useEffect, useState} from "react";
import {AuthActions} from "./redux/actions/authActions";
import {AUTH_TOKEN} from "./axios/axiosInstance";
import {jwtDecode} from "jwt-decode";
import {NoAccess} from "./views/static/NoAccess";

function App() {
    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(AuthActions.updateToken(localStorage.getItem(AUTH_TOKEN)))
    }, [dispatch])

    const [user, setUser] = useState(null);
    const [loading, setLoading] = useState(true);
    const auth = useSelector(state => state.auth);

    useEffect(() => {
        const token = localStorage.getItem(AUTH_TOKEN);
        if (token !== null) {
            try {
                const decodedToken = jwtDecode(token);
                setUser({
                    name: decodedToken.name,
                    role: decodedToken.role,
                    hasAccess: auth.currentUser.access,
                });
                setLoading(false);
            } catch (error) {
                console.error('Failed to decode token', error);
                setLoading(false);
            }
        } else {
            setLoading(false);
        }
    }, [auth]);

    if (loading) {
        return <NoAccess />; // Replace LoadingSpinner with your loading indicator component
    }

  return (
      <div className="App">
          <BrowserRouter>
              {user === null ? (
                  <>
                      <Header />
                      <RoutesConfig />
                  </>
              ) : user.hasAccess ? (
                  <>
                      <Header />
                      <RoutesConfig />
                  </>
              ) : (
                  <NoAccess user={user}/>
              )}


          </BrowserRouter>
      </div>
  );
}

export default App;
