import "./Dashboard.css"

import {useDispatch, useSelector} from "react-redux";
import {useEffect, useState} from "react";
import {JobAdvertisementActions} from "../../redux/actions/jobAdvertisementActions";
import {formatRelativeTime, sortElementsBy} from "../../utils/utils";
import {dataRangeOptions, industryOptions, industryOptionsFilter, sortOptions} from "../selectOptions";
import Select from "react-select";
import Roles from "../../enumerations/Roles";
import {Link} from "react-router-dom";
import JobType from "../../enumerations/JobType";
import {AUTH_TOKEN} from "../../axios/axiosInstance";
import {jwtDecode} from "jwt-decode";

export const Dashboard = (props) => {

    const dispatch = useDispatch();

    const [jobAdvertisements, setJobAdvertisements] = useState([]);
    let jobAdvertisementsState = useSelector(state => state.jobAd.jobAdvertisements)
    const auth = useSelector(state => state.auth);

    // const [role, setRole] = useState("");
    const [selectedSortOrder, setSelectedSortOrder] = useState("date_newest");
    const [selectedIndustry, setSelectedIndustry] = useState("all");
    const [searchTerm, setSearchTerm] = useState("");
    const [dispatched, setDispatched] = useState(false)

    // const [user, setUser] = useState(null);
    //
    // useEffect(() => {
    //     const token = localStorage.getItem(AUTH_TOKEN);
    //     if (token!=null) {
    //         try {
    //             const decodedToken = jwtDecode(token);
    //             setUser({
    //                 name: decodedToken.name,
    //                 role: decodedToken.role,
    //                 hasAccess: decodedToken.access,
    //             });
    //         } catch (error) {
    //             console.error('Failed to decode token', error);
    //         }
    //     }
    //     console.log(user)
    // }, [auth]);

    // useEffect(() => {
    //     if (auth) {
    //         setRole(auth.role);
    //     }
    //     console.log(props)
    // }, [auth]);

    useEffect(() => {
        if (!dispatched && jobAdvertisementsState.length == 0) {
            dispatch(JobAdvertisementActions.fetchJobAdvertisements((success, response) => {
                if (success && response.data.length > 0) {
                    setJobAdvertisements(sortElementsBy(response.data))
                }
                setDispatched(true)
                console.log("Fetch all job advertisements GET")
            }))

        } else {
            setJobAdvertisements(jobAdvertisementsState)
            console.log("Fetch all job advertisements STATE")
        }
    }, [jobAdvertisementsState])

    let filterJobAdvertisements = () => {
        JobAdvertisementActions.filterJobAdvertisements(
            {
                searchTerm: searchTerm,
                industry: selectedIndustry,
                sortOrder: selectedSortOrder
            }, (success, response) => {
                if (success) {
                    setJobAdvertisements(response.data);
                }
            }
        )
    }

    return (

        <div className="container">
            <div className="head-dashboard-box">
                <div className="row">
                    <div className="col-md-12 filter-container">
                        <div className="search-container">
                            <i className="fa-solid fa-magnifying-glass search-icon"></i>
                            <input
                                className="search-input"
                                type="text"
                                placeholder="Search job advertisement by title..."
                                value={searchTerm}
                                onChange={event => setSearchTerm(event.target.value)}
                            />
                        </div>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "all", label: "All industries"}}
                                value={selectedIndustry.value}
                                onChange={option => setSelectedIndustry(option.value)}
                                options={industryOptionsFilter}
                                className="sort-range sort"
                            />
                        </div>
                        <div className="sort-section item">
                            <Select
                                defaultValue={{value: "newest", label: "Date (Newest First)"}}
                                value={selectedSortOrder.value}
                                onChange={option => setSelectedSortOrder(option.value)}
                                options={sortOptions}
                                className="sort-range sort"
                            />
                        </div>
                        <button onClick={filterJobAdvertisements} className="btn-open-modal">Find jobs</button>
                    </div>
                    {/*<div className="col-md-3">*/}

                    {/*<div className="date-range-section item">*/}
                    {/*    <Select*/}
                    {/*        defaultValue={{value: "all", label: "Lifetime"}}*/}
                    {/*        //value={selectedDateRange.value}*/}
                    {/*        //onChange={option => setSelectedDateRange(option.value)}*/}
                    {/*        options={dataRangeOptions}*/}
                    {/*        className="date-range sort"*/}
                    {/*    />*/}
                    {/*</div>*/}
                    {/*</div>*/}
                </div>
            </div>
            <div className="row row-cols-1 row-cols-md-4 g-4">

                {jobAdvertisements &&
                    jobAdvertisements.map((jobAd, index) => (
                        <div key={index} className="col">
                            <div className="custom-card">
                                <div className="card-head">
                                    <span className="hourly-salary"><b>${jobAd.startingSalary}/hr</b></span>
                                    <span
                                        className="job-type"> {jobAd.jobType === JobType.JOB ? "Job" : "Internship"}</span>
                                    {!jobAd.active && <span className="expired">Expired</span>}
                                </div>
                                <div className="card-body">
                                    <h5 className="card-title">{jobAd.title}</h5>
                                    <span>{jobAd.industry} • <span style={{
                                        color: "black",
                                        fontWeight: "bold"
                                    }}>{formatRelativeTime(jobAd.postedOn)}</span></span>
                                    <div className="card-info">
                                        <span><i className="fa-solid fa-building"
                                                 style={{color: "#000000"}}></i> Company: <span style={{
                                            color: "black",
                                            fontWeight: "bold"
                                        }}>{jobAd.recruiterName}</span></span> <br/>
                                    </div>

                                    <div className="aligned">
                                        <Link to={`/job-advertisements/${jobAd.id}`} className="card-button">Read
                                            more</Link>
                                    </div>

                                </div>
                            </div>
                        </div>
                    ))}

            </div>
        </div>
    )
}